/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.net.SocketException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.IConnection;
import org.scale7.cassandra.pelops.exceptions.IExceptionTranslator;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class Connection
implements IConnection {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(Connection.class);
    private Cluster.Node node;
    private String keyspace;
    private TTransport transport;
    private final Cassandra.Client client;

    public Connection(Cluster.Node node, String keyspace) throws SocketException, TException, InvalidRequestException {
        this.node = node;
        this.keyspace = keyspace;
        TSocket socket = new TSocket(node.getAddress(), node.getConfig().getThriftPort());
        this.transport = node.getConfig().isFramedTransportRequired() ? new TFramedTransport((TTransport)socket) : socket;
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new Cassandra.Client((TProtocol)protocol);
        if (node.getConfig().isTimeoutSet()) {
            socket.setTimeout(node.getConfig().getTimeout());
        }
    }

    @Override
    public Cassandra.Client getAPI() {
        return this.client;
    }

    @Override
    public Cluster.Node getNode() {
        return this.node;
    }

    @Override
    public boolean isOpen() {
        return this.transport.isOpen();
    }

    @Override
    public void open() throws TTransportException {
        if (this.isOpen()) {
            return;
        }
        this.transport.open();
        logger.debug("transport is open '{}'", (Object)this.transport);
        if (this.node.getConfig().getConnectionAuthenticator() != null) {
            logger.debug("Authentication request '{}'", (Object)this.node.getConfig().getConnectionAuthenticator());
            try {
                this.getAPI().login(this.node.getConfig().getConnectionAuthenticator().getAuthenticationRequest());
            }
            catch (Exception e) {
                logger.warn("Failed to login on client for node {}.  Cause is {}", (Object)this.node.getAddress(), (Object)e);
                throw new IExceptionTranslator.ExceptionTranslator().translate(e);
            }
        }
        logger.debug("set keyspace  '{}'", (Object)this.keyspace);
        if (this.keyspace != null) {
            try {
                this.client.set_keyspace(this.keyspace);
            }
            catch (Exception e) {
                logger.warn("Failed to set keyspace on client for node {}.  Cause is {}", (Object)this.node.getAddress(), (Object)e);
                throw new IExceptionTranslator.ExceptionTranslator().translate(e);
            }
        }
    }

    @Override
    public void close() {
        this.transport.close();
    }
}

