/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.benchmark;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.contrib.benchmark.Stats;

public class BenchmarkWorker {
    private byte[] buffer = new byte[4096];
    private final int verbosity;
    private final HttpClient httpexecutor;

    public BenchmarkWorker(HttpClient httpexecutor, int verbosity) {
        this.httpexecutor = httpexecutor;
        this.verbosity = verbosity;
    }

    public Stats execute(HostConfiguration hostconf, HttpMethod method, int count, boolean keepalive) throws HttpException {
        Stats stats = new Stats();
        stats.start();
        int i = 0;
        while (i < count) {
            block16: {
                try {
                    try {
                        int h;
                        Header[] headers;
                        this.httpexecutor.executeMethod(hostconf, method);
                        if (this.verbosity >= 4) {
                            System.out.println(">> " + method.getName() + " " + method.getURI() + " " + method.getParams().getVersion());
                            headers = method.getRequestHeaders();
                            h = 0;
                            while (h < headers.length) {
                                System.out.print(">> " + headers[h].toString());
                                ++h;
                            }
                            System.out.println();
                        }
                        if (this.verbosity >= 3) {
                            System.out.println(method.getStatusLine().getStatusCode());
                        }
                        if (this.verbosity >= 4) {
                            System.out.println("<< " + method.getStatusLine().toString());
                            headers = method.getResponseHeaders();
                            h = 0;
                            while (h < headers.length) {
                                System.out.print("<< " + headers[h].toString());
                                ++h;
                            }
                            System.out.println();
                        }
                        InputStream instream = method.getResponseBodyAsStream();
                        long contentlen = 0L;
                        if (instream != null) {
                            int l = 0;
                            while ((l = instream.read(this.buffer)) != -1) {
                                stats.incTotal(l);
                                contentlen += (long)l;
                            }
                        }
                        stats.setContentLength(contentlen);
                        stats.incSuccessCount();
                    }
                    catch (IOException ex) {
                        stats.incFailureCount();
                        if (this.verbosity >= 2) {
                            System.err.println("I/O error: " + ex.getMessage());
                        }
                        method.releaseConnection();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    method.releaseConnection();
                    throw throwable;
                }
                method.releaseConnection();
            }
            if (!keepalive) {
                this.httpexecutor.getHttpConnectionManager().closeIdleConnections(0L);
            }
            ++i;
        }
        stats.finish();
        Header header = method.getResponseHeader("Server");
        if (header != null) {
            stats.setServerName(header.getValue());
        }
        return stats;
    }
}

