/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.analysis.layers;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.layers.intersect.SimpleRegion;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;

public class Records {
    ArrayList<Double> points;
    ArrayList<Integer> lsidIdx;
    ArrayList<Short> years;
    String[] lsids;
    int speciesSize;
    Integer[] sortOrder;
    int[] sortOrderRowStarts;
    double soMinLat;
    double soMinLong;
    int soHeight;
    double soResolution;
    boolean soSortedStarts;
    boolean soSortedRowStarts;

    public Records(String biocache_service_url, String q, double[] bbox, String filename, SimpleRegion region) throws IOException {
        this.init(biocache_service_url, q, bbox, filename, region, "names_and_lsid");
    }

    public Records(String biocache_service_url, String q, double[] bbox, String filename, SimpleRegion region, String facetField) throws IOException {
        this.init(biocache_service_url, q, bbox, filename, region, facetField);
    }

    public Records(String filename) throws IOException {
        String rawline;
        int speciesEstimate = 250000;
        int recordsEstimate = 26000000;
        this.points = new ArrayList(recordsEstimate);
        this.lsidIdx = new ArrayList(recordsEstimate);
        HashMap<String, Integer> lsidMap = new HashMap<String, Integer>(speciesEstimate);
        int start = 0;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        int[] header = new int[4];
        int row = start;
        int currentCount = 0;
        String[] line = new String[4];
        while ((rawline = br.readLine()) != null) {
            ++currentCount;
            int p1 = rawline.indexOf(44);
            int p2 = rawline.indexOf(44, p1 + 1);
            int p3 = rawline.indexOf(44, p2 + 1);
            if (p1 < 0 || p2 < 0 || p3 < 0) continue;
            line[0] = rawline.substring(0, p1);
            line[1] = rawline.substring(p1 + 1, p2);
            line[2] = rawline.substring(p2 + 1, p3);
            line[3] = rawline.substring(p3 + 1, rawline.length());
            if (currentCount % 100000 == 0) {
                System.out.print("\rreading row: " + currentCount);
            }
            String facetName = "names_and_lsid";
            if (row == 0) {
                boolean notThree;
                for (int i = 0; i < line.length; ++i) {
                    if (line[i].equals(facetName)) {
                        header[0] = i;
                    }
                    if (line[i].equals("longitude")) {
                        header[1] = i;
                    }
                    if (line[i].equals("latitude")) {
                        header[2] = i;
                    }
                    if (!line[i].equals("year")) continue;
                    header[3] = i;
                }
                System.out.println("line: " + line[0] + "," + line[1] + "," + line[2] + "," + line[3]);
                System.out.println("header: " + header[0] + "," + header[1] + "," + header[2] + "," + header[3]);
                boolean notZero = header[1] == 0 || header[2] == 0 || header[3] == 0 && line.length > 3;
                boolean notOne = line.length < 1 || header[1] == 1 || header[2] == 1 || header[3] == 1;
                boolean notTwo = line.length < 2 || header[1] == 2 || header[2] == 2 || header[3] == 2;
                boolean bl = notThree = line.length < 3 || header[1] == 3 || header[2] == 3 || header[3] == 3;
                if (!notZero) {
                    header[0] = 0;
                }
                if (!notOne) {
                    header[0] = 1;
                }
                if (!notTwo) {
                    header[0] = 2;
                }
                if (!notThree) {
                    header[0] = 3;
                }
                System.out.println("header: " + header[0] + "," + header[1] + "," + header[2] + "," + header[3]);
            } else if (line.length >= 3) {
                try {
                    double longitude = Double.parseDouble(line[header[1]]);
                    double latitude = Double.parseDouble(line[header[2]]);
                    this.points.add(longitude);
                    this.points.add(latitude);
                    String species = line[header[0]];
                    Integer idx = (Integer)lsidMap.get(species);
                    if (idx == null) {
                        idx = lsidMap.size();
                        lsidMap.put(species, idx);
                    }
                    this.lsidIdx.add(idx);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++row;
        }
        start = start == 0 ? row - 1 : row;
        br.close();
        this.lsids = new String[lsidMap.size()];
        for (Map.Entry e : lsidMap.entrySet()) {
            this.lsids[((Integer)e.getValue()).intValue()] = (String)e.getKey();
        }
        System.out.println("\nGot " + this.getRecordsSize() + " records of " + this.getSpeciesSize() + " species");
    }

    public Records(String filename, SimpleRegion region) throws IOException {
        String rawline;
        int speciesEstimate = 250000;
        int recordsEstimate = 26000000;
        this.points = new ArrayList(recordsEstimate);
        this.lsidIdx = new ArrayList(recordsEstimate);
        HashMap<String, Integer> lsidMap = new HashMap<String, Integer>(speciesEstimate);
        int start = 0;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        int[] header = new int[4];
        int row = start;
        int currentCount = 0;
        String[] line = new String[4];
        while ((rawline = br.readLine()) != null) {
            ++currentCount;
            int p1 = rawline.indexOf(44);
            int p2 = rawline.indexOf(44, p1 + 1);
            int p3 = rawline.indexOf(44, p2 + 1);
            if (p1 < 0 || p2 < 0 || p3 < 0) continue;
            line[0] = rawline.substring(0, p1);
            line[1] = rawline.substring(p1 + 1, p2);
            line[2] = rawline.substring(p2 + 1, p3);
            line[3] = rawline.substring(p3 + 1, rawline.length());
            if (currentCount % 100000 == 0) {
                System.out.print("\rreading row: " + currentCount);
            }
            String facetName = "names_and_lsid";
            if (row == 0) {
                boolean notThree;
                for (int i = 0; i < line.length; ++i) {
                    if (line[i].equals(facetName)) {
                        header[0] = i;
                    }
                    if (line[i].equals("longitude")) {
                        header[1] = i;
                    }
                    if (line[i].equals("latitude")) {
                        header[2] = i;
                    }
                    if (!line[i].equals("year")) continue;
                    header[3] = i;
                }
                System.out.println("line: " + line[0] + "," + line[1] + "," + line[2] + "," + line[3]);
                System.out.println("header: " + header[0] + "," + header[1] + "," + header[2] + "," + header[3]);
                boolean notZero = header[1] == 0 || header[2] == 0 || header[3] == 0 && line.length > 3;
                boolean notOne = line.length < 1 || header[1] == 1 || header[2] == 1 || header[3] == 1;
                boolean notTwo = line.length < 2 || header[1] == 2 || header[2] == 2 || header[3] == 2;
                boolean bl = notThree = line.length < 3 || header[1] == 3 || header[2] == 3 || header[3] == 3;
                if (!notZero) {
                    header[0] = 0;
                }
                if (!notOne) {
                    header[0] = 1;
                }
                if (!notTwo) {
                    header[0] = 2;
                }
                if (!notThree) {
                    header[0] = 3;
                }
                System.out.println("header: " + header[0] + "," + header[1] + "," + header[2] + "," + header[3]);
            } else if (line.length >= 3) {
                try {
                    double longitude = Double.parseDouble(line[header[1]]);
                    double latitude = Double.parseDouble(line[header[2]]);
                    if (region != null && !region.isWithin(longitude, latitude)) continue;
                    this.points.add(longitude);
                    this.points.add(latitude);
                    String species = line[header[0]];
                    Integer idx = (Integer)lsidMap.get(species);
                    if (idx == null) {
                        idx = lsidMap.size();
                        lsidMap.put(species, idx);
                    }
                    this.lsidIdx.add(idx);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++row;
        }
        start = start == 0 ? row - 1 : row;
        br.close();
        this.lsids = new String[lsidMap.size()];
        for (Map.Entry e : lsidMap.entrySet()) {
            this.lsids[((Integer)e.getValue()).intValue()] = (String)e.getKey();
        }
        System.out.println("\nGot " + this.getRecordsSize() + " records of " + this.getSpeciesSize() + " species");
    }

    static InputStream getUrlStream(String url) throws IOException {
        System.out.print("getting : " + url + " ... ");
        long start = System.currentTimeMillis();
        URLConnection c = new URL(url).openConnection();
        InputStream is = c.getInputStream();
        System.out.print(System.currentTimeMillis() - start + "ms\n");
        return is;
    }

    public static void main(String[] args) {
        System.out.println("args[0] = path to save the records file");
        System.out.println("args[1] = biocache service URL");
        if (args.length > 0) {
            Records.download(args[0], args[1]);
        }
    }

    public static void download(String dir, String biocacheServiceUrl) {
        try {
            for (int i = -180; i < 180; ++i) {
                double longitude1 = i;
                double longitude2 = (double)i + 0.9999999999999;
                if (i == 179) {
                    longitude2 = 180.0;
                }
                new Records(biocacheServiceUrl, "*:*", new double[]{longitude1, -90.0, longitude2, 90.0}, dir + "." + i, null);
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dir));
            for (int i = -180; i < 180; ++i) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(dir + "." + i));
                while ((line = br.readLine()) != null) {
                    bos.write(line.getBytes());
                    bos.write("\n".getBytes());
                }
                FileUtils.deleteQuietly((File)new File(dir + "." + i));
                br.close();
            }
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(String biocache_service_url, String q, double[] bbox, String filename, SimpleRegion region, String facetField) throws IOException {
        int speciesEstimate = 250000;
        int recordsEstimate = 26000000;
        int pageSize = 50000;
        String bboxTerm = null;
        bboxTerm = bbox != null ? "&fq=longitude:%5B" + bbox[0] + "%20TO%20" + bbox[2] + "%5D&fq=latitude:%5B" + bbox[1] + "%20TO%20" + bbox[3] + "%5D" : "";
        this.points = new ArrayList(recordsEstimate);
        this.lsidIdx = new ArrayList(recordsEstimate);
        this.years = new ArrayList(recordsEstimate);
        HashMap<String, Integer> lsidMap = new HashMap<String, Integer>(speciesEstimate);
        int start = 0;
        RandomAccessFile raf = null;
        if (filename != null) {
            raf = new RandomAccessFile(filename, "rw");
        }
        while (start < 300000000) {
            String[] line;
            String url = biocache_service_url + "/webportal/occurrences.gz?q=" + q.replace(" ", "%20") + bboxTerm + "&pageSize=" + pageSize + "&start=" + start + "&fl=longitude,latitude," + facetField + ",year";
            int tryCount = 0;
            InputStream is = null;
            CSVReader csv = null;
            int maxTrys = 4;
            while (tryCount < maxTrys && csv == null) {
                ++tryCount;
                try {
                    is = Records.getUrlStream(url);
                    csv = new CSVReader((Reader)new InputStreamReader(new GZIPInputStream(is)));
                }
                catch (Exception e) {
                    System.out.println("failed try " + tryCount + " of " + maxTrys + ": " + url);
                    e.printStackTrace();
                }
            }
            if (csv == null) {
                throw new IOException("failed to get records from biocache.");
            }
            int[] header = new int[4];
            int row = start;
            int currentCount = 0;
            while ((line = csv.readNext()) != null) {
                int i;
                if (raf != null) {
                    for (i = 0; i < line.length; ++i) {
                        if (i > 0) {
                            raf.write(",".getBytes());
                        }
                        raf.write(line[i].getBytes());
                    }
                    raf.write("\n".getBytes());
                }
                if (++currentCount == 1) {
                    for (i = 0; i < line.length; ++i) {
                        if (line[i].equals(facetField)) {
                            header[0] = i;
                        }
                        if (line[i].equals("longitude")) {
                            header[1] = i;
                        }
                        if (line[i].equals("latitude")) {
                            header[2] = i;
                        }
                        if (!line[i].equals("year")) continue;
                        header[3] = i;
                    }
                    System.out.println("header info:" + header[0] + "," + header[1] + "," + header[2] + "," + header[3]);
                } else if (line.length >= 3) {
                    try {
                        double longitude = Double.parseDouble(line[header[1]]);
                        double latitude = Double.parseDouble(line[header[2]]);
                        if (region == null || region.isWithin_EPSG900913(longitude, latitude)) {
                            this.points.add(longitude);
                            this.points.add(latitude);
                            String species = line[header[0]];
                            Integer idx = (Integer)lsidMap.get(species);
                            if (idx == null) {
                                idx = lsidMap.size();
                                lsidMap.put(species, idx);
                            }
                            this.lsidIdx.add(idx);
                            this.years.add(Short.parseShort(line[header[3]]));
                        }
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (this.lsidIdx.size() * 2 < this.points.size()) {
                            this.points.remove(this.points.size() - 1);
                            this.points.remove(this.points.size() - 1);
                        } else if (this.years.size() < this.lsidIdx.size()) {
                            this.years.add((short)0);
                        }
                    }
                }
                ++row;
            }
            start = start == 0 ? row - 1 : row - 1;
            csv.close();
            is.close();
            if (currentCount != 0 && currentCount >= pageSize) continue;
            break;
        }
        if (raf != null) {
            raf.close();
        }
        this.lsids = new String[lsidMap.size()];
        for (Map.Entry e : lsidMap.entrySet()) {
            this.lsids[((Integer)e.getValue()).intValue()] = (String)e.getKey();
        }
        System.out.println("Got " + this.getRecordsSize() + " records of " + this.getSpeciesSize() + " species");
    }

    public String getSpecies(int pos) {
        return this.lsids[this.lsidIdx.get(pos)];
    }

    public int getSpeciesNumber(int pos) {
        return this.lsidIdx.get(pos);
    }

    public double getLongitude(int pos) {
        return this.points.get(pos * 2);
    }

    public double getLatitude(int pos) {
        return this.points.get(pos * 2 + 1);
    }

    public short getYear(int pos) {
        return this.years.get(pos);
    }

    public int getRecordsSize() {
        return this.lsidIdx.size();
    }

    public int getSpeciesSize() {
        if (this.lsids == null) {
            return this.speciesSize;
        }
        return this.lsids.length;
    }

    public void removeSpeciesNames() {
        this.speciesSize = this.lsids.length;
        this.lsids = null;
    }

    public int[] sortedRowStarts(double minLat, int height, double resolution) {
        int i;
        if (this.sortOrder != null && this.soMinLat == minLat && this.soHeight == height && this.soResolution == resolution && this.soSortedRowStarts) {
            return this.sortOrderRowStarts;
        }
        this.sortOrder = new Integer[this.points.size() / 2];
        for (int i2 = 0; i2 < this.sortOrder.length; ++i2) {
            this.sortOrder[i2] = i2 * 2 + 1;
        }
        final double mLat = minLat;
        final double res = resolution;
        final int h = height;
        Arrays.sort(this.sortOrder, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return h - 1 - (int)((Records.this.points.get(o1) - mLat) / res) - (h - 1 - (int)((Records.this.points.get(o2) - mLat) / res));
            }
        });
        int[] rowStarts = new int[height];
        int row = 0;
        for (i = 0; i < this.sortOrder.length; ++i) {
            int j;
            int thisRow = h - 1 - (int)((this.points.get(this.sortOrder[i]) - mLat) / res);
            if (thisRow >= height) {
                for (j = row + 1; j < height; ++j) {
                    rowStarts[j] = rowStarts[j - 1];
                }
                break;
            }
            if (thisRow <= row) continue;
            for (j = row + 1; j < thisRow; ++j) {
                rowStarts[j] = i;
            }
            rowStarts[thisRow] = i;
            row = thisRow;
        }
        for (int j = row + 1; j < height; ++j) {
            rowStarts[j] = this.sortOrder.length;
        }
        for (i = 0; i < this.sortOrder.length; ++i) {
            this.sortOrder[i] = (this.sortOrder[i] - 1) / 2;
        }
        this.sortOrderRowStarts = rowStarts;
        this.soMinLat = minLat;
        this.soHeight = height;
        this.soResolution = resolution;
        this.soSortedStarts = false;
        this.soSortedRowStarts = true;
        return rowStarts;
    }

    public void sortedStarts(double minLat, double minLong, double resolution) {
        if (this.sortOrder != null && this.soMinLat == minLat && this.soMinLong == minLong && this.soResolution == resolution && this.soSortedStarts) {
            return;
        }
        this.sortOrder = new Integer[this.points.size() / 2];
        for (int i = 0; i < this.sortOrder.length; ++i) {
            this.sortOrder[i] = i * 2 + 1;
        }
        final double mLat = minLat;
        final double mLong = minLong;
        final double res = resolution;
        Arrays.sort(this.sortOrder, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int v = (int)((Records.this.points.get(o1) - mLat) / res) - (int)((Records.this.points.get(o2) - mLat) / res);
                if (v == 0) {
                    return (int)((Records.this.points.get(o1 - 1) - mLong) / res) - (int)((Records.this.points.get(o2 - 1) - mLong) / res);
                }
                return v;
            }
        });
        this.soMinLat = minLat;
        this.soMinLong = minLong;
        this.soResolution = resolution;
        this.soSortedStarts = true;
        this.soSortedRowStarts = false;
    }

    public String getSortedSpecies(int pos) {
        return this.lsids[this.lsidIdx.get(this.sortOrder[pos])];
    }

    public int getSortedSpeciesNumber(int pos) {
        return this.lsidIdx.get(this.sortOrder[pos]);
    }

    public double getSortedLongitude(int pos) {
        return this.points.get(this.sortOrder[pos] * 2);
    }

    public double getSortedLatitude(int pos) {
        return this.points.get(this.sortOrder[pos] * 2 + 1);
    }
}

