/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Bil2diva {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("hdr bil to diva.  Must be: \n- single band\n- EPSG:4326\n- no skip byes\n- unless PIXELTYPE value in header; NBITS 8=BYTE 16=SHORT 32=INT 64=LONG\n");
            System.out.println("args[0] = bil (without .bil or .hdr) OR directory containing .bil files, \nargs[1] = output prefix (.grd and .gri added) OR output directory if args[0] is a directory, \nargs[2] = units to store in .grd");
            return;
        }
        Bil2diva.bil2diva(args[0], args[1], args[2]);
    }

    public static boolean bil2diva(String bilFilename, String divaFilename, String unitsString) {
        File dir = new File(bilFilename);
        if (dir.isDirectory()) {
            new File(divaFilename).mkdirs();
            boolean success = false;
            for (File f : dir.listFiles()) {
                if (!f.getName().toLowerCase().endsWith(".bil")) continue;
                String name = f.getName().substring(0, f.getName().length() - 4);
                boolean ret = Bil2diva.bil2diva(bilFilename + File.separator + name, divaFilename + File.separator + name, unitsString);
                if (!ret) continue;
                success = true;
            }
            return success;
        }
        System.out.println("Running .bil to diva grid conversion for: " + bilFilename);
        boolean ret = true;
        try {
            int len;
            String noDataValueString;
            String line;
            File headerFile = new File(bilFilename + ".hdr");
            File bilFile = new File(bilFilename + ".bil");
            BufferedReader br = new BufferedReader(new FileReader(headerFile));
            HashMap<String, String> map = new HashMap<String, String>();
            while ((line = br.readLine()) != null) {
                int p = line.indexOf(" ");
                if (p < 0) {
                    p = line.indexOf("\t");
                }
                if (p <= 0) continue;
                map.put(line.substring(0, p).trim().toLowerCase(), line.substring(p).trim().toLowerCase());
            }
            br.close();
            FileWriter fw = new FileWriter(divaFilename + ".grd");
            fw.write("[General]\n");
            fw.write("Creator=Bil2diva\n");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyymmdd");
            fw.write("Created=" + sdf.format(new Date()) + "\n");
            fw.write("Title=" + headerFile.getName().replace(".hdr", "") + "\n");
            fw.write("[GeoReference]\n");
            fw.write("Projection=GEOGRAPHIC\n");
            fw.write("Datum=WGS84\n");
            fw.write("Mapunits=DEGREES\n");
            int ncols = Integer.parseInt((String)map.get("ncols"));
            int nrows = Integer.parseInt((String)map.get("nrows"));
            double minx = Double.parseDouble((String)map.get("ulxmap"));
            double maxy = Double.parseDouble((String)map.get("ulymap"));
            double divx = Double.parseDouble((String)map.get("xdim"));
            double divy = Double.parseDouble((String)map.get("ydim"));
            fw.write("Columns=" + ncols + "\n");
            fw.write("Rows=" + nrows + "\n");
            fw.write("MinX=" + String.valueOf((float)(minx - divx / 2.0)) + "\n");
            fw.write("MaxX=" + String.valueOf((float)(minx + (double)ncols * divx - divx / 2.0)) + "\n");
            fw.write("MinY=" + String.valueOf((float)(maxy - (double)nrows * divy + divy / 2.0)) + "\n");
            fw.write("MaxY=" + String.valueOf((float)(maxy + divy / 2.0)) + "\n");
            fw.write("ResolutionX=" + (String)map.get("xdim") + "\n");
            fw.write("ResolutionY=" + (String)map.get("ydim") + "\n");
            int nbits = Integer.parseInt((String)map.get("nbits"));
            String pixelType = (String)map.get("pixeltype");
            if (pixelType != null) {
                pixelType = pixelType.toUpperCase();
            }
            if (nbits == 8) {
                pixelType = pixelType != null && pixelType.contains("U") ? "UBYTE" : "BYTE";
            } else if (nbits == 16) {
                pixelType = "SHORT";
            } else if (nbits == 32) {
                pixelType = pixelType != null && (pixelType.contains("F") || pixelType.equals("REAL") || pixelType.equals("SINGLE")) ? "FLOAT" : "INT";
            } else if (nbits == 64) {
                pixelType = pixelType != null && (pixelType.contains("D") || pixelType.contains("F")) ? "DOUBLE" : "LONG";
            }
            fw.write("[Data]\n");
            fw.write("DataType=" + pixelType.toUpperCase() + "\n");
            String byteOrder = (String)map.get("byteorder");
            if (byteOrder == null || byteOrder.equals("m")) {
                fw.write("ByteOrder=MSB\n");
            }
            double missingValue = (noDataValueString = (String)map.get("nodata")) == null ? -1.7976931348623157E308 : Double.parseDouble(noDataValueString);
            System.out.println("Reading .bil min and max values");
            double[] minmax = Bil2diva.getMinMax(nbits, pixelType, nrows, ncols, byteOrder, missingValue, bilFile);
            if (noDataValueString == null) {
                noDataValueString = Double.toString(minmax[0] - 1.0);
            }
            fw.write("NoDataValue=" + noDataValueString + "\n");
            fw.write("MinValue=" + minmax[0] + "\n");
            fw.write("MaxValue=" + minmax[1] + "\n");
            fw.write("Transparent=0\n");
            String units = unitsString;
            fw.write("Units=" + units + "\n");
            fw.close();
            System.out.println("Creating diva grid file: " + divaFilename);
            FileInputStream fis = new FileInputStream(bilFile);
            FileOutputStream fos = new FileOutputStream(divaFilename + ".gri");
            byte[] buf = new byte[0x100000];
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            ret = false;
            e.printStackTrace();
        }
        System.out.println(".bil to diva grid conversion complete");
        return ret;
    }

    static double[] getMinMax(int nbits, String datatype, int nrows, int ncols, String strByteOrder, double missingValue, File bilFile) {
        double[] minmax = new double[]{Double.NaN, Double.NaN};
        try {
            RandomAccessFile raf = new RandomAccessFile(bilFile, "r");
            FileChannel channel = raf.getChannel();
            ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
            byteOrder = strByteOrder == null || strByteOrder.equals("m") ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            while (channel.position() < channel.size()) {
                long bytesLeft = channel.size() - channel.position();
                ByteBuffer byteBuffer = bytesLeft < 1024L ? ByteBuffer.allocate((int)bytesLeft) : ByteBuffer.allocate(1024);
                channel.read(byteBuffer);
                byteBuffer.order(byteOrder);
                byteBuffer.position(0);
                while (byteBuffer.hasRemaining()) {
                    if (datatype.equalsIgnoreCase("UBYTE") || datatype.equalsIgnoreCase("INT1U")) {
                        double ret = byteBuffer.get();
                        if (ret < 0.0) {
                            ret += 256.0;
                        }
                        Bil2diva.updateMinMax(minmax, ret, missingValue);
                        continue;
                    }
                    if (datatype.equalsIgnoreCase("BYTE") || datatype.equalsIgnoreCase("INT1BYTE") || datatype.equalsIgnoreCase("INT1B")) {
                        Bil2diva.updateMinMax(minmax, byteBuffer.get(), missingValue);
                        continue;
                    }
                    if (nbits == 16) {
                        Bil2diva.updateMinMax(minmax, byteBuffer.getShort(), missingValue);
                        continue;
                    }
                    if (datatype.equalsIgnoreCase("INT") || datatype.equalsIgnoreCase("INTEGER") || datatype.equalsIgnoreCase("INT4BYTES") || datatype.equalsIgnoreCase("INT4B") || datatype.equalsIgnoreCase("INT32") || datatype.equalsIgnoreCase("SMALLINT")) {
                        Bil2diva.updateMinMax(minmax, byteBuffer.getInt(), missingValue);
                        continue;
                    }
                    if (datatype.equalsIgnoreCase("LONG") || datatype.equalsIgnoreCase("INT8BYTES") || datatype.equalsIgnoreCase("INT8B") || datatype.equalsIgnoreCase("INT64")) {
                        Bil2diva.updateMinMax(minmax, byteBuffer.getLong(), missingValue);
                        continue;
                    }
                    if (datatype.equalsIgnoreCase("FLOAT") || datatype.equalsIgnoreCase("FLT4BYTES") || datatype.equalsIgnoreCase("FLT4B") || datatype.equalsIgnoreCase("FLOAT32") || datatype.equalsIgnoreCase("FLT4S") || datatype.equalsIgnoreCase("REAL") || datatype.equalsIgnoreCase("SINGLE")) {
                        Bil2diva.updateMinMax(minmax, byteBuffer.getFloat(), missingValue);
                        continue;
                    }
                    if (datatype.equalsIgnoreCase("DOUBLE") || datatype.equalsIgnoreCase("FLT8BYTES") || datatype.equalsIgnoreCase("FLT8B") || datatype.equalsIgnoreCase("FLOAT64") || datatype.equalsIgnoreCase("FLT8S")) {
                        Bil2diva.updateMinMax(minmax, byteBuffer.getDouble(), missingValue);
                        continue;
                    }
                    System.out.println("UNKNOWN TYPE: " + datatype);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return minmax;
    }

    static void updateMinMax(double[] minmax, double d, double missingValue) {
        if ((float)d != (float)missingValue) {
            if (Double.isNaN(minmax[0])) {
                minmax[0] = d;
                minmax[1] = d;
            } else {
                if (minmax[0] > d) {
                    minmax[0] = d;
                }
                if (minmax[1] < d) {
                    minmax[1] = d;
                }
            }
        }
    }
}

