/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.legend;

import au.org.ala.layers.legend.QueryField;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class Facet
implements Serializable {
    String field;
    String value;
    String[] valueArray;
    String parameter;
    double min;
    double max;
    boolean includeRange;
    Facet[] orInAndTerms;
    Facet[] andTerms;
    Facet[] orTerms;

    public Facet(String field, String value, boolean includeRange) {
        this.field = field;
        this.value = value;
        this.includeRange = includeRange;
        this.parameter = null;
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.valueArray = null;
        if (this.value != null) {
            this.valueArray = new String[]{this.value};
        }
    }

    public Facet(String field, double min, double max, boolean includeRange) {
        String strMin;
        this.field = field;
        this.min = min;
        this.max = max;
        this.includeRange = includeRange;
        String string = Double.isInfinite(min) ? "*" : (strMin = min == (double)((int)min) ? String.format("%d", (int)min) : String.valueOf(min));
        String strMax = Double.isInfinite(max) ? "*" : (max == (double)((int)max) ? String.format("%d", (int)max) : String.valueOf(max));
        this.value = "[" + strMin + " TO " + strMax + "]";
        this.valueArray = null;
        this.parameter = (includeRange ? "" : "-") + this.field + ":" + this.value;
    }

    public Facet(String field, String strMin, String strMax, boolean includeRange) {
        this.field = field;
        if (field.equals("occurrence_year")) {
            strMin = strMin.replace("-12-31T00:00:00Z", "").replace("-01-01T00:00:00Z", "");
            strMax = strMax.replace("-12-31T00:00:00Z", "").replace("-01-01T00:00:00Z", "");
        }
        double[] d = new double[]{strMin.equals("*") ? Double.NEGATIVE_INFINITY : Double.parseDouble(strMin), strMax.equals("*") ? Double.POSITIVE_INFINITY : Double.parseDouble(strMax)};
        this.min = d[0];
        this.max = d[1];
        this.includeRange = includeRange;
        if (field.equals("occurrence_year")) {
            this.value = !strMin.equals("*") ? "[" + strMin + "-01-01T00:00:00Z TO " : "[" + strMin + " TO ";
            this.value = !strMax.equals("*") ? this.value + strMax + "-12-31T00:00:00Z]" : this.value + strMax + "]";
        } else {
            this.value = "[" + strMin + " TO " + strMax + "]";
        }
        this.valueArray = null;
        this.parameter = (includeRange ? "" : "-") + this.field + ":" + this.value;
    }

    public Facet(String fq, Facet[] orInAndTerms, Facet[] andTerms, Facet[] orTerms) {
        this.parameter = fq;
        this.orInAndTerms = orInAndTerms;
        this.andTerms = andTerms;
        this.orTerms = orTerms;
    }

    public static Facet parseFacet(String fq) {
        boolean invert;
        String s;
        if (fq == null || fq.length() < 3) {
            return null;
        }
        boolean hasAnd = fq.contains(" AND ");
        boolean hasOr = fq.contains(" OR ");
        if (fq.startsWith("-(-(")) {
            int p = fq.indexOf(41);
            Facet[] orPart = Facet.parseTerms(" AND ", fq.substring(4, p), true);
            Facet[] andPart = Facet.parseTerms(" AND ", fq.substring(p + 6, fq.length() - 1), false);
            return new Facet(fq, orPart, andPart, null);
        }
        if (fq.startsWith("-(") && !fq.endsWith(")") && !hasOr) {
            int p = fq.indexOf(41);
            Facet[] orPart = Facet.parseTerms(" AND ", fq.substring(2, p), true);
            Facet[] andPart = Facet.parseTerms(" AND ", fq.substring(p + 6, fq.length() - 1), false);
            return new Facet(fq, orPart, andPart, null);
        }
        Facet[] f = Facet.parseTerms(hasAnd ? " AND " : " OR ", s = (invert = fq.charAt(0) == '-' && fq.charAt(1) == '(') ? fq.substring(2, fq.length() - 1) : fq, invert);
        if (f.length == 1) {
            return f[0];
        }
        if (invert) {
            return new Facet(fq, (Facet[])(hasAnd ? f : null), (Facet[])(hasOr ? f : null), null);
        }
        return new Facet(fq, (Facet[])(hasOr ? f : null), (Facet[])(hasAnd ? f : null), null);
    }

    static Facet[] parseTerms(String separator, String fq, boolean invert) {
        String[] terms = fq.split(separator);
        Facet[] facets = new Facet[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            String ff = terms[i];
            int offset = ff.startsWith("-") ? 1 : 0;
            String f = ff.substring(offset, ff.indexOf(58));
            String v = ff.substring(ff.indexOf(58) + 1);
            if (v.charAt(0) == '\"' || v.charAt(0) == '*' || !v.toUpperCase().contains(" TO ")) {
                if (v.charAt(0) == '\"') {
                    v = v.substring(1, v.length() - 1);
                }
                facets[i] = new Facet(f, v, invert != (offset == 0));
                continue;
            }
            String[] n = v.toUpperCase().substring(1, v.length() - 1).split(" TO ");
            facets[i] = new Facet(f, n[0], n[1], invert != (offset == 0));
        }
        return facets;
    }

    public String toString() {
        String facet = "";
        if (this.parameter == null) {
            if (this.value.startsWith("\"") && this.value.endsWith("\"") || this.value.equals("*")) {
                facet = (this.includeRange ? "" : "-") + this.field + ":" + this.value;
            } else {
                try {
                    facet = (this.includeRange ? "" : "-") + this.field + ":\"" + this.value + "\"";
                }
                catch (Exception e) {
                    Logger.getLogger(Facet.class).error((Object)("failed to encode to UTF-8: " + this.value), (Throwable)e);
                }
            }
            if (this.field.equals("occurrence_year")) {
                if (!facet.contains("* TO *")) {
                    facet = facet.contains("* TO ") ? facet.replace("]", "-12-31T00:00:00Z]") : (facet.contains(" TO *") ? facet.replace(" TO ", "-01-01T00:00:00Z TO ") : facet.replace(" TO ", "-01-01T00:00:00Z TO ").replace("]", "-12-31T00:00:00Z]"));
                }
            } else if (this.field.equals("occurrence_year_decade") || this.field.equals("decade")) {
                if (this.value.contains("before")) {
                    facet = (this.includeRange ? "" : "-") + this.field + ":[* TO 1849-12-31T00:00:00Z]";
                } else {
                    String yr = this.value.replace("\"", "");
                    yr = yr.substring(0, yr.length() - 1);
                    facet = (this.includeRange ? "" : "-") + this.field + ":[" + yr + "0-01-01T00:00:00Z TO " + yr + "9-12-31T00:00:00Z]";
                }
                facet = facet.replace("_decade", "");
            }
        } else {
            facet = this.parameter;
            if (!facet.contains("-01-01T00:00:00Z") && !facet.contains("-12-31T00:00:00Z") && facet.contains("occurrence_year")) {
                if (this.field.equals("occurrence_year")) {
                    if (!this.parameter.contains("* TO *")) {
                        this.parameter = this.parameter.contains("* TO ") ? this.parameter.replace("]", "-12-31T00:00:00Z]") : (this.parameter.contains(" TO *") ? this.parameter.replace(" TO ", "-01-01T00:00:00Z TO ") : this.parameter.replace(" TO ", "-01-01T00:00:00Z TO ").replace("]", "-12-31T00:00:00Z]"));
                    }
                } else if (this.field.equals("occurrence_year_decade") || this.field.equals("decade")) {
                    // empty if block
                }
            }
        }
        return facet;
    }

    public String[] getFields() {
        HashSet<String> fieldSet = new HashSet<String>();
        if (this.field != null) {
            fieldSet.add(this.field);
        }
        if (this.orInAndTerms != null) {
            for (Facet f : this.orInAndTerms) {
                Collections.addAll(fieldSet, f.getFields());
            }
        }
        if (this.andTerms != null) {
            for (Facet f : this.andTerms) {
                Collections.addAll(fieldSet, f.getFields());
            }
        }
        if (this.orTerms != null) {
            for (Facet f : this.orTerms) {
                Collections.addAll(fieldSet, f.getFields());
            }
        }
        String[] fields = new String[fieldSet.size()];
        fieldSet.toArray(fields);
        return fields;
    }

    public boolean isValid(String v) {
        if (this.getType() == 1) {
            for (int i = 0; i < this.valueArray.length; ++i) {
                if (!this.valueArray[i].equals(v) && (v.length() == 0 || !this.valueArray[i].equals("*"))) continue;
                return this.includeRange;
            }
            return !this.includeRange;
        }
        if (this.getType() == 0) {
            try {
                boolean inside;
                double d = Double.parseDouble(v);
                boolean bl = inside = d >= this.min && d <= this.max;
                return this.includeRange ? inside : !inside;
            }
            catch (Exception e) {}
        } else {
            boolean state = true;
            if (this.orInAndTerms != null) {
                boolean bl = state = this.sumTermTests(this.orInAndTerms, v) > 0;
            }
            if (this.andTerms != null && state) {
                boolean bl = state = this.sumTermTests(this.andTerms, v) == this.andTerms.length;
            }
            if (this.orTerms != null) {
                if (state) {
                    return true;
                }
                return this.sumTermTests(this.orTerms, v) > 0;
            }
            return state;
        }
        return !this.includeRange;
    }

    public boolean isValid(double d) {
        if (this.getType() == 1) {
            String v = String.valueOf(d);
            if (Double.isNaN(d)) {
                v = "";
            }
            for (int i = 0; i < this.valueArray.length; ++i) {
                if (!this.valueArray[i].equals(v) && (v.length() == 0 || !this.valueArray[i].equals("*"))) continue;
                return this.includeRange;
            }
            return !this.includeRange;
        }
        if (this.getType() == 0) {
            try {
                boolean inside;
                boolean bl = inside = d >= this.min && d <= this.max;
                return this.includeRange ? inside : !inside;
            }
            catch (Exception e) {}
        } else {
            boolean state = true;
            if (this.orInAndTerms != null) {
                boolean bl = state = this.sumTermTests(this.orInAndTerms, d) > 0;
            }
            if (this.andTerms != null && state) {
                boolean bl = state = this.sumTermTests(this.andTerms, d) == this.andTerms.length;
            }
            if (this.orTerms != null) {
                if (state) {
                    return true;
                }
                return this.sumTermTests(this.orTerms, d) > 0;
            }
            return state;
        }
        return !this.includeRange;
    }

    public int getType() {
        if (this.orInAndTerms != null || this.andTerms != null || this.orTerms != null) {
            return 2;
        }
        if (this.valueArray != null) {
            return 1;
        }
        return 0;
    }

    public boolean isValid(List<QueryField> fields, int record) {
        if (this.getType() == 2) {
            boolean state = true;
            if (this.orInAndTerms != null) {
                boolean bl = state = this.sumTermTests(this.orInAndTerms, fields, record) > 0;
            }
            if (this.andTerms != null && state) {
                boolean bl = state = this.sumTermTests(this.andTerms, fields, record) == this.andTerms.length;
            }
            if (this.orTerms != null) {
                if (state) {
                    return true;
                }
                return this.sumTermTests(this.orTerms, fields, record) > 0;
            }
            return state;
        }
        for (QueryField qf : fields) {
            if (!qf.getName().equals(this.field)) continue;
            if (this.getType() == 1) {
                return this.isValid(qf.getAsString(record));
            }
            switch (qf.getFieldType()) {
                case DOUBLE: {
                    return this.isValid(qf.getDouble(record));
                }
                case FLOAT: {
                    return this.isValid(qf.getFloat(record));
                }
                case LONG: {
                    return this.isValid(qf.getLong(record));
                }
                case INT: {
                    return this.isValid(qf.getInt(record));
                }
            }
            return this.isValid(qf.getAsString(record));
        }
        return !this.includeRange;
    }

    private int sumTermTests(Facet[] andTerms, List<QueryField> fields, int record) {
        int sum = 0;
        for (int i = 0; andTerms != null && i < andTerms.length; ++i) {
            if (andTerms[i].getType() == 2) {
                if (!andTerms[i].isValid(fields, record)) continue;
                ++sum;
                continue;
            }
            if (!andTerms[i].isValid(fields, record)) continue;
            ++sum;
        }
        return sum;
    }

    private int sumTermTests(Facet[] andTerms, String value) {
        int sum = 0;
        for (int i = 0; andTerms != null && i < andTerms.length; ++i) {
            if (andTerms[i].getType() == 2) {
                if (!andTerms[i].isValid(value)) continue;
                ++sum;
                continue;
            }
            if (!andTerms[i].isValid(value)) continue;
            ++sum;
        }
        return sum;
    }

    private int sumTermTests(Facet[] andTerms, double value) {
        int sum = 0;
        for (int i = 0; andTerms != null && i < andTerms.length; ++i) {
            if (andTerms[i].getType() == 2) {
                if (!andTerms[i].isValid(value)) continue;
                ++sum;
                continue;
            }
            if (!andTerms[i].isValid(value)) continue;
            ++sum;
        }
        return sum;
    }

    public double getMin() {
        double newMin;
        int i;
        if (this.getType() == 0) {
            return this.min;
        }
        if (this.getType() == 1) {
            return Double.NaN;
        }
        double min = Double.POSITIVE_INFINITY;
        if (this.orInAndTerms != null) {
            for (i = 0; i < this.orInAndTerms.length; ++i) {
                newMin = this.orInAndTerms[i].getMin();
                if (!this.orInAndTerms[i].includeRange || !(newMin < min)) continue;
                min = newMin;
            }
        }
        if (this.andTerms != null) {
            for (i = 0; i < this.andTerms.length; ++i) {
                newMin = this.andTerms[i].getMin();
                if (!this.andTerms[i].includeRange || !(newMin < min)) continue;
                min = newMin;
            }
        }
        if (this.orTerms != null) {
            for (i = 0; i < this.orTerms.length; ++i) {
                newMin = this.orTerms[i].getMin();
                if (!this.orTerms[i].includeRange || !(newMin < min)) continue;
                min = newMin;
            }
        }
        return min;
    }

    public double getMax() {
        double newMax;
        int i;
        if (this.getType() == 0) {
            return this.max;
        }
        if (this.getType() == 1) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        if (this.orInAndTerms != null) {
            for (i = 0; i < this.orInAndTerms.length; ++i) {
                newMax = this.orInAndTerms[i].getMax();
                if (!this.orInAndTerms[i].includeRange || !(newMax > max)) continue;
                max = newMax;
            }
        }
        if (this.andTerms != null) {
            for (i = 0; i < this.andTerms.length; ++i) {
                newMax = this.andTerms[i].getMax();
                if (!this.andTerms[i].includeRange || !(newMax > max)) continue;
                max = newMax;
            }
        }
        if (this.orTerms != null) {
            for (i = 0; i < this.orTerms.length; ++i) {
                newMax = this.orTerms[i].getMax();
                if (!this.orTerms[i].includeRange || !(newMax > max)) continue;
                max = newMax;
            }
        }
        return max;
    }
}

