/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.SimpleShapeFile;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SimpleShapeFileCache {
    protected Logger logger = Logger.getLogger(this.getClass());
    HashMap<String, SimpleShapeFile> cache = new HashMap();
    HashMap<String, SimpleShapeFile> cacheByFieldId = new HashMap();

    public SimpleShapeFileCache(String[] shapeFileNames, String[] columns, String[] fieldIds) {
        this.update(shapeFileNames, columns, fieldIds);
    }

    public SimpleShapeFile get(String shapeFileName) {
        return this.cache.get(shapeFileName);
    }

    public HashMap<String, SimpleShapeFile> getAll() {
        return this.cacheByFieldId;
    }

    public void update(String[] layers, String[] columns, String[] fieldIds) {
        this.logger.info((Object)"start caching shape files");
        System.gc();
        System.out.println("Memory usage (total/used/free):" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + "MB / " + (Runtime.getRuntime().totalMemory() / 1024L / 1024L - Runtime.getRuntime().freeMemory() / 1024L / 1024L) + "MB / " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "MB");
        for (int i = 0; i < layers.length; ++i) {
            if (this.get(layers[i]) != null) continue;
            try {
                SimpleShapeFile ssf = new SimpleShapeFile(layers[i], columns[i]);
                System.gc();
                this.logger.info((Object)(layers[i] + " loaded, Memory usage (total/used/free):" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + "MB / " + (Runtime.getRuntime().totalMemory() / 1024L / 1024L - Runtime.getRuntime().freeMemory() / 1024L / 1024L) + "MB / " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "MB"));
                if (ssf == null) continue;
                this.cache.put(layers[i], ssf);
                this.cacheByFieldId.put(fieldIds[i], ssf);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("error with shape file: " + layers[i] + ", field: " + columns[i]));
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

