/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.dao.IntersectCallback;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.SimpleShapeFile;
import au.org.ala.layers.intersect.SimpleShapeFileCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class SamplingThread
extends Thread {
    private static final Logger logger = Logger.getLogger(SamplingThread.class);
    LinkedBlockingQueue<Integer> lbq;
    CountDownLatch cdl;
    double[][] points;
    IntersectionFile[] intersectionFiles;
    ArrayList<String> output;
    int threadCount;
    SimpleShapeFileCache simpleShapeFileCache;
    int gridBufferSize;
    IntersectCallback callback;

    public SamplingThread(LinkedBlockingQueue<Integer> lbq, CountDownLatch cdl, IntersectionFile[] intersectionFiles, double[][] points, ArrayList<String> output, int threadCount, SimpleShapeFileCache simpleShapeFileCache, int gridBufferSize, IntersectCallback callback) {
        this.lbq = lbq;
        this.cdl = cdl;
        this.points = points;
        this.intersectionFiles = intersectionFiles;
        this.output = output;
        this.threadCount = threadCount;
        this.simpleShapeFileCache = simpleShapeFileCache;
        this.gridBufferSize = gridBufferSize;
        this.callback = callback;
        this.setPriority(1);
    }

    @Override
    public void run() {
        try {
            while (true) {
                int pos = this.lbq.take();
                this.callback.setCurrentLayerIdx(pos);
                try {
                    StringBuilder sb = new StringBuilder();
                    this.sample(this.points, this.intersectionFiles[pos], sb);
                    this.output.set(pos, sb.toString());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.callback.setCurrentLayer(this.intersectionFiles[pos]);
                this.cdl.countDown();
            }
        }
        catch (Exception e) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
            return;
        }
    }

    public void sample(double[][] points, IntersectionFile intersectionFile, StringBuilder sb) {
        if (intersectionFile == null) {
            return;
        }
        HashMap<Integer, GridClass> classes = intersectionFile.getClasses();
        String shapeFieldName = intersectionFile.getShapeFields();
        String fileName = intersectionFile.getFilePath();
        String name = intersectionFile.getFieldId();
        long start = System.currentTimeMillis();
        logger.info((Object)("Starting sampling " + points.length + " points in " + name + ":" + fileName + (shapeFieldName == null ? "" : " field: " + shapeFieldName)));
        this.callback.progressMessage("Started sampling layer:" + intersectionFile.getLayerName());
        if (shapeFieldName != null) {
            this.intersectShape(fileName, shapeFieldName, points, sb);
        } else if (classes != null) {
            this.intersectGridAsContextual(fileName, classes, points, sb);
        } else {
            this.intersectGrid(fileName, points, sb);
        }
        logger.info((Object)("Finished sampling " + points.length + " points in " + name + ":" + fileName + " in " + (System.currentTimeMillis() - start) + "ms"));
        this.callback.progressMessage("Finished sampling layer: " + intersectionFile.getLayerName() + ". Points processed: " + points.length / 2);
    }

    public void intersectGrid(String filename, double[][] points, StringBuilder sb) {
        try {
            Grid grid = new Grid(filename, true);
            float[] values = null;
            values = grid.getValues3(points, this.gridBufferSize);
            if (values != null) {
                for (int i = 0; i < points.length; ++i) {
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if (!Float.isNaN(values[i])) {
                        sb.append(values[i]);
                        continue;
                    }
                    sb.append("");
                }
            } else {
                for (int i = 1; i < points.length; ++i) {
                    sb.append("\n");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error with grid: " + filename), (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void intersectGridAsContextual(String filename, HashMap<Integer, GridClass> classes, double[][] points, StringBuilder sb) {
        try {
            Grid grid = new Grid(filename);
            float[] values = null;
            values = grid.getValues3(points, this.gridBufferSize);
            if (values != null) {
                for (int i = 0; i < points.length; ++i) {
                    GridClass gc;
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if ((gc = classes.get((int)values[i])) != null) {
                        sb.append(gc.getName());
                        continue;
                    }
                    sb.append("");
                }
            } else {
                for (int i = 1; i < points.length; ++i) {
                    sb.append("\n");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error with grid: " + filename), (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    void intersectShape(String filename, String fieldName, double[][] points, StringBuilder sb) {
        try {
            int column_idx;
            String[] categories;
            int[] values;
            SimpleShapeFile ssf = null;
            if (this.simpleShapeFileCache != null) {
                ssf = this.simpleShapeFileCache.get(filename);
            }
            if (ssf == null) {
                logger.debug((Object)("shape file not in cache: " + filename));
                ssf = new SimpleShapeFile(filename, fieldName);
            }
            if ((values = ssf.intersect(points, categories = ssf.getColumnLookup(column_idx = ssf.getColumnIdx(fieldName)), column_idx, this.threadCount)) != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if (values[i] >= 0) {
                        sb.append(categories[values[i]]);
                        continue;
                    }
                    sb.append("");
                }
            } else {
                for (int i = 1; i < points.length; ++i) {
                    sb.append("\n");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error with shapefile: " + filename), (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

