/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.ingestion;

import au.org.ala.layers.dto.Layer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ThumbnailGenerator {
    private static final Logger LOGGER = Logger.getLogger(ThumbnailGenerator.class);
    private static final int THUMBNAIL_WIDTH = 200;
    private static final int THUMBNAIL_HEIGHT = 200;

    public static void many(List<Layer> layers, String thumbnailDir, boolean force) {
        for (Layer layer : layers) {
            if (!force && ThumbnailGenerator.hasThumbnail(layer.getName(), thumbnailDir)) continue;
            ThumbnailGenerator.one(layer, thumbnailDir);
        }
    }

    private static boolean hasThumbnail(String layerName, String thumbnailDir) {
        return new File(ThumbnailGenerator.thumbnailFileName(layerName, thumbnailDir)).exists();
    }

    private static String thumbnailFileName(String layerName, String thumbnailDir) {
        return thumbnailDir + "/ALA:" + layerName + ".jpg";
    }

    public static void one(Layer layer, String thumbnailDir) {
        try {
            int gwcPos;
            String geoserverUrl = layer.getDisplaypath();
            int wmsPos = geoserverUrl.indexOf("/wms");
            if (wmsPos >= 0) {
                geoserverUrl = geoserverUrl.substring(0, wmsPos);
            }
            if ((gwcPos = geoserverUrl.indexOf("/gwc")) >= 0) {
                geoserverUrl = geoserverUrl.substring(0, gwcPos);
            }
            String thumburl = geoserverUrl + "/wms/reflect?layers=ALA:" + layer.getName() + "&width=" + 200 + "&height=" + 200;
            URL url = new URL(thumburl);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            ((InputStream)in).close();
            String thumbnailFileName = ThumbnailGenerator.thumbnailFileName(layer.getName(), thumbnailDir);
            FileUtils.deleteQuietly((File)new File(thumbnailFileName));
            FileOutputStream fos = new FileOutputStream(thumbnailFileName);
            fos.write(out.toByteArray());
            fos.close();
        }
        catch (IOException ex) {
            LOGGER.error((Object)("failed to create thumbnail for layer: " + layer.getName() + ", thumbnailDir: " + thumbnailDir), (Throwable)ex);
        }
    }
}

