/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.layers.dao.FieldDAO;
import au.org.ala.layers.dao.IntersectCallback;
import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.ObjectDAO;
import au.org.ala.layers.dto.Field;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.dto.Objects;
import au.org.ala.layers.grid.GridCacheReader;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.layers.intersect.SamplingThread;
import au.org.ala.layers.intersect.SimpleShapeFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="layerIntersectDao")
public class LayerIntersectDAOImpl
implements LayerIntersectDAO {
    private static final Logger logger = Logger.getLogger(LayerIntersectDAOImpl.class);
    IntersectConfig intersectConfig;
    LinkedBlockingQueue<GridCacheReader> gridReaders = null;
    int gridGroupCount = 0;
    Object initLock = new Object();
    @Resource(name="fieldDao")
    private FieldDAO fieldDao;
    @Resource(name="layerDao")
    private LayerDAO layerDao;
    @Autowired
    private ApplicationContext appcontext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reload() {
        String error = null;
        try {
            if (this.intersectConfig == null) {
                this.init();
            }
            Object object = this.initLock;
            synchronized (object) {
                LayerIntersectDAOImpl layerIntersectDAOImpl = this;
                int oldGridCacheReaderCount = layerIntersectDAOImpl.intersectConfig.getGridCacheReaderCount();
                this.intersectConfig = new IntersectConfig(this.fieldDao, this.layerDao);
                ArrayList<GridCacheReader> newGridReaders = new ArrayList<GridCacheReader>();
                int i = 0;
                while (true) {
                    LayerIntersectDAOImpl layerIntersectDAOImpl2 = this;
                    if (i >= layerIntersectDAOImpl2.intersectConfig.getGridCacheReaderCount()) break;
                    LayerIntersectDAOImpl layerIntersectDAOImpl3 = this;
                    GridCacheReader gcr = this.fixGridCacheReaderNames(new GridCacheReader(layerIntersectDAOImpl3.intersectConfig.getGridCachePath()));
                    newGridReaders.add(gcr);
                    this.gridGroupCount = gcr.getGroupCount();
                    ++i;
                }
                if (newGridReaders.isEmpty()) {
                    newGridReaders = null;
                }
                for (i = 0; i < oldGridCacheReaderCount; ++i) {
                    this.gridReaders.take();
                }
                this.gridReaders.addAll(newGridReaders);
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"error reloading properties and table images", (Throwable)e);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            error = "error reloading properties and table images\n" + sw.getBuffer().toString();
            return error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        if (this.intersectConfig == null) {
            Object object = this.initLock;
            synchronized (object) {
                if (this.intersectConfig != null) {
                    return;
                }
                this.intersectConfig = new IntersectConfig(this.fieldDao, this.layerDao);
                this.gridReaders = new LinkedBlockingQueue();
                int i = 0;
                while (true) {
                    LayerIntersectDAOImpl layerIntersectDAOImpl = this;
                    if (i >= layerIntersectDAOImpl.intersectConfig.getGridCacheReaderCount()) break;
                    LayerIntersectDAOImpl layerIntersectDAOImpl2 = this;
                    GridCacheReader gcr = this.fixGridCacheReaderNames(new GridCacheReader(layerIntersectDAOImpl2.intersectConfig.getGridCachePath()));
                    try {
                        this.gridReaders.put(gcr);
                    }
                    catch (InterruptedException ex) {
                        logger.error((Object)"failed to add a GridCacheReader");
                    }
                    this.gridGroupCount = gcr.getGroupCount();
                    ++i;
                }
                if (this.gridReaders.size() == 0) {
                    this.gridReaders = null;
                }
            }
        }
    }

    @Override
    public Vector samplingFull(String fieldIds, double longitude, double latitude) {
        this.init();
        Vector out = new Vector();
        for (String id : fieldIds.split(",")) {
            float[] v;
            Layer layer = null;
            int newid = this.cleanObjectId(id);
            IntersectionFile f = this.intersectConfig.getIntersectionFile(id);
            if (f != null) {
                layer = this.layerDao.getLayerByName(f.getLayerName(), false);
            } else {
                if (newid != -1) {
                    layer = this.layerDao.getLayerById(newid, false);
                }
                if (layer == null) {
                    layer = this.layerDao.getLayerByName(id, false);
                }
            }
            double[][] p = new double[][]{{longitude, latitude}};
            if (layer != null) {
                HashMap<String, Object> m;
                if (layer.isShape() && f != null && f.getClasses() == null) {
                    ObjectDAO objectDao = (ObjectDAO)this.appcontext.getBean("objectDao");
                    Objects o = objectDao.getObjectByIdAndLocation("cl" + layer.getId(), longitude, latitude);
                    if (o != null) {
                        m = new HashMap();
                        m.put("field", id);
                        m.put("value", o.getName());
                        m.put("layername", o.getFieldname());
                        m.put("pid", o.getPid());
                        m.put("description", o.getDescription());
                        out.add(m);
                        continue;
                    }
                    m = new HashMap();
                    m.put("field", id);
                    m.put("value", "");
                    m.put("layername", layer.getDisplayname());
                    out.add(m);
                    continue;
                }
                if (!layer.isGrid() && (f == null || f.getClasses() == null)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                this.getConfig();
                Grid g = new Grid(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(layer.getPath_orig()).toString());
                if (g != null) {
                    float[] v2 = g.getValues3(p, 40960);
                    m = new HashMap<String, Object>();
                    m.put("field", id);
                    m.put("layername", layer.getDisplayname());
                    if (f != null && f.getClasses() != null) {
                        GridClass gc = f.getClasses().get((int)v2[0]);
                        m.put("value", gc == null ? "" : gc.getName());
                        if (gc != null) {
                            if (new File(f.getFilePath() + File.separator + "polygons.grd").exists()) {
                                g = new Grid(f.getFilePath() + File.separator + "polygons");
                                if (g != null) {
                                    int v0 = (int)v2[0];
                                    v2 = g.getValues(p);
                                    m.put("pid", f.getLayerPid() + ":" + v0 + ":" + (int)v2[0]);
                                }
                            } else {
                                m.put("pid", f.getLayerPid() + ":" + (int)v2[0]);
                            }
                        }
                    }
                    if (!m.containsKey("value")) {
                        m.put("value", Float.isNaN(v2[0]) ? "" : Float.valueOf(v2[0]));
                        m.put("units", layer.getEnvironmentalvalueunits());
                    }
                    out.add(m);
                    continue;
                }
                StringBuilder stringBuilder2 = new StringBuilder().append("Cannot find grid file: ");
                this.getConfig();
                logger.error((Object)stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(layer.getPath_orig()).toString());
                HashMap<String, String> m2 = new HashMap<String, String>();
                m2.put("field", id);
                m2.put("value", "");
                m2.put("layername", layer.getDisplayname());
                out.add(m2);
                continue;
            }
            String[] info = this.getConfig().getAnalysisLayerInfo(id);
            if (info == null) continue;
            String gid = info[0];
            String filename = info[1];
            String name = info[2];
            Grid grid = new Grid(filename);
            if (grid == null || !new File(filename + ".grd").exists() || (v = grid.getValues(p)) == null) continue;
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("field", id);
            m.put("layername", name + "(" + gid + ")");
            if (Float.isNaN(v[0])) {
                m.put("value", "");
            } else {
                m.put("value", Float.isNaN(v[0]) ? "" : Float.valueOf(v[0]));
            }
            out.add(m);
        }
        return out;
    }

    @Override
    public String sampling(String fieldIds, double longitude, double latitude) {
        this.init();
        double[][] p = new double[][]{{longitude, latitude}};
        String[] fields = fieldIds.split(",");
        int elCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].length() <= 0 || fields[i].charAt(0) != 'e') continue;
            ++elCount;
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Float> gridValues = null;
        for (String fid : fields) {
            String filename;
            Grid grid;
            IntersectionFile f = this.getConfig().getIntersectionFile(fid);
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (f != null) {
                if (f.getShapeFields() != null && this.getConfig().getShapeFileCache() != null) {
                    SimpleShapeFile ssf = this.getConfig().getShapeFileCache().get(f.getFilePath());
                    if (ssf != null) {
                        String s = ssf.intersect(longitude, latitude);
                        if (s == null) continue;
                        sb.append(s);
                        continue;
                    }
                    ObjectDAO objectDao = (ObjectDAO)this.appcontext.getBean("objectDao");
                    Objects o = objectDao.getObjectByIdAndLocation(f.getFieldId(), longitude, latitude);
                    if (o == null) continue;
                    sb.append(o.getName());
                    continue;
                }
                if (gridValues == null && this.gridReaders != null && elCount > this.gridGroupCount) {
                    try {
                        GridCacheReader gcr = this.gridReaders.take();
                        gridValues = gcr.sample(longitude, latitude);
                        this.gridReaders.put(gcr);
                    }
                    catch (Exception e) {
                        logger.error((Object)"GridCacheReader failed.", (Throwable)e);
                    }
                }
                if (gridValues != null) {
                    Float v = (Float)gridValues.get(fid);
                    if (v == null && !gridValues.containsKey(fid)) {
                        Grid g = new Grid(f.getFilePath());
                        if (g == null) continue;
                        float fv = g.getValues(p)[0];
                        if (f.getClasses() != null) {
                            GridClass gc = f.getClasses().get((int)fv);
                            if (gc == null) continue;
                            sb.append(gc.getName());
                            continue;
                        }
                        if (Float.isNaN(fv)) continue;
                        sb.append(String.valueOf(fv));
                        continue;
                    }
                    if (f.getClasses() != null) {
                        GridClass gc = f.getClasses().get(v.intValue());
                        if (gc == null) continue;
                        sb.append(gc.getName());
                        continue;
                    }
                    if (v == null || v.isNaN()) continue;
                    sb.append(String.valueOf(v));
                    continue;
                }
                Grid g = new Grid(f.getFilePath());
                if (g == null) continue;
                float fv = g.getValues(p)[0];
                if (f.getClasses() != null) {
                    GridClass gc = f.getClasses().get((int)fv);
                    if (gc == null) continue;
                    sb.append(gc.getName());
                    continue;
                }
                if (Float.isNaN(fv)) continue;
                sb.append(String.valueOf(fv));
                continue;
            }
            String[] info = this.getConfig().getAnalysisLayerInfo(fid);
            if (info == null || (grid = new Grid(filename = info[1])) == null || !new File(filename + ".grd").exists()) continue;
            sb.append(String.valueOf(grid.getValues(p)[0]));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, String> sampling(double longitude, double latitude) {
        this.init();
        HashMap<String, String> output = new HashMap<String, String>();
        if (this.getConfig().getShapeFileCache() != null) {
            HashMap<String, SimpleShapeFile> ssfs = this.getConfig().getShapeFileCache().getAll();
            for (Map.Entry<String, SimpleShapeFile> entry : ssfs.entrySet()) {
                String s = entry.getValue().intersect(longitude, latitude);
                if (s == null) {
                    s = "";
                }
                output.put(entry.getKey(), s);
            }
        }
        if (this.gridReaders != null) {
            GridCacheReader gcr = null;
            HashMap<String, Float> gridValues = null;
            try {
                gcr = this.gridReaders.take();
                gridValues = gcr.sample(longitude, latitude);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (gcr != null) {
                    try {
                        this.gridReaders.put(gcr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (gridValues != null) {
                for (Map.Entry<String, Float> entry : gridValues.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().isNaN()) {
                        output.put(entry.getKey(), "");
                        continue;
                    }
                    output.put(entry.getKey(), entry.getValue().toString());
                }
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] sampling(String pointsString, int gridcacheToUse) {
        HashMap[] output;
        block26: {
            double[][] points;
            block25: {
                this.init();
                String[] pointsArray = pointsString.split(",");
                points = new double[pointsArray.length / 2][2];
                for (int i = 0; i < pointsArray.length; i += 2) {
                    try {
                        points[i / 2][1] = Double.parseDouble(pointsArray[i]);
                        points[i / 2][0] = Double.parseDouble(pointsArray[i + 1]);
                        continue;
                    }
                    catch (Exception e) {
                        points[i / 2][1] = Double.NaN;
                        points[i / 2][0] = Double.NaN;
                    }
                }
                output = new HashMap[points.length];
                for (int i = 0; i < points.length; ++i) {
                    output[i] = new HashMap();
                }
                if (0 != gridcacheToUse) break block25;
                String fids = "";
                for (Field f : this.fieldDao.getFields()) {
                    if (!f.isEnabled().booleanValue() || !f.isIndb().booleanValue()) continue;
                    if (!fids.isEmpty()) {
                        fids = fids + ",";
                    }
                    fids = fids + f.getId();
                }
                String[] fidsSplit = fids.split(",");
                ArrayList<String> sample = this.sampling(fidsSplit, points);
                for (int i = 0; i < sample.size(); ++i) {
                    String[] column = sample.get(i).split("\n");
                    for (int j = 0; j < column.length; ++j) {
                        output[j].put(fidsSplit[i], column[j]);
                    }
                }
                break block26;
            }
            if (1 != gridcacheToUse) break block26;
            if (this.getConfig().getShapeFileCache() != null) {
                HashMap<String, SimpleShapeFile> ssfs = this.getConfig().getShapeFileCache().getAll();
                for (Map.Entry<String, SimpleShapeFile> entry : ssfs.entrySet()) {
                    for (int i = 0; i < points.length; ++i) {
                        output[i].put(entry.getKey(), entry.getValue().intersect(points[i][0], points[i][1]));
                    }
                }
            }
            if (this.gridReaders != null) {
                GridCacheReader gcr = null;
                try {
                    gcr = this.gridReaders.take();
                    for (int i = 0; i < points.length; ++i) {
                        output[i].putAll(gcr.sample(points[i][0], points[i][1]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (gcr != null) {
                        try {
                            this.gridReaders.put(gcr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return output;
    }

    @Override
    public ArrayList<String> sampling(String fieldIds, String pointsString) {
        this.init();
        String[] pointsArray = pointsString.split(",");
        double[][] points = new double[pointsArray.length / 2][2];
        for (int i = 0; i < pointsArray.length; i += 2) {
            try {
                points[i / 2][1] = Double.parseDouble(pointsArray[i]);
                points[i / 2][0] = Double.parseDouble(pointsArray[i + 1]);
                continue;
            }
            catch (Exception e) {
                points[i / 2][1] = Double.NaN;
                points[i / 2][0] = Double.NaN;
            }
        }
        String[] fidsArray = fieldIds.split(",");
        return this.sampling(fidsArray, points);
    }

    @Override
    public ArrayList<String> sampling(String[] fieldIds, double[][] points, IntersectCallback callback) {
        this.init();
        IntersectionFile[] intersectionFiles = new IntersectionFile[fieldIds.length];
        for (int i = 0; i < fieldIds.length; ++i) {
            intersectionFiles[i] = this.intersectConfig.getIntersectionFile(fieldIds[i]);
            if (intersectionFiles[i] != null) continue;
            String[] info = this.getConfig().getAnalysisLayerInfo(fieldIds[i]);
            if (info != null) {
                intersectionFiles[i] = new IntersectionFile(fieldIds[i], info[1], null, fieldIds[i], fieldIds[i], null, null, null, null);
                continue;
            }
            logger.warn((Object)("failed to find layer for id '" + fieldIds[i] + "'"));
        }
        if (callback == null) {
            callback = new DummyCallback();
        }
        return this.sampling(intersectionFiles, points, callback);
    }

    @Override
    public ArrayList<String> sampling(String[] fieldIds, double[][] points) {
        return this.sampling(fieldIds, points, (IntersectCallback)new DummyCallback());
    }

    @Override
    public ArrayList<String> sampling(IntersectionFile[] intersectionFiles, double[][] points) {
        return this.sampling(intersectionFiles, points, (IntersectCallback)new DummyCallback());
    }

    ArrayList<String> sampling(IntersectionFile[] intersectionFiles, double[][] points, IntersectCallback callback) {
        this.init();
        if (callback == null) {
            callback = new DummyCallback();
        }
        if (this.intersectConfig.isLocalSampling()) {
            return this.localSampling(intersectionFiles, points, callback);
        }
        return this.remoteSampling(intersectionFiles, points, callback);
    }

    @Override
    public IntersectConfig getConfig() {
        this.init();
        return this.intersectConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> localSampling(IntersectionFile[] intersectionFiles, double[][] points, IntersectCallback callback) {
        int i;
        LayerIntersectDAOImpl layerIntersectDAOImpl = this;
        logger.info((Object)("begin LOCAL sampling, number of threads " + layerIntersectDAOImpl.intersectConfig.getThreadCount() + ", number of layers=" + intersectionFiles.length + ", number of coordinates=" + points.length));
        long start = System.currentTimeMillis();
        LayerIntersectDAOImpl layerIntersectDAOImpl2 = this;
        int threadCount = layerIntersectDAOImpl2.intersectConfig.getThreadCount();
        SamplingThread[] threads = new SamplingThread[threadCount];
        LinkedBlockingQueue<Integer> lbq = new LinkedBlockingQueue<Integer>();
        CountDownLatch cdl = new CountDownLatch(intersectionFiles.length);
        ArrayList<String> output = new ArrayList<String>();
        for (i = 0; i < intersectionFiles.length; ++i) {
            output.add("");
            lbq.add(i);
        }
        callback.setLayersToSample(intersectionFiles);
        logger.info((Object)("Initialising sampling threads: " + threadCount));
        for (i = 0; i < threadCount; ++i) {
            LayerIntersectDAOImpl layerIntersectDAOImpl3 = this;
            LayerIntersectDAOImpl layerIntersectDAOImpl4 = this;
            threads[i] = new SamplingThread(lbq, cdl, intersectionFiles, points, output, layerIntersectDAOImpl3.intersectConfig.getThreadCount(), this.intersectConfig.getShapeFileCache(), layerIntersectDAOImpl4.intersectConfig.getGridBufferSize(), callback);
            threads[i].start();
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            for (int i2 = 0; i2 < threadCount; ++i2) {
                try {
                    threads[i2].interrupt();
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        logger.info((Object)("End sampling, threads=" + threadCount + " layers=" + intersectionFiles.length + " in " + (System.currentTimeMillis() - start) + "ms"));
        return output;
    }

    ArrayList<String> remoteSampling(IntersectionFile[] intersectionFiles, double[][] points, IntersectCallback callback) {
        LayerIntersectDAOImpl layerIntersectDAOImpl = this;
        logger.info((Object)("begin REMOTE sampling, number of threads " + layerIntersectDAOImpl.intersectConfig.getThreadCount() + ", number of layers=" + intersectionFiles.length + ", number of coordinates=" + points.length));
        ArrayList<String> output = null;
        try {
            int i;
            String[] line;
            int i2;
            long start = System.currentTimeMillis();
            LayerIntersectDAOImpl layerIntersectDAOImpl2 = this;
            URL url = new URL(layerIntersectDAOImpl2.intersectConfig.getLayerIndexUrl() + "/intersect/batch");
            URLConnection c = url.openConnection();
            c.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(c.getOutputStream());
            out.write("fids=");
            for (i2 = 0; i2 < intersectionFiles.length; ++i2) {
                if (i2 > 0) {
                    out.write(",");
                }
                out.write(intersectionFiles[i2].getFieldId());
            }
            out.write("&points=");
            for (i2 = 0; i2 < points.length; ++i2) {
                if (i2 > 0) {
                    out.write(",");
                }
                out.write(String.valueOf(points[i2][1]));
                out.write(",");
                out.write(String.valueOf(points[i2][0]));
            }
            out.close();
            JSONObject jo = JSONObject.fromObject((Object)IOUtils.toString((InputStream)c.getInputStream()));
            String checkUrl = jo.getString("statusUrl");
            boolean notFinished = true;
            String downloadUrl = null;
            while (notFinished) {
                Thread.sleep(5000L);
                jo = JSONObject.fromObject((Object)IOUtils.toString((InputStream)new URI(checkUrl).toURL().openStream()));
                if (jo.containsKey((Object)"error")) {
                    notFinished = false;
                    continue;
                }
                if (!jo.containsKey((Object)"status")) continue;
                String status = jo.getString("status");
                if ("finished".equals(status)) {
                    downloadUrl = jo.getString("downloadUrl");
                    notFinished = false;
                    continue;
                }
                if (!"cancelled".equals(status) && !"error".equals(status)) continue;
                notFinished = false;
            }
            ZipInputStream zis = new ZipInputStream(new URI(downloadUrl).toURL().openStream());
            ZipEntry ze = zis.getNextEntry();
            CSVReader csv = new CSVReader((Reader)new InputStreamReader(zis));
            long mid = System.currentTimeMillis();
            ArrayList<StringBuilder> tmpOutput = new ArrayList<StringBuilder>();
            for (int i3 = 0; i3 < intersectionFiles.length; ++i3) {
                tmpOutput.add(new StringBuilder());
            }
            int row = 0;
            csv.readNext();
            while ((line = csv.readNext()) != null) {
                for (i = 2; i < line.length && i - 2 < tmpOutput.size(); ++i) {
                    if (row > 0) {
                        ((StringBuilder)tmpOutput.get(i - 2)).append("\n");
                    }
                    ((StringBuilder)tmpOutput.get(i - 2)).append(line[i]);
                }
                ++row;
            }
            csv.close();
            zis.close();
            output = new ArrayList<String>();
            for (i = 0; i < tmpOutput.size(); ++i) {
                output.add(((StringBuilder)tmpOutput.get(i)).toString());
                tmpOutput.set(i, null);
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("sample time for 5 layers and 3 coordinates: get response=" + (mid - start) + "ms, write response=" + (end - mid) + "ms"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return output;
    }

    private int cleanObjectId(String id) {
        int len = Math.min(6, id.length());
        id = id.substring(0, len);
        char prefix = id.toUpperCase().charAt(0);
        String number = id.substring(2, len);
        try {
            int i = Integer.parseInt(number);
            return i;
        }
        catch (Exception e) {
            return -1;
        }
    }

    GridCacheReader fixGridCacheReaderNames(GridCacheReader gcr) {
        ArrayList<String> fileNames = gcr.getFileNames();
        for (int i = 0; i < fileNames.size(); ++i) {
            gcr.updateNames(fileNames.get(i), this.intersectConfig.getFieldIdFromFile(fileNames.get(i)));
        }
        return gcr;
    }

    class DummyCallback
    implements IntersectCallback {
        DummyCallback() {
        }

        @Override
        public void setLayersToSample(IntersectionFile[] layersToSample) {
        }

        @Override
        public void setCurrentLayer(IntersectionFile layer) {
        }

        @Override
        public void setCurrentLayerIdx(Integer layer) {
        }

        @Override
        public void progressMessage(String message) {
        }
    }
}

