/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.FieldDAO;
import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dto.Field;
import au.org.ala.layers.intersect.IntersectConfig;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="fieldDao")
public class FieldDAOImpl
implements FieldDAO {
    private static final Logger logger = Logger.getLogger(FieldDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertField;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;
    @Resource(name="layerDao")
    private LayerDAO layerDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.insertField = new SimpleJdbcInsert(dataSource).withTableName("fields").usingColumns(new String[]{"id", "name", "\"desc\"", "sname", "sdesc", "sid", "addtomap", "\"intersect\"", "defaultlayer", "enabled", "layerbranch", "analysis", "indb", "spid", "namesearch", "type", "last_update"});
    }

    @Override
    public List<Field> getFields() {
        return this.getFields(false);
    }

    @Override
    public List<Field> getFields(boolean enabledFieldsOnly) {
        logger.info((Object)"Getting a list of all fields");
        String sql = "select * from fields";
        if (enabledFieldsOnly) {
            sql = sql + " where enabled=true";
        }
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Field.class), new Object[0]);
    }

    @Override
    public Field getFieldById(String id) {
        return this.getFieldById(id, true);
    }

    @Override
    public Field getFieldById(String id, boolean enabledFieldsOnly) {
        List l;
        logger.info((Object)("Getting enabled field info for id = " + id));
        String sql = "select *, number_of_objects from fields, (select count(*) as number_of_objects from objects where fid = ? ) o where id = ? ";
        if (enabledFieldsOnly) {
            sql = sql + " and enabled=true";
        }
        if ((l = this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Field.class), new Object[]{id, id})).size() > 0) {
            return (Field)l.get(0);
        }
        return null;
    }

    @Override
    public List<Field> getFieldsByDB() {
        this.layerIntersectDao.getConfig();
        if (IntersectConfig.getLayerIndexUrl() != null) {
            return this.layerIntersectDao.getConfig().getFieldsByDB();
        }
        logger.info((Object)"Getting a list of all enabled fields with indb");
        String sql = "select * from fields where enabled=TRUE and indb=TRUE";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Field.class), new Object[0]);
    }

    @Override
    public synchronized void addField(Field field) {
        logger.info((Object)("Add new field for " + field.getName()));
        Map<String, Object> parameters = field.toMap();
        parameters.remove("id");
        String idPrefix = "Contextual".equalsIgnoreCase(this.layerDao.getLayerById(Integer.parseInt(field.getSpid())).getType()) ? "cl" : "el";
        String newId = field.getId();
        if (newId == null || this.getFieldById(newId) != null) {
            String string = newId = this.getFieldById(idPrefix + field.getSpid()) == null ? idPrefix + field.getSpid() : null;
            if (newId == null) {
                String idEnd = field.getSpid();
                while (idEnd.length() < 3) {
                    idEnd = "0" + idEnd;
                }
                int maxNFound = 0;
                for (Field f : this.getFields(false)) {
                    int n;
                    if (!f.getId().startsWith(idPrefix) || !f.getId().endsWith(idEnd) || f.getId().length() - idEnd.length() <= 2 || (n = Integer.parseInt(f.getId().substring(2, f.getId().length() - idEnd.length()))) <= maxNFound) continue;
                    maxNFound = n;
                }
                newId = idPrefix + (maxNFound + 1) + idEnd;
            }
        }
        parameters.put("id", newId);
        if (parameters.containsKey("desc")) {
            parameters.put("\"desc\"", parameters.get("desc"));
            parameters.remove("desc");
        }
        if (parameters.containsKey("intersect")) {
            parameters.put("\"intersect\"", parameters.get("intersect"));
            parameters.remove("intersect");
        }
        this.insertField.execute(parameters);
        field.setId(newId);
    }

    @Override
    public void updateField(Field field) {
        logger.info((Object)("Updating field metadata for " + field.getName()));
        String sql = "update fields set name=:name, \"desc\"=:desc, type=:type, spid=:spid, sid=:sid, sname=:sname, sdesc=:sdesc, indb=:indb, enabled=:enabled, namesearch=:namesearch, defaultlayer=:defaultlayer, \"intersect\"=:intersect, layerbranch=:layerbranch, analysis=:analysis, addtomap=:addtomap where id=:id";
        this.jdbcTemplate.update(sql, field.toMap());
    }

    @Override
    public void delete(String fieldId) {
        Field f = this.getFieldById(fieldId);
        if (f != null) {
            this.jdbcTemplate.update("delete from objects where fid='" + f.getId() + "'", new Object[0]);
            this.jdbcTemplate.update("delete from fields where id='" + f.getId() + "'", new Object[0]);
        }
    }
}

