/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.BooleanOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class LeafOperation
implements BooleanOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    protected String field;
    protected Double val;
    protected Tuple tuple;

    @Override
    public void operate(Tuple tuple) {
        this.tuple = tuple;
    }

    public LeafOperation(String field, double val) {
        this.field = field;
        this.val = val;
    }

    public LeafOperation(StreamExpression expression, StreamFactory factory) throws IOException {
        this.field = factory.getValueOperand(expression, 0);
        this.val = Double.parseDouble(factory.getValueOperand(expression, 1));
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    protected String quote(String s) {
        if (s.contains("(")) {
            return "'" + s + "'";
        }
        return s;
    }
}

