/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public enum NomenclaturalStatus {
    LEGITIMATE(null, null, "acceptable", "potentially valid"),
    VALIDLY_PUBLISHED(null, null, "available", "valid", "established"),
    NEW_COMBINATION("combinatio nova", "comb. nov.", new String[0]),
    REPLACEMENT("nomen novum", "nom. nov.", "replacement name", "substitute name"),
    CONSERVED("nomen conservandum", "nom. cons.", "orth. cons."),
    PROTECTED("nomen protectum", "nom. prot.", new String[0]),
    CORRECTED("nomen correctum", "nom. corr.", "improved"),
    ORIGINAL_COMBINATION(null, null, new String[0]),
    NEW_SPECIES("species novum", "sp. nov.", new String[0]),
    NEW_GENUS("genus novum", "gen. nov.", new String[0]),
    ALTERNATIVE("nomen alternativum", "nom. altern.", new String[0]),
    OBSCURE("nomen obscurum", "nom. obsc.", new String[0]),
    CONSERVED_PROPOSED("nomen conservandum propositum", "orth. cons. prop.", new String[0]),
    PROVISIONAL("nomen provisorium", "nom. prov.", new String[0]),
    SUBNUDUM("nomen subnudum", "nom. subnud.", new String[0]),
    REJECTED_PROPOSED("nomen rejiciendum propositum", "nom. rej. prop.", new String[0]),
    REJECTED_OUTRIGHT_PROPOSED("nomen utique rejiciendum propositum", "nom. utique rej. prop.", new String[0]),
    DOUBTFUL("nomen dubium", "nom. dub.", "dubious"),
    AMBIGUOUS("nomen ambigua", "nom. ambig.", new String[0]),
    CONFUSED("nomen confusum", "nom. confus.", new String[0]),
    FORGOTTEN("nomen oblitum", "nom. obl.", new String[0]),
    ABORTED("nomen abortivum", "nom. abort.", new String[0]),
    ORTHOGRAPHIC_VARIANT("nomen orthographia", "orth. var.", "spelling variant"),
    SUPERFLUOUS("nomen superfluum", "nom. superfl.", new String[0]),
    NUDUM("nomen nudum", "nom. nud.", "nomen solum", "nom. sol."),
    NULL_NAME("nomen nullum", "nom. null.", new String[0]),
    SUPPRESSED("nomen oppressa", "nom. opp.", new String[0]),
    REJECTED_OUTRIGHT("nomen utique rejiciendum", "nom. utique rej.", new String[0]),
    REJECTED("nomen rejiciendum", "nom. rej.", new String[0]),
    ILLEGITIMATE("nomen illegitimum", "nom. illeg.", new String[0]),
    INVALID("nomen invalidum", "nom. inval.", "unavailable"),
    DENIED("nomen negatum", "nom. neg.", new String[0]);

    private static final Set VALID_VALUES;
    private static final Set DOUBTFUL_VALUES;
    private static final Pattern NORMALIZE_TERM;
    private static final Map<String, NomenclaturalStatus> LOOKUP;
    private final String latin;
    private final String abbreviated;
    private final String[] alternatives;

    private static String normalize(String x) {
        return NORMALIZE_TERM.matcher(x.toUpperCase()).replaceAll("");
    }

    @Deprecated
    public static NomenclaturalStatus fromString(String nomStatus) {
        if (Strings.isNullOrEmpty((String)nomStatus)) {
            return null;
        }
        return LOOKUP.get(NomenclaturalStatus.normalize(nomStatus));
    }

    private NomenclaturalStatus(String latin, String abbreviated, String ... alternatives) {
        this.latin = latin;
        this.abbreviated = abbreviated;
        this.alternatives = alternatives;
    }

    public String getLatinLabel() {
        return this.latin;
    }

    @Nullable
    public String getAbbreviatedLabel() {
        return this.abbreviated;
    }

    public boolean isGood() {
        return VALID_VALUES.contains((Object)this);
    }

    public boolean isDoubtful() {
        return DOUBTFUL_VALUES.contains((Object)this);
    }

    public boolean isBad() {
        return !this.isGood() && !this.isDoubtful();
    }

    static {
        VALID_VALUES = ImmutableSet.of((Object)((Object)VALIDLY_PUBLISHED), (Object)((Object)LEGITIMATE), (Object)((Object)NEW_COMBINATION), (Object)((Object)REPLACEMENT), (Object)((Object)NEW_COMBINATION), (Object)((Object)NEW_GENUS), (Object[])new NomenclaturalStatus[]{NEW_SPECIES, SUBNUDUM, CONSERVED, PROTECTED, CORRECTED, ALTERNATIVE, CONSERVED_PROPOSED, PROVISIONAL});
        DOUBTFUL_VALUES = ImmutableSet.of((Object)((Object)DOUBTFUL), (Object)((Object)OBSCURE));
        NORMALIZE_TERM = Pattern.compile("[._ -]+");
        HashMap lookup = Maps.newHashMap();
        for (NomenclaturalStatus n : NomenclaturalStatus.values()) {
            lookup.put(NomenclaturalStatus.normalize(n.name()), n);
            if (n.getLatinLabel() != null) {
                lookup.put(NomenclaturalStatus.normalize(n.getLatinLabel()), n);
                lookup.put(NomenclaturalStatus.normalize(n.getLatinLabel().replace("nomen ", "")), n);
            }
            if (n.getAbbreviatedLabel() != null) {
                lookup.put(NomenclaturalStatus.normalize(n.getAbbreviatedLabel()), n);
            }
            if (n.alternatives == null) continue;
            for (String alt : n.alternatives) {
                lookup.put(NomenclaturalStatus.normalize(alt), n);
            }
        }
        LOOKUP = ImmutableMap.copyOf((Map)lookup);
    }
}

