/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import org.gbif.api.model.crawler.CrawlJob;
import org.gbif.api.model.crawler.FinishReason;
import org.gbif.api.model.crawler.ProcessState;

public class DatasetProcessStatus {
    private UUID datasetKey;
    private CrawlJob crawlJob;
    private Date startedCrawling;
    private Date finishedCrawling;
    private String crawlContext;
    private FinishReason finishReason;
    private ProcessState processStateOccurrence;
    private ProcessState processStateChecklist;
    private ProcessState processStateSample;
    private Long declaredCount;
    private long pagesCrawled;
    private long pagesFragmentedSuccessful;
    private long pagesFragmentedError;
    private long fragmentsEmitted;
    private long fragmentsReceived;
    private long rawOccurrencesPersistedNew;
    private long rawOccurrencesPersistedUpdated;
    private long rawOccurrencesPersistedUnchanged;
    private long rawOccurrencesPersistedError;
    private long fragmentsProcessed;
    private long verbatimOccurrencesPersistedSuccessful;
    private long verbatimOccurrencesPersistedError;
    private long interpretedOccurrencesPersistedSuccessful;
    private long interpretedOccurrencesPersistedError;

    public static Builder builder() {
        return new Builder();
    }

    public DatasetProcessStatus() {
    }

    public DatasetProcessStatus(Builder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder can't be null");
        this.datasetKey = (UUID)Preconditions.checkNotNull((Object)builder.datasetKey, (Object)"datasetKey can't be null");
        this.crawlJob = (CrawlJob)Preconditions.checkNotNull((Object)builder.crawlJob, (Object)"crawlJob can't be null");
        this.startedCrawling = builder.startedCrawling;
        this.finishedCrawling = builder.finishedCrawling;
        this.finishReason = builder.finishReason;
        this.processStateOccurrence = builder.processStateOccurrence;
        this.processStateChecklist = builder.processStateChecklist;
        this.processStateSample = builder.processStateSample;
        this.crawlContext = builder.crawlContext;
        this.declaredCount = builder.declaredCount;
        this.pagesCrawled = builder.pagesCrawled;
        this.pagesFragmentedSuccessful = builder.pagesFragmentedSuccessful;
        this.pagesFragmentedError = builder.pagesFragmentedError;
        this.fragmentsEmitted = builder.fragmentsEmitted;
        this.fragmentsReceived = builder.fragmentsReceived;
        this.rawOccurrencesPersistedNew = builder.rawOccurrencesPersistedNew;
        this.rawOccurrencesPersistedUpdated = builder.rawOccurrencesPersistedUpdated;
        this.rawOccurrencesPersistedUnchanged = builder.rawOccurrencesPersistedUnchanged;
        this.rawOccurrencesPersistedError = builder.rawOccurrencesPersistedError;
        this.fragmentsProcessed = builder.fragmentsProcessed;
        this.verbatimOccurrencesPersistedSuccessful = builder.verbatimOccurrencesPersistedSuccessful;
        this.verbatimOccurrencesPersistedError = builder.verbatimOccurrencesPersistedError;
        this.interpretedOccurrencesPersistedSuccessful = builder.interpretedOccurrencesPersistedSuccessful;
        this.interpretedOccurrencesPersistedError = builder.interpretedOccurrencesPersistedError;
        Preconditions.checkArgument((this.declaredCount == null || this.declaredCount >= 0L ? 1 : 0) != 0, (Object)"declaredCount must be either null or greater than or equal to zero");
        Preconditions.checkArgument((this.pagesCrawled >= 0L ? 1 : 0) != 0, (Object)"pagesCrawled has to be greater than or equal to zero");
        Preconditions.checkArgument((this.pagesFragmentedSuccessful >= 0L ? 1 : 0) != 0, (Object)"pagesFragmentedSuccessful");
        Preconditions.checkArgument((this.pagesFragmentedError >= 0L ? 1 : 0) != 0, (Object)"pagesFragmentedError has to be greater than or equal to zero");
        Preconditions.checkArgument((this.fragmentsEmitted >= 0L ? 1 : 0) != 0, (Object)"fragmentsEmitted has to be greater than or equal to zero");
        Preconditions.checkArgument((this.fragmentsReceived >= 0L ? 1 : 0) != 0, (Object)"fragmentsReceived has to be greater than or equal to zero");
        Preconditions.checkArgument((this.rawOccurrencesPersistedNew >= 0L ? 1 : 0) != 0, (Object)"rawOccurrencesPersistedNew has to be greater than or equal to zero");
        Preconditions.checkArgument((this.rawOccurrencesPersistedUpdated >= 0L ? 1 : 0) != 0, (Object)"rawOccurrencesPersistedUpdated has to be greater than or equal to zero");
        Preconditions.checkArgument((this.rawOccurrencesPersistedUnchanged >= 0L ? 1 : 0) != 0, (Object)"rawOccurrencesPersistedUnchanged has to be greater than or equal to zero");
        Preconditions.checkArgument((this.rawOccurrencesPersistedError >= 0L ? 1 : 0) != 0, (Object)"rawOccurrencesPersistedError has to be greater than or equal to zero");
        Preconditions.checkArgument((this.fragmentsProcessed >= 0L ? 1 : 0) != 0, (Object)"fragmentsProcessed has to be greater than or equal to zero");
        Preconditions.checkArgument((this.verbatimOccurrencesPersistedSuccessful >= 0L ? 1 : 0) != 0, (Object)"verbatimOccurrencesPersistedSuccessful has to be greater than or equal to zero");
        Preconditions.checkArgument((this.verbatimOccurrencesPersistedError >= 0L ? 1 : 0) != 0, (Object)"verbatimOccurrencesPersistedError has to be greater than or equal to zero");
        Preconditions.checkArgument((this.interpretedOccurrencesPersistedSuccessful >= 0L ? 1 : 0) != 0, (Object)"interpretedOccurrencesPersistedSuccessful has to be greater than or equal to zero");
        Preconditions.checkArgument((this.interpretedOccurrencesPersistedError >= 0L ? 1 : 0) != 0, (Object)"interpretedOccurrencesPersistedError has to be greater than or equal to zero");
    }

    @Nullable
    public String getCrawlContext() {
        return this.crawlContext;
    }

    public CrawlJob getCrawlJob() {
        return this.crawlJob;
    }

    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    @Nullable
    public Long getDeclaredCount() {
        return this.declaredCount;
    }

    @Nullable
    public Date getFinishedCrawling() {
        return this.finishedCrawling;
    }

    @Nullable
    public FinishReason getFinishReason() {
        return this.finishReason;
    }

    @Nullable
    public ProcessState getProcessStateOccurrence() {
        return this.processStateOccurrence;
    }

    @Nullable
    public ProcessState getProcessStateChecklist() {
        return this.processStateChecklist;
    }

    @Nullable
    public ProcessState getProcessStateSample() {
        return this.processStateSample;
    }

    @Min(value=0L)
    public long getFragmentsEmitted() {
        return this.fragmentsEmitted;
    }

    @Min(value=0L)
    public long getFragmentsProcessed() {
        return this.fragmentsProcessed;
    }

    @Min(value=0L)
    public long getFragmentsReceived() {
        return this.fragmentsReceived;
    }

    @Min(value=0L)
    public long getInterpretedOccurrencesPersistedError() {
        return this.interpretedOccurrencesPersistedError;
    }

    @Min(value=0L)
    public long getInterpretedOccurrencesPersistedSuccessful() {
        return this.interpretedOccurrencesPersistedSuccessful;
    }

    @Min(value=0L)
    public long getPagesCrawled() {
        return this.pagesCrawled;
    }

    @Min(value=0L)
    public long getPagesFragmentedError() {
        return this.pagesFragmentedError;
    }

    @Min(value=0L)
    public long getPagesFragmentedSuccessful() {
        return this.pagesFragmentedSuccessful;
    }

    @Min(value=0L)
    public long getRawOccurrencesPersistedError() {
        return this.rawOccurrencesPersistedError;
    }

    @Min(value=0L)
    public long getRawOccurrencesPersistedNew() {
        return this.rawOccurrencesPersistedNew;
    }

    @Min(value=0L)
    public long getRawOccurrencesPersistedUnchanged() {
        return this.rawOccurrencesPersistedUnchanged;
    }

    @Min(value=0L)
    public long getRawOccurrencesPersistedUpdated() {
        return this.rawOccurrencesPersistedUpdated;
    }

    @Nullable
    public Date getStartedCrawling() {
        return this.startedCrawling;
    }

    @Min(value=0L)
    public long getVerbatimOccurrencesPersistedError() {
        return this.verbatimOccurrencesPersistedError;
    }

    @Min(value=0L)
    public long getVerbatimOccurrencesPersistedSuccessful() {
        return this.verbatimOccurrencesPersistedSuccessful;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    public void setCrawlJob(CrawlJob crawlJob) {
        this.crawlJob = crawlJob;
    }

    public void setStartedCrawling(Date startedCrawling) {
        this.startedCrawling = startedCrawling;
    }

    public void setFinishedCrawling(Date finishedCrawling) {
        this.finishedCrawling = finishedCrawling;
    }

    public void setCrawlContext(String crawlContext) {
        this.crawlContext = crawlContext;
    }

    public void setFinishReason(FinishReason finishReason) {
        this.finishReason = finishReason;
    }

    public void setProcessStateOccurrence(ProcessState processStateOccurrence) {
        this.processStateOccurrence = processStateOccurrence;
    }

    public void setProcessStateChecklist(ProcessState processStateChecklist) {
        this.processStateChecklist = processStateChecklist;
    }

    public void setProcessStateSample(ProcessState processStateSample) {
        this.processStateSample = processStateSample;
    }

    public void setDeclaredCount(Long declaredCount) {
        this.declaredCount = declaredCount;
    }

    public void setPagesCrawled(long pagesCrawled) {
        this.pagesCrawled = pagesCrawled;
    }

    public void setPagesFragmentedSuccessful(long pagesFragmentedSuccessful) {
        this.pagesFragmentedSuccessful = pagesFragmentedSuccessful;
    }

    public void setPagesFragmentedError(long pagesFragmentedError) {
        this.pagesFragmentedError = pagesFragmentedError;
    }

    public void setFragmentsEmitted(long fragmentsEmitted) {
        this.fragmentsEmitted = fragmentsEmitted;
    }

    public void setFragmentsReceived(long fragmentsReceived) {
        this.fragmentsReceived = fragmentsReceived;
    }

    public void setRawOccurrencesPersistedNew(long rawOccurrencesPersistedNew) {
        this.rawOccurrencesPersistedNew = rawOccurrencesPersistedNew;
    }

    public void setRawOccurrencesPersistedUpdated(long rawOccurrencesPersistedUpdated) {
        this.rawOccurrencesPersistedUpdated = rawOccurrencesPersistedUpdated;
    }

    public void setRawOccurrencesPersistedUnchanged(long rawOccurrencesPersistedUnchanged) {
        this.rawOccurrencesPersistedUnchanged = rawOccurrencesPersistedUnchanged;
    }

    public void setRawOccurrencesPersistedError(long rawOccurrencesPersistedError) {
        this.rawOccurrencesPersistedError = rawOccurrencesPersistedError;
    }

    public void setFragmentsProcessed(long fragmentsProcessed) {
        this.fragmentsProcessed = fragmentsProcessed;
    }

    public void setVerbatimOccurrencesPersistedSuccessful(long verbatimOccurrencesPersistedSuccessful) {
        this.verbatimOccurrencesPersistedSuccessful = verbatimOccurrencesPersistedSuccessful;
    }

    public void setVerbatimOccurrencesPersistedError(long verbatimOccurrencesPersistedError) {
        this.verbatimOccurrencesPersistedError = verbatimOccurrencesPersistedError;
    }

    public void setInterpretedOccurrencesPersistedSuccessful(long interpretedOccurrencesPersistedSuccessful) {
        this.interpretedOccurrencesPersistedSuccessful = interpretedOccurrencesPersistedSuccessful;
    }

    public void setInterpretedOccurrencesPersistedError(long interpretedOccurrencesPersistedError) {
        this.interpretedOccurrencesPersistedError = interpretedOccurrencesPersistedError;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatasetProcessStatus other = (DatasetProcessStatus)obj;
        return Objects.equal((Object)this.datasetKey, (Object)other.datasetKey) && Objects.equal((Object)this.crawlJob, (Object)other.crawlJob) && Objects.equal((Object)this.startedCrawling, (Object)other.startedCrawling) && Objects.equal((Object)this.finishedCrawling, (Object)other.finishedCrawling) && Objects.equal((Object)((Object)this.finishReason), (Object)((Object)other.finishReason)) && Objects.equal((Object)((Object)this.processStateOccurrence), (Object)((Object)other.processStateOccurrence)) && Objects.equal((Object)((Object)this.processStateChecklist), (Object)((Object)other.processStateChecklist)) && Objects.equal((Object)((Object)this.processStateSample), (Object)((Object)other.processStateSample)) && Objects.equal((Object)this.crawlContext, (Object)other.crawlContext) && Objects.equal((Object)this.declaredCount, (Object)other.declaredCount) && Objects.equal((Object)this.pagesCrawled, (Object)other.pagesCrawled) && Objects.equal((Object)this.pagesFragmentedSuccessful, (Object)other.pagesFragmentedSuccessful) && Objects.equal((Object)this.pagesFragmentedError, (Object)other.pagesFragmentedError) && Objects.equal((Object)this.fragmentsEmitted, (Object)other.fragmentsEmitted) && Objects.equal((Object)this.fragmentsReceived, (Object)other.fragmentsReceived) && Objects.equal((Object)this.rawOccurrencesPersistedNew, (Object)other.rawOccurrencesPersistedNew) && Objects.equal((Object)this.rawOccurrencesPersistedUpdated, (Object)other.rawOccurrencesPersistedUpdated) && Objects.equal((Object)this.rawOccurrencesPersistedUnchanged, (Object)other.rawOccurrencesPersistedUnchanged) && Objects.equal((Object)this.rawOccurrencesPersistedError, (Object)other.rawOccurrencesPersistedError) && Objects.equal((Object)this.fragmentsProcessed, (Object)other.fragmentsProcessed) && Objects.equal((Object)this.verbatimOccurrencesPersistedSuccessful, (Object)other.verbatimOccurrencesPersistedSuccessful) && Objects.equal((Object)this.verbatimOccurrencesPersistedError, (Object)other.verbatimOccurrencesPersistedError) && Objects.equal((Object)this.interpretedOccurrencesPersistedSuccessful, (Object)other.interpretedOccurrencesPersistedSuccessful) && Objects.equal((Object)this.interpretedOccurrencesPersistedError, (Object)other.interpretedOccurrencesPersistedError);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetKey, this.crawlJob, this.startedCrawling, this.finishedCrawling, this.finishReason, this.processStateOccurrence, this.processStateChecklist, this.processStateSample, this.crawlContext, this.declaredCount, this.pagesCrawled, this.pagesFragmentedSuccessful, this.pagesFragmentedError, this.fragmentsEmitted, this.fragmentsReceived, this.rawOccurrencesPersistedNew, this.rawOccurrencesPersistedUpdated, this.rawOccurrencesPersistedUnchanged, this.rawOccurrencesPersistedError, this.fragmentsProcessed, this.verbatimOccurrencesPersistedSuccessful, this.verbatimOccurrencesPersistedError, this.interpretedOccurrencesPersistedSuccessful, this.interpretedOccurrencesPersistedError});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetKey", (Object)this.datasetKey).add("crawlJob", (Object)this.crawlJob).add("startedCrawling", (Object)this.startedCrawling).add("finishedCrawling", (Object)this.finishedCrawling).add("finisReason", (Object)this.finishReason).add("processStateOccurrence", (Object)this.processStateOccurrence).add("processStateChecklist", (Object)this.processStateChecklist).add("processStateSample", (Object)this.processStateSample).add("crawlContext", (Object)this.crawlContext).add("declaredCount", (Object)this.declaredCount).add("pagesCrawled", this.pagesCrawled).add("pagesFragmentedSuccessful", this.pagesFragmentedSuccessful).add("pagesFragmentedError", this.pagesFragmentedError).add("fragmentsEmitted", this.fragmentsEmitted).add("fragmentsReceived", this.fragmentsReceived).add("rawOccurrencesPersistedNew", this.rawOccurrencesPersistedNew).add("rawOccurrencesPersistedUpdated", this.rawOccurrencesPersistedUpdated).add("rawOccurrencesPersistedUnchanged", this.rawOccurrencesPersistedUnchanged).add("rawOccurrencesPersistedError", this.rawOccurrencesPersistedError).add("fragmentsProcessed", this.fragmentsProcessed).add("verbatimOccurrencesPersistedSuccessful", this.verbatimOccurrencesPersistedSuccessful).add("verbatimOccurrencesPersistedError", this.verbatimOccurrencesPersistedError).add("interpretedOccurrencesPersistedSuccessful", this.interpretedOccurrencesPersistedSuccessful).add("interpretedOccurrencesPersistedError", this.interpretedOccurrencesPersistedError).toString();
    }

    public static class Builder {
        private UUID datasetKey;
        private CrawlJob crawlJob;
        private Date startedCrawling;
        private Date finishedCrawling;
        private String crawlContext;
        private FinishReason finishReason;
        private ProcessState processStateOccurrence;
        private ProcessState processStateChecklist;
        private ProcessState processStateSample;
        private Long declaredCount;
        private long pagesCrawled;
        private long pagesFragmentedSuccessful;
        private long pagesFragmentedError;
        private long fragmentsEmitted;
        private long fragmentsReceived;
        private long rawOccurrencesPersistedNew;
        private long rawOccurrencesPersistedUpdated;
        private long rawOccurrencesPersistedUnchanged;
        private long rawOccurrencesPersistedError;
        private long fragmentsProcessed;
        private long verbatimOccurrencesPersistedSuccessful;
        private long verbatimOccurrencesPersistedError;
        private long interpretedOccurrencesPersistedSuccessful;
        private long interpretedOccurrencesPersistedError;

        public DatasetProcessStatus build() {
            return new DatasetProcessStatus(this);
        }

        public Builder crawlContext(String crawlContext) {
            this.crawlContext = crawlContext;
            return this;
        }

        public Builder crawlJob(CrawlJob crawlJob) {
            this.crawlJob = crawlJob;
            return this;
        }

        public Builder datasetKey(UUID datasetKey) {
            this.datasetKey = datasetKey;
            return this;
        }

        public Builder declaredCount(Long declaredCount) {
            this.declaredCount = declaredCount;
            return this;
        }

        public Builder finishedCrawling(Date finishedCrawling) {
            this.finishedCrawling = finishedCrawling;
            return this;
        }

        public Builder finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public Builder processStateOccurrence(ProcessState processStateOccurrence) {
            this.processStateOccurrence = processStateOccurrence;
            return this;
        }

        public Builder processStateChecklist(ProcessState processStateChecklist) {
            this.processStateChecklist = processStateChecklist;
            return this;
        }

        public Builder processStateSample(ProcessState processStateSample) {
            this.processStateSample = processStateSample;
            return this;
        }

        public Builder fragmentsEmitted(long fragmentsEmitted) {
            this.fragmentsEmitted = fragmentsEmitted;
            return this;
        }

        public Builder fragmentsProcessed(long fragmentsProcessed) {
            this.fragmentsProcessed = fragmentsProcessed;
            return this;
        }

        public Builder fragmentsReceived(long fragmentsReceived) {
            this.fragmentsReceived = fragmentsReceived;
            return this;
        }

        public Builder interpretedOccurrencesPersistedError(long interpretedOccurrencesPersistedError) {
            this.interpretedOccurrencesPersistedError = interpretedOccurrencesPersistedError;
            return this;
        }

        public Builder interpretedOccurrencesPersistedSuccessful(long interpretedOccurrencesPersistedSuccessful) {
            this.interpretedOccurrencesPersistedSuccessful = interpretedOccurrencesPersistedSuccessful;
            return this;
        }

        public Builder pagesCrawled(long pagesCrawled) {
            this.pagesCrawled = pagesCrawled;
            return this;
        }

        public Builder pagesFragmentedError(long pagesFragmentedError) {
            this.pagesFragmentedError = pagesFragmentedError;
            return this;
        }

        public Builder pagesFragmentedSuccessful(long pagesFragmentedSuccessful) {
            this.pagesFragmentedSuccessful = pagesFragmentedSuccessful;
            return this;
        }

        public Builder rawOccurrencesPersistedError(long rawOccurrencesPersistedError) {
            this.rawOccurrencesPersistedError = rawOccurrencesPersistedError;
            return this;
        }

        public Builder rawOccurrencesPersistedNew(long rawOccurrencesPersistedNew) {
            this.rawOccurrencesPersistedNew = rawOccurrencesPersistedNew;
            return this;
        }

        public Builder rawOccurrencesPersistedUnchanged(long rawOccurrencesPersistedUnchanged) {
            this.rawOccurrencesPersistedUnchanged = rawOccurrencesPersistedUnchanged;
            return this;
        }

        public Builder rawOccurrencesPersistedUpdated(long rawOccurrencesPersistedUpdated) {
            this.rawOccurrencesPersistedUpdated = rawOccurrencesPersistedUpdated;
            return this;
        }

        public Builder startedCrawling(Date startedCrawling) {
            this.startedCrawling = startedCrawling;
            return this;
        }

        public Builder verbatimOccurrencesPersistedError(long verbatimOccurrencesPersistedError) {
            this.verbatimOccurrencesPersistedError = verbatimOccurrencesPersistedError;
            return this;
        }

        public Builder verbatimOccurrencesPersistedSuccessful(long verbatimOccurrencesPersistedSuccessful) {
            this.verbatimOccurrencesPersistedSuccessful = verbatimOccurrencesPersistedSuccessful;
            return this;
        }
    }
}

