/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotools.measure.SexagesimalConverter;

public final class Units {
    public static final Unit<Angle> SEXAGESIMAL_DMS = NonSI.DEGREE_ANGLE.transform(SexagesimalConverter.FRACTIONAL.inverse()).asType(Angle.class);
    public static final Unit<Angle> DEGREE_MINUTE_SECOND = NonSI.DEGREE_ANGLE.transform(SexagesimalConverter.INTEGER.inverse()).asType(Angle.class);
    public static final Unit<Dimensionless> PPM = Unit.ONE.times(1.0E-6);

    private Units() {
    }

    static {
        UnitFormat format = UnitFormat.getInstance();
        format.label(SEXAGESIMAL_DMS, "D.MS");
        format.label(DEGREE_MINUTE_SECOND, "DMS");
        format.label(PPM, "ppm");
    }
}

