/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.NamedList;

public class MetricUtils {
    static final String MS = "_ms";
    static final String MIN = "min";
    static final String MIN_MS = "min_ms";
    static final String MAX = "max";
    static final String MAX_MS = "max_ms";
    static final String MEAN = "mean";
    static final String MEAN_MS = "mean_ms";
    static final String MEDIAN = "median";
    static final String MEDIAN_MS = "median_ms";
    static final String STDDEV = "stddev";
    static final String STDDEV_MS = "stddev_ms";
    static final String P75 = "p75";
    static final String P75_MS = "p75_ms";
    static final String P95 = "p95";
    static final String P95_MS = "p95_ms";
    static final String P99 = "p99";
    static final String P99_MS = "p99_ms";
    static final String P999 = "p999";
    static final String P999_MS = "p999_ms";

    public static void addMetrics(NamedList<Object> lst, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        lst.add("avgRequestsPerSecond", (Object)timer.getMeanRate());
        lst.add("5minRateRequestsPerSecond", (Object)timer.getFiveMinuteRate());
        lst.add("15minRateRequestsPerSecond", (Object)timer.getFifteenMinuteRate());
        lst.add("avgTimePerRequest", (Object)MetricUtils.nsToMs(snapshot.getMean()));
        lst.add("medianRequestTime", (Object)MetricUtils.nsToMs(snapshot.getMedian()));
        lst.add("75thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get75thPercentile()));
        lst.add("95thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get95thPercentile()));
        lst.add("99thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get99thPercentile()));
        lst.add("999thPcRequestTime", (Object)MetricUtils.nsToMs(snapshot.get999thPercentile()));
    }

    static double nsToMs(double ns) {
        return ns / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public static NamedList toNamedList(MetricRegistry registry, List<MetricFilter> shouldMatchFilters, MetricFilter mustMatchFilter) {
        NamedList response = new NamedList();
        Map metrics = registry.getMetrics();
        SortedSet names = registry.getNames();
        names.stream().filter(s -> shouldMatchFilters.stream().anyMatch(metricFilter -> metricFilter.matches(s, (Metric)metrics.get(s)))).filter(s -> mustMatchFilter.matches(s, (Metric)metrics.get(s))).forEach(n -> {
            Metric metric = (Metric)metrics.get(n);
            if (metric instanceof Counter) {
                Counter counter = (Counter)metric;
                response.add(n, (Object)MetricUtils.counterToNamedList(counter));
            } else if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                response.add(n, (Object)MetricUtils.gaugeToNamedList(gauge));
            } else if (metric instanceof Meter) {
                Meter meter = (Meter)metric;
                response.add(n, (Object)MetricUtils.meterToNamedList(meter));
            } else if (metric instanceof Timer) {
                Timer timer = (Timer)metric;
                response.add(n, (Object)MetricUtils.timerToNamedList(timer));
            } else if (metric instanceof Histogram) {
                Histogram histogram = (Histogram)metric;
                response.add(n, (Object)MetricUtils.histogramToNamedList(histogram));
            }
        });
        return response;
    }

    static NamedList histogramToNamedList(Histogram histogram) {
        NamedList response = new NamedList();
        Snapshot snapshot = histogram.getSnapshot();
        response.add("count", (Object)histogram.getCount());
        MetricUtils.addSnapshot(response, snapshot, false);
        return response;
    }

    static double nsToMs(boolean convert, double value) {
        if (convert) {
            return MetricUtils.nsToMs(value);
        }
        return value;
    }

    static void addSnapshot(NamedList response, Snapshot snapshot, boolean ms) {
        response.add(ms ? MIN_MS : MIN, (Object)MetricUtils.nsToMs(ms, snapshot.getMin()));
        response.add(ms ? MAX_MS : MAX, (Object)MetricUtils.nsToMs(ms, snapshot.getMax()));
        response.add(ms ? MEAN_MS : MEAN, (Object)MetricUtils.nsToMs(ms, snapshot.getMean()));
        response.add(ms ? MEDIAN_MS : MEDIAN, (Object)MetricUtils.nsToMs(ms, snapshot.getMedian()));
        response.add(ms ? STDDEV_MS : STDDEV, (Object)MetricUtils.nsToMs(ms, snapshot.getStdDev()));
        response.add(ms ? P75_MS : P75, (Object)MetricUtils.nsToMs(ms, snapshot.get75thPercentile()));
        response.add(ms ? P95_MS : P95, (Object)MetricUtils.nsToMs(ms, snapshot.get95thPercentile()));
        response.add(ms ? P99_MS : P99, (Object)MetricUtils.nsToMs(ms, snapshot.get99thPercentile()));
        response.add(ms ? P999_MS : P999, (Object)MetricUtils.nsToMs(ms, snapshot.get999thPercentile()));
    }

    static NamedList timerToNamedList(Timer timer) {
        NamedList response = new NamedList();
        response.add("count", (Object)timer.getCount());
        response.add("meanRate", (Object)timer.getMeanRate());
        response.add("1minRate", (Object)timer.getOneMinuteRate());
        response.add("5minRate", (Object)timer.getFiveMinuteRate());
        response.add("15minRate", (Object)timer.getFifteenMinuteRate());
        MetricUtils.addSnapshot(response, timer.getSnapshot(), true);
        return response;
    }

    static NamedList meterToNamedList(Meter meter) {
        NamedList response = new NamedList();
        response.add("count", (Object)meter.getCount());
        response.add("meanRate", (Object)meter.getMeanRate());
        response.add("1minRate", (Object)meter.getOneMinuteRate());
        response.add("5minRate", (Object)meter.getFiveMinuteRate());
        response.add("15minRate", (Object)meter.getFifteenMinuteRate());
        return response;
    }

    static NamedList gaugeToNamedList(Gauge gauge) {
        NamedList response = new NamedList();
        response.add("value", gauge.getValue());
        return response;
    }

    static NamedList counterToNamedList(Counter counter) {
        NamedList response = new NamedList();
        response.add("count", (Object)counter.getCount());
        return response;
    }

    public static ExecutorService instrumentedExecutorService(ExecutorService delegate, MetricRegistry metricRegistry, String scope) {
        return new InstrumentedExecutorService(delegate, metricRegistry, scope);
    }
}

