/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;

public class InstrumentedPoolingClientConnectionManager
extends PoolingClientConnectionManager
implements SolrMetricProducer {
    protected MetricRegistry metricsRegistry;

    public InstrumentedPoolingClientConnectionManager(SchemeRegistry schreg) {
        super(schreg);
    }

    public MetricRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MetricRegistry metricRegistry) {
        this.metricsRegistry = metricRegistry;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String scope) {
        this.metricsRegistry = manager.registry(registry);
        this.metricsRegistry.register(SolrMetricManager.mkName("availableConnections", scope), (Metric)((Gauge)() -> this.getTotalStats().getAvailable()));
        this.metricsRegistry.register(SolrMetricManager.mkName("leasedConnections", scope), (Metric)((Gauge)() -> this.getTotalStats().getLeased()));
        this.metricsRegistry.register(SolrMetricManager.mkName("maxConnections", scope), (Metric)((Gauge)() -> this.getTotalStats().getMax()));
        this.metricsRegistry.register(SolrMetricManager.mkName("pendingConnections", scope), (Metric)((Gauge)() -> this.getTotalStats().getPending()));
    }
}

