/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.AtomicUpdateDocumentMerger;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipExistingDocumentsProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware,
UpdateRequestProcessorFactory.RunAlways {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_SKIP_INSERT_IF_EXISTS = "skipInsertIfExists";
    private static final String PARAM_SKIP_UPDATE_IF_MISSING = "skipUpdateIfMissing";
    private boolean skipInsertIfExists = true;
    private boolean skipUpdateIfMissing = true;

    @Override
    public void init(NamedList args) {
        Object tmp = args.remove(PARAM_SKIP_INSERT_IF_EXISTS);
        if (null != tmp) {
            if (!(tmp instanceof Boolean)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'skipInsertIfExists' must be configured as a <bool>");
            }
            this.skipInsertIfExists = (Boolean)tmp;
        }
        if (null != (tmp = args.remove(PARAM_SKIP_UPDATE_IF_MISSING))) {
            if (!(tmp instanceof Boolean)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'skipUpdateIfMissing' must be configured as a <bool>");
            }
            this.skipUpdateIfMissing = (Boolean)tmp;
        }
        super.init(args);
    }

    @Override
    public SkipExistingDocumentsUpdateProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        DistributedUpdateProcessorFactory.addParamToDistributedRequestWhitelist(req, PARAM_SKIP_INSERT_IF_EXISTS, PARAM_SKIP_UPDATE_IF_MISSING);
        boolean skipInsertForRequest = req.getOriginalParams().getBool(PARAM_SKIP_INSERT_IF_EXISTS, this.skipInsertIfExists);
        boolean skipUpdateForRequest = req.getOriginalParams().getBool(PARAM_SKIP_UPDATE_IF_MISSING, this.skipUpdateIfMissing);
        return new SkipExistingDocumentsUpdateProcessor(req, next, skipInsertForRequest, skipUpdateForRequest);
    }

    @Override
    public void inform(SolrCore core) {
        if (core.getUpdateHandler().getUpdateLog() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "updateLog must be enabled.");
        }
        if (core.getLatestSchema().getUniqueKeyField() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "schema must have uniqueKey defined.");
        }
    }

    static class SkipExistingDocumentsUpdateProcessor
    extends UpdateRequestProcessor {
        private final boolean skipInsertIfExists;
        private final boolean skipUpdateIfMissing;
        private final SolrCore core;
        private DistributedUpdateProcessor distribProc;
        private DistributedUpdateProcessor.DistribPhase phase;

        SkipExistingDocumentsUpdateProcessor(SolrQueryRequest req, UpdateRequestProcessor next, boolean skipInsertIfExists, boolean skipUpdateIfMissing) {
            super(next);
            this.skipInsertIfExists = skipInsertIfExists;
            this.skipUpdateIfMissing = skipUpdateIfMissing;
            this.core = req.getCore();
            UpdateRequestProcessor proc = next;
            while (proc != null) {
                if (proc instanceof DistributedUpdateProcessor) {
                    this.distribProc = (DistributedUpdateProcessor)proc;
                    break;
                }
                proc = proc.next;
            }
            if (this.distribProc == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "DistributedUpdateProcessor must follow SkipExistingDocumentsUpdateProcessor");
            }
            this.phase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        }

        boolean isSkipInsertIfExists() {
            return this.skipInsertIfExists;
        }

        boolean isSkipUpdateIfMissing() {
            return this.skipUpdateIfMissing;
        }

        boolean doesDocumentExist(BytesRef indexedDocId) throws IOException {
            assert (null != indexedDocId);
            SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocumentFromTlog(this.core, indexedDocId);
            if (oldDoc == RealTimeGetComponent.DELETED) {
                return false;
            }
            if (oldDoc != null) {
                return true;
            }
            RefCounted<SolrIndexSearcher> newestSearcher = this.core.getRealtimeSearcher();
            try {
                SolrIndexSearcher searcher = newestSearcher.get();
                boolean bl = searcher.lookupId(indexedDocId) >= 0L;
                return bl;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading document from index", (Throwable)e);
            }
            finally {
                if (newestSearcher != null) {
                    newestSearcher.decref();
                }
            }
        }

        boolean isLeader(UpdateCommand cmd) {
            if ((cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
                return false;
            }
            if (this.phase == DistributedUpdateProcessor.DistribPhase.FROMLEADER) {
                return false;
            }
            return this.distribProc.isLeader(cmd);
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            BytesRef indexedDocId = cmd.getIndexedId();
            boolean isUpdate = AtomicUpdateDocumentMerger.isAtomicUpdate(cmd);
            if (log.isDebugEnabled()) {
                log.debug("Document ID {} ... exists already? {} ... isAtomicUpdate? {} ... isLeader? {}", new Object[]{indexedDocId.utf8ToString(), this.doesDocumentExist(indexedDocId), isUpdate, this.isLeader(cmd)});
            }
            if (this.skipInsertIfExists && !isUpdate && this.isLeader(cmd) && this.doesDocumentExist(indexedDocId)) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping insert for pre-existing document ID {}", (Object)indexedDocId.utf8ToString());
                }
                return;
            }
            if (this.skipUpdateIfMissing && isUpdate && this.isLeader(cmd) && !this.doesDocumentExist(indexedDocId)) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping update to non-existent document ID {}", (Object)indexedDocId.utf8ToString());
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Passing on document ID {}", (Object)indexedDocId.utf8ToString());
            }
            super.processAdd(cmd);
        }
    }
}

