/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public abstract class SimpleUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    protected final String myName;
    protected NamedList initArgs = new NamedList();
    private static ThreadLocal<SolrQueryRequest> REQ = new ThreadLocal();

    protected SimpleUpdateProcessorFactory() {
        String simpleName = this.getClass().getSimpleName();
        int idx = simpleName.indexOf("UpdateProcessorFactory");
        this.myName = idx == -1 ? simpleName : simpleName.substring(0, idx);
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initArgs = args;
    }

    @Override
    public UpdateRequestProcessor getInstance(final SolrQueryRequest req, final SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                REQ.set(req);
                try {
                    SimpleUpdateProcessorFactory.this.process(cmd, req, rsp);
                }
                finally {
                    REQ.remove();
                }
                super.processAdd(cmd);
            }
        };
    }

    protected String getParam(String name) {
        String[] v = this.getParams(name);
        return v == null || v.length == 0 ? null : v[0];
    }

    protected String[] getParams(String name) {
        String[] v = REQ.get().getParams().getParams(this._param(name));
        if (v == null) {
            v = this.initArgs.get(name);
        }
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            return v;
        }
        return new String[]{v.toString()};
    }

    private String _param(String name) {
        return this.myName + "." + name;
    }

    protected abstract void process(AddUpdateCommand var1, SolrQueryRequest var2, SolrQueryResponse var3);
}

