/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicUpdateDocumentMerger {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final IndexSchema schema;
    protected final SchemaField idField;

    public AtomicUpdateDocumentMerger(SolrQueryRequest queryReq) {
        this.schema = queryReq.getSchema();
        this.idField = this.schema.getUniqueKeyField();
    }

    public static boolean isAtomicUpdate(AddUpdateCommand cmd) {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        for (SolrInputField sif : sdoc.values()) {
            if (!(sif.getValue() instanceof Map)) continue;
            return true;
        }
        return false;
    }

    public SolrInputDocument merge(SolrInputDocument fromDoc, SolrInputDocument toDoc) {
        for (SolrInputField sif : fromDoc.values()) {
            Object val = sif.getValue();
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    String key = (String)entry.getKey();
                    Object fieldVal = entry.getValue();
                    boolean updateField = false;
                    switch (key) {
                        case "add": {
                            updateField = true;
                            this.doAdd(toDoc, sif, fieldVal);
                            break;
                        }
                        case "set": {
                            updateField = true;
                            this.doSet(toDoc, sif, fieldVal);
                            break;
                        }
                        case "remove": {
                            updateField = true;
                            this.doRemove(toDoc, sif, fieldVal);
                            break;
                        }
                        case "removeregex": {
                            updateField = true;
                            this.doRemoveRegex(toDoc, sif, fieldVal);
                            break;
                        }
                        case "inc": {
                            updateField = true;
                            this.doInc(toDoc, sif, fieldVal);
                            break;
                        }
                        default: {
                            log.warn("Unknown operation for the an atomic update, operation ignored: " + key);
                        }
                    }
                    if (!updateField || !this.idField.getName().equals(sif.getName())) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update of id field: " + sif);
                }
                continue;
            }
            toDoc.put(sif.getName(), sif);
        }
        return toDoc;
    }

    protected void doSet(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        SchemaField sf = this.schema.getField(sif.getName());
        toDoc.setField(sif.getName(), sf.getType().toNativeType(fieldVal), sif.getBoost());
    }

    protected void doAdd(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        SchemaField sf = this.schema.getField(sif.getName());
        toDoc.addField(sif.getName(), sf.getType().toNativeType(fieldVal), sif.getBoost());
    }

    protected void doInc(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        SolrInputField numericField = toDoc.get((Object)sif.getName());
        if (numericField == null) {
            toDoc.setField(sif.getName(), fieldVal, sif.getBoost());
        } else {
            String oldValS = numericField.getFirstValue().toString();
            SchemaField sf = this.schema.getField(sif.getName());
            BytesRefBuilder term = new BytesRefBuilder();
            sf.getType().readableToIndexed(oldValS, term);
            Object oldVal = sf.getType().toObject(sf, term.get());
            String fieldValS = fieldVal.toString();
            Number result = oldVal instanceof Long ? (Number)((Long)oldVal + Long.parseLong(fieldValS)) : (Number)(oldVal instanceof Float ? (Number)Float.valueOf(((Float)oldVal).floatValue() + Float.parseFloat(fieldValS)) : (Number)(oldVal instanceof Double ? (Number)((Double)oldVal + Double.parseDouble(fieldValS)) : (Number)((Integer)oldVal + Integer.parseInt(fieldValS))));
            toDoc.setField(sif.getName(), (Object)result, sif.getBoost());
        }
    }

    protected void doRemove(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        if (existingField == null) {
            return;
        }
        SchemaField sf = this.schema.getField(name);
        if (sf != null) {
            Collection original = existingField.getValues();
            if (fieldVal instanceof Collection) {
                for (Object object : (Collection)fieldVal) {
                    Object o = sf.getType().toNativeType(object);
                    original.remove(o);
                }
            } else {
                original.remove(sf.getType().toNativeType(fieldVal));
            }
            toDoc.setField(name, (Object)original);
        }
    }

    protected void doRemoveRegex(SolrInputDocument toDoc, SolrInputField sif, Object valuePatterns) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        if (existingField != null) {
            HashSet valueToRemove = new HashSet();
            Collection original = existingField.getValues();
            Collection<Pattern> patterns = this.preparePatterns(valuePatterns);
            for (Object value : original) {
                for (Pattern pattern : patterns) {
                    Matcher m = pattern.matcher(value.toString());
                    if (!m.matches()) continue;
                    valueToRemove.add(value);
                }
            }
            original.removeAll(valueToRemove);
            toDoc.setField(name, (Object)original);
        }
    }

    private Collection<Pattern> preparePatterns(Object fieldVal) {
        LinkedHashSet<Pattern> patterns = new LinkedHashSet<Pattern>(1);
        if (fieldVal instanceof Collection) {
            Collection patternVals = (Collection)fieldVal;
            for (String patternVal : patternVals) {
                patterns.add(Pattern.compile(patternVal));
            }
        } else {
            patterns.add(Pattern.compile(fieldVal.toString()));
        }
        return patterns;
    }
}

