/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.InstrumentedExecutorService;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.util.Args;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.stats.HttpClientMetricNameStrategy;
import org.apache.solr.util.stats.InstrumentedHttpClient;
import org.apache.solr.util.stats.InstrumentedHttpRequestExecutor;
import org.apache.solr.util.stats.InstrumentedPoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler
implements SolrMetricProducer,
SolrInfoMBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExecutorService updateExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("updateExecutor"));
    private ExecutorService recoveryExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("recoveryExecutor"));
    private final CloseableHttpClient client;
    private final InstrumentedPoolingClientConnectionManager clientConnectionManager;
    private final UpdateShardHandlerConfig cfg;
    private IdleConnectionsEvictor idleConnectionsEvictor;

    public UpdateShardHandler(UpdateShardHandlerConfig cfg) {
        this.cfg = cfg;
        this.clientConnectionManager = new InstrumentedPoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
        if (cfg != null) {
            this.clientConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.clientConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
        }
        ModifiableSolrParams clientParams = this.getClientParams();
        log.info("Creating UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        HttpClientMetricNameStrategy metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get("queryLessURLAndMethod");
        if (cfg != null && (metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get(cfg.getMetricNameStrategy())) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + cfg.getMetricNameStrategy() + " found. Must be one of: " + InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        InstrumentedHttpClient httpClient = new InstrumentedHttpClient((ClientConnectionManager)this.clientConnectionManager, metricNameStrategy);
        HttpClientUtil.configureClient((DefaultHttpClient)httpClient, (SolrParams)clientParams);
        this.client = httpClient;
        if (cfg != null) {
            this.idleConnectionsEvictor = new IdleConnectionsEvictor((ClientConnectionManager)this.clientConnectionManager, cfg.getUpdateConnectionsEvictorSleepDelay(), TimeUnit.MILLISECONDS, cfg.getMaxUpdateConnectionIdleTime(), TimeUnit.MILLISECONDS);
            this.idleConnectionsEvictor.start();
        }
        log.trace("Created UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
    }

    protected ModifiableSolrParams getClientParams() {
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        if (this.cfg != null) {
            clientParams.set("socketTimeout", this.cfg.getDistributedSocketTimeout());
            clientParams.set("connTimeout", this.cfg.getDistributedConnectionTimeout());
        }
        clientParams.set("retry", true);
        return clientParams;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String scope) {
        String expandedScope = SolrMetricManager.mkName(scope, this.getCategory().name());
        this.clientConnectionManager.initializeMetrics(manager, registry, expandedScope);
        if (this.client instanceof SolrMetricProducer) {
            SolrMetricProducer solrMetricProducer = (SolrMetricProducer)this.client;
            solrMetricProducer.initializeMetrics(manager, registry, expandedScope);
        }
        this.updateExecutor = new InstrumentedExecutorService(this.updateExecutor, manager.registry(registry), SolrMetricManager.mkName("updateExecutor", expandedScope, "threadPool"));
        this.recoveryExecutor = new InstrumentedExecutorService(this.recoveryExecutor, manager.registry(registry), SolrMetricManager.mkName("recoveryExecutor", expandedScope, "threadPool"));
    }

    @Override
    public String getDescription() {
        return "Metrics tracked by UpdateShardHandler related to distributed updates and recovery";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.UPDATE;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return new URL[0];
    }

    @Override
    public NamedList getStatistics() {
        return null;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public void reconfigureHttpClient(HttpClientConfigurer configurer) {
        log.info("Reconfiguring the default client with: " + configurer);
        configurer.configure((DefaultHttpClient)this.client, (SolrParams)this.getClientParams());
    }

    public ClientConnectionManager getConnectionManager() {
        return this.clientConnectionManager;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    public ExecutorService getRecoveryExecutor() {
        return this.recoveryExecutor;
    }

    public void close() {
        try {
            ExecutorUtil.shutdownWithInterruptAndAwaitTermination((ExecutorService)this.updateExecutor);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.recoveryExecutor);
            if (this.idleConnectionsEvictor != null) {
                this.idleConnectionsEvictor.shutdown();
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.client);
            this.clientConnectionManager.shutdown();
        }
    }

    public static final class IdleConnectionsEvictor {
        private final ClientConnectionManager connectionManager;
        private final ThreadFactory threadFactory;
        private final Thread thread;
        private final long sleepTimeMs;
        private final long maxIdleTimeMs;
        private volatile Exception exception;

        public IdleConnectionsEvictor(final ClientConnectionManager connectionManager, ThreadFactory threadFactory, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            this.connectionManager = (ClientConnectionManager)Args.notNull((Object)connectionManager, (String)"Connection manager");
            this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
            this.sleepTimeMs = sleepTimeUnit != null ? sleepTimeUnit.toMillis(sleepTime) : sleepTime;
            this.maxIdleTimeMs = maxIdleTimeUnit != null ? maxIdleTimeUnit.toMillis(maxIdleTime) : maxIdleTime;
            this.thread = this.threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            Thread.sleep(sleepTimeMs);
                            connectionManager.closeExpiredConnections();
                            if (maxIdleTimeMs <= 0L) continue;
                            connectionManager.closeIdleConnections(maxIdleTimeMs, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                }
            });
        }

        public IdleConnectionsEvictor(ClientConnectionManager connectionManager, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            this(connectionManager, null, sleepTime, sleepTimeUnit, maxIdleTime, maxIdleTimeUnit);
        }

        public void start() {
            this.thread.start();
        }

        public void shutdown() {
            this.thread.interrupt();
        }

        public boolean isRunning() {
            return this.thread.isAlive();
        }

        public void awaitTermination(long time, TimeUnit tunit) throws InterruptedException {
            this.thread.join((tunit != null ? tunit : TimeUnit.MILLISECONDS).toMillis(time));
        }

        static class DefaultThreadFactory
        implements ThreadFactory {
            DefaultThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "solr-idle-connections-evictor");
                t.setDaemon(true);
                return t;
            }
        }
    }
}

