/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerSync
implements SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();
    private List<String> replicas;
    private int nUpdates;
    private int maxUpdates;
    private UpdateHandler uhandler;
    private UpdateLog ulog;
    private HttpShardHandlerFactory shardHandlerFactory;
    private ShardHandler shardHandler;
    private List<SyncShardRequest> requests = new ArrayList<SyncShardRequest>();
    private List<Long> startingVersions;
    private List<Long> ourUpdates;
    private Set<Long> ourUpdateSet;
    private Set<Long> requestedUpdateSet;
    private long ourLowThreshold;
    private long ourHighThreshold;
    private long ourHighest;
    private final boolean cantReachIsSuccess;
    private final boolean getNoVersionsIsSuccess;
    private final boolean doFingerprint;
    private final HttpClient client;
    private final boolean onlyIfActive;
    private SolrCore core;
    private Timer syncTime;
    private Counter syncErrors;
    private Counter syncSkipped;
    public static Comparator<Long> absComparator = (o1, o2) -> {
        long l2;
        long l1 = Math.abs(o1);
        if (l1 > (l2 = Math.abs(o2))) {
            return -1;
        }
        if (l1 < l2) {
            return 1;
        }
        return 0;
    };
    private static Comparator<Object> updateRecordComparator = (o1, o2) -> {
        long l2;
        if (!(o1 instanceof List)) {
            return 1;
        }
        if (!(o2 instanceof List)) {
            return -1;
        }
        List lst1 = (List)o1;
        List lst2 = (List)o2;
        long l1 = Math.abs((Long)lst1.get(1));
        if (l1 > (l2 = Math.abs((Long)lst2.get(1)))) {
            return 1;
        }
        if (l1 < l2) {
            return -1;
        }
        return 0;
    };

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates) {
        this(core, replicas, nUpdates, false, true);
    }

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates, boolean cantReachIsSuccess, boolean getNoVersionsIsSuccess) {
        this(core, replicas, nUpdates, cantReachIsSuccess, getNoVersionsIsSuccess, false, true);
    }

    public PeerSync(SolrCore core, List<String> replicas, int nUpdates, boolean cantReachIsSuccess, boolean getNoVersionsIsSuccess, boolean onlyIfActive, boolean doFingerprint) {
        this.core = core;
        this.replicas = replicas;
        this.nUpdates = nUpdates;
        this.maxUpdates = nUpdates;
        this.cantReachIsSuccess = cantReachIsSuccess;
        this.getNoVersionsIsSuccess = getNoVersionsIsSuccess;
        this.doFingerprint = doFingerprint && !"true".equals(System.getProperty("solr.disableFingerprint"));
        this.client = core.getCoreDescriptor().getCoreContainer().getUpdateShardHandler().getHttpClient();
        this.onlyIfActive = onlyIfActive;
        this.uhandler = core.getUpdateHandler();
        this.ulog = this.uhandler.getUpdateLog();
        this.shardHandlerFactory = (HttpShardHandlerFactory)core.getCoreDescriptor().getCoreContainer().getShardHandlerFactory();
        this.shardHandler = this.shardHandlerFactory.getShardHandler(this.client);
        core.getCoreMetricManager().registerMetricProducer(SolrInfoMBean.Category.REPLICATION.toString(), this);
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String scope) {
        this.syncTime = manager.timer(registry, "time", scope);
        this.syncErrors = manager.counter(registry, "errors", scope);
        this.syncSkipped = manager.counter(registry, "skipped", scope);
    }

    public void setStartingVersions(List<Long> startingVersions) {
        this.startingVersions = startingVersions;
    }

    public long percentile(List<Long> arr, float frac) {
        int elem = (int)((float)arr.size() * frac);
        return Math.abs(arr.get(elem));
    }

    private String msg() {
        ZkController zkController = this.uhandler.core.getCoreDescriptor().getCoreContainer().getZkController();
        String myURL = "";
        if (zkController != null) {
            myURL = zkController.getBaseUrl();
        }
        return "PeerSync: core=" + this.uhandler.core.getName() + " url=" + myURL + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerSyncResult sync() {
        if (this.ulog == null) {
            this.syncErrors.inc();
            return PeerSyncResult.failure();
        }
        MDCLoggingContext.setCore(this.core);
        Timer.Context timerContext = null;
        try {
            ShardResponse srsp;
            Object newList22;
            log.info(this.msg() + "START replicas=" + this.replicas + " nUpdates=" + this.nUpdates);
            if (this.debug && this.startingVersions != null) {
                log.debug(this.msg() + "startingVersions=" + this.startingVersions.size() + " " + this.startingVersions);
            }
            if (this.doFingerprint && this.alreadyInSync()) {
                this.syncSkipped.inc();
                PeerSyncResult peerSyncResult = PeerSyncResult.success();
                return peerSyncResult;
            }
            timerContext = this.syncTime.time();
            for (String string : this.replicas) {
                this.requestVersions(string);
            }
            Throwable throwable = null;
            try (Object recentUpdates = this.ulog.getRecentUpdates();){
                this.ourUpdates = ((UpdateLog.RecentUpdates)recentUpdates).getVersions(this.nUpdates);
            }
            catch (Throwable throwable2) {
                Throwable peerSyncResult = throwable2;
                throw throwable2;
            }
            Collections.sort(this.ourUpdates, absComparator);
            if (this.startingVersions != null) {
                if (this.startingVersions.size() == 0) {
                    log.warn("no frame of reference to tell if we've missed updates");
                    this.syncErrors.inc();
                    recentUpdates = PeerSyncResult.failure();
                    return recentUpdates;
                }
                Collections.sort(this.startingVersions, absComparator);
                this.ourLowThreshold = this.percentile(this.startingVersions, 0.8f);
                this.ourHighThreshold = this.percentile(this.startingVersions, 0.2f);
                long smallestNewUpdate = Math.abs(this.ourUpdates.get(this.ourUpdates.size() - 1));
                if (Math.abs(this.startingVersions.get(0)) < smallestNewUpdate) {
                    log.warn(this.msg() + "too many updates received since start - startingUpdates no longer overlaps with our currentUpdates");
                    this.syncErrors.inc();
                    PeerSyncResult peerSyncResult = PeerSyncResult.failure();
                    return peerSyncResult;
                }
                newList22 = new ArrayList<Long>(this.ourUpdates);
                for (Long ver : this.startingVersions) {
                    if (Math.abs(ver) >= smallestNewUpdate) continue;
                    newList22.add((Long)ver);
                }
                this.ourUpdates = newList22;
                Collections.sort(this.ourUpdates, absComparator);
            } else if (this.ourUpdates.size() > 0) {
                this.ourLowThreshold = this.percentile(this.ourUpdates, 0.8f);
                this.ourHighThreshold = this.percentile(this.ourUpdates, 0.2f);
            } else {
                Object srsp2;
                log.info(this.msg() + "DONE.  We have no versions.  sync failed.");
                while ((srsp2 = this.shardHandler.takeCompletedOrError()) != null) {
                    List list;
                    if (((ShardResponse)srsp2).getException() != null || (list = (List)((ShardResponse)srsp2).getSolrResponse().getResponse().get("versions")) == null || list.isEmpty()) continue;
                    this.syncErrors.inc();
                    PeerSyncResult newList22 = PeerSyncResult.failure(true);
                    return newList22;
                }
                this.syncErrors.inc();
                srsp2 = PeerSyncResult.failure(false);
                return srsp2;
            }
            this.ourHighest = this.ourUpdates.get(0);
            this.ourUpdateSet = new HashSet<Long>(this.ourUpdates);
            this.requestedUpdateSet = new HashSet<Long>();
            while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
                boolean bl = this.handleResponse(srsp);
                if (bl) continue;
                log.info(this.msg() + "DONE. sync failed");
                this.shardHandler.cancelAll();
                this.syncErrors.inc();
                newList22 = PeerSyncResult.failure();
                return newList22;
            }
            boolean success = true;
            for (SyncShardRequest sreq : this.requests) {
                if (!sreq.doFingerprintComparison || (success = this.compareFingerprint(sreq))) continue;
                break;
            }
            log.info(this.msg() + "DONE. sync " + (success ? "succeeded" : "failed"));
            if (!success) {
                this.syncErrors.inc();
            }
            PeerSyncResult peerSyncResult = success ? PeerSyncResult.success() : PeerSyncResult.failure();
            return peerSyncResult;
        }
        finally {
            if (timerContext != null) {
                timerContext.close();
            }
            MDCLoggingContext.clear();
        }
    }

    private boolean alreadyInSync() {
        ShardResponse srsp;
        for (String replica : this.replicas) {
            this.requestFingerprint(replica);
        }
        while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
            Object replicaFingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
            if (replicaFingerprint == null) {
                log.warn("Replica did not return a fingerprint - possibly an older Solr version");
                continue;
            }
            try {
                IndexFingerprint ourFingerprint;
                IndexFingerprint otherFingerprint = IndexFingerprint.fromObject(replicaFingerprint);
                if (IndexFingerprint.compare(otherFingerprint, ourFingerprint = IndexFingerprint.getFingerprint(this.core, Long.MAX_VALUE)) != 0) continue;
                log.info("We are already in sync. No need to do a PeerSync ");
                return true;
            }
            catch (IOException e) {
                log.warn("Could not cofirm if we are already in sync. Continue with PeerSync");
            }
        }
        return false;
    }

    private void requestFingerprint(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getFingerprint", new String[]{String.valueOf(Long.MAX_VALUE)});
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private void requestVersions(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.purpose = 1;
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", this.nUpdates);
        sreq.params.set("fingerprint", this.doFingerprint);
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private boolean handleResponse(ShardResponse srsp) {
        ShardRequest sreq = srsp.getShardRequest();
        if (srsp.getException() != null) {
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrServerException) {
                Throwable solrException = ((SolrServerException)srsp.getException()).getRootCause();
                boolean connectTimeoutExceptionInChain = this.connectTimeoutExceptionInChain(srsp.getException());
                if (connectTimeoutExceptionInChain || solrException instanceof ConnectException || solrException instanceof ConnectTimeoutException || solrException instanceof NoHttpResponseException || solrException instanceof SocketException) {
                    log.warn(this.msg() + " couldn't connect to " + srsp.getShardAddress() + ", counting as success", srsp.getException());
                    return true;
                }
            }
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrException && ((SolrException)srsp.getException()).code() == 503) {
                log.warn(this.msg() + " got a 503 from " + srsp.getShardAddress() + ", counting as success", srsp.getException());
                return true;
            }
            if (this.cantReachIsSuccess && sreq.purpose == 1 && srsp.getException() instanceof SolrException && ((SolrException)srsp.getException()).code() == 404) {
                log.warn(this.msg() + " got a 404 from " + srsp.getShardAddress() + ", counting as success. Perhaps /get is not registered?", srsp.getException());
                return true;
            }
            log.warn(this.msg() + " exception talking to " + srsp.getShardAddress() + ", failed", srsp.getException());
            return false;
        }
        if (sreq.purpose == 1) {
            return this.handleVersions(srsp);
        }
        return this.handleUpdates(srsp);
    }

    private boolean connectTimeoutExceptionInChain(Throwable exception) {
        Throwable t = exception;
        while (true) {
            if (t instanceof ConnectTimeoutException) {
                return true;
            }
            Throwable cause = t.getCause();
            if (cause == null) break;
            t = cause;
        }
        return false;
    }

    private boolean canHandleVersionRanges(String replica) {
        SyncShardRequest sreq = new SyncShardRequest();
        this.requests.add(sreq);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("checkCanHandleVersionRanges", false);
        ShardHandler sh = this.shardHandlerFactory.getShardHandler(this.client);
        sh.submit(sreq, replica, sreq.params);
        ShardResponse srsp = sh.takeCompletedIncludingErrors();
        Boolean canHandleVersionRanges = srsp.getSolrResponse().getResponse().getBooleanArg("canHandleVersionRanges");
        return canHandleVersionRanges != null && canHandleVersionRanges != false;
    }

    private boolean handleVersionsWithRanges(ShardResponse srsp, List<Long> otherVersions, SyncShardRequest sreq, boolean completeList, long otherHigh, long otherHighest) {
        ArrayList<String> rangesToRequest = new ArrayList<String>();
        int ourUpdatesIndex = this.ourUpdates.size() - 1;
        int otherUpdatesIndex = otherVersions.size() - 1;
        long totalRequestedVersions = 0L;
        while (otherUpdatesIndex >= 0) {
            if (ourUpdatesIndex < 0) {
                String range = otherVersions.get(otherUpdatesIndex) + "..." + otherVersions.get(0);
                rangesToRequest.add(range);
                totalRequestedVersions += (long)(otherUpdatesIndex + 1);
                break;
            }
            if (!completeList && Math.abs(otherVersions.get(otherUpdatesIndex)) < this.ourLowThreshold) break;
            if (this.ourUpdates.get(ourUpdatesIndex).longValue() == otherVersions.get(otherUpdatesIndex).longValue()) {
                --ourUpdatesIndex;
                --otherUpdatesIndex;
                continue;
            }
            if (Math.abs(this.ourUpdates.get(ourUpdatesIndex)) < Math.abs(otherVersions.get(otherUpdatesIndex))) {
                --ourUpdatesIndex;
                continue;
            }
            long rangeStart = otherVersions.get(otherUpdatesIndex);
            while (otherUpdatesIndex < otherVersions.size() && Math.abs(otherVersions.get(otherUpdatesIndex)) < Math.abs(this.ourUpdates.get(ourUpdatesIndex))) {
                --otherUpdatesIndex;
                ++totalRequestedVersions;
            }
            rangesToRequest.add(rangeStart + "..." + otherVersions.get(otherUpdatesIndex + 1));
        }
        sreq.requestedRanges = rangesToRequest;
        sreq.totalRequestedUpdates = totalRequestedVersions;
        if (rangesToRequest.isEmpty()) {
            log.info(this.msg() + " No additional versions requested. ourLowThreshold=" + this.ourLowThreshold + " otherHigh=" + otherHigh + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            if (this.doFingerprint) {
                sreq.doFingerprintComparison = true;
            }
            return true;
        }
        if (totalRequestedVersions > (long)this.maxUpdates) {
            log.info(this.msg() + " Failing due to needing too many updates:" + this.maxUpdates);
            return false;
        }
        String rangesToRequestStr = rangesToRequest.stream().collect(Collectors.joining(","));
        return this.requestUpdates(srsp, rangesToRequestStr, totalRequestedVersions);
    }

    private boolean handleVersions(ShardResponse srsp) {
        List otherVersions = (List)srsp.getSolrResponse().getResponse().get("versions");
        SyncShardRequest sreq = (SyncShardRequest)srsp.getShardRequest();
        sreq.reportedVersions = otherVersions;
        Object fingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
        log.info(this.msg() + " Received " + otherVersions.size() + " versions from " + sreq.shards[0] + " fingerprint:" + fingerprint);
        if (fingerprint != null) {
            sreq.fingerprint = IndexFingerprint.fromObject(fingerprint);
        }
        if (otherVersions.size() == 0) {
            return this.getNoVersionsIsSuccess;
        }
        boolean completeList = otherVersions.size() < this.nUpdates;
        Collections.sort(otherVersions, absComparator);
        if (this.debug) {
            log.debug(this.msg() + " sorted versions from " + sreq.shards[0] + " = " + otherVersions);
        }
        long otherHigh = this.percentile(otherVersions, 0.2f);
        long otherLow = this.percentile(otherVersions, 0.8f);
        long otherHighest = (Long)otherVersions.get(0);
        if (this.ourHighThreshold < otherLow) {
            log.info(this.msg() + " Our versions are too old. ourHighThreshold=" + this.ourHighThreshold + " otherLowThreshold=" + otherLow + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            return false;
        }
        if (this.ourLowThreshold > otherHigh) {
            log.info(this.msg() + " Our versions are newer. ourLowThreshold=" + this.ourLowThreshold + " otherHigh=" + otherHigh + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            return true;
        }
        if (this.core.getSolrConfig().useRangeVersionsForPeerSync && this.canHandleVersionRanges(sreq.shards[0])) {
            return this.handleVersionsWithRanges(srsp, otherVersions, sreq, completeList, otherHigh, otherHighest);
        }
        return this.handleIndividualVersions(srsp, otherVersions, sreq, completeList, otherHigh, otherHighest);
    }

    private boolean handleIndividualVersions(ShardResponse srsp, List<Long> otherVersions, SyncShardRequest sreq, boolean completeList, long otherHigh, long otherHighest) {
        ArrayList<Long> toRequest = new ArrayList<Long>();
        for (Long otherVersion : otherVersions) {
            if (!completeList && Math.abs(otherVersion) < this.ourLowThreshold) break;
            if (this.ourUpdateSet.contains(otherVersion) || this.requestedUpdateSet.contains(otherVersion)) continue;
            toRequest.add(otherVersion);
            this.requestedUpdateSet.add(otherVersion);
        }
        sreq.requestedUpdates = toRequest;
        sreq.totalRequestedUpdates = toRequest.size();
        if (toRequest.isEmpty()) {
            log.info(this.msg() + " No additional versions requested. ourLowThreshold=" + this.ourLowThreshold + " otherHigh=" + otherHigh + " ourHighest=" + this.ourHighest + " otherHighest=" + otherHighest);
            if (this.doFingerprint) {
                sreq.doFingerprintComparison = true;
            }
            return true;
        }
        if (toRequest.size() > this.maxUpdates) {
            log.info(this.msg() + " Failing due to needing too many updates:" + this.maxUpdates);
            return false;
        }
        return this.requestUpdates(srsp, StrUtils.join(toRequest, (char)','), toRequest.size());
    }

    private boolean compareFingerprint(SyncShardRequest sreq) {
        if (sreq.fingerprint == null) {
            return true;
        }
        try {
            IndexFingerprint ourFingerprint = IndexFingerprint.getFingerprint(this.core, sreq.fingerprint.getMaxVersionSpecified());
            int cmp = IndexFingerprint.compare(sreq.fingerprint, ourFingerprint);
            log.info("Fingerprint comparison: {}", (Object)cmp);
            if (cmp != 0) {
                log.info("Other fingerprint: {}, Our fingerprint: {}", (Object)sreq.fingerprint, (Object)ourFingerprint);
            }
            return cmp == 0;
        }
        catch (IOException e) {
            log.error(this.msg() + "Error getting index fingerprint", (Throwable)e);
            return false;
        }
    }

    private boolean requestUpdates(ShardResponse srsp, String versionsAndRanges, long totalUpdates) {
        String replica = srsp.getShardRequest().shards[0];
        log.info(this.msg() + "Requesting updates from " + replica + "n=" + totalUpdates + " versions=" + versionsAndRanges);
        ShardRequest sreq = srsp.getShardRequest();
        sreq.purpose = 0;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getUpdates", new String[]{versionsAndRanges});
        sreq.params.set("onlyIfActive", this.onlyIfActive);
        sreq.params.set("fingerprint", this.doFingerprint);
        sreq.responses.clear();
        this.shardHandler.submit(sreq, sreq.shards[0], sreq.params);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleUpdates(ShardResponse srsp) {
        List updates = (List)srsp.getSolrResponse().getResponse().get("updates");
        SyncShardRequest sreq = (SyncShardRequest)srsp.getShardRequest();
        if ((long)updates.size() < sreq.totalRequestedUpdates) {
            log.error(this.msg() + " Requested " + sreq.totalRequestedUpdates + " updates from " + sreq.shards[0] + " but retrieved " + updates.size());
            return false;
        }
        Object fingerprint = srsp.getSolrResponse().getResponse().get("fingerprint");
        if (fingerprint != null) {
            sreq.fingerprint = IndexFingerprint.fromObject(fingerprint);
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
        params.set("peersync", true);
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.uhandler.core, (SolrParams)params);
        SolrQueryResponse rsp = new SolrQueryResponse();
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(null);
        UpdateRequestProcessor proc = processorChain.createProcessor(req, rsp);
        Collections.sort(updates, updateRecordComparator);
        Object o = null;
        long lastVersion = 0L;
        try {
            block20: for (Object obj : updates) {
                o = obj;
                List entry = o;
                if (this.debug) {
                    log.debug(this.msg() + "raw update record " + o);
                }
                int oper = (Integer)entry.get(0) & 0xF;
                long version = (Long)entry.get(1);
                if (version == lastVersion && version != 0L) continue;
                lastVersion = version;
                switch (oper) {
                    case 1: {
                        SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                        UpdateCommand cmd = new AddUpdateCommand(req);
                        ((AddUpdateCommand)cmd).solrDoc = sdoc;
                        cmd.setVersion(version);
                        cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                        if (this.debug) {
                            log.debug(this.msg() + "add " + cmd + " id " + sdoc.getField("id"));
                        }
                        proc.processAdd((AddUpdateCommand)cmd);
                        continue block20;
                    }
                    case 2: {
                        byte[] idBytes = (byte[])entry.get(2);
                        UpdateCommand cmd = new DeleteUpdateCommand(req);
                        ((DeleteUpdateCommand)cmd).setIndexedId(new BytesRef(idBytes));
                        cmd.setVersion(version);
                        cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                        if (this.debug) {
                            log.debug(this.msg() + "delete " + cmd + " " + new BytesRef(idBytes).utf8ToString());
                        }
                        proc.processDelete((DeleteUpdateCommand)cmd);
                        continue block20;
                    }
                    case 3: {
                        String query = (String)entry.get(2);
                        UpdateCommand cmd = new DeleteUpdateCommand(req);
                        ((DeleteUpdateCommand)cmd).query = query;
                        cmd.setVersion(version);
                        cmd.setFlags(UpdateCommand.PEER_SYNC | UpdateCommand.IGNORE_AUTOCOMMIT);
                        if (this.debug) {
                            log.debug(this.msg() + "deleteByQuery " + cmd);
                        }
                        proc.processDelete((DeleteUpdateCommand)cmd);
                        continue block20;
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
            }
        }
        catch (IOException e) {
            sreq.updateException = e;
            log.error(this.msg() + "Error applying updates from " + sreq.shards + " ,update=" + o, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            sreq.updateException = e;
            log.error(this.msg() + "Error applying updates from " + sreq.shards + " ,update=" + o, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                proc.finish();
            }
            catch (Exception e) {
                sreq.updateException = e;
                log.error(this.msg() + "Error applying updates from " + sreq.shards + " ,finish()", (Throwable)e);
                return false;
            }
        }
        return this.compareFingerprint(sreq);
    }

    public static void sync(SolrCore core, List<String> replicas, int nUpdates) {
        ShardHandlerFactory shardHandlerFactory = core.getCoreDescriptor().getCoreContainer().getShardHandlerFactory();
        ShardHandler shardHandler = shardHandlerFactory.getShardHandler();
        for (String replica : replicas) {
            ShardRequest sreq = new ShardRequest();
            sreq.shards = new String[]{replica};
            sreq.params = new ModifiableSolrParams();
            sreq.params.set("qt", new String[]{"/get"});
            sreq.params.set("distrib", false);
            sreq.params.set("getVersions", nUpdates);
            shardHandler.submit(sreq, replica, sreq.params);
        }
        for (String replica : replicas) {
            ShardResponse shardResponse = shardHandler.takeCompletedOrError();
        }
    }

    public static class PeerSyncResult {
        private final boolean success;
        private final Boolean otherHasVersions;

        public PeerSyncResult(boolean success, Boolean otherHasVersions) {
            this.success = success;
            this.otherHasVersions = otherHasVersions;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Optional<Boolean> getOtherHasVersions() {
            return Optional.ofNullable(this.otherHasVersions);
        }

        public static PeerSyncResult success() {
            return new PeerSyncResult(true, null);
        }

        public static PeerSyncResult failure() {
            return new PeerSyncResult(false, null);
        }

        public static PeerSyncResult failure(boolean otherHasVersions) {
            return new PeerSyncResult(false, otherHasVersions);
        }
    }

    private static class SyncShardRequest
    extends ShardRequest {
        List<Long> reportedVersions;
        IndexFingerprint fingerprint;
        boolean doFingerprintComparison;
        List<Long> requestedUpdates;
        Exception updateException;
        List<String> requestedRanges;
        long totalRequestedUpdates;

        private SyncShardRequest() {
        }
    }
}

