/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRefHash;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitTracker;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteByQueryWrapper;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectUpdateHandler2
extends UpdateHandler
implements SolrCoreState.IndexWriterCloser {
    protected final SolrCoreState solrCoreState;
    LongAdder addCommands = new LongAdder();
    LongAdder addCommandsCumulative = new LongAdder();
    LongAdder deleteByIdCommands = new LongAdder();
    LongAdder deleteByIdCommandsCumulative = new LongAdder();
    LongAdder deleteByQueryCommands = new LongAdder();
    LongAdder deleteByQueryCommandsCumulative = new LongAdder();
    LongAdder expungeDeleteCommands = new LongAdder();
    LongAdder mergeIndexesCommands = new LongAdder();
    LongAdder commitCommands = new LongAdder();
    LongAdder optimizeCommands = new LongAdder();
    LongAdder rollbackCommands = new LongAdder();
    LongAdder numDocsPending = new LongAdder();
    LongAdder numErrors = new LongAdder();
    LongAdder numErrorsCumulative = new LongAdder();
    protected final CommitTracker commitTracker;
    protected final CommitTracker softCommitTracker;
    protected boolean commitWithinSoftCommit;
    protected boolean indexWriterCloseWaitsForMerges;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static boolean commitOnClose = true;

    public DirectUpdateHandler2(SolrCore core) {
        super(core);
        this.solrCoreState = core.getSolrCoreState();
        SolrConfig.UpdateHandlerInfo updateHandlerInfo = core.getSolrConfig().getUpdateHandlerInfo();
        int docsUpperBound = updateHandlerInfo.autoCommmitMaxDocs;
        int timeUpperBound = updateHandlerInfo.autoCommmitMaxTime;
        this.commitTracker = new CommitTracker("Hard", core, docsUpperBound, timeUpperBound, updateHandlerInfo.openSearcher, false);
        int softCommitDocsUpperBound = updateHandlerInfo.autoSoftCommmitMaxDocs;
        int softCommitTimeUpperBound = updateHandlerInfo.autoSoftCommmitMaxTime;
        this.softCommitTracker = new CommitTracker("Soft", core, softCommitDocsUpperBound, softCommitTimeUpperBound, true, true);
        this.commitWithinSoftCommit = updateHandlerInfo.commitWithinSoftCommit;
        this.indexWriterCloseWaitsForMerges = updateHandlerInfo.indexWriterCloseWaitsForMerges;
    }

    public DirectUpdateHandler2(SolrCore core, UpdateHandler updateHandler) {
        super(core, updateHandler.getUpdateLog());
        this.solrCoreState = core.getSolrCoreState();
        SolrConfig.UpdateHandlerInfo updateHandlerInfo = core.getSolrConfig().getUpdateHandlerInfo();
        int docsUpperBound = updateHandlerInfo.autoCommmitMaxDocs;
        int timeUpperBound = updateHandlerInfo.autoCommmitMaxTime;
        this.commitTracker = new CommitTracker("Hard", core, docsUpperBound, timeUpperBound, updateHandlerInfo.openSearcher, false);
        int softCommitDocsUpperBound = updateHandlerInfo.autoSoftCommmitMaxDocs;
        int softCommitTimeUpperBound = updateHandlerInfo.autoSoftCommmitMaxTime;
        this.softCommitTracker = new CommitTracker("Soft", core, softCommitDocsUpperBound, softCommitTimeUpperBound, updateHandlerInfo.openSearcher, true);
        this.commitWithinSoftCommit = updateHandlerInfo.commitWithinSoftCommit;
        this.indexWriterCloseWaitsForMerges = updateHandlerInfo.indexWriterCloseWaitsForMerges;
        UpdateLog existingLog = updateHandler.getUpdateLog();
        if (this.ulog != null && this.ulog == existingLog) {
            this.ulog.init(this, core);
        }
    }

    private void deleteAll() throws IOException {
        log.info(this.core.getLogId() + "REMOVING ALL DOCUMENTS FROM INDEX");
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            iw.get().deleteAll();
        }
        finally {
            iw.decref();
        }
    }

    protected void rollbackWriter() throws IOException {
        this.numDocsPending.reset();
        this.solrCoreState.rollbackIndexWriter(this.core);
    }

    @Override
    public int addDoc(AddUpdateCommand cmd) throws IOException {
        try {
            return this.addDoc0(cmd);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (IllegalArgumentException iae) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Exception writing document id %s to the index; possible analysis error: " + iae.getMessage() + (iae.getCause() instanceof BytesRefHash.MaxBytesLengthExceededException ? ". Perhaps the document has an indexed string field (solr.StrField) which is too large" : ""), cmd.getPrintableId()), (Throwable)iae);
        }
        catch (RuntimeException t) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Exception writing document id %s to the index; possible analysis error.", cmd.getPrintableId()), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addDoc0(AddUpdateCommand cmd) throws IOException {
        int rc = -1;
        this.addCommands.increment();
        this.addCommandsCumulative.increment();
        if (this.idField == null) {
            cmd.overwrite = false;
        }
        try {
            if (cmd.overwrite) {
                List<UpdateLog.DBQ> deletesAfter = null;
                if (this.ulog != null && cmd.version > 0L) {
                    deletesAfter = this.ulog.getDBQNewer(cmd.version);
                }
                if (deletesAfter != null) {
                    this.addAndDelete(cmd, deletesAfter);
                } else {
                    this.doNormalUpdate(cmd);
                }
            } else {
                this.allowDuplicateUpdate(cmd);
            }
            if ((cmd.getFlags() & UpdateCommand.IGNORE_AUTOCOMMIT) == 0) {
                if (this.commitWithinSoftCommit) {
                    this.commitTracker.addedDocument(-1);
                    this.softCommitTracker.addedDocument(cmd.commitWithin);
                } else {
                    this.softCommitTracker.addedDocument(-1);
                    this.commitTracker.addedDocument(cmd.commitWithin);
                }
            }
            rc = 1;
        }
        finally {
            if (rc != 1) {
                this.numErrors.increment();
                this.numErrorsCumulative.increment();
            } else {
                this.numDocsPending.increment();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allowDuplicateUpdate(AddUpdateCommand cmd) throws IOException {
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            if (cmd.isBlock()) {
                writer.addDocuments((Iterable)cmd);
            } else {
                writer.addDocument((Iterable)cmd.getLuceneDocument());
            }
            if (this.ulog != null) {
                this.ulog.add(cmd);
            }
        }
        finally {
            iw.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNormalUpdate(AddUpdateCommand cmd) throws IOException {
        Term updateTerm;
        Term idTerm = new Term(cmd.isBlock() ? "_root_" : this.idField.getName(), cmd.getIndexedId());
        boolean del = false;
        if (cmd.updateTerm == null) {
            updateTerm = idTerm;
        } else {
            del = true;
            updateTerm = cmd.updateTerm;
        }
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            if (cmd.isBlock()) {
                writer.updateDocuments(updateTerm, (Iterable)cmd);
            } else {
                Document luceneDocument = cmd.getLuceneDocument();
                writer.updateDocument(updateTerm, (Iterable)luceneDocument);
            }
            if (del) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(new BooleanClause((Query)new TermQuery(updateTerm), BooleanClause.Occur.MUST_NOT));
                bq.add(new BooleanClause((Query)new TermQuery(idTerm), BooleanClause.Occur.MUST));
                writer.deleteDocuments(new Query[]{new DeleteByQueryWrapper((Query)bq.build(), this.core.getLatestSchema())});
            }
            if (this.ulog != null) {
                this.ulog.add(cmd);
            }
        }
        finally {
            iw.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAndDelete(AddUpdateCommand cmd, List<UpdateLog.DBQ> deletesAfter) throws IOException {
        log.info("Reordered DBQs detected.  Update=" + cmd + " DBQs=" + deletesAfter);
        ArrayList<Query> dbqList = new ArrayList<Query>(deletesAfter.size());
        for (UpdateLog.DBQ dbq : deletesAfter) {
            try {
                DeleteUpdateCommand tmpDel = new DeleteUpdateCommand(cmd.req);
                tmpDel.query = dbq.q;
                tmpDel.version = -dbq.version;
                dbqList.add(this.getQuery(tmpDel));
            }
            catch (Exception e) {
                log.error("Exception parsing reordered query : " + dbq, (Throwable)e);
            }
        }
        Document luceneDocument = cmd.getLuceneDocument();
        Term idTerm = new Term(this.idField.getName(), cmd.getIndexedId());
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            Object object = this.solrCoreState.getUpdateLock();
            synchronized (object) {
                writer.updateDocument(idTerm, (Iterable)luceneDocument);
                for (Query q : dbqList) {
                    writer.deleteDocuments(new Query[]{new DeleteByQueryWrapper(q, this.core.getLatestSchema())});
                }
                if (this.ulog != null) {
                    this.ulog.add(cmd, true);
                }
            }
        }
        finally {
            iw.decref();
        }
    }

    private void updateDeleteTrackers(DeleteUpdateCommand cmd) {
        if ((cmd.getFlags() & UpdateCommand.IGNORE_AUTOCOMMIT) == 0) {
            if (this.commitWithinSoftCommit) {
                this.softCommitTracker.deletedDocument(cmd.commitWithin);
            } else {
                this.commitTracker.deletedDocument(cmd.commitWithin);
            }
            if (this.commitTracker.getTimeUpperBound() > 0L) {
                this.commitTracker.scheduleCommitWithin(this.commitTracker.getTimeUpperBound());
            }
            if (this.softCommitTracker.getTimeUpperBound() > 0L) {
                this.softCommitTracker.scheduleCommitWithin(this.softCommitTracker.getTimeUpperBound());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteUpdateCommand cmd) throws IOException {
        this.deleteByIdCommands.increment();
        this.deleteByIdCommandsCumulative.increment();
        Term deleteTerm = new Term(this.idField.getName(), cmd.getIndexedId());
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            iw.get().deleteDocuments(new Term[]{deleteTerm});
        }
        finally {
            iw.decref();
        }
        if (this.ulog != null) {
            this.ulog.delete(cmd);
        }
        this.updateDeleteTrackers(cmd);
    }

    public void clearIndex() throws IOException {
        this.deleteAll();
        if (this.ulog != null) {
            this.ulog.deleteAll();
        }
    }

    private Query getQuery(DeleteUpdateCommand cmd) {
        try {
            QParser parser = QParser.getParser(cmd.getQuery(), cmd.req);
            Query q = parser.getQuery();
            q = QueryUtils.makeQueryable(q);
            if (this.ulog != null && cmd.getVersion() != 0L && cmd.getVersion() != -9223372036854775807L) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(q, BooleanClause.Occur.MUST);
                SchemaField sf = this.ulog.getVersionInfo().getVersionField();
                ValueSource vs = sf.getType().getValueSource(sf, null);
                ValueSourceRangeFilter filt = new ValueSourceRangeFilter(vs, Long.toString(Math.abs(cmd.getVersion())), null, true, true);
                FunctionRangeQuery range = new FunctionRangeQuery(filt);
                bq.add((Query)range, BooleanClause.Occur.MUST_NOT);
                q = bq.build();
            }
            return q;
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean delAll;
        this.deleteByQueryCommands.increment();
        this.deleteByQueryCommandsCumulative.increment();
        boolean madeIt = false;
        Query q = this.getQuery(cmd);
        boolean bl = delAll = MatchAllDocsQuery.class == q.getClass();
        if (delAll && cmd.getVersion() == -9223372036854775807L) {
            Object object = this.solrCoreState.getUpdateLock();
            synchronized (object) {
                this.deleteAll();
                this.ulog.deleteAll();
                return;
            }
        }
        Object object = this.solrCoreState.getUpdateLock();
        synchronized (object) {
            if (delAll) {
                this.deleteAll();
            } else {
                RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
                try {
                    iw.get().deleteDocuments(new Query[]{new DeleteByQueryWrapper(q, this.core.getLatestSchema())});
                }
                finally {
                    iw.decref();
                }
            }
            if (this.ulog != null) {
                this.ulog.deleteByQuery(cmd);
            }
        }
        finally {
            if (!madeIt) {
                this.numErrors.increment();
                this.numErrorsCumulative.increment();
            }
        }
        madeIt = true;
        this.updateDeleteTrackers(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        int rc;
        this.mergeIndexesCommands.increment();
        log.info("start " + cmd);
        List<DirectoryReader> readers = cmd.readers;
        if (readers != null && readers.size() > 0) {
            ArrayList<CodecReader> mergeReaders = new ArrayList<CodecReader>();
            for (DirectoryReader reader : readers) {
                for (LeafReaderContext leaf : reader.leaves()) {
                    mergeReaders.add(SlowCodecReaderWrapper.wrap((LeafReader)leaf.reader()));
                }
            }
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                iw.get().addIndexes(mergeReaders.toArray(new CodecReader[mergeReaders.size()]));
            }
            finally {
                iw.decref();
            }
            rc = 1;
        } else {
            rc = 0;
        }
        log.info("end_mergeIndexes");
        if (rc == 1 && this.commitTracker.getTimeUpperBound() > 0L) {
            this.commitTracker.scheduleCommitWithin(this.commitTracker.getTimeUpperBound());
        } else if (rc == 1 && this.softCommitTracker.getTimeUpperBound() > 0L) {
            this.softCommitTracker.scheduleCommitWithin(this.softCommitTracker.getTimeUpperBound());
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(CommitUpdateCommand cmd) throws IOException {
        boolean error = true;
        try {
            log.info("start " + cmd);
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                SolrIndexWriter.setCommitData(iw.get());
                iw.get().prepareCommit();
            }
            finally {
                iw.decref();
            }
            log.info("end_prepareCommit");
            error = false;
        }
        finally {
            if (error) {
                this.numErrors.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(CommitUpdateCommand cmd) throws IOException {
        if (cmd.prepareCommit) {
            this.prepareCommit(cmd);
            return;
        }
        if (cmd.optimize) {
            this.optimizeCommands.increment();
        } else {
            this.commitCommands.increment();
            if (cmd.expungeDeletes) {
                this.expungeDeleteCommands.increment();
            }
        }
        Future[] waitSearcher = null;
        if (cmd.waitSearcher) {
            waitSearcher = new Future[1];
        }
        boolean error = true;
        try {
            Object object;
            block48: {
                if (!cmd.softCommit) {
                    this.solrCoreState.getCommitLock().lock();
                }
                log.info("start " + cmd);
                if (cmd.openSearcher) {
                    this.softCommitTracker.cancelPendingCommit();
                }
                if (!(cmd.softCommit || !cmd.openSearcher && this.commitTracker.getOpenSearcher())) {
                    this.commitTracker.cancelPendingCommit();
                }
                RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
                try {
                    IndexWriter writer = iw.get();
                    if (cmd.optimize) {
                        if (cmd.maxOptimizeSegments == 1) {
                            log.warn("Starting optimize... Reading and rewriting the entire index! Use with care.");
                        } else {
                            log.warn("Starting optimize... Reading and rewriting a potentially large percent of the entire index, reducing to " + cmd.maxOptimizeSegments + " segments");
                        }
                        writer.forceMerge(cmd.maxOptimizeSegments);
                    } else if (cmd.expungeDeletes) {
                        log.warn("Starting expungeDeletes... Reading and rewriting segments with enough deletes, potentially the entire index");
                        writer.forceMergeDeletes();
                    }
                    if (cmd.softCommit) break block48;
                    Object object2 = this.solrCoreState.getUpdateLock();
                    synchronized (object2) {
                        if (this.ulog != null) {
                            this.ulog.preCommit(cmd);
                        }
                    }
                    if (writer.hasUncommittedChanges()) {
                        SolrIndexWriter.setCommitData(writer);
                        writer.commit();
                    } else {
                        log.info("No uncommitted changes. Skipping IW.commit.");
                    }
                    this.numDocsPending.reset();
                    this.callPostCommitCallbacks();
                }
                finally {
                    iw.decref();
                }
            }
            if (cmd.optimize) {
                this.callPostOptimizeCallbacks();
            }
            if (cmd.softCommit) {
                object = this.solrCoreState.getUpdateLock();
                synchronized (object) {
                    if (this.ulog != null) {
                        this.ulog.preSoftCommit(cmd);
                    }
                    this.core.getSearcher(true, false, waitSearcher, true);
                    if (this.ulog != null) {
                        this.ulog.postSoftCommit(cmd);
                    }
                }
                this.callPostSoftCommitCallbacks();
            } else {
                object = this.solrCoreState.getUpdateLock();
                synchronized (object) {
                    if (this.ulog != null) {
                        this.ulog.preSoftCommit(cmd);
                    }
                    if (cmd.openSearcher) {
                        this.core.getSearcher(true, false, waitSearcher);
                    } else {
                        RefCounted<SolrIndexSearcher> searchHolder = this.core.openNewSearcher(true, true);
                        searchHolder.decref();
                    }
                    if (this.ulog != null) {
                        this.ulog.postSoftCommit(cmd);
                    }
                }
                if (this.ulog != null) {
                    this.ulog.postCommit(cmd);
                }
            }
            if (cmd.softCommit) {
                this.softCommitTracker.didCommit();
            } else {
                this.commitTracker.didCommit();
            }
            log.info("end_commit_flush");
            error = false;
        }
        finally {
            if (!cmd.softCommit) {
                this.solrCoreState.getCommitLock().unlock();
            }
            this.addCommands.reset();
            this.deleteByIdCommands.reset();
            this.deleteByQueryCommands.reset();
            if (error) {
                this.numErrors.increment();
            }
        }
        if (waitSearcher != null && waitSearcher[0] != null) {
            try {
                waitSearcher[0].get();
            }
            catch (InterruptedException | ExecutionException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
        }
    }

    @Override
    public void newIndexWriter(boolean rollback) throws IOException {
        this.solrCoreState.newIndexWriter(this.core, rollback);
    }

    @Override
    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        if (this.core.getCoreDescriptor().getCoreContainer().isZooKeeperAware()) {
            throw new UnsupportedOperationException("Rollback is currently not supported in SolrCloud mode. (SOLR-4895)");
        }
        this.rollbackCommands.increment();
        boolean error = true;
        try {
            log.info("start " + cmd);
            this.rollbackWriter();
            this.commitTracker.didRollback();
            this.softCommitTracker.didRollback();
            log.info("end_rollback");
            error = false;
        }
        finally {
            this.addCommandsCumulative.add(-this.addCommands.sumThenReset());
            this.deleteByIdCommandsCumulative.add(-this.deleteByIdCommands.sumThenReset());
            this.deleteByQueryCommandsCumulative.add(-this.deleteByQueryCommands.sumThenReset());
            if (error) {
                this.numErrors.increment();
            }
        }
    }

    @Override
    public UpdateLog getUpdateLog() {
        return this.ulog;
    }

    @Override
    public void close() throws IOException {
        log.debug("closing " + this);
        this.commitTracker.close();
        this.softCommitTracker.close();
        this.numDocsPending.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWriter(IndexWriter writer) throws IOException {
        assert (TestInjection.injectNonGracefullClose(this.core.getCoreDescriptor().getCoreContainer()));
        boolean clearRequestInfo = false;
        this.solrCoreState.getCommitLock().lock();
        try {
            block23: {
                block22: {
                    LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, (SolrParams)new ModifiableSolrParams());
                    SolrQueryResponse rsp = new SolrQueryResponse();
                    if (SolrRequestInfo.getRequestInfo() == null) {
                        clearRequestInfo = true;
                        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                    }
                    if (!commitOnClose) {
                        if (writer != null) {
                            writer.rollback();
                        }
                        if (this.ulog != null) {
                            this.ulog.close(false);
                        }
                        return;
                    }
                    boolean tryToCommit = writer != null && this.ulog != null && this.ulog.hasUncommittedChanges() && this.ulog.getState() == UpdateLog.State.ACTIVE;
                    try {
                        if (!tryToCommit) break block22;
                        log.info("Committing on IndexWriter close.");
                        CommitUpdateCommand cmd = new CommitUpdateCommand(req, false);
                        cmd.openSearcher = false;
                        cmd.waitSearcher = false;
                        cmd.softCommit = false;
                        Object object = this.solrCoreState.getUpdateLock();
                        synchronized (object) {
                            this.ulog.preCommit(cmd);
                        }
                        SolrIndexWriter.setCommitData(writer);
                        writer.commit();
                        object = this.solrCoreState.getUpdateLock();
                        synchronized (object) {
                            this.ulog.postCommit(cmd);
                        }
                    }
                    catch (Throwable th) {
                        log.error("Error in final commit", th);
                        if (!(th instanceof OutOfMemoryError)) break block22;
                        throw (OutOfMemoryError)th;
                    }
                }
                try {
                    if (this.ulog != null) {
                        this.ulog.close(false);
                    }
                }
                catch (Throwable th) {
                    log.error("Error closing log files", th);
                    if (!(th instanceof OutOfMemoryError)) break block23;
                    throw (OutOfMemoryError)th;
                }
            }
            if (writer != null) {
                writer.close();
            }
        }
        finally {
            this.solrCoreState.getCommitLock().unlock();
            if (clearRequestInfo) {
                SolrRequestInfo.clearRequestInfo();
            }
        }
    }

    @Override
    public void split(SplitIndexCommand cmd) throws IOException {
        this.commit(new CommitUpdateCommand(cmd.req, false));
        SolrIndexSplitter splitter = new SolrIndexSplitter(cmd);
        splitter.split();
    }

    @Override
    public String getName() {
        return DirectUpdateHandler2.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "Update handler that efficiently directly updates the on-disk main lucene index";
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("commits", (Object)this.commitCommands.longValue());
        if (this.commitTracker.getDocsUpperBound() > 0) {
            lst.add("autocommit maxDocs", (Object)this.commitTracker.getDocsUpperBound());
        }
        if (this.commitTracker.getTimeUpperBound() > 0L) {
            lst.add("autocommit maxTime", (Object)("" + this.commitTracker.getTimeUpperBound() + "ms"));
        }
        lst.add("autocommits", (Object)this.commitTracker.getCommitCount());
        if (this.softCommitTracker.getDocsUpperBound() > 0) {
            lst.add("soft autocommit maxDocs", (Object)this.softCommitTracker.getDocsUpperBound());
        }
        if (this.softCommitTracker.getTimeUpperBound() > 0L) {
            lst.add("soft autocommit maxTime", (Object)("" + this.softCommitTracker.getTimeUpperBound() + "ms"));
        }
        lst.add("soft autocommits", (Object)this.softCommitTracker.getCommitCount());
        lst.add("optimizes", (Object)this.optimizeCommands.longValue());
        lst.add("rollbacks", (Object)this.rollbackCommands.longValue());
        lst.add("expungeDeletes", (Object)this.expungeDeleteCommands.longValue());
        lst.add("docsPending", (Object)this.numDocsPending.longValue());
        lst.add("adds", (Object)this.addCommands.longValue());
        lst.add("deletesById", (Object)this.deleteByIdCommands.longValue());
        lst.add("deletesByQuery", (Object)this.deleteByQueryCommands.longValue());
        lst.add("errors", (Object)this.numErrors.longValue());
        lst.add("cumulative_adds", (Object)this.addCommandsCumulative.longValue());
        lst.add("cumulative_deletesById", (Object)this.deleteByIdCommandsCumulative.longValue());
        lst.add("cumulative_deletesByQuery", (Object)this.deleteByQueryCommandsCumulative.longValue());
        lst.add("cumulative_errors", (Object)this.numErrorsCumulative.longValue());
        if (this.ulog != null) {
            lst.add("transaction_logs_total_size", (Object)this.ulog.getTotalLogsSize());
            lst.add("transaction_logs_total_number", (Object)this.ulog.getTotalLogsNumber());
        }
        return lst;
    }

    public String toString() {
        return "DirectUpdateHandler2" + this.getStatistics();
    }

    @Override
    public SolrCoreState getSolrCoreState() {
        return this.solrCoreState;
    }

    public CommitTracker getCommitTracker() {
        return this.commitTracker;
    }

    public CommitTracker getSoftCommitTracker() {
        return this.softCommitTracker;
    }
}

