/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.UpdateCommand;

public class AddUpdateCommand
extends UpdateCommand
implements Iterable<Document> {
    private BytesRef indexedId;
    public SolrInputDocument solrDoc;
    public boolean overwrite = true;
    public Term updateTerm;
    public int commitWithin = -1;
    public boolean isLastDocInBatch = false;
    public int pollQueueTime = 0;

    public AddUpdateCommand(SolrQueryRequest req) {
        super(req);
    }

    @Override
    public String name() {
        return "add";
    }

    public void clear() {
        this.solrDoc = null;
        this.indexedId = null;
        this.updateTerm = null;
        this.isLastDocInBatch = false;
        this.version = 0L;
    }

    public SolrInputDocument getSolrInputDocument() {
        return this.solrDoc;
    }

    public Document getLuceneDocument() {
        return DocumentBuilder.toDocument(this.getSolrInputDocument(), this.req.getSchema());
    }

    public BytesRef getIndexedId() {
        IndexSchema schema;
        SchemaField sf;
        if (this.indexedId == null && (sf = (schema = this.req.getSchema()).getUniqueKeyField()) != null && this.solrDoc != null) {
            int count;
            SolrInputField field = this.solrDoc.getField(sf.getName());
            int n = count = field == null ? 0 : field.getValueCount();
            if (count == 0) {
                if (this.overwrite) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document is missing mandatory uniqueKey field: " + sf.getName());
                }
            } else {
                if (count > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document contains multiple values for uniqueKey field: " + field);
                }
                BytesRefBuilder b = new BytesRefBuilder();
                sf.getType().readableToIndexed(field.getFirstValue().toString(), b);
                this.indexedId = b.get();
            }
        }
        return this.indexedId;
    }

    public void setIndexedId(BytesRef indexedId) {
        this.indexedId = indexedId;
    }

    public String getPrintableId() {
        if (this.req != null) {
            SolrInputField field;
            IndexSchema schema = this.req.getSchema();
            SchemaField sf = schema.getUniqueKeyField();
            if (this.solrDoc != null && sf != null && (field = this.solrDoc.getField(sf.getName())) != null) {
                return field.getFirstValue().toString();
            }
        }
        return "(null)";
    }

    public String getHashableId() {
        String id = null;
        IndexSchema schema = this.req.getSchema();
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null && this.solrDoc != null) {
            int count;
            SolrInputField field = this.solrDoc.getField(sf.getName());
            int n = count = field == null ? 0 : field.getValueCount();
            if (count == 0) {
                if (this.overwrite) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document is missing mandatory uniqueKey field: " + sf.getName());
                }
            } else {
                if (count > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document contains multiple values for uniqueKey field: " + field);
                }
                return field.getFirstValue().toString();
            }
        }
        return id;
    }

    public boolean isBlock() {
        return this.solrDoc.hasChildDocuments();
    }

    @Override
    public Iterator<Document> iterator() {
        return new Iterator<Document>(){
            Iterator<SolrInputDocument> iter;
            {
                List all = AddUpdateCommand.this.flatten(AddUpdateCommand.this.solrDoc);
                String idField = AddUpdateCommand.this.getHashableId();
                for (SolrInputDocument sdoc : all) {
                    sdoc.setField("_root_", (Object)idField);
                }
                this.iter = all.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Document next() {
                return DocumentBuilder.toDocument(this.iter.next(), AddUpdateCommand.this.req.getSchema());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private List<SolrInputDocument> flatten(SolrInputDocument root) {
        ArrayList<SolrInputDocument> unwrappedDocs = new ArrayList<SolrInputDocument>();
        this.recUnwrapp(unwrappedDocs, root);
        return unwrappedDocs;
    }

    private void recUnwrapp(List<SolrInputDocument> unwrappedDocs, SolrInputDocument currentDoc) {
        List children = currentDoc.getChildDocuments();
        if (children != null) {
            for (SolrInputDocument child : children) {
                this.recUnwrapp(unwrappedDocs, child);
            }
        }
        unwrappedDocs.add(currentDoc);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(",id=").append(this.getPrintableId());
        if (!this.overwrite) {
            sb.append(",overwrite=").append(this.overwrite);
        }
        if (this.commitWithin != -1) {
            sb.append(",commitWithin=").append(this.commitWithin);
        }
        sb.append('}');
        return sb.toString();
    }
}

