/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.security.AutorizationEditOperation;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.Permission;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.CommandOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedAuthorizationPlugin
implements AuthorizationPlugin,
ConfigEditablePlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Set<String>> usersVsRoles = new HashMap<String, Set<String>>();
    private final Map<String, WildCardSupportMap> mapping = new HashMap<String, WildCardSupportMap>();
    private final List<Permission> permissions = new ArrayList<Permission>();
    private static final Map<String, AutorizationEditOperation> ops = Collections.unmodifiableMap(Arrays.asList(AutorizationEditOperation.values()).stream().collect(Collectors.toMap(AutorizationEditOperation::getOperationName, Function.identity())));

    @Override
    public AuthorizationResponse authorize(AuthorizationContext context) {
        List<AuthorizationContext.CollectionRequest> collectionRequests = context.getCollectionRequests();
        if (context.getRequestType() == AuthorizationContext.RequestType.ADMIN) {
            MatchStatus flag = this.checkCollPerm(this.mapping.get(null), context);
            return flag.rsp;
        }
        for (AuthorizationContext.CollectionRequest collreq : collectionRequests) {
            MatchStatus flag = this.checkCollPerm(this.mapping.get(collreq.collectionName), context);
            if (flag == MatchStatus.NO_PERMISSIONS_FOUND) continue;
            return flag.rsp;
        }
        Object flag = this.checkCollPerm(this.mapping.get("*"), context);
        return ((MatchStatus)((Object)flag)).rsp;
    }

    private MatchStatus checkCollPerm(Map<String, List<Permission>> pathVsPerms, AuthorizationContext context) {
        if (pathVsPerms == null) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        String path = context.getResource();
        MatchStatus flag = this.checkPathPerm(pathVsPerms.get(path), context);
        if (flag != MatchStatus.NO_PERMISSIONS_FOUND) {
            return flag;
        }
        return this.checkPathPerm(pathVsPerms.get(null), context);
    }

    private MatchStatus checkPathPerm(List<Permission> permissions, AuthorizationContext context) {
        if (permissions == null || permissions.isEmpty()) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        Principal principal = context.getUserPrincipal();
        block0: for (int i = 0; i < permissions.size(); ++i) {
            Permission permission = permissions.get(i);
            if (PermissionNameProvider.values.containsKey(permission.name)) {
                PermissionNameProvider handler;
                PermissionNameProvider.Name permissionName;
                if (context.getHandler() instanceof PermissionNameProvider ? (permissionName = (handler = (PermissionNameProvider)context.getHandler()).getPermissionName(context)) == null || !permission.name.equals(permissionName.name) : permission.wellknownName != PermissionNameProvider.Name.ALL) {
                    continue;
                }
            } else {
                if (permission.method != null && !permission.method.contains(context.getHttpMethod())) continue;
                if (permission.params != null) {
                    for (Map.Entry<String, Function<String[], Boolean>> e : permission.params.entrySet()) {
                        String[] paramVal = context.getParams().getParams(e.getKey());
                        if (e.getValue().apply(paramVal).booleanValue()) continue;
                        continue block0;
                    }
                }
            }
            if (permission.role == null) {
                return MatchStatus.PERMITTED;
            }
            if (principal == null) {
                log.info("request has come without principal. failed permission {} ", (Object)permission);
                return MatchStatus.USER_REQUIRED;
            }
            if (permission.role.contains("*")) {
                return MatchStatus.PERMITTED;
            }
            for (String role : permission.role) {
                Set<String> userRoles = this.usersVsRoles.get(principal.getName());
                if (userRoles == null || !userRoles.contains(role)) continue;
                return MatchStatus.PERMITTED;
            }
            log.info("This resource is configured to have a permission {}, The principal {} does not have the right role ", (Object)permission, (Object)principal);
            return MatchStatus.FORBIDDEN;
        }
        log.debug("No permissions configured for the resource {} . So allowed to access", (Object)context.getResource());
        return MatchStatus.NO_PERMISSIONS_FOUND;
    }

    @Override
    public void init(Map<String, Object> initInfo) {
        this.mapping.put(null, new WildCardSupportMap());
        Map<String, Object> map = SecurityConfHandler.getMapValue(initInfo, "user-role");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> e = o = iterator.next();
            String roleName = e.getKey();
            this.usersVsRoles.put(roleName, Permission.readValueAsSet(map, roleName));
        }
        List perms = SecurityConfHandler.getListValue(initInfo, "permissions");
        for (Map o : perms) {
            Permission p;
            try {
                p = Permission.load(o);
            }
            catch (Exception exp) {
                log.error("Invalid permission ", (Throwable)exp);
                continue;
            }
            this.permissions.add(p);
            this.add2Mapping(p);
        }
    }

    private void add2Mapping(Permission permission) {
        for (String c : permission.collections) {
            WildCardSupportMap m = this.mapping.get(c);
            if (m == null) {
                m = new WildCardSupportMap();
                this.mapping.put(c, m);
            }
            for (String path : permission.path) {
                ArrayList<Permission> perms = m.get(path);
                if (perms == null) {
                    perms = new ArrayList<Permission>();
                    m.put(path, (List<Permission>)perms);
                }
                perms.add(permission);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation op : commands) {
            AutorizationEditOperation operation = ops.get(op.name);
            if (operation == null) {
                op.unknownOperation();
                return null;
            }
            if ((latestConf = operation.edit(latestConf, op)) != null) continue;
            return null;
        }
        return latestConf;
    }

    static enum MatchStatus {
        USER_REQUIRED(AuthorizationResponse.PROMPT),
        NO_PERMISSIONS_FOUND(AuthorizationResponse.OK),
        PERMITTED(AuthorizationResponse.OK),
        FORBIDDEN(AuthorizationResponse.FORBIDDEN);

        final AuthorizationResponse rsp;

        private MatchStatus(AuthorizationResponse rsp) {
            this.rsp = rsp;
        }
    }

    private static class WildCardSupportMap
    extends HashMap<String, List<Permission>> {
        final Set<String> wildcardPrefixes = new HashSet<String>();

        private WildCardSupportMap() {
        }

        @Override
        public List<Permission> put(String key, List<Permission> value) {
            if (key != null && key.endsWith("/*")) {
                key = key.substring(0, key.length() - 2);
                this.wildcardPrefixes.add(key);
            }
            return super.put(key, value);
        }

        @Override
        public List<Permission> get(Object key) {
            ArrayList result = (ArrayList)super.get(key);
            if (key == null || result != null) {
                return result;
            }
            if (!this.wildcardPrefixes.isEmpty()) {
                for (String s : this.wildcardPrefixes) {
                    List l;
                    if (!key.toString().startsWith(s) || (l = (List)super.get(s)) == null) continue;
                    result = result == null ? new ArrayList() : new ArrayList(result);
                    result.addAll(l);
                }
            }
            return result;
        }
    }
}

