/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.Permission;
import org.apache.solr.util.CommandOperation;

enum AutorizationEditOperation {
    SET_USER_ROLE("set-user-role"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Map<String, Object> roleMap = SecurityConfHandler.getMapValue(latestConf, "user-role");
            Map<String, Object> map = op.getDataMap();
            if (op.hasError()) {
                return null;
            }
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (e.getValue() == null) {
                    roleMap.remove(e.getKey());
                    continue;
                }
                if (e.getValue() instanceof String || e.getValue() instanceof List) {
                    roleMap.put(e.getKey(), e.getValue());
                    continue;
                }
                op.addError("Unexpected value ");
                return null;
            }
            return latestConf;
        }
    }
    ,
    SET_PERMISSION("set-permission"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Integer index = op.getInt("index", null);
            Integer beforeIdx = op.getInt("before", null);
            Map dataMap = op.getDataMap();
            if (op.hasError()) {
                return null;
            }
            dataMap = Utils.getDeepCopy(dataMap, (int)3);
            dataMap.remove("before");
            if (beforeIdx != null && index != null) {
                op.addError("Cannot use 'index' and 'before together ");
                return null;
            }
            for (String key : dataMap.keySet()) {
                if (Permission.knownKeys.contains(key)) continue;
                op.addError("Unknown key, " + key);
            }
            try {
                Permission.load(dataMap);
            }
            catch (Exception e) {
                op.addError(e.getMessage());
                return null;
            }
            if (op.hasError()) {
                return null;
            }
            List permissions = SecurityConfHandler.getListValue(latestConf, "permissions");
            2.setIndex(permissions);
            ArrayList<Map> permissionsCopy = new ArrayList<Map>();
            boolean beforeSatisfied = beforeIdx == null;
            boolean indexSatisfied = index == null;
            for (int i = 0; i < permissions.size(); ++i) {
                Map perm = (Map)permissions.get(i);
                Integer thisIdx = (int)((Integer)perm.get("index"));
                if (thisIdx.equals(beforeIdx)) {
                    beforeSatisfied = true;
                    permissionsCopy.add(dataMap);
                    permissionsCopy.add(perm);
                    continue;
                }
                if (thisIdx.equals(index)) {
                    indexSatisfied = true;
                    permissionsCopy.add(dataMap);
                    continue;
                }
                permissionsCopy.add(perm);
            }
            if (!beforeSatisfied) {
                op.addError("Invalid 'before' :" + beforeIdx);
                return null;
            }
            if (!indexSatisfied) {
                op.addError("Invalid 'index' :" + index);
                return null;
            }
            if (!permissionsCopy.contains(dataMap)) {
                permissionsCopy.add(dataMap);
            }
            latestConf.put("permissions", permissionsCopy);
            2.setIndex(permissionsCopy);
            return latestConf;
        }
    }
    ,
    UPDATE_PERMISSION("update-permission"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Integer index = op.getInt("index");
            if (op.hasError()) {
                return null;
            }
            List permissions = SecurityConfHandler.getListValue(latestConf, "permissions");
            3.setIndex(permissions);
            for (Map permission : permissions) {
                if (!index.equals(permission.get("index"))) continue;
                LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(permission);
                copy.putAll(op.getDataMap());
                op.setCommandData(copy);
                return SET_PERMISSION.edit(latestConf, op);
            }
            op.addError("No such permission " + this.name);
            return null;
        }
    }
    ,
    DELETE_PERMISSION("delete-permission"){

        @Override
        public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
            Integer id = op.getInt("");
            if (op.hasError()) {
                return null;
            }
            List p = SecurityConfHandler.getListValue(latestConf, "permissions");
            4.setIndex(p);
            List c = p.stream().filter(map -> !id.equals(map.get("index"))).collect(Collectors.toList());
            if (c.size() == p.size()) {
                op.addError("No such index :" + id);
                return null;
            }
            latestConf.put("permissions", c);
            return latestConf;
        }
    };

    public final String name;

    public abstract Map<String, Object> edit(Map<String, Object> var1, CommandOperation var2);

    public String getOperationName() {
        return this.name;
    }

    private AutorizationEditOperation(String s) {
        this.name = s;
    }

    public static AutorizationEditOperation get(String name) {
        for (AutorizationEditOperation o : AutorizationEditOperation.values()) {
            if (!o.name.equals(name)) continue;
            return o;
        }
        return null;
    }

    static void setIndex(List<Map> permissionsCopy) {
        AtomicInteger counter = new AtomicInteger(0);
        permissionsCopy.stream().forEach(map -> map.put("index", counter.incrementAndGet()));
    }
}

