/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.ScoreModeParser;
import org.apache.solr.util.RefCounted;

public class ScoreJoinQParserPlugin
extends QParserPlugin {
    public static final String SCORE = "score";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String fromField = this.localParams.get("from");
                String fromIndex = this.localParams.get("fromIndex");
                String toField = this.localParams.get("to");
                ScoreMode scoreMode = ScoreModeParser.parse(this.getParam(ScoreJoinQParserPlugin.SCORE));
                String v = this.localParams.get("v");
                Query q = this.createQuery(fromField, v, fromIndex, toField, scoreMode, CommonParams.TRUE.equals(this.localParams.get("TESTenforceSameCoreAsAnotherOne")));
                return q;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Query createQuery(String fromField, String fromQueryStr, String fromIndex, String toField, ScoreMode scoreMode, boolean byPassShortCircutCheck) throws SyntaxError {
                String myCore = this.req.getCore().getCoreDescriptor().getName();
                if (fromIndex != null && (!fromIndex.equals(myCore) || byPassShortCircutCheck)) {
                    CoreContainer container = this.req.getCore().getCoreDescriptor().getCoreContainer();
                    String coreName = ScoreJoinQParserPlugin.getCoreName(fromIndex, container);
                    SolrCore fromCore = container.getCore(coreName);
                    RefCounted<SolrIndexSearcher> fromHolder = null;
                    if (fromCore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + coreName);
                    }
                    long fromCoreOpenTime = 0L;
                    LocalSolrQueryRequest otherReq = new LocalSolrQueryRequest(fromCore, this.params);
                    try {
                        QParser fromQueryParser = QParser.getParser(fromQueryStr, otherReq);
                        Query fromQuery = fromQueryParser.getQuery();
                        fromHolder = fromCore.getRegisteredSearcher();
                        if (fromHolder != null) {
                            SolrIndexSearcher solrIndexSearcher = fromHolder.get();
                            fromCoreOpenTime = solrIndexSearcher.getOpenNanoTime();
                        }
                        OtherCoreJoinQuery otherCoreJoinQuery = new OtherCoreJoinQuery(fromQuery, fromField, coreName, fromCoreOpenTime, scoreMode, toField);
                        return otherCoreJoinQuery;
                    }
                    finally {
                        otherReq.close();
                        fromCore.close();
                        if (fromHolder != null) {
                            fromHolder.decref();
                        }
                    }
                }
                QParser fromQueryParser = this.subQuery(fromQueryStr, null);
                Query fromQuery = fromQueryParser.getQuery();
                return new SameCoreJoinQuery(fromQuery, fromField, toField, scoreMode);
            }
        };
    }

    public static String getCoreName(String fromIndex, CoreContainer container) {
        if (container.isZooKeeperAware()) {
            String resolved;
            ZkController zkController = container.getZkController();
            String string = resolved = zkController.getClusterState().hasCollection(fromIndex) ? fromIndex : ScoreJoinQParserPlugin.resolveAlias(fromIndex, zkController);
            if (resolved == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: Collection '" + fromIndex + "' not found!");
            }
            return ScoreJoinQParserPlugin.findLocalReplicaForFromIndex(zkController, resolved);
        }
        return fromIndex;
    }

    private static String resolveAlias(String fromIndex, ZkController zkController) {
        Aliases aliases = zkController.getZkStateReader().getAliases();
        if (aliases != null) {
            String resolved;
            Map collectionAliases = aliases.getCollectionAliasMap();
            String string = resolved = collectionAliases != null ? (String)collectionAliases.get(fromIndex) : null;
            if (resolved != null) {
                if (resolved.split(",").length > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: Collection alias '" + fromIndex + "' maps to multiple collections (" + resolved + "), which is not currently supported for joins.");
                }
                return resolved;
            }
        }
        return null;
    }

    private static String findLocalReplicaForFromIndex(ZkController zkController, String fromIndex) {
        String fromReplica = null;
        String nodeName = zkController.getNodeName();
        block0: for (Slice slice : zkController.getClusterState().getActiveSlices(fromIndex)) {
            if (fromReplica != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: multiple shards not yet supported " + fromIndex);
            }
            for (Replica replica : slice.getReplicas()) {
                if (!replica.getNodeName().equals(nodeName)) continue;
                fromReplica = replica.getStr("core");
                if (replica.getState() == Replica.State.ACTIVE) continue block0;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: " + fromIndex + " has a local replica (" + fromReplica + ") on " + nodeName + ", but it is " + replica.getState());
            }
        }
        if (fromReplica == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: No active replicas for " + fromIndex + " found in node " + nodeName);
        }
        return fromReplica;
    }

    static class SameCoreJoinQuery
    extends Query {
        protected final Query fromQuery;
        protected final ScoreMode scoreMode;
        protected final String fromField;
        protected final String toField;

        SameCoreJoinQuery(Query fromQuery, String fromField, String toField, ScoreMode scoreMode) {
            this.fromQuery = fromQuery;
            this.scoreMode = scoreMode;
            this.fromField = fromField;
            this.toField = toField;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            IndexSchema schema = info.getReq().getSchema();
            Query jq = this.createJoinQuery(info.getReq().getSearcher(), this.getNumericType(schema, schema));
            return jq.rewrite(reader);
        }

        protected Query createJoinQuery(IndexSearcher searcher, FieldType.LegacyNumericType numericType) throws IOException {
            if (numericType != null) {
                return JoinUtil.createJoinQuery((String)this.fromField, (boolean)true, (String)this.toField, (FieldType.LegacyNumericType)numericType, (Query)this.fromQuery, (IndexSearcher)searcher, (ScoreMode)this.scoreMode);
            }
            return JoinUtil.createJoinQuery((String)this.fromField, (boolean)true, (String)this.toField, (Query)this.fromQuery, (IndexSearcher)searcher, (ScoreMode)this.scoreMode);
        }

        protected FieldType.LegacyNumericType getNumericType(IndexSchema fromSchema, IndexSchema toSchema) {
            FieldType.LegacyNumericType toNumericType;
            FieldType.LegacyNumericType fromNumericType = fromSchema.getField(this.fromField).getType().getNumericType();
            if (fromNumericType != (toNumericType = toSchema.getField(this.toField).getType().getNumericType())) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "From and to field must have same numeric type. Found from=" + fromNumericType + " to=" + toNumericType);
            }
            return fromNumericType;
        }

        public String toString(String field) {
            return "SameCoreJoinQuery [fromQuery=" + this.fromQuery + ", fromField=" + this.fromField + ", toField=" + this.toField + ", scoreMode=" + this.scoreMode + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = this.classHash();
            result = 31 * result + Objects.hashCode(this.fromField);
            result = 31 * result + Objects.hashCode(this.fromQuery);
            result = 31 * result + Objects.hashCode(this.scoreMode);
            result = 31 * result + Objects.hashCode(this.toField);
            return result;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((SameCoreJoinQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
        }

        private boolean equalsTo(SameCoreJoinQuery other) {
            return Objects.equals(this.fromField, other.fromField) && Objects.equals(this.fromQuery, other.fromQuery) && Objects.equals(this.scoreMode, other.scoreMode) && Objects.equals(this.toField, other.toField);
        }
    }

    static class OtherCoreJoinQuery
    extends SameCoreJoinQuery {
        private final String fromIndex;
        private final long fromCoreOpenTime;

        public OtherCoreJoinQuery(Query fromQuery, String fromField, String fromIndex, long fromCoreOpenTime, ScoreMode scoreMode, String toField) {
            super(fromQuery, fromField, toField, scoreMode);
            this.fromIndex = fromIndex;
            this.fromCoreOpenTime = fromCoreOpenTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query joinQuery;
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            CoreContainer container = info.getReq().getCore().getCoreDescriptor().getCoreContainer();
            SolrCore fromCore = container.getCore(this.fromIndex);
            if (fromCore == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + this.fromIndex);
            }
            RefCounted<SolrIndexSearcher> fromHolder = null;
            fromHolder = fromCore.getRegisteredSearcher();
            try {
                SolrIndexSearcher searcher = fromHolder.get();
                FieldType.LegacyNumericType fromNumericType = this.getNumericType(searcher.getSchema(), info.getReq().getSchema());
                joinQuery = this.createJoinQuery(searcher, fromNumericType);
            }
            finally {
                fromCore.close();
                fromHolder.decref();
            }
            return joinQuery.rewrite(reader);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.fromCoreOpenTime ^ this.fromCoreOpenTime >>> 32);
            result = 31 * result + (this.fromIndex == null ? 0 : this.fromIndex.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OtherCoreJoinQuery other = (OtherCoreJoinQuery)((Object)obj);
            if (this.fromCoreOpenTime != other.fromCoreOpenTime) {
                return false;
            }
            return !(this.fromIndex == null ? other.fromIndex != null : !this.fromIndex.equals(other.fromIndex));
        }

        @Override
        public String toString(String field) {
            return "OtherCoreJoinQuery [fromIndex=" + this.fromIndex + ", fromCoreOpenTime=" + this.fromCoreOpenTime + " extends " + super.toString(field) + "]";
        }
    }
}

