/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.join.BlockJoinFacetAccsHolder;

abstract class BlockJoinFacetComponentSupport
extends SearchComponent {
    public static final String CHILD_FACET_FIELD_PARAMETER = "child.facet.field";
    public static final String NO_TO_PARENT_BJQ_MESSAGE = "Block join faceting is allowed with ToParentBlockJoinQuery only";
    public static final String COLLECTOR_CONTEXT_PARAM = "blockJoinFacetCollector";

    BlockJoinFacetComponentSupport() {
    }

    protected void validateQuery(Query query) {
        if (!(query instanceof ToParentBlockJoinQuery)) {
            if (query instanceof BooleanQuery) {
                List clauses = ((BooleanQuery)query).clauses();
                for (BooleanClause clause : clauses) {
                    if (!(clause.getQuery() instanceof ToParentBlockJoinQuery)) continue;
                    return;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, NO_TO_PARENT_BJQ_MESSAGE);
        }
    }

    static String[] getChildFacetFields(SolrQueryRequest req) {
        return req.getParams().getParams(CHILD_FACET_FIELD_PARAMETER);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (BlockJoinFacetComponentSupport.getChildFacetFields(rb.req) != null) {
            BlockJoinFacetAccsHolder blockJoinFacetCollector = (BlockJoinFacetAccsHolder)rb.req.getContext().get(COLLECTOR_CONTEXT_PARAM);
            assert (blockJoinFacetCollector != null);
            NamedList output = this.isShard(rb) ? this.getChildFacetFields(rb.rsp.getValues(), true) : this.getFacetFieldsList(rb);
            this.mergeFacets(output, blockJoinFacetCollector.getFacets());
        }
    }

    private boolean isShard(ResponseBuilder rb) {
        return "true".equals(rb.req.getParams().get("isShard"));
    }

    private NamedList getChildFacetFields(NamedList responseValues, boolean createIfAbsent) {
        return this.getNamedListFromList(responseValues, "child_facet_fields", createIfAbsent);
    }

    private void mergeFacets(NamedList childFacetFields, NamedList shardFacets) {
        if (shardFacets != null) {
            for (Map.Entry nextShardFacet : shardFacets) {
                String fieldName = (String)nextShardFacet.getKey();
                NamedList collectedFacet = (NamedList)childFacetFields.get(fieldName);
                NamedList shardFacet = (NamedList)nextShardFacet.getValue();
                if (collectedFacet == null) {
                    childFacetFields.add(fieldName, (Object)shardFacet);
                    continue;
                }
                this.mergeFacetValues((NamedList<Integer>)collectedFacet, (NamedList<Integer>)shardFacet);
            }
        }
    }

    private void mergeFacetValues(NamedList<Integer> collectedFacetValue, NamedList<Integer> shardFacetValue) {
        for (Map.Entry nextShardValue : shardFacetValue) {
            String facetValue = (String)nextShardValue.getKey();
            Integer shardCount = (Integer)nextShardValue.getValue();
            int indexOfCollectedValue = collectedFacetValue.indexOf(facetValue, 0);
            if (indexOfCollectedValue == -1) {
                collectedFacetValue.add(facetValue, (Object)shardCount);
                continue;
            }
            int newCount = (Integer)collectedFacetValue.getVal(indexOfCollectedValue) + shardCount;
            collectedFacetValue.setVal(indexOfCollectedValue, (Object)newCount);
        }
    }

    private NamedList getNamedListFromList(NamedList parentList, String name, boolean createIfAbsent) {
        NamedList result = null;
        if (parentList != null && (result = (NamedList)parentList.get(name)) == null && createIfAbsent) {
            result = new NamedList();
            parentList.add(name, (Object)result);
        }
        return result;
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        NamedList collectedChildFacetFields = this.getChildFacetFields(rb.rsp.getValues(), true);
        List<ShardResponse> responses = sreq.responses;
        for (ShardResponse shardResponse : responses) {
            NamedList shardChildFacetFields = this.getChildFacetFields(shardResponse.getSolrResponse().getResponse(), false);
            this.mergeFacets(collectedChildFacetFields, shardChildFacetFields);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        NamedList childFacetFields = this.getChildFacetFields(rb.rsp.getValues(), true);
        NamedList facetFields = this.getFacetFieldsList(rb);
        for (Map.Entry childFacetField : childFacetFields) {
            facetFields.add((String)childFacetField.getKey(), childFacetField.getValue());
        }
        rb.rsp.getValues().remove("child_facet_fields");
    }

    private NamedList getFacetFieldsList(ResponseBuilder rb) {
        NamedList facetCounts = this.getNamedListFromList(rb.rsp.getValues(), "facet_counts", true);
        return this.getNamedListFromList(facetCounts, "facet_fields", true);
    }

    @Override
    public String getDescription() {
        return "BlockJoin facet component";
    }
}

