/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetProcessor;

public abstract class FacetRequest {
    protected Map<String, AggValueSource> facetStats = new LinkedHashMap<String, AggValueSource>();
    protected Map<String, FacetRequest> subFacets = new LinkedHashMap<String, FacetRequest>();
    protected boolean processEmpty;
    protected Domain domain;

    public Map<String, AggValueSource> getFacetStats() {
        return this.facetStats;
    }

    public Map<String, FacetRequest> getSubFacets() {
        return this.subFacets;
    }

    public RefineMethod getRefineMethod() {
        return null;
    }

    public boolean doRefine() {
        return this.getRefineMethod() != null && this.getRefineMethod() != RefineMethod.NONE;
    }

    public boolean returnsPartial() {
        return false;
    }

    public boolean canProduceFromEmpty() {
        if (this.domain != null && this.domain.canBecomeNonEmpty()) {
            return true;
        }
        for (FacetRequest freq : this.subFacets.values()) {
            if (!freq.canProduceFromEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addStat(String key, AggValueSource stat) {
        this.facetStats.put(key, stat);
    }

    public void addSubFacet(String key, FacetRequest facetRequest) {
        this.subFacets.put(key, facetRequest);
    }

    public String toString() {
        Map<String, Object> descr = this.getFacetDescription();
        String s = "facet request: { ";
        for (String key : descr.keySet()) {
            s = s + key + ":" + descr.get(key) + ",";
        }
        s = s + "}";
        return s;
    }

    public abstract FacetProcessor createFacetProcessor(FacetContext var1);

    public abstract FacetMerger createFacetMerger(Object var1);

    public abstract Map<String, Object> getFacetDescription();

    public static class Domain {
        public List<String> excludeTags;
        public boolean toParent;
        public boolean toChildren;
        public String parents;
        public List<Object> filters;

        public boolean canTransformDomain() {
            return this.toParent || this.toChildren || this.excludeTags != null;
        }

        public boolean canBecomeNonEmpty() {
            return this.excludeTags != null;
        }
    }

    public static enum RefineMethod {
        NONE,
        SIMPLE;


        public static RefineMethod fromObj(Object method) {
            if (method == null) {
                return null;
            }
            if (method instanceof Boolean) {
                return (Boolean)method != false ? SIMPLE : NONE;
            }
            if ("simple".equals(method)) {
                return SIMPLE;
            }
            if ("none".equals(method)) {
                return NONE;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown RefineMethod method " + method);
        }
    }

    public static enum SortDirection {
        asc(-1),
        desc(1);

        private final int multiplier;

        private SortDirection(int multiplier) {
            this.multiplier = multiplier;
        }

        public int getMultiplier() {
            return this.multiplier;
        }
    }
}

