/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRange;
import org.apache.solr.util.DateMathParser;

class FacetRangeProcessor
extends FacetProcessor<FacetRange> {
    SchemaField sf;
    Calc calc;
    List<Range> rangeList;
    List<Range> otherList;
    long effectiveMincount;
    private Query[] filters;
    private DocSet[] intersections;

    FacetRangeProcessor(FacetContext fcontext, FacetRange freq) {
        super(fcontext, freq);
    }

    @Override
    public void process() throws IOException {
        super.process();
        this.effectiveMincount = this.fcontext.isShard() ? (long)(((FacetRange)this.freq).mincount > 0L ? 1 : 0) : ((FacetRange)this.freq).mincount;
        this.sf = this.fcontext.searcher.getSchema().getField(((FacetRange)this.freq).field);
        this.response = this.getRangeCounts();
    }

    public static Calc getNumericCalc(SchemaField sf) {
        Calc calc;
        FieldType ft = sf.getType();
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    calc = new FloatCalc(sf);
                    break;
                }
                case DOUBLE: {
                    calc = new DoubleCalc(sf);
                    break;
                }
                case INTEGER: {
                    calc = new IntCalc(sf);
                    break;
                }
                case LONG: {
                    calc = new LongCalc(sf);
                    break;
                }
                case DATE: {
                    calc = new DateCalc(sf, null);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected numeric field type :" + sf);
                }
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected numeric field type :" + sf);
        }
        return calc;
    }

    private SimpleOrderedMap<Object> getRangeCounts() throws IOException {
        FieldType ft = this.sf.getType();
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    this.calc = new FloatCalc(this.sf);
                    break;
                }
                case DOUBLE: {
                    this.calc = new DoubleCalc(this.sf);
                    break;
                }
                case INTEGER: {
                    this.calc = new IntCalc(this.sf);
                    break;
                }
                case LONG: {
                    this.calc = new LongCalc(this.sf);
                    break;
                }
                case DATE: {
                    this.calc = new DateCalc(this.sf, null);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on tried field of unexpected type:" + ((FacetRange)this.freq).field);
                }
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + this.sf);
        }
        this.createRangeList();
        return this.getRangeCountsIndexed();
    }

    private void createRangeList() throws IOException {
        boolean incUpper;
        boolean incLower;
        this.rangeList = new ArrayList<Range>();
        this.otherList = new ArrayList<Range>(3);
        Comparable start = this.calc.getValue(((FacetRange)this.freq).start.toString());
        Comparable end = this.calc.getValue(((FacetRange)this.freq).end.toString());
        EnumSet<FacetParams.FacetRangeInclude> include = ((FacetRange)this.freq).include;
        String gap = ((FacetRange)this.freq).gap.toString();
        Comparable low = start;
        while (low.compareTo(end) < 0) {
            Comparable high = this.calc.addGap(low, gap);
            if (end.compareTo(high) < 0) {
                if (((FacetRange)this.freq).hardend) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            if (high.compareTo(low) == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + gap + " = " + high);
            }
            incLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            incUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            Range range = new Range(low, low, high, incLower, incUpper);
            this.rangeList.add(range);
            low = high;
        }
        if (!((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.NONE)) {
            boolean all = ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.ALL);
            if (all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                boolean incUpper2 = include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE);
                this.otherList.add(new Range(FacetParams.FacetRangeOther.BEFORE.toString(), null, start, false, incUpper2));
            }
            if (all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.AFTER)) {
                incLower = include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE);
                this.otherList.add(new Range(FacetParams.FacetRangeOther.AFTER.toString(), end, null, incLower, false));
            }
            if (all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                incLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE);
                incUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE);
                this.otherList.add(new Range(FacetParams.FacetRangeOther.BETWEEN.toString(), start, end, incLower, incUpper));
            }
        }
    }

    private SimpleOrderedMap getRangeCountsIndexed() throws IOException {
        SimpleOrderedMap bucket;
        Range range;
        int idx;
        int idx2;
        int slotCount = this.rangeList.size() + this.otherList.size();
        this.intersections = new DocSet[slotCount];
        this.filters = new Query[slotCount];
        this.createAccs(this.fcontext.base.size(), slotCount);
        for (idx2 = 0; idx2 < this.rangeList.size(); ++idx2) {
            this.rangeStats(this.rangeList.get(idx2), idx2);
        }
        for (idx2 = 0; idx2 < this.otherList.size(); ++idx2) {
            this.rangeStats(this.otherList.get(idx2), this.rangeList.size() + idx2);
        }
        SimpleOrderedMap res = new SimpleOrderedMap();
        ArrayList<SimpleOrderedMap> buckets = new ArrayList<SimpleOrderedMap>();
        res.add("buckets", buckets);
        for (idx = 0; idx < this.rangeList.size(); ++idx) {
            if (this.effectiveMincount > 0L && (long)this.countAcc.getCount(idx) < this.effectiveMincount) continue;
            range = this.rangeList.get(idx);
            bucket = new SimpleOrderedMap();
            buckets.add(bucket);
            bucket.add("val", range.label);
            this.addStats((SimpleOrderedMap<Object>)bucket, idx);
            this.doSubs(bucket, idx);
        }
        for (idx = 0; idx < this.otherList.size(); ++idx) {
            range = this.otherList.get(idx);
            bucket = new SimpleOrderedMap();
            res.add(range.label.toString(), (Object)bucket);
            this.addStats((SimpleOrderedMap<Object>)bucket, this.rangeList.size() + idx);
            this.doSubs(bucket, this.rangeList.size() + idx);
        }
        return res;
    }

    private void rangeStats(Range range, int slot) throws IOException {
        Query rangeQ = this.sf.getType().getRangeQuery(null, this.sf, range.low == null ? null : this.calc.formatValue(range.low), range.high == null ? null : this.calc.formatValue(range.high), range.includeLower, range.includeUpper);
        DocSet intersection = this.fcontext.searcher.getDocSet(rangeQ, this.fcontext.base);
        this.filters[slot] = rangeQ;
        this.intersections[slot] = intersection;
        int num = this.collect(intersection, slot);
        this.countAcc.incrementCount(slot, num);
    }

    private void doSubs(SimpleOrderedMap bucket, int slot) throws IOException {
        if (((FacetRange)this.freq).getSubFacets().size() > 0) {
            DocSet subBase = this.intersections[slot];
            this.processSubs((SimpleOrderedMap<Object>)bucket, this.filters[slot], subBase);
        }
    }

    private SimpleOrderedMap<Object> rangeStats(Range range, boolean special) throws IOException {
        SimpleOrderedMap bucket = new SimpleOrderedMap();
        if (!special) {
            bucket.add("val", range.label);
        }
        Query rangeQ = this.sf.getType().getRangeQuery(null, this.sf, range.low == null ? null : this.calc.formatValue(range.low), range.high == null ? null : this.calc.formatValue(range.high), range.includeLower, range.includeUpper);
        this.fillBucket((SimpleOrderedMap<Object>)bucket, rangeQ, null);
        return bucket;
    }

    private static class DateCalc
    extends Calc {
        private final Date now;

        public DateCalc(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof TrieDateField)) {
                throw new IllegalArgumentException("SchemaField must use field type extending TrieDateField or DateRangeField");
            }
        }

        @Override
        public Comparable bitsToValue(long bits) {
            return new Date(bits);
        }

        @Override
        public String formatValue(Comparable val) {
            return ((Date)val).toInstant().toString();
        }

        @Override
        protected Date parseStr(String rawval) {
            return DateMathParser.parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Comparable value, String gap) throws ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow((Date)value);
            return dmp.parseMath(gap);
        }
    }

    private static class LongCalc
    extends Calc {
        public LongCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Long parseStr(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Comparable value, String gap) {
            return new Long(((Number)((Object)value)).longValue() + Long.valueOf(gap));
        }
    }

    private static class IntCalc
    extends Calc {
        public IntCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Integer parseStr(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Comparable value, String gap) {
            return new Integer(((Number)((Object)value)).intValue() + Integer.valueOf(gap));
        }
    }

    private static class DoubleCalc
    extends Calc {
        @Override
        public Comparable bitsToValue(long bits) {
            return Double.valueOf(Double.longBitsToDouble(bits));
        }

        @Override
        public long bitsToSortableBits(long bits) {
            return NumericUtils.sortableDoubleBits((long)bits);
        }

        public DoubleCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Double parseStr(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Comparable value, String gap) {
            return new Double(((Number)((Object)value)).doubleValue() + Double.valueOf(gap));
        }
    }

    private static class FloatCalc
    extends Calc {
        @Override
        public Comparable bitsToValue(long bits) {
            return Float.valueOf(Float.intBitsToFloat((int)bits));
        }

        @Override
        public long bitsToSortableBits(long bits) {
            return NumericUtils.sortableDoubleBits((long)bits);
        }

        public FloatCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Float parseStr(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Comparable value, String gap) {
            return new Float(((Number)((Object)value)).floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    static abstract class Calc {
        protected final SchemaField field;

        public Calc(SchemaField field) {
            this.field = field;
        }

        public Comparable bitsToValue(long bits) {
            return Long.valueOf(bits);
        }

        public long bitsToSortableBits(long bits) {
            return bits;
        }

        public String formatValue(Comparable val) {
            return val.toString();
        }

        public final Comparable getValue(String rawval) {
            try {
                return this.parseStr(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract Comparable parseStr(String var1) throws ParseException;

        public final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected Object parseGap(String rawval) throws ParseException {
            return this.parseStr(rawval);
        }

        public final Comparable addGap(Comparable value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract Comparable parseAndAddGap(Comparable var1, String var2) throws ParseException;
    }

    private static class Range {
        Object label;
        Comparable low;
        Comparable high;
        boolean includeLower;
        boolean includeUpper;

        public Range(Object label, Comparable low, Comparable high, boolean includeLower, boolean includeUpper) {
            this.label = label;
            this.low = low;
            this.high = high;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
        }
    }
}

