/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;

abstract class FacetFieldProcessorByArray
extends FacetFieldProcessor {
    BytesRefBuilder prefixRef;
    int startTermIndex;
    int endTermIndex;
    int nTerms;
    int nDocs;
    int maxSlots;
    int allBucketsSlot = -1;

    FacetFieldProcessorByArray(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    protected abstract void findStartAndEndOrds() throws IOException;

    protected abstract void collectDocs() throws IOException;

    protected abstract BytesRef lookupOrd(int var1) throws IOException;

    @Override
    public void process() throws IOException {
        super.process();
        this.response = this.calcFacets();
    }

    private SimpleOrderedMap<Object> calcFacets() throws IOException {
        String prefix = ((FacetField)this.freq).prefix;
        if (prefix == null || prefix.length() == 0) {
            this.prefixRef = null;
        } else {
            this.prefixRef = new BytesRefBuilder();
            this.prefixRef.copyChars((CharSequence)prefix);
        }
        this.findStartAndEndOrds();
        this.maxSlots = this.nTerms;
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsSlot = this.maxSlots++;
        }
        this.createCollectAcc(this.nDocs, this.maxSlots);
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsAcc = new FacetFieldProcessor.SpecialSlotAcc(this.fcontext, this.collectAcc, this.allBucketsSlot, this.otherAccs, 0);
        }
        this.collectDocs();
        return super.findTopSlots(this.nTerms, this.nTerms, slotNum -> {
            try {
                return (Comparable)this.sf.getType().toObject(this.sf, this.lookupOrd(slotNum + this.startTermIndex));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, Object::toString);
    }
}

