/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.net.URL;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.JmxMonitoredMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.uninverting.UninvertingReader;

public class SolrFieldCacheMBean
implements JmxMonitoredMap.JmxAugmentedSolrInfoMBean {
    private boolean disableEntryList = Boolean.getBoolean("disableSolrFieldCacheMBeanEntryList");
    private boolean disableJmxEntryList = Boolean.getBoolean("disableSolrFieldCacheMBeanEntryListJmx");

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "Provides introspection of the Solr FieldCache ";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        return this.getStats(!this.disableEntryList);
    }

    @Override
    public NamedList getStatisticsForJmx() {
        return this.getStats(!this.disableEntryList && !this.disableJmxEntryList);
    }

    private NamedList getStats(boolean listEntries) {
        SimpleOrderedMap stats = new SimpleOrderedMap();
        if (listEntries) {
            UninvertingReader.FieldCacheStats fieldCacheStats = UninvertingReader.getUninvertedStats();
            String[] entries = fieldCacheStats.info;
            stats.add("entries_count", (Object)entries.length);
            stats.add("total_size", (Object)fieldCacheStats.totalSize);
            for (int i = 0; i < entries.length; ++i) {
                stats.add("entry#" + i, (Object)entries[i]);
            }
        } else {
            stats.add("entries_count", (Object)UninvertingReader.getUninvertedStatsSize());
        }
        return stats;
    }
}

