/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.xml.CoreParser;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrQueryBuilder;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public class SolrCoreParser
extends CoreParser
implements NamedListInitializedPlugin {
    protected final SolrQueryRequest req;

    public SolrCoreParser(String defaultField, Analyzer analyzer, SolrQueryRequest req) {
        super(defaultField, analyzer);
        this.req = req;
    }

    @Override
    public void init(NamedList initArgs) {
        if (initArgs == null || initArgs.size() == 0) {
            return;
        }
        SolrResourceLoader loader = this.req == null ? new SolrResourceLoader() : this.req.getCore().getResourceLoader();
        NamedList args = initArgs;
        for (Map.Entry entry : args) {
            String queryName = (String)entry.getKey();
            String queryBuilderClassName = (String)entry.getValue();
            SolrQueryBuilder queryBuilder = loader.newInstance(queryBuilderClassName, SolrQueryBuilder.class, null, new Class[]{String.class, Analyzer.class, SolrQueryRequest.class, QueryBuilder.class}, new Object[]{this.defaultField, this.analyzer, this.req, this});
            this.queryFactory.addBuilder(queryName, (QueryBuilder)queryBuilder);
        }
    }
}

