/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.Rescorer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.AbstractReRankQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class ReRankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rerank";
    private static Query defaultQuery = new MatchAllDocsQuery();
    public static final String RERANK_QUERY = "reRankQuery";
    public static final String RERANK_DOCS = "reRankDocs";
    public static final int RERANK_DOCS_DEFAULT = 200;
    public static final String RERANK_WEIGHT = "reRankWeight";
    public static final double RERANK_WEIGHT_DEFAULT = 2.0;

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ReRankQParser(query, localParams, params, req);
    }

    private final class ReRankQuery
    extends AbstractReRankQuery {
        private final Query reRankQuery;
        private final double reRankWeight;

        public int hashCode() {
            return 31 * this.classHash() + this.mainQuery.hashCode() + this.reRankQuery.hashCode() + (int)this.reRankWeight + this.reRankDocs;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ReRankQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ReRankQuery rrq) {
            return this.mainQuery.equals((Object)rrq.mainQuery) && this.reRankQuery.equals((Object)rrq.reRankQuery) && this.reRankWeight == rrq.reRankWeight && this.reRankDocs == rrq.reRankDocs;
        }

        public ReRankQuery(Query reRankQuery, int reRankDocs, double reRankWeight) {
            super(defaultQuery, reRankDocs, (Rescorer)new ReRankQueryRescorer(reRankQuery, reRankWeight));
            this.reRankQuery = reRankQuery;
            this.reRankWeight = reRankWeight;
        }

        @Override
        public String toString(String s) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("{!").append(ReRankQParserPlugin.NAME);
            sb.append(" mainQuery='").append(this.mainQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_QUERY).append("='").append(this.reRankQuery.toString()).append("' ");
            sb.append(ReRankQParserPlugin.RERANK_DOCS).append('=').append(this.reRankDocs).append(' ');
            sb.append(ReRankQParserPlugin.RERANK_WEIGHT).append('=').append(this.reRankWeight).append('}');
            return sb.toString();
        }

        @Override
        protected Query rewrite(Query rewrittenMainQuery) throws IOException {
            return new ReRankQuery(this.reRankQuery, this.reRankDocs, this.reRankWeight).wrap(rewrittenMainQuery);
        }
    }

    private final class ReRankQueryRescorer
    extends QueryRescorer {
        final double reRankWeight;

        public ReRankQueryRescorer(Query reRankQuery, double reRankWeight) {
            super(reRankQuery);
            this.reRankWeight = reRankWeight;
        }

        protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
            float score = firstPassScore;
            if (secondPassMatches) {
                score = (float)((double)score + this.reRankWeight * (double)secondPassScore);
            }
            return score;
        }
    }

    private class ReRankQParser
    extends QParser {
        public ReRankQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(query, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String reRankQueryString = this.localParams.get(ReRankQParserPlugin.RERANK_QUERY);
            if (reRankQueryString == null || reRankQueryString.trim().length() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "reRankQuery parameter is mandatory");
            }
            QParser reRankParser = QParser.getParser(reRankQueryString, this.req);
            Query reRankQuery = reRankParser.parse();
            int reRankDocs = this.localParams.getInt(ReRankQParserPlugin.RERANK_DOCS, 200);
            reRankDocs = Math.max(1, reRankDocs);
            double reRankWeight = this.localParams.getDouble(ReRankQParserPlugin.RERANK_WEIGHT, 2.0);
            return new ReRankQuery(reRankQuery, reRankDocs, reRankWeight);
        }
    }
}

