/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.SortedIntDocSet;

public class DocSetCollector
extends SimpleCollector {
    int pos = 0;
    FixedBitSet bits;
    final int maxDoc;
    final int smallSetSize;
    int base;
    final ExpandingIntArray scratch;

    public DocSetCollector(int maxDoc) {
        this(DocSetUtil.smallSetSize(maxDoc), maxDoc);
    }

    public DocSetCollector(int smallSetSize, int maxDoc) {
        this.smallSetSize = smallSetSize;
        this.maxDoc = maxDoc;
        this.scratch = new ExpandingIntArray(smallSetSize);
    }

    public void collect(int doc) throws IOException {
        doc += this.base;
        if (this.pos < this.smallSetSize) {
            this.scratch.add(this.pos, doc);
        } else {
            if (this.bits == null) {
                this.bits = new FixedBitSet(this.maxDoc);
            }
            this.bits.set(doc);
        }
        ++this.pos;
    }

    public DocSet getDocSet() {
        if (this.pos <= this.scratch.size()) {
            return new SortedIntDocSet(this.scratch.toArray(), this.pos);
        }
        this.scratch.copyTo(this.bits);
        return new BitDocSet(this.bits, this.pos);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public boolean needsScores() {
        return false;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.base = context.docBase;
    }

    protected static class ExpandingIntArray {
        private static final int[] EMPTY = new int[0];
        private int[] currentAddArray = null;
        private int indexForNextAddInCurrentAddArray = 0;
        private int size = 0;
        private final int smallSetSize;
        private ArrayList<int[]> arrays;

        public ExpandingIntArray(int smallSetSize) {
            this.smallSetSize = smallSetSize;
            this.currentAddArray = EMPTY;
        }

        private void addNewArray() {
            int arrSize = Math.max(10, this.currentAddArray.length << 1);
            arrSize = Math.min(arrSize, this.smallSetSize - this.size);
            this.currentAddArray = new int[arrSize];
            if (this.arrays == null) {
                this.arrays = new ArrayList();
            }
            this.arrays.add(this.currentAddArray);
            this.indexForNextAddInCurrentAddArray = 0;
        }

        public void add(int index, int value) {
            if (this.indexForNextAddInCurrentAddArray >= this.currentAddArray.length) {
                this.addNewArray();
            }
            this.currentAddArray[this.indexForNextAddInCurrentAddArray++] = value;
            ++this.size;
        }

        public void copyTo(FixedBitSet bits) {
            if (this.size > 0) {
                int resultPos = 0;
                for (int i = 0; i < this.arrays.size(); ++i) {
                    int[] srcArray = this.arrays.get(i);
                    int intsToCopy = i < this.arrays.size() - 1 ? srcArray.length : this.indexForNextAddInCurrentAddArray;
                    for (int j = 0; j < intsToCopy; ++j) {
                        bits.set(srcArray[j]);
                    }
                    resultPos += intsToCopy;
                }
                assert (resultPos == this.size);
            }
        }

        public int[] toArray() {
            int[] result = new int[this.size];
            if (this.size > 0) {
                int resultPos = 0;
                for (int i = 0; i < this.arrays.size(); ++i) {
                    int[] srcArray = this.arrays.get(i);
                    int intsToCopy = i < this.arrays.size() - 1 ? srcArray.length : this.indexForNextAddInCurrentAddArray;
                    System.arraycopy(srcArray, 0, result, resultPos, intsToCopy);
                    resultPos += intsToCopy;
                }
                assert (resultPos == this.size);
            }
            return result;
        }

        public int size() {
            return this.size;
        }
    }
}

