/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LegacyDoubleField;
import org.apache.lucene.document.LegacyFloatField;
import org.apache.lucene.document.LegacyIntField;
import org.apache.lucene.document.LegacyLongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.DocValuesRangeQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateFieldSource;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieField
extends PrimitiveFieldType {
    public static final int DEFAULT_PRECISION_STEP = 8;
    protected int precisionStepArg = 8;
    protected int precisionStep;
    protected TrieTypes type;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static long FLOAT_NEGATIVE_INFINITY_BITS = Float.floatToIntBits(Float.NEGATIVE_INFINITY);
    private static long DOUBLE_NEGATIVE_INFINITY_BITS = Double.doubleToLongBits(Double.NEGATIVE_INFINITY);
    private static long FLOAT_POSITIVE_INFINITY_BITS = Float.floatToIntBits(Float.POSITIVE_INFINITY);
    private static long DOUBLE_POSITIVE_INFINITY_BITS = Double.doubleToLongBits(Double.POSITIVE_INFINITY);
    private static long FLOAT_MINUS_ZERO_BITS = Float.floatToIntBits(-0.0f);
    private static long DOUBLE_MINUS_ZERO_BITS = Double.doubleToLongBits(-0.0);
    private static long FLOAT_ZERO_BITS = Float.floatToIntBits(0.0f);
    private static long DOUBLE_ZERO_BITS = Double.doubleToLongBits(0.0);
    static final String INT_PREFIX = new String(new char[]{'`'});
    static final String LONG_PREFIX = new String(new char[]{' '});

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String t;
        super.init(schema, args);
        String p = args.remove("precisionStep");
        if (p != null) {
            this.precisionStepArg = Integer.parseInt(p);
        }
        this.precisionStep = this.precisionStepArg;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
        if ((t = args.remove("type")) != null) {
            try {
                this.type = TrieTypes.valueOf(t.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid type specified in schema.xml for field: " + args.get("name"), (Throwable)e);
            }
        }
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.NUMERIC) {
                long bits = val.longValue();
                switch (this.type) {
                    case INTEGER: {
                        return (int)bits;
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.intBitsToFloat((int)bits));
                    }
                    case LONG: {
                        return bits;
                    }
                    case DOUBLE: {
                        return Double.longBitsToDouble(bits);
                    }
                    case DATE: {
                        return new Date(bits);
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
            }
            return this.type == TrieTypes.DATE ? new Date(val.longValue()) : val;
        }
        BytesRef term = f.binaryValue();
        switch (this.type) {
            case INTEGER: {
                return LegacyNumericUtils.prefixCodedToInt((BytesRef)term);
            }
            case FLOAT: {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt((BytesRef)term)));
            }
            case LONG: {
                return LegacyNumericUtils.prefixCodedToLong((BytesRef)term);
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong((BytesRef)term));
            }
            case DATE: {
                return new Date(LegacyNumericUtils.prefixCodedToLong((BytesRef)term));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        Number missingValue = null;
        boolean sortMissingLast = field.sortMissingLast();
        boolean sortMissingFirst = field.sortMissingFirst();
        switch (this.type) {
            case INTEGER: {
                if (sortMissingLast) {
                    missingValue = top ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                } else if (sortMissingFirst) {
                    missingValue = top ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                }
                SortField sf = new SortField(field.getName(), SortField.Type.INT, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
            case FLOAT: {
                if (sortMissingLast) {
                    missingValue = Float.valueOf(top ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                } else if (sortMissingFirst) {
                    missingValue = Float.valueOf(top ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
                }
                SortField sf = new SortField(field.getName(), SortField.Type.FLOAT, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
            case LONG: 
            case DATE: {
                if (sortMissingLast) {
                    missingValue = top ? Long.MIN_VALUE : Long.MAX_VALUE;
                } else if (sortMissingFirst) {
                    missingValue = top ? Long.MAX_VALUE : Long.MIN_VALUE;
                }
                SortField sf = new SortField(field.getName(), SortField.Type.LONG, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
            case DOUBLE: {
                if (sortMissingLast) {
                    missingValue = top ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                } else if (sortMissingFirst) {
                    missingValue = top ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
                SortField sf = new SortField(field.getName(), SortField.Type.DOUBLE, top);
                sf.setMissingValue((Object)missingValue);
                return sf;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            switch (this.type) {
                case INTEGER: {
                    return UninvertingReader.Type.SORTED_SET_INTEGER;
                }
                case LONG: 
                case DATE: {
                    return UninvertingReader.Type.SORTED_SET_LONG;
                }
                case FLOAT: {
                    return UninvertingReader.Type.SORTED_SET_FLOAT;
                }
                case DOUBLE: {
                    return UninvertingReader.Type.SORTED_SET_DOUBLE;
                }
            }
            throw new AssertionError();
        }
        switch (this.type) {
            case INTEGER: {
                return UninvertingReader.Type.LEGACY_INTEGER;
            }
            case LONG: 
            case DATE: {
                return UninvertingReader.Type.LEGACY_LONG;
            }
            case FLOAT: {
                return UninvertingReader.Type.LEGACY_FLOAT;
            }
            case DOUBLE: {
                return UninvertingReader.Type.LEGACY_DOUBLE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        switch (this.type) {
            case INTEGER: {
                return new IntFieldSource(field.getName());
            }
            case FLOAT: {
                return new FloatFieldSource(field.getName());
            }
            case DATE: {
                return new TrieDateFieldSource(field.getName());
            }
            case LONG: {
                return new LongFieldSource(field.getName());
            }
            case DOUBLE: {
                return new DoubleFieldSource(field.getName());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public final ValueSource getSingleValueSource(FieldType.MultiValueSelector choice, SchemaField field, QParser parser) {
        if (!field.multiValued()) {
            return this.getValueSource(field, parser);
        }
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "docValues='true' is required to select '" + choice.toString() + "' value from multivalued field (" + field.getName() + ") at query time");
        }
        SortedSetSelector.Type selectorType = choice.getSortedSetSelectorType();
        if (null == selectorType) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, choice.toString() + " is not a supported option for picking a single value from the multivalued field: " + field.getName() + " (type: " + this.getTypeName() + ")");
        }
        return this.getSingleValueSource(selectorType, field);
    }

    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField field) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not select a single value for multivalued field: " + field.getName() + " (single valued field selection not supported for type: " + this.getTypeName() + ")");
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeVal(name, this.toObject(f));
    }

    @Override
    public boolean isTokenized() {
        return false;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }

    public int getPrecisionStep() {
        return this.precisionStepArg;
    }

    public TrieTypes getType() {
        return this.type;
    }

    @Override
    public FieldType.LegacyNumericType getNumericType() {
        switch (this.type) {
            case INTEGER: {
                return FieldType.LegacyNumericType.INT;
            }
            case LONG: 
            case DATE: {
                return FieldType.LegacyNumericType.LONG;
            }
            case FLOAT: {
                return FieldType.LegacyNumericType.FLOAT;
            }
            case DOUBLE: {
                return FieldType.LegacyNumericType.DOUBLE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        Query query;
        if (field.multiValued() && field.hasDocValues() && !field.indexed()) {
            return super.getRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
        }
        int ps = this.precisionStep;
        boolean matchOnly = field.hasDocValues() && !field.indexed();
        switch (this.type) {
            case INTEGER: {
                if (matchOnly) {
                    query = DocValuesRangeQuery.newLongRange((String)field.getName(), (Long)(min == null ? null : Long.valueOf(Integer.parseInt(min))), (Long)(max == null ? null : Long.valueOf(Integer.parseInt(max))), (boolean)minInclusive, (boolean)maxInclusive);
                    break;
                }
                query = LegacyNumericRangeQuery.newIntRange((String)field.getName(), (int)ps, (Integer)(min == null ? null : Integer.valueOf(Integer.parseInt(min))), (Integer)(max == null ? null : Integer.valueOf(Integer.parseInt(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case FLOAT: {
                if (matchOnly) {
                    return this.getRangeQueryForFloatDoubleDocValues(field, min, max, minInclusive, maxInclusive);
                }
                query = LegacyNumericRangeQuery.newFloatRange((String)field.getName(), (int)ps, (Float)(min == null ? null : Float.valueOf(Float.parseFloat(min))), (Float)(max == null ? null : Float.valueOf(Float.parseFloat(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case LONG: {
                if (matchOnly) {
                    query = DocValuesRangeQuery.newLongRange((String)field.getName(), (Long)(min == null ? null : Long.valueOf(Long.parseLong(min))), (Long)(max == null ? null : Long.valueOf(Long.parseLong(max))), (boolean)minInclusive, (boolean)maxInclusive);
                    break;
                }
                query = LegacyNumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(Long.parseLong(min))), (Long)(max == null ? null : Long.valueOf(Long.parseLong(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DOUBLE: {
                if (matchOnly) {
                    return this.getRangeQueryForFloatDoubleDocValues(field, min, max, minInclusive, maxInclusive);
                }
                query = LegacyNumericRangeQuery.newDoubleRange((String)field.getName(), (int)ps, (Double)(min == null ? null : Double.valueOf(Double.parseDouble(min))), (Double)(max == null ? null : Double.valueOf(Double.parseDouble(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DATE: {
                if (matchOnly) {
                    query = DocValuesRangeQuery.newLongRange((String)field.getName(), (Long)(min == null ? null : Long.valueOf(DateMathParser.parseMath(null, min).getTime())), max == null ? null : Long.valueOf(DateMathParser.parseMath(null, max).getTime()), (boolean)minInclusive, (boolean)maxInclusive);
                    break;
                }
                query = LegacyNumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(DateMathParser.parseMath(null, min).getTime())), max == null ? null : Long.valueOf(DateMathParser.parseMath(null, max).getTime()), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
            }
        }
        return query;
    }

    private Query getRangeQueryForFloatDoubleDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        FunctionRangeQuery query;
        long zeroBits;
        Long minBits;
        Double maxVal;
        Double minVal;
        String fieldName = sf.getName();
        Double d = min == null ? null : (minVal = Double.valueOf(this.type == TrieTypes.FLOAT ? (double)Float.parseFloat(min) : Double.parseDouble(min)));
        Double d2 = max == null ? null : (maxVal = Double.valueOf(this.type == TrieTypes.FLOAT ? (double)Float.parseFloat(max) : Double.parseDouble(max)));
        Long l = min == null ? null : (minBits = Long.valueOf(this.type == TrieTypes.FLOAT ? (long)Float.floatToIntBits(((Number)minVal).floatValue()) : Double.doubleToLongBits(minVal)));
        Long maxBits = max == null ? null : Long.valueOf(this.type == TrieTypes.FLOAT ? (long)Float.floatToIntBits(((Number)maxVal).floatValue()) : Double.doubleToLongBits(maxVal));
        long negativeInfinityBits = this.type == TrieTypes.FLOAT ? FLOAT_NEGATIVE_INFINITY_BITS : DOUBLE_NEGATIVE_INFINITY_BITS;
        long positiveInfinityBits = this.type == TrieTypes.FLOAT ? FLOAT_POSITIVE_INFINITY_BITS : DOUBLE_POSITIVE_INFINITY_BITS;
        long minusZeroBits = this.type == TrieTypes.FLOAT ? FLOAT_MINUS_ZERO_BITS : DOUBLE_MINUS_ZERO_BITS;
        long l2 = zeroBits = this.type == TrieTypes.FLOAT ? FLOAT_ZERO_BITS : DOUBLE_ZERO_BITS;
        if ((minVal == null || minVal < 0.0 || minBits == minusZeroBits) && (maxVal == null || maxVal > 0.0 || maxBits == zeroBits)) {
            ValueSource vs = this.getValueSource(sf, null);
            query = new FunctionRangeQuery(new ValueSourceRangeFilter(vs, min, max, minInclusive, maxInclusive));
        } else {
            query = (minVal == null || minVal < 0.0 || minBits == minusZeroBits) && maxVal != null && (maxVal < 0.0 || maxBits == minusZeroBits) ? DocValuesRangeQuery.newLongRange((String)fieldName, (Long)maxBits, (Long)(min == null ? negativeInfinityBits : minBits), (boolean)maxInclusive, (boolean)minInclusive) : DocValuesRangeQuery.newLongRange((String)fieldName, (Long)minBits, (Long)(max == null ? positiveInfinityBits : maxBits), (boolean)minInclusive, (boolean)maxInclusive);
        }
        return query;
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        if (!field.indexed() && field.hasDocValues()) {
            return this.getRangeQuery(parser, field, externalVal, externalVal, true, true);
        }
        return super.getFieldQuery(parser, field, externalVal);
    }

    @Override
    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    @Override
    public String readableToIndexed(String val) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.readableToIndexed(val, bytes);
        return bytes.get().utf8ToString();
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        String s = val.toString();
        try {
            switch (this.type) {
                case INTEGER: {
                    LegacyNumericUtils.intToPrefixCoded((int)Integer.parseInt(s), (int)0, (BytesRefBuilder)result);
                    break;
                }
                case FLOAT: {
                    LegacyNumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)Float.parseFloat(s)), (int)0, (BytesRefBuilder)result);
                    break;
                }
                case LONG: {
                    LegacyNumericUtils.longToPrefixCoded((long)Long.parseLong(s), (int)0, (BytesRefBuilder)result);
                    break;
                }
                case DOUBLE: {
                    LegacyNumericUtils.longToPrefixCoded((long)NumericUtils.doubleToSortableLong((double)Double.parseDouble(s)), (int)0, (BytesRefBuilder)result);
                    break;
                }
                case DATE: {
                    LegacyNumericUtils.longToPrefixCoded((long)DateMathParser.parseMath(null, s).getTime(), (int)0, (BytesRefBuilder)result);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Number: " + val);
        }
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    static String badFieldString(IndexableField f) {
        String s = f.stringValue();
        return "ERROR:SCHEMA-INDEX-MISMATCH,stringValue=" + s;
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.type == TrieTypes.DATE ? ((Date)this.toObject(f)).toInstant().toString() : this.toObject(f).toString();
    }

    @Override
    public String indexedToReadable(String _indexedForm) {
        BytesRef indexedForm = new BytesRef((CharSequence)_indexedForm);
        switch (this.type) {
            case INTEGER: {
                return Integer.toString(LegacyNumericUtils.prefixCodedToInt((BytesRef)indexedForm));
            }
            case FLOAT: {
                return Float.toString(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt((BytesRef)indexedForm)));
            }
            case LONG: {
                return Long.toString(LegacyNumericUtils.prefixCodedToLong((BytesRef)indexedForm));
            }
            case DOUBLE: {
                return Double.toString(NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong((BytesRef)indexedForm)));
            }
            case DATE: {
                return Instant.ofEpochMilli(LegacyNumericUtils.prefixCodedToLong((BytesRef)indexedForm)).toString();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public CharsRef indexedToReadable(BytesRef indexedForm, CharsRefBuilder charsRef) {
        String value;
        switch (this.type) {
            case INTEGER: {
                value = Integer.toString(LegacyNumericUtils.prefixCodedToInt((BytesRef)indexedForm));
                break;
            }
            case FLOAT: {
                value = Float.toString(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt((BytesRef)indexedForm)));
                break;
            }
            case LONG: {
                value = Long.toString(LegacyNumericUtils.prefixCodedToLong((BytesRef)indexedForm));
                break;
            }
            case DOUBLE: {
                value = Double.toString(NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong((BytesRef)indexedForm)));
                break;
            }
            case DATE: {
                value = Instant.ofEpochMilli(LegacyNumericUtils.prefixCodedToLong((BytesRef)indexedForm)).toString();
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        charsRef.grow(value.length());
        charsRef.setLength(value.length());
        value.getChars(0, charsRef.length(), charsRef.chars(), 0);
        return charsRef.get();
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        switch (this.type) {
            case INTEGER: {
                return LegacyNumericUtils.prefixCodedToInt((BytesRef)term);
            }
            case FLOAT: {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt((BytesRef)term)));
            }
            case LONG: {
                return LegacyNumericUtils.prefixCodedToLong((BytesRef)term);
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong((BytesRef)term));
            }
            case DATE: {
                return new Date(LegacyNumericUtils.prefixCodedToLong((BytesRef)term));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.storedToIndexed(f, bytes);
        return bytes.get().utf8ToString();
    }

    private void storedToIndexed(IndexableField f, BytesRefBuilder bytes) {
        block7: {
            block6: {
                Number val = f.numericValue();
                if (val == null) break block6;
                switch (this.type) {
                    case INTEGER: {
                        LegacyNumericUtils.intToPrefixCoded((int)val.intValue(), (int)0, (BytesRefBuilder)bytes);
                        break block7;
                    }
                    case FLOAT: {
                        LegacyNumericUtils.intToPrefixCoded((int)NumericUtils.floatToSortableInt((float)val.floatValue()), (int)0, (BytesRefBuilder)bytes);
                        break block7;
                    }
                    case LONG: 
                    case DATE: {
                        LegacyNumericUtils.longToPrefixCoded((long)val.longValue(), (int)0, (BytesRefBuilder)bytes);
                        break block7;
                    }
                    case DOUBLE: {
                        LegacyNumericUtils.longToPrefixCoded((long)NumericUtils.doubleToSortableLong((double)val.doubleValue()), (int)0, (BytesRefBuilder)bytes);
                        break block7;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
                    }
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid field contents: " + f.name());
        }
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        LegacyIntField f;
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        boolean docValues = field.hasDocValues();
        if (!(indexed || stored || docValues)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        org.apache.lucene.document.FieldType ft = new org.apache.lucene.document.FieldType();
        ft.setStored(stored);
        ft.setTokenized(true);
        ft.setOmitNorms(field.omitNorms());
        ft.setIndexOptions(indexed ? this.getIndexOptions(field, value.toString()) : IndexOptions.NONE);
        switch (this.type) {
            case INTEGER: {
                ft.setNumericType(FieldType.LegacyNumericType.INT);
                break;
            }
            case FLOAT: {
                ft.setNumericType(FieldType.LegacyNumericType.FLOAT);
                break;
            }
            case LONG: {
                ft.setNumericType(FieldType.LegacyNumericType.LONG);
                break;
            }
            case DOUBLE: {
                ft.setNumericType(FieldType.LegacyNumericType.DOUBLE);
                break;
            }
            case DATE: {
                ft.setNumericType(FieldType.LegacyNumericType.LONG);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        ft.setNumericPrecisionStep(this.precisionStep);
        switch (this.type) {
            case INTEGER: {
                int i = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                f = new LegacyIntField(field.getName(), i, ft);
                break;
            }
            case FLOAT: {
                float fl = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
                f = new LegacyFloatField(field.getName(), fl, ft);
                break;
            }
            case LONG: {
                long l = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
                f = new LegacyLongField(field.getName(), l, ft);
                break;
            }
            case DOUBLE: {
                double d = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                f = new LegacyDoubleField(field.getName(), d, ft);
                break;
            }
            case DATE: {
                Date date = value instanceof Date ? (Date)value : DateMathParser.parseMath(null, value.toString());
                f = new LegacyLongField(field.getName(), date.getTime(), ft);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        f.setBoost(boost);
        return f;
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value, float boost) {
        if (sf.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            IndexableField field = this.createField(sf, value, boost);
            fields.add(field);
            if (sf.multiValued()) {
                BytesRefBuilder bytes = new BytesRefBuilder();
                this.storedToIndexed(field, bytes);
                fields.add((IndexableField)new SortedSetDocValuesField(sf.getName(), bytes.get()));
            } else {
                long bits;
                if (field.numericValue() instanceof Integer || field.numericValue() instanceof Long) {
                    bits = field.numericValue().longValue();
                } else if (field.numericValue() instanceof Float) {
                    bits = Float.floatToIntBits(field.numericValue().floatValue());
                } else {
                    assert (field.numericValue() instanceof Double);
                    bits = Double.doubleToLongBits(field.numericValue().doubleValue());
                }
                fields.add((IndexableField)new NumericDocValuesField(sf.getName(), bits));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(sf, value, boost));
    }

    public static String getMainValuePrefix(FieldType ft) {
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            if (trie.precisionStep == Integer.MAX_VALUE) {
                return null;
            }
            switch (trie.type) {
                case INTEGER: 
                case FLOAT: {
                    return INT_PREFIX;
                }
                case LONG: 
                case DOUBLE: 
                case DATE: {
                    return LONG_PREFIX;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)trie.type));
        }
        return null;
    }

    @Override
    public void checkSchemaField(SchemaField field) {
    }

    public static enum TrieTypes {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        DATE;

    }
}

