/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieField;
import org.locationtech.spatial4j.context.SpatialContext;

public class SpatialPointVectorFieldType
extends AbstractSpatialFieldType<PointVectorStrategy>
implements SchemaAware {
    protected String numberFieldName = "tdouble";
    private int precisionStep;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String v = args.remove("numberType");
        if (v != null) {
            this.numberFieldName = v;
        }
    }

    @Override
    public void inform(IndexSchema schema) {
        FieldType fieldType = schema.getFieldTypeByName(this.numberFieldName);
        if (fieldType == null) {
            throw new RuntimeException("Can not find number field: " + this.numberFieldName);
        }
        if (!(fieldType instanceof TrieDoubleField)) {
            throw new RuntimeException("field type must be TrieDoubleField: " + fieldType);
        }
        this.precisionStep = ((TrieField)fieldType).getPrecisionStep();
        int p = 51;
        ArrayList<SchemaField> newFields = new ArrayList<SchemaField>();
        for (SchemaField sf : schema.getFields().values()) {
            if (sf.getType() != this) continue;
            String name = sf.getName();
            newFields.add(new SchemaField(name + "__x", fieldType, 51, null));
            newFields.add(new SchemaField(name + "__y", fieldType, 51, null));
        }
        for (SchemaField newField : newFields) {
            schema.getFields().put(newField.getName(), newField);
        }
    }

    @Override
    public FieldType.LegacyNumericType getNumericType() {
        return FieldType.LegacyNumericType.DOUBLE;
    }

    @Override
    protected PointVectorStrategy newSpatialStrategy(String fieldName) {
        if (this.getNumericType() != null) {
            org.apache.lucene.document.FieldType fieldType = new org.apache.lucene.document.FieldType(PointVectorStrategy.LEGACY_FIELDTYPE);
            fieldType.setNumericPrecisionStep(this.precisionStep);
            return new PointVectorStrategy(this.ctx, fieldName, fieldType);
        }
        return PointVectorStrategy.newInstance((SpatialContext)this.ctx, (String)fieldName);
    }
}

