/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.CoordinateFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PointTypeValueSource;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.uninverting.UninvertingReader;

public class PointType
extends CoordinateFieldType
implements SpatialQueryable {
    private static final double SIN_PI_DIV_4 = Math.sin(0.7853981633974483);

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        MapSolrParams p = new MapSolrParams(args);
        this.dimension = p.getInt("dimension", 2);
        if (this.dimension < 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The dimension must be > 0: " + this.dimension);
        }
        args.remove("dimension");
        super.init(schema, args);
        this.createSuffixCache(this.dimension);
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        String externalVal = value.toString();
        String[] point = PointType.parseCommaSeparatedList(externalVal, this.dimension);
        ArrayList<IndexableField> f = new ArrayList<IndexableField>(this.dimension + 1);
        if (field.indexed()) {
            for (int i = 0; i < this.dimension; ++i) {
                SchemaField sf = this.subField(field, i, this.schema);
                f.add(sf.createField(point[i], sf.indexed() && !sf.omitNorms() ? boost : 1.0f));
            }
        }
        if (field.stored()) {
            String storedVal = externalVal;
            FieldType customType = new FieldType();
            customType.setStored(true);
            f.add(this.createField(field.getName(), storedVal, customType, 1.0f));
        }
        return f;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        ArrayList<ValueSource> vs = new ArrayList<ValueSource>(this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            SchemaField sub = this.subField(field, i, this.schema);
            vs.add(sub.getType().getValueSource(sub, parser));
        }
        return new PointTypeValueSource(field, vs);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        throw new UnsupportedOperationException("PointType uses multiple fields.  field=" + field.getName());
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on PointType " + field.getName());
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        String[] p1 = PointType.parseCommaSeparatedList(part1, this.dimension);
        String[] p2 = PointType.parseCommaSeparatedList(part2, this.dimension);
        BooleanQuery.Builder result = new BooleanQuery.Builder();
        result.setDisableCoord(true);
        for (int i = 0; i < this.dimension; ++i) {
            SchemaField subSF = this.subField(field, i, this.schema);
            result.add(subSF.getType().getRangeQuery(parser, subSF, p1[i], p2[i], minInclusive, maxInclusive), BooleanClause.Occur.MUST);
        }
        return result.build();
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        String[] p1 = PointType.parseCommaSeparatedList(externalVal, this.dimension);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (int i = 0; i < this.dimension; ++i) {
            SchemaField sf = this.subField(field, i, this.schema);
            Query tq = sf.getType().getFieldQuery(parser, sf, p1[i]);
            bq.add(tq, BooleanClause.Occur.MUST);
        }
        return bq.build();
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        String[] pointStrs = PointType.parseCommaSeparatedList(options.pointStr, this.dimension);
        double[] point = new double[this.dimension];
        try {
            for (int i = 0; i < pointStrs.length; ++i) {
                point[i] = Double.parseDouble(pointStrs[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        IndexSchema schema = parser.getReq().getSchema();
        if (this.dimension == 1) {
            String lower = String.valueOf(point[0] - options.distance);
            String upper = String.valueOf(point[0] + options.distance);
            SchemaField subSF = this.subField(options.field, 0, schema);
            return subSF.getType().getRangeQuery(parser, subSF, lower, upper, true, true);
        }
        BooleanQuery.Builder tmp = new BooleanQuery.Builder();
        double[] ur = PointType.vectorBoxCorner(point, null, options.distance, true);
        double[] ll = PointType.vectorBoxCorner(point, null, options.distance, false);
        for (int i = 0; i < ur.length; ++i) {
            SchemaField subSF = this.subField(options.field, i, schema);
            Query range = subSF.getType().getRangeQuery(parser, subSF, String.valueOf(ll[i]), String.valueOf(ur[i]), true, true);
            tmp.add(range, BooleanClause.Occur.MUST);
        }
        return tmp.build();
    }

    public static double[] vectorBoxCorner(double[] center, double[] result, double distance, boolean upperRight) {
        if (result == null || result.length != center.length) {
            result = new double[center.length];
        }
        if (!upperRight) {
            distance = -distance;
        }
        distance = SIN_PI_DIV_4 * distance;
        for (int i = 0; i < center.length; ++i) {
            result[i] = center[i] + distance;
        }
        return result;
    }

    public static String[] parseCommaSeparatedList(String externalVal, int dimension) throws SolrException {
        int i;
        int idx;
        String[] out = new String[dimension];
        int end = idx = externalVal.indexOf(44);
        int start = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = externalVal.trim();
            i = 1;
        } else if (idx > 0) {
            for (i = 0; i < dimension; ++i) {
                while (start < end && externalVal.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && externalVal.charAt(end - 1) == ' ') {
                    --end;
                }
                if (start == end) break;
                out[i] = externalVal.substring(start, end);
                start = idx + 1;
                idx = end = externalVal.indexOf(44, start);
                if (end != -1) continue;
                end = externalVal.length();
            }
        }
        if (i != dimension) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i + " values specified");
        }
        return out;
    }

    @Override
    public double getSphereRadius() {
        return 6371.0087714;
    }
}

