/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.FieldType;

public abstract class BaseEditorialTransformer
extends DocTransformer {
    final String name;
    final String idFieldName;
    final FieldType ft;

    public BaseEditorialTransformer(String name, String idFieldName, FieldType ft) {
        this.name = name;
        this.idFieldName = idFieldName;
        this.ft = ft;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void transform(SolrDocument doc, int docid, float score) {
        Set<String> ids = this.getIdSet();
        if (ids != null && !ids.isEmpty()) {
            String key = this.getKey(doc);
            doc.setField(this.name, (Object)ids.contains(key));
        } else {
            doc.setField(this.name, (Object)Boolean.FALSE);
        }
    }

    protected abstract Set<String> getIdSet();

    protected String getKey(SolrDocument doc) {
        String key;
        Object field = doc.get((Object)this.idFieldName);
        Number n = field instanceof Field ? (Number)((Field)field).numericValue() : (Number)null;
        if (n != null) {
            key = n.toString();
            key = this.ft.readableToIndexed(key);
        } else {
            key = field instanceof Field ? ((Field)field).stringValue() : field.toString();
        }
        return key;
    }
}

