/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import javax.management.MBeanServer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricReporter;
import org.apache.solr.metrics.reporters.JmxObjectNameFactory;
import org.apache.solr.util.JmxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrJmxReporter
extends SolrMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String domain;
    private String agentId;
    private String serviceUrl;
    private JmxReporter reporter;
    private MBeanServer mBeanServer;

    public SolrJmxReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
        this.setDomain(registryName);
    }

    @Override
    public synchronized void init(PluginInfo pluginInfo) {
        super.init(pluginInfo);
        if (this.serviceUrl != null && this.agentId != null) {
            ManagementFactory.getPlatformMBeanServer();
            this.mBeanServer = JmxUtil.findFirstMBeanServer();
            log.warn("No more than one of serviceUrl(%s) and agentId(%s) should be configured, using first MBeanServer instead of configuration.", new Object[]{this.serviceUrl, this.agentId, this.mBeanServer});
        } else if (this.serviceUrl != null) {
            try {
                this.mBeanServer = JmxUtil.findMBeanServerForServiceUrl(this.serviceUrl);
            }
            catch (IOException e) {
                log.warn("findMBeanServerForServiceUrl(%s) exception: %s", (Object)this.serviceUrl, (Object)e);
                this.mBeanServer = null;
            }
        } else if (this.agentId != null) {
            this.mBeanServer = JmxUtil.findMBeanServerForAgentId(this.agentId);
        } else {
            ManagementFactory.getPlatformMBeanServer();
            this.mBeanServer = JmxUtil.findFirstMBeanServer();
            log.warn("No serviceUrl or agentId was configured, using first MBeanServer.", (Object)this.mBeanServer);
        }
        if (this.mBeanServer == null) {
            log.warn("No JMX server found. Not exposing Solr metrics.");
            return;
        }
        JmxObjectNameFactory jmxObjectNameFactory = new JmxObjectNameFactory(pluginInfo.name, this.domain, new String[0]);
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).registerWith(this.mBeanServer).inDomain(this.domain).createsObjectNamesWith((ObjectNameFactory)jmxObjectNameFactory).build();
        this.reporter.start();
        log.info("JMX monitoring enabled at server: " + this.mBeanServer);
    }

    @Override
    public synchronized void close() {
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
    }

    @Override
    protected void validate() throws IllegalStateException {
    }

    public void setDomain(String domain) {
        this.domain = domain != null ? domain : this.registryName;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    @Override
    public String toString() {
        return String.format(Locale.ENGLISH, "[%s@%s: domain = %s, service url = %s, agent id = %s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), this.domain, this.serviceUrl, this.agentId);
    }
}

