/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricReporter;

public class SolrGangliaReporter
extends SolrMetricReporter {
    private String host = null;
    private int port = -1;
    private boolean multicast;
    private int period = 60;
    private String instancePrefix = null;
    private String filterPrefix = null;
    private boolean testing;
    private GangliaReporter reporter;
    GMetric ganglia = null;

    public SolrGangliaReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPrefix(String prefix) {
        this.instancePrefix = prefix;
    }

    public void setFilter(String filter) {
        this.filterPrefix = filter;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    void setGMetric(GMetric ganglia) {
        this.ganglia = ganglia;
    }

    @Override
    protected void validate() throws IllegalStateException {
        if (this.host == null) {
            throw new IllegalStateException("Init argument 'host' must be set to a valid Ganglia server name.");
        }
        if (this.port == -1) {
            throw new IllegalStateException("Init argument 'port' must be set to a valid Ganglia server port.");
        }
        if (this.period < 1) {
            throw new IllegalStateException("Init argument 'period' is in time unit 'seconds' and must be at least 1.");
        }
        if (!this.testing) {
            this.start();
        }
    }

    void start() {
        if (!this.testing) {
            try {
                this.ganglia = new GMetric(this.host, this.port, this.multicast ? GMetric.UDPAddressingMode.MULTICAST : GMetric.UDPAddressingMode.UNICAST, 1);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Exception connecting to Ganglia", ioe);
            }
        }
        this.instancePrefix = this.instancePrefix == null ? this.registryName : this.instancePrefix + "." + this.registryName;
        GangliaReporter.Builder builder = GangliaReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).prefixedWith(this.instancePrefix);
        MetricFilter filter = this.filterPrefix != null ? new SolrMetricManager.PrefixFilter(this.filterPrefix) : MetricFilter.ALL;
        builder = builder.filter(filter);
        this.reporter = builder.build(this.ganglia);
        this.reporter.start((long)this.period, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }
}

