/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.metrics.SolrMetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrMetricManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REGISTRY_NAME_PREFIX = "solr.";
    public static final String JETTY_REGISTRY = "solr." + SolrInfoMBean.Group.jetty.toString();
    public static final String JVM_REGISTRY = "solr." + SolrInfoMBean.Group.jvm.toString();
    private final ConcurrentMap<String, MetricRegistry> registries = new ConcurrentHashMap<String, MetricRegistry>();
    private final Map<String, Map<String, SolrMetricReporter>> reporters = new HashMap<String, Map<String, SolrMetricReporter>>();
    private final Lock reportersLock = new ReentrantLock();
    private final Lock swapLock = new ReentrantLock();

    public Set<String> registryNames() {
        HashSet set = new HashSet();
        set.addAll(this.registries.keySet());
        set.addAll(SharedMetricRegistries.names());
        return Collections.unmodifiableSet(set);
    }

    private static boolean isSharedRegistry(String registry) {
        return SolrMetricManager.overridableRegistryName(JETTY_REGISTRY).equals(registry) || SolrMetricManager.overridableRegistryName(JVM_REGISTRY).equals(registry);
    }

    public MetricRegistry registry(String registry) {
        if (SolrMetricManager.isSharedRegistry(registry = SolrMetricManager.overridableRegistryName(registry))) {
            return SharedMetricRegistries.getOrCreate((String)registry);
        }
        this.swapLock.lock();
        try {
            MetricRegistry metricRegistry = SolrMetricManager.getOrCreate(this.registries, registry);
            return metricRegistry;
        }
        finally {
            this.swapLock.unlock();
        }
    }

    private static MetricRegistry getOrCreate(ConcurrentMap<String, MetricRegistry> map, String registry) {
        MetricRegistry existing = (MetricRegistry)map.get(registry);
        if (existing == null) {
            MetricRegistry created = new MetricRegistry();
            MetricRegistry raced = map.putIfAbsent(registry, created);
            if (raced == null) {
                return created;
            }
            return raced;
        }
        return existing;
    }

    public void removeRegistry(String registry) {
        this.closeReporters(registry);
        registry = SolrMetricManager.overridableRegistryName(registry);
        if (SolrMetricManager.isSharedRegistry(registry)) {
            SharedMetricRegistries.remove((String)registry);
        } else {
            this.swapLock.lock();
            try {
                this.registries.remove(registry);
            }
            finally {
                this.swapLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapRegistries(String registry1, String registry2) {
        registry1 = SolrMetricManager.overridableRegistryName(registry1);
        registry2 = SolrMetricManager.overridableRegistryName(registry2);
        if (SolrMetricManager.isSharedRegistry(registry1) || SolrMetricManager.isSharedRegistry(registry2)) {
            throw new UnsupportedOperationException("Cannot swap shared registry: " + registry1 + ", " + registry2);
        }
        this.swapLock.lock();
        try {
            MetricRegistry from = (MetricRegistry)this.registries.get(registry1);
            MetricRegistry to = (MetricRegistry)this.registries.get(registry2);
            if (from == to) {
                return;
            }
            MetricRegistry reg1 = (MetricRegistry)this.registries.remove(registry1);
            MetricRegistry reg2 = (MetricRegistry)this.registries.remove(registry2);
            if (reg2 != null) {
                this.registries.put(registry1, reg2);
            }
            if (reg1 != null) {
                this.registries.put(registry2, reg1);
            }
        }
        finally {
            this.swapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll(String registry, MetricSet metrics, boolean force, String ... metricPath) throws Exception {
        MetricRegistry metricRegistry;
        MetricRegistry metricRegistry2 = metricRegistry = this.registry(registry);
        synchronized (metricRegistry2) {
            Map existingMetrics = metricRegistry.getMetrics();
            for (Map.Entry entry : metrics.getMetrics().entrySet()) {
                String fullName = SolrMetricManager.mkName((String)entry.getKey(), metricPath);
                if (force && existingMetrics.containsKey(fullName)) {
                    metricRegistry.remove(fullName);
                }
                metricRegistry.register(fullName, (Metric)entry.getValue());
            }
        }
    }

    public void clearRegistry(String registry) {
        this.registry(registry).removeMatching(MetricFilter.ALL);
    }

    public Set<String> clearMetrics(String registry, String ... metricPath) {
        PrefixFilter filter;
        if (metricPath == null || metricPath.length == 0) {
            filter = new PrefixFilter("");
        } else {
            String prefix = MetricRegistry.name((String)"", (String[])metricPath);
            filter = new PrefixFilter(prefix);
        }
        this.registry(registry).removeMatching((MetricFilter)filter);
        return filter.getMatched();
    }

    public Meter meter(String registry, String metricName, String ... metricPath) {
        return this.registry(registry).meter(SolrMetricManager.mkName(metricName, metricPath));
    }

    public Timer timer(String registry, String metricName, String ... metricPath) {
        return this.registry(registry).timer(SolrMetricManager.mkName(metricName, metricPath));
    }

    public Counter counter(String registry, String metricName, String ... metricPath) {
        return this.registry(registry).counter(SolrMetricManager.mkName(metricName, metricPath));
    }

    public Histogram histogram(String registry, String metricName, String ... metricPath) {
        return this.registry(registry).histogram(SolrMetricManager.mkName(metricName, metricPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String registry, Metric metric, boolean force, String metricName, String ... metricPath) {
        MetricRegistry metricRegistry = this.registry(registry);
        String fullName = SolrMetricManager.mkName(metricName, metricPath);
        MetricRegistry metricRegistry2 = metricRegistry;
        synchronized (metricRegistry2) {
            if (force && metricRegistry.getMetrics().containsKey(fullName)) {
                metricRegistry.remove(fullName);
            }
            metricRegistry.register(fullName, metric);
        }
    }

    public static String mkName(String name, String ... path) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        if (path == null || path.length == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : path) {
            if (s == null || s.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(s);
        }
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(name);
        return sb.toString();
    }

    public static String overridableRegistryName(String registry) {
        String fqRegistry = SolrMetricManager.enforcePrefix(registry);
        return SolrMetricManager.enforcePrefix(System.getProperty(fqRegistry, fqRegistry));
    }

    public static String enforcePrefix(String name) {
        if (name.startsWith(REGISTRY_NAME_PREFIX)) {
            return name;
        }
        return REGISTRY_NAME_PREFIX + name;
    }

    public static String getRegistryName(SolrInfoMBean.Group group, String ... names) {
        String fullName;
        String prefix = REGISTRY_NAME_PREFIX + group.toString() + ".";
        if (names != null && names.length > 0 && names[0] != null && names[0].startsWith(prefix)) {
            if (names.length > 1) {
                String[] newNames = new String[names.length - 1];
                System.arraycopy(names, 1, newNames, 0, newNames.length);
                fullName = MetricRegistry.name((String)names[0], (String[])newNames);
            } else {
                fullName = MetricRegistry.name((String)names[0], (String[])new String[0]);
            }
        } else {
            fullName = MetricRegistry.name((String)group.toString(), (String[])names);
        }
        return SolrMetricManager.overridableRegistryName(fullName);
    }

    public void loadReporters(PluginInfo[] pluginInfos, SolrResourceLoader loader, SolrInfoMBean.Group group, String ... registryNames) {
        if (pluginInfos == null || pluginInfos.length == 0) {
            return;
        }
        String registryName = SolrMetricManager.getRegistryName(group, registryNames);
        for (PluginInfo info : pluginInfos) {
            boolean found;
            String[] targets;
            String target = info.attributes.get("group");
            if (target == null) {
                target = info.attributes.get("registry");
                if (target != null) {
                    targets = target.split("[\\s,]+");
                    found = false;
                    for (String t : targets) {
                        if (!registryName.equals(t = SolrMetricManager.overridableRegistryName(t))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        continue;
                    }
                }
            } else {
                targets = target.split("[\\s,]+");
                found = false;
                for (String t : targets) {
                    if (!group.toString().equals(t)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            try {
                this.loadReporter(registryName, loader, info);
            }
            catch (Exception e) {
                log.warn("Error loading metrics reporter, plugin info: " + info, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReporter(String registry, SolrResourceLoader loader, PluginInfo pluginInfo) throws Exception {
        if (registry == null || pluginInfo == null || pluginInfo.name == null || pluginInfo.className == null) {
            throw new IllegalArgumentException("loadReporter called with missing arguments: registry=" + registry + ", loader=" + loader + ", pluginInfo=" + pluginInfo);
        }
        registry = SolrMetricManager.overridableRegistryName(registry);
        SolrMetricReporter reporter = loader.newInstance(pluginInfo.className, SolrMetricReporter.class, new String[0], new Class[]{SolrMetricManager.class, String.class}, new Object[]{this, registry});
        try {
            reporter.init(pluginInfo);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("reporter init failed: " + pluginInfo, e);
        }
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                throw new Exception("Could not obtain lock to modify reporters registry: " + registry);
            }
        }
        catch (InterruptedException e) {
            throw new Exception("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
        }
        try {
            SolrMetricReporter oldReporter;
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry == null) {
                perRegistry = new HashMap<String, SolrMetricReporter>();
                this.reporters.put(registry, perRegistry);
            }
            if ((oldReporter = perRegistry.get(pluginInfo.name)) != null) {
                log.info("Replacing existing reporter '" + pluginInfo.name + "' in registry '" + registry + "': " + oldReporter.toString());
                oldReporter.close();
            }
            perRegistry.put(pluginInfo.name, reporter);
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeReporter(String registry, String name) {
        registry = SolrMetricManager.overridableRegistryName(registry);
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                log.warn("Could not obtain lock to modify reporters registry: " + registry);
                return false;
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
            return false;
        }
        try {
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry == null) {
                boolean bl = false;
                return bl;
            }
            SolrMetricReporter reporter = perRegistry.remove(name);
            if (reporter == null) {
                boolean bl = false;
                return bl;
            }
            try {
                reporter.close();
            }
            catch (Exception e) {
                log.warn("Error closing metric reporter, registry=" + registry + ", name=" + name, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> closeReporters(String registry) {
        registry = SolrMetricManager.overridableRegistryName(registry);
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                log.warn("Could not obtain lock to modify reporters registry: " + registry);
                return Collections.emptySet();
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
            return Collections.emptySet();
        }
        log.info("Closing metric reporters for: " + registry);
        try {
            Map<String, SolrMetricReporter> perRegistry = this.reporters.remove(registry);
            if (perRegistry != null) {
                for (SolrMetricReporter reporter : perRegistry.values()) {
                    try {
                        reporter.close();
                    }
                    catch (IOException ioe) {
                        log.warn("Exception closing reporter " + reporter, (Throwable)ioe);
                    }
                }
                Set<String> set = perRegistry.keySet();
                return set;
            }
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SolrMetricReporter> getReporters(String registry) {
        registry = SolrMetricManager.overridableRegistryName(registry);
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                log.warn("Could not obtain lock to modify reporters registry: " + registry);
                return Collections.emptyMap();
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
            return Collections.emptyMap();
        }
        try {
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry == null) {
                Map<String, SolrMetricReporter> map = Collections.emptyMap();
                return map;
            }
            Map<String, SolrMetricReporter> map = Collections.unmodifiableMap(new HashMap<String, SolrMetricReporter>(perRegistry));
            return map;
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    public static class PrefixFilter
    implements MetricFilter {
        private final String[] prefixes;
        private final Set<String> matched = new HashSet<String>();
        private boolean allMatch = false;

        public PrefixFilter(String ... prefixes) {
            Objects.requireNonNull(prefixes);
            this.prefixes = prefixes;
            if (prefixes.length == 0) {
                this.allMatch = true;
            }
        }

        public boolean matches(String name, Metric metric) {
            if (this.allMatch) {
                this.matched.add(name);
                return true;
            }
            for (String prefix : this.prefixes) {
                if (!name.startsWith(prefix)) continue;
                this.matched.add(name);
                return true;
            }
            return false;
        }

        public Set<String> getMatched() {
            return Collections.unmodifiableSet(this.matched);
        }

        public void reset() {
            this.matched.clear();
        }
    }
}

