/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatingSystemMetricSet
implements MetricSet {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String[] METRICS = new String[]{"AvailableProcessors", "CommittedVirtualMemorySize", "FreePhysicalMemorySize", "FreeSwapSpaceSize", "MaxFileDescriptorCount", "OpenFileDescriptorCount", "ProcessCpuLoad", "ProcessCpuTime", "SystemLoadAverage", "TotalPhysicalMemorySize", "TotalSwapSpaceSize"};
    private final MBeanServer mBeanServer;

    public OperatingSystemMetricSet(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        try {
            ObjectName on = new ObjectName("java.lang:type=OperatingSystem");
            MBeanInfo info = this.mBeanServer.getMBeanInfo(on);
            HashSet<String> attributes = new HashSet<String>();
            for (MBeanAttributeInfo ai : info.getAttributes()) {
                attributes.add(ai.getName());
            }
            for (String metric : METRICS) {
                if (!attributes.contains(metric)) continue;
                metrics.put(metric, (Metric)new JmxAttributeGauge((MBeanServerConnection)this.mBeanServer, on, metric));
            }
        }
        catch (JMException ignored) {
            log.debug("Unable to load OperatingSystem MBean", (Throwable)ignored);
        }
        return metrics;
    }
}

