/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.QParser;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTimeGetComponent
extends SearchComponent {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMPONENT_NAME = "get";
    public static SolrInputDocument DELETED = new SolrInputDocument(new String[0]);

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrReturnFields returnFields = new SolrReturnFields(rb.req);
        rb.rsp.setReturnFields(returnFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        String val = params.get("checkCanHandleVersionRanges");
        if (val != null) {
            rb.rsp.add("canHandleVersionRanges", true);
            return;
        }
        val = params.get("getFingerprint");
        if (val != null) {
            this.processGetFingeprint(rb);
            return;
        }
        val = params.get("getVersions");
        if (val != null) {
            this.processGetVersions(rb);
            return;
        }
        val = params.get("getUpdates");
        if (val != null) {
            if (log.isDebugEnabled()) {
                try {
                    RefCounted<SolrIndexSearcher> searchHolder = req.getCore().getNewestSearcher(false);
                    SolrIndexSearcher searcher = searchHolder.get();
                    try {
                        log.debug(req.getCore().getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " min count to sync to (from most recent searcher view) " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                    }
                    finally {
                        searchHolder.decref();
                    }
                }
                catch (Exception e) {
                    log.debug("Error in solrcloud_debug block", (Throwable)e);
                }
            }
            this.processGetUpdates(rb);
            return;
        }
        IdsRequsted reqIds = IdsRequsted.parseParams(req);
        if (reqIds.allIds.isEmpty()) {
            return;
        }
        try {
            String[] fqs = req.getParams().getParams("fq");
            if (fqs != null && fqs.length != 0) {
                List<Query> filters = rb.getFilters();
                filters = filters == null ? new ArrayList<Query>(fqs.length) : new ArrayList<Query>(filters);
                for (String fq : fqs) {
                    if (fq == null || fq.trim().length() == 0) continue;
                    QParser fqp = QParser.getParser(fq, req);
                    filters.add(fqp.getQuery());
                }
                if (!filters.isEmpty()) {
                    rb.setFilters(filters);
                }
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        SolrCore core = req.getCore();
        SchemaField idField = core.getLatestSchema().getUniqueKeyField();
        FieldType fieldType = idField.getType();
        SolrDocumentList docList = new SolrDocumentList();
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        RefCounted<SolrIndexSearcher> searcherHolder = null;
        RTGResultContext resultContext = null;
        DocTransformer transformer = rsp.getReturnFields().getTransformer();
        boolean mustUseRealtimeSearcher = rb.getFilters() != null || null != transformer && transformer.needsSolrIndexSearcher();
        try {
            SolrIndexSearcher searcher = null;
            BytesRefBuilder idBytes = new BytesRefBuilder();
            for (String idStr : reqIds.allIds) {
                Object o;
                fieldType.readableToIndexed(idStr, idBytes);
                if (ulog != null && (o = ulog.lookup(idBytes.get())) != null) {
                    List entry = (List)o;
                    assert (entry.size() >= 3);
                    int oper = (Integer)entry.get(0) & 0xF;
                    switch (oper) {
                        case 1: {
                            if (mustUseRealtimeSearcher) {
                                if (searcherHolder != null) {
                                    searcher = null;
                                    searcherHolder.decref();
                                    searcherHolder = null;
                                    resultContext = null;
                                }
                                ulog.openRealtimeSearcher();
                                o = null;
                                break;
                            }
                            SolrDocument doc = RealTimeGetComponent.toSolrDoc((SolrInputDocument)entry.get(entry.size() - 1), core.getLatestSchema());
                            if (transformer != null) {
                                transformer.transform(doc, -1, 0.0f);
                            }
                            docList.add((Object)doc);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                        }
                    }
                    if (o != null) continue;
                }
                if (searcher == null) {
                    searcherHolder = core.getRealtimeSearcher();
                    searcher = searcherHolder.get();
                }
                int docid = -1;
                long segAndId = searcher.lookupId(idBytes.get());
                if (segAndId >= 0L) {
                    int segid = (int)segAndId;
                    LeafReaderContext ctx = (LeafReaderContext)searcher.getTopReaderContext().leaves().get((int)(segAndId >> 32));
                    docid = segid + ctx.docBase;
                    if (rb.getFilters() != null) {
                        for (Query raw : rb.getFilters()) {
                            Query q = raw.rewrite((IndexReader)searcher.getIndexReader());
                            Scorer scorer = searcher.createWeight(q, false).scorer(ctx);
                            if (scorer != null && segid == scorer.iterator().advance(segid)) continue;
                            docid = -1;
                            break;
                        }
                    }
                }
                if (docid < 0) continue;
                Document luceneDocument = searcher.doc(docid, rsp.getReturnFields().getLuceneFieldNames());
                SolrDocument doc = RealTimeGetComponent.toSolrDoc(luceneDocument, core.getLatestSchema());
                searcher.decorateDocValueFields((SolrDocumentBase)doc, docid, searcher.getNonStoredDVs(true));
                if (null != transformer) {
                    if (null == resultContext) {
                        resultContext = new RTGResultContext(rsp.getReturnFields(), searcher, req);
                        transformer.setContext(resultContext);
                    }
                    transformer.transform(doc, docid, 0.0f);
                }
                docList.add((Object)doc);
            }
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
        }
        this.addDocListToResponse(rb, docList);
    }

    public static SolrInputDocument getInputDocumentFromTlog(SolrCore core, BytesRef idBytes) {
        Object o;
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog != null && (o = ulog.lookup(idBytes)) != null) {
            List entry = (List)o;
            assert (entry.size() >= 3);
            int oper = (Integer)entry.get(0) & 0xF;
            switch (oper) {
                case 1: {
                    return (SolrInputDocument)entry.get(entry.size() - 1);
                }
                case 2: {
                    return DELETED;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrInputDocument getInputDocument(SolrCore core, BytesRef idBytes) throws IOException {
        SolrInputDocument sid = null;
        RefCounted<SolrIndexSearcher> searcherHolder = null;
        try {
            SolrIndexSearcher searcher = null;
            sid = RealTimeGetComponent.getInputDocumentFromTlog(core, idBytes);
            if (sid == DELETED) {
                SolrInputDocument solrInputDocument = null;
                return solrInputDocument;
            }
            if (sid == null) {
                SchemaField idField;
                int docid;
                if (searcher == null) {
                    searcherHolder = core.getRealtimeSearcher();
                    searcher = searcherHolder.get();
                }
                if ((docid = searcher.getFirstMatch(new Term((idField = core.getLatestSchema().getUniqueKeyField()).getName(), idBytes))) < 0) {
                    SolrInputDocument solrInputDocument = null;
                    return solrInputDocument;
                }
                Document luceneDocument = searcher.doc(docid);
                sid = RealTimeGetComponent.toSolrInputDocument(luceneDocument, core.getLatestSchema());
                searcher.decorateDocValueFields((SolrDocumentBase)sid, docid, searcher.getNonStoredDVsWithoutCopyTargets());
            }
        }
        finally {
            if (searcherHolder != null) {
                searcherHolder.decref();
            }
        }
        return sid;
    }

    private static SolrInputDocument toSolrInputDocument(Document doc, IndexSchema schema) {
        SolrInputDocument out = new SolrInputDocument(new String[0]);
        for (IndexableField f : doc.getFields()) {
            String fname = f.name();
            SchemaField sf = schema.getFieldOrNull(f.name());
            Object val = null;
            if (sf != null) {
                if (!sf.hasDocValues() && !sf.stored() || schema.isCopyFieldTarget(sf)) continue;
                val = sf.getType().toObject(f);
            } else {
                val = f.stringValue();
                if (val == null) {
                    val = f.numericValue();
                }
                if (val == null) {
                    val = f.binaryValue();
                }
                if (val == null) {
                    val = f;
                }
            }
            out.addField(fname, val);
        }
        return out;
    }

    private static SolrDocument toSolrDoc(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc.getFields()) {
            Object existing = out.get((Object)f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && schema.isCopyFieldTarget(sf)) continue;
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), (Object)f);
                continue;
            }
            out.addField(f.name(), (Object)f);
        }
        return out;
    }

    private static SolrDocument toSolrDoc(SolrInputDocument sdoc, IndexSchema schema) {
        Document doc = DocumentBuilder.toDocument(sdoc, schema);
        Document out = new Document();
        for (IndexableField f : doc.getFields()) {
            if (f.fieldType().stored()) {
                out.add(f);
                continue;
            }
            if (f.fieldType().docValuesType() != DocValuesType.NONE) {
                SchemaField schemaField = schema.getFieldOrNull(f.name());
                if (schemaField == null || schemaField.stored() || !schemaField.useDocValuesAsStored()) continue;
                out.add(f);
                continue;
            }
            log.debug("Don't know how to handle field " + f);
        }
        return RealTimeGetComponent.toSolrDoc(out, schema);
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            return this.createSubRequests(rb);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public int createSubRequests(ResponseBuilder rb) throws IOException {
        IdsRequsted reqIds = IdsRequsted.parseParams(rb.req);
        if (reqIds.allIds.isEmpty()) {
            return ResponseBuilder.STAGE_DONE;
        }
        SolrParams params = rb.req.getParams();
        ZkController zkController = rb.req.getCore().getCoreDescriptor().getCoreContainer().getZkController();
        if (zkController != null && params.get("shards") == null) {
            CloudDescriptor cloudDescriptor = rb.req.getCore().getCoreDescriptor().getCloudDescriptor();
            String collection = cloudDescriptor.getCollectionName();
            ClusterState clusterState = zkController.getClusterState();
            DocCollection coll = clusterState.getCollection(collection);
            HashMap<String, ArrayList<String>> sliceToId = new HashMap<String, ArrayList<String>>();
            for (String string : reqIds.allIds) {
                Slice slice = coll.getRouter().getTargetSlice(string, null, null, params, coll);
                ArrayList<String> idsForShard = (ArrayList<String>)sliceToId.get(slice.getName());
                if (idsForShard == null) {
                    idsForShard = new ArrayList<String>(2);
                    sliceToId.put(slice.getName(), idsForShard);
                }
                idsForShard.add(string);
            }
            for (Map.Entry entry : sliceToId.entrySet()) {
                String shard = (String)entry.getKey();
                ShardRequest sreq = this.createShardRequest(rb, (List)entry.getValue());
                sreq.shards = this.sliceToShards(rb, collection, shard);
                sreq.actualShards = sreq.shards;
                rb.addRequest(this, sreq);
            }
        } else {
            ShardRequest sreq = this.createShardRequest(rb, reqIds.allIds);
            sreq.shards = null;
            sreq.actualShards = sreq.shards;
            rb.addRequest(this, sreq);
        }
        return ResponseBuilder.STAGE_DONE;
    }

    private ShardRequest createShardRequest(ResponseBuilder rb, List<String> ids) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.set("shards.qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.remove("shards");
        sreq.params.remove("id");
        sreq.params.remove("ids");
        sreq.params.set("ids", new String[]{StrUtils.join(ids, (char)',')});
        return sreq;
    }

    private String[] sliceToShards(ResponseBuilder rb, String collection, String slice) {
        String lookup = collection + '_' + slice;
        for (int i = 0; i < rb.slices.length; ++i) {
            log.info("LOOKUP_SLICE:" + rb.slices[i] + "=" + rb.shards[i]);
            if (!lookup.equals(rb.slices[i]) && !slice.equals(rb.slices[i])) continue;
            return new String[]{rb.shards[i]};
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find shard '" + lookup + "'");
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        this.mergeResponses(rb);
    }

    private void mergeResponses(ResponseBuilder rb) {
        SolrDocumentList docList = new SolrDocumentList();
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                SolrResponse sr = srsp.getSolrResponse();
                NamedList nl = sr.getResponse();
                SolrDocumentList subList = (SolrDocumentList)nl.get("response");
                docList.addAll((Collection)subList);
            }
        }
        this.addDocListToResponse(rb, docList);
    }

    private void addDocListToResponse(ResponseBuilder rb, SolrDocumentList docList) {
        assert (null != docList);
        SolrQueryResponse rsp = rb.rsp;
        IdsRequsted reqIds = IdsRequsted.parseParams(rb.req);
        if (reqIds.useSingleDocResponse) {
            assert (docList.size() <= 1);
            rsp.add("doc", docList.size() > 0 ? docList.get(0) : null);
        } else {
            docList.setNumFound((long)docList.size());
            rsp.addResponse(docList);
        }
    }

    @Override
    public String getDescription() {
        return "query";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERY;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    public void processGetFingeprint(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        long maxVersion = params.getLong("getFingerprint", Long.MAX_VALUE);
        IndexFingerprint fingerprint = IndexFingerprint.getFingerprint(req.getCore(), Math.abs(maxVersion));
        rb.rsp.add("fingerprint", fingerprint);
    }

    public void processGetVersions(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        int nVersions = params.getInt("getVersions", -1);
        if (nVersions == -1) {
            return;
        }
        boolean doFingerprint = params.getBool("fingerprint", false);
        String sync = params.get("sync");
        if (sync != null) {
            this.processSync(rb, nVersions, sync);
            return;
        }
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            return;
        }
        if (doFingerprint) {
            IndexFingerprint fingerprint = IndexFingerprint.getFingerprint(req.getCore(), Long.MAX_VALUE);
            rb.rsp.add("fingerprint", fingerprint);
        }
        try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
            List<Long> versions = recentUpdates.getVersions(nVersions);
            rb.rsp.add("versions", versions);
        }
    }

    public void processSync(ResponseBuilder rb, int nVersions, String sync) {
        boolean onlyIfActive = rb.req.getParams().getBool("onlyIfActive", false);
        if (onlyIfActive && rb.req.getCore().getCoreDescriptor().getCloudDescriptor().getLastPublished() != Replica.State.ACTIVE) {
            log.info("Last published state was not ACTIVE, cannot sync.");
            rb.rsp.add("sync", "false");
            return;
        }
        List replicas = StrUtils.splitSmart((String)sync, (String)",", (boolean)true);
        boolean cantReachIsSuccess = rb.req.getParams().getBool("cantReachIsSuccess", false);
        PeerSync peerSync = new PeerSync(rb.req.getCore(), replicas, nVersions, cantReachIsSuccess, true);
        boolean success = peerSync.sync().isSuccess();
        rb.rsp.add("sync", success);
    }

    public void processGetUpdates(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        String versionsStr = params.get("getUpdates");
        if (versionsStr == null) {
            return;
        }
        UpdateLog ulog = req.getCore().getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            return;
        }
        List<Long> versions = null;
        versions = versionsStr.indexOf("...") != -1 ? this.resolveVersionRanges(versionsStr, ulog) : StrUtils.splitSmart((String)versionsStr, (String)",", (boolean)true).stream().map(Long::parseLong).collect(Collectors.toList());
        boolean doFingerprint = params.getBool("fingerprint", false);
        if (doFingerprint) {
            long maxVersionForUpdate = Collections.min(versions, PeerSync.absComparator);
            IndexFingerprint fingerprint = IndexFingerprint.getFingerprint(req.getCore(), Math.abs(maxVersionForUpdate));
            rb.rsp.add("fingerprint", fingerprint);
        }
        ArrayList<Object> updates = new ArrayList<Object>(versions.size());
        long minVersion = Long.MAX_VALUE;
        try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
            for (Long version : versions) {
                try {
                    Object o = recentUpdates.lookup(version);
                    if (o == null) continue;
                    if (version > 0L) {
                        minVersion = Math.min(minVersion, version);
                    }
                    updates.add(o);
                }
                catch (ClassCastException | SolrException e) {
                    log.warn("Exception reading log for updates", e);
                }
            }
            updates.addAll(recentUpdates.getDeleteByQuery(minVersion));
            rb.rsp.add("updates", updates);
        }
    }

    private List<Long> resolveVersionRanges(String versionsStr, UpdateLog ulog) {
        if (StringUtils.isEmpty((String)versionsStr)) {
            return Collections.emptyList();
        }
        List ranges = StrUtils.splitSmart((String)versionsStr, (String)",", (boolean)true);
        List<Long> versionAvailable = null;
        UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();
        Object object = null;
        try {
            versionAvailable = recentUpdates.getVersions(ulog.getNumRecordsToKeep());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (recentUpdates != null) {
                if (object != null) {
                    try {
                        recentUpdates.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    recentUpdates.close();
                }
            }
        }
        Collections.sort(versionAvailable, PeerSync.absComparator);
        HashSet<Long> versionsToRet = new HashSet<Long>(ulog.getNumRecordsToKeep());
        for (String range : ranges) {
            String[] rangeBounds = range.split("\\.{3}");
            int indexStart = Collections.binarySearch(versionAvailable, Long.valueOf(rangeBounds[1]), PeerSync.absComparator);
            int indexEnd = Collections.binarySearch(versionAvailable, Long.valueOf(rangeBounds[0]), PeerSync.absComparator);
            if (indexStart < 0 || indexEnd < 0) continue;
            versionsToRet.addAll(versionAvailable.subList(indexStart, indexEnd + 1));
        }
        return new ArrayList<Long>(versionsToRet);
    }

    private static final class RTGResultContext
    extends ResultContext {
        final ReturnFields returnFields;
        final SolrIndexSearcher searcher;
        final SolrQueryRequest req;

        public RTGResultContext(ReturnFields returnFields, SolrIndexSearcher searcher, SolrQueryRequest req) {
            this.returnFields = returnFields;
            this.searcher = searcher;
            this.req = req;
        }

        @Override
        public DocList getDocList() {
            return null;
        }

        @Override
        public ReturnFields getReturnFields() {
            return this.returnFields;
        }

        @Override
        public SolrIndexSearcher getSearcher() {
            return this.searcher;
        }

        @Override
        public Query getQuery() {
            return null;
        }

        @Override
        public SolrQueryRequest getRequest() {
            return this.req;
        }

        @Override
        public Iterator<SolrDocument> getProcessedDocuments() {
            return null;
        }
    }

    private static final class IdsRequsted {
        public final List<String> allIds;
        public final boolean useSingleDocResponse;

        private IdsRequsted(List<String> allIds, boolean useSingleDocResponse) {
            assert (null != allIds);
            this.allIds = allIds;
            this.useSingleDocResponse = useSingleDocResponse;
        }

        public static IdsRequsted parseParams(SolrQueryRequest req) {
            String contextKey = IdsRequsted.class.toString() + "_PARSED_ID_PARAMS";
            if (req.getContext().containsKey(contextKey)) {
                return (IdsRequsted)req.getContext().get(contextKey);
            }
            SolrParams params = req.getParams();
            String[] id = params.getParams("id");
            String[] ids = params.getParams("ids");
            if (id == null && ids == null) {
                IdsRequsted result = new IdsRequsted(Collections.emptyList(), true);
                req.getContext().put(contextKey, result);
                return result;
            }
            ArrayList<String> allIds = new ArrayList<String>((null == id ? 0 : id.length) + (null == ids ? 0 : 2 * ids.length));
            if (null != id) {
                for (String singleId : id) {
                    allIds.add(singleId);
                }
            }
            if (null != ids) {
                for (String idList : ids) {
                    allIds.addAll(StrUtils.splitSmart((String)idList, (String)",", (boolean)true));
                }
            }
            IdsRequsted result = new IdsRequsted(allIds, ids == null && allIds.size() <= 1);
            req.getContext().put(contextKey, result);
            return result;
        }
    }
}

