/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.schema.DateRangeField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeFacetRequest
extends FacetComponent.FacetBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SchemaField schemaField;
    protected final String start;
    protected final String end;
    protected final String gap;
    protected final boolean hardEnd;
    protected final EnumSet<FacetParams.FacetRangeInclude> include;
    protected final EnumSet<FacetParams.FacetRangeOther> others;
    protected final FacetParams.FacetRangeMethod method;
    protected final int minCount;
    protected final boolean groupFacet;
    protected final List<FacetRange> facetRanges;
    protected final Object startObj;
    protected final Object endObj;
    protected final Object gapObj;

    public RangeFacetRequest(ResponseBuilder rb, String f) {
        super(rb, "facet.range", f);
        FacetParams.FacetRangeMethod method;
        IndexSchema schema = rb.req.getSchema();
        this.schemaField = schema.getField(this.facetOn);
        SolrParams params = SolrParams.wrapDefaults((SolrParams)this.localParams, (SolrParams)rb.req.getParams());
        RequiredSolrParams required = new RequiredSolrParams(params);
        String methodStr = params.get("facet.range.method");
        FacetParams.FacetRangeMethod facetRangeMethod = method = methodStr == null ? FacetParams.FacetRangeMethod.getDefault() : FacetParams.FacetRangeMethod.get((String)methodStr);
        if (this.schemaField.getType() instanceof DateRangeField && method.equals((Object)FacetParams.FacetRangeMethod.DV)) {
            log.warn("Range facet method '" + FacetParams.FacetRangeMethod.DV + "' is not supported together with field type '" + DateRangeField.class + "'. Will use method '" + FacetParams.FacetRangeMethod.FILTER + "' instead");
            method = FacetParams.FacetRangeMethod.FILTER;
        }
        this.start = required.getFieldParam(this.facetOn, "facet.range.start");
        this.end = required.getFieldParam(this.facetOn, "facet.range.end");
        this.gap = required.getFieldParam(this.facetOn, "facet.range.gap");
        this.minCount = params.getFieldInt(this.facetOn, "facet.mincount", 0);
        this.include = FacetParams.FacetRangeInclude.parseParam((String[])params.getFieldParams(this.facetOn, "facet.range.include"));
        this.hardEnd = params.getFieldBool(this.facetOn, "facet.range.hardend", false);
        this.others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
        String[] othersP = params.getFieldParams(this.facetOn, "facet.range.other");
        if (othersP != null && othersP.length > 0) {
            for (String o : othersP) {
                this.others.add(FacetParams.FacetRangeOther.get((String)o));
            }
        }
        this.groupFacet = params.getBool("group.facet", false);
        if (this.groupFacet && method.equals((Object)FacetParams.FacetRangeMethod.DV)) {
            log.warn("Range facet method '" + FacetParams.FacetRangeMethod.DV + "' is not supported together with '" + "group.facet" + "'. Will use method '" + FacetParams.FacetRangeMethod.FILTER + "' instead");
            method = FacetParams.FacetRangeMethod.FILTER;
        }
        this.method = method;
        RangeEndpointCalculator<Comparable<?>> calculator = this.createCalculator();
        this.facetRanges = calculator.computeRanges();
        this.gapObj = calculator.getGap();
        this.startObj = calculator.getStart();
        this.endObj = calculator.getComputedEnd();
    }

    private RangeEndpointCalculator<? extends Comparable<?>> createCalculator() {
        RangeEndpointCalculator calc;
        FieldType ft = this.schemaField.getType();
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    calc = new FloatRangeEndpointCalculator(this);
                    break;
                }
                case DOUBLE: {
                    calc = new DoubleRangeEndpointCalculator(this);
                    break;
                }
                case INTEGER: {
                    calc = new IntegerRangeEndpointCalculator(this);
                    break;
                }
                case LONG: {
                    calc = new LongRangeEndpointCalculator(this);
                    break;
                }
                case DATE: {
                    calc = new DateRangeEndpointCalculator(this, null);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on tried field of unexpected type:" + this.facetOn);
                }
            }
        } else if (ft instanceof DateRangeField) {
            calc = new DateRangeEndpointCalculator(this, null);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + this.schemaField);
        }
        return calc;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public EnumSet<FacetParams.FacetRangeInclude> getInclude() {
        return this.include;
    }

    public String getGap() {
        return this.gap;
    }

    public Object getGapObj() {
        return this.gapObj;
    }

    public boolean isHardEnd() {
        return this.hardEnd;
    }

    public EnumSet<FacetParams.FacetRangeOther> getOthers() {
        return this.others;
    }

    public FacetParams.FacetRangeMethod getMethod() {
        return this.method;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public SchemaField getSchemaField() {
        return this.schemaField;
    }

    public boolean isGroupFacet() {
        return this.groupFacet;
    }

    public List<FacetRange> getFacetRanges() {
        return this.facetRanges;
    }

    public Object getStartObj() {
        return this.startObj;
    }

    public Object getEndObj() {
        return this.endObj;
    }

    public static class FacetRange {
        public final FacetParams.FacetRangeOther other;
        public final String name;
        public final String lower;
        public final String upper;
        public final boolean includeLower;
        public final boolean includeUpper;

        private FacetRange(FacetParams.FacetRangeOther other, String name, String lower, String upper, boolean includeLower, boolean includeUpper) {
            this.other = other;
            this.name = name;
            this.lower = lower;
            this.upper = upper;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
        }

        public FacetRange(FacetParams.FacetRangeOther other, String lower, String upper, boolean includeLower, boolean includeUpper) {
            this(other, other.toString(), lower, upper, includeLower, includeUpper);
        }

        public FacetRange(String name, String lower, String upper, boolean includeLower, boolean includeUpper) {
            this(null, name, lower, upper, includeLower, includeUpper);
        }
    }

    private static class DateRangeEndpointCalculator
    extends RangeEndpointCalculator<Date> {
        private static final String TYPE_ERR_MSG = "SchemaField must use field type extending TrieDateField or DateRangeField";
        private final Date now;

        public DateRangeEndpointCalculator(RangeFacetRequest rangeFacetRequest, Date now) {
            super(rangeFacetRequest);
            this.now = now;
            if (!(this.field.getType() instanceof TrieDateField) && !(this.field.getType() instanceof DateRangeField)) {
                throw new IllegalArgumentException(TYPE_ERR_MSG);
            }
        }

        @Override
        public String formatValue(Date val) {
            return val.toInstant().toString();
        }

        @Override
        protected Date parseVal(String rawval) {
            return DateMathParser.parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    private static class LongRangeEndpointCalculator
    extends RangeEndpointCalculator<Long> {
        public LongRangeEndpointCalculator(RangeFacetRequest rangeFacetRequest) {
            super(rangeFacetRequest);
        }

        @Override
        protected Long parseVal(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Long value, String gap) {
            return new Long(value + Long.valueOf(gap));
        }
    }

    private static class IntegerRangeEndpointCalculator
    extends RangeEndpointCalculator<Integer> {
        public IntegerRangeEndpointCalculator(RangeFacetRequest rangeFacetRequest) {
            super(rangeFacetRequest);
        }

        @Override
        protected Integer parseVal(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Integer value, String gap) {
            return new Integer(value + Integer.valueOf(gap));
        }
    }

    private static class DoubleRangeEndpointCalculator
    extends RangeEndpointCalculator<Double> {
        public DoubleRangeEndpointCalculator(RangeFacetRequest rangeFacetRequest) {
            super(rangeFacetRequest);
        }

        @Override
        protected Double parseVal(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Double value, String gap) {
            return new Double(value + Double.valueOf(gap));
        }
    }

    private static class FloatRangeEndpointCalculator
    extends RangeEndpointCalculator<Float> {
        public FloatRangeEndpointCalculator(RangeFacetRequest rangeFacetRequest) {
            super(rangeFacetRequest);
        }

        @Override
        protected Float parseVal(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Float value, String gap) {
            return new Float(value.floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    private static abstract class RangeEndpointCalculator<T extends Comparable<T>> {
        protected final RangeFacetRequest rfr;
        protected final SchemaField field;
        protected T computedEnd;
        protected T start;
        protected Object gap;
        protected boolean computed = false;

        public RangeEndpointCalculator(RangeFacetRequest rfr) {
            this.rfr = rfr;
            this.field = rfr.getSchemaField();
        }

        public T getComputedEnd() {
            assert (this.computed);
            return this.computedEnd;
        }

        public T getStart() {
            assert (this.computed);
            return this.start;
        }

        public Object getGap() {
            assert (this.computed);
            return this.gap;
        }

        public String formatValue(T val) {
            return val.toString();
        }

        public final T getValue(String rawval) {
            try {
                return this.parseVal(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseVal(String var1) throws ParseException;

        protected final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected Object parseGap(String rawval) throws ParseException {
            return this.parseVal(rawval);
        }

        public final T addGap(T value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseAndAddGap(T var1, String var2) throws ParseException;

        public List<FacetRange> computeRanges() {
            ArrayList<FacetRange> ranges = new ArrayList<FacetRange>();
            this.gap = this.getGap(this.rfr.getGap());
            this.start = this.getValue(this.rfr.getStart());
            T end = this.getValue(this.rfr.getEnd());
            if (end.compareTo(this.start) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + this.start);
            }
            EnumSet<FacetParams.FacetRangeInclude> include = this.rfr.getInclude();
            T low = this.start;
            while (low.compareTo(end) < 0) {
                T high = this.addGap(low, this.rfr.getGap());
                if (end.compareTo(high) < 0) {
                    if (this.rfr.isHardEnd()) {
                        high = end;
                    } else {
                        end = high;
                    }
                }
                if (high.compareTo(low) < 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
                }
                if (high.compareTo(low) == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + this.rfr.getGap() + " = " + high);
                }
                boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(this.start);
                boolean includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
                String lowS = this.formatValue(low);
                String highS = this.formatValue(high);
                ranges.add(new FacetRange(lowS, lowS, highS, includeLower, includeUpper));
                low = high;
            }
            this.computedEnd = end;
            this.computed = true;
            if (!this.rfr.getOthers().contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = this.rfr.getOthers().contains(FacetParams.FacetRangeOther.ALL);
                String startS = this.formatValue(this.start);
                String endS = this.formatValue(end);
                if (all || this.rfr.getOthers().contains(FacetParams.FacetRangeOther.BEFORE)) {
                    ranges.add(new FacetRange(FacetParams.FacetRangeOther.BEFORE, null, startS, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || include.contains(FacetParams.FacetRangeInclude.ALL) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || this.rfr.getOthers().contains(FacetParams.FacetRangeOther.AFTER)) {
                    ranges.add(new FacetRange(FacetParams.FacetRangeOther.AFTER, endS, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || include.contains(FacetParams.FacetRangeInclude.ALL) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || this.rfr.getOthers().contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    ranges.add(new FacetRange(FacetParams.FacetRangeOther.BETWEEN, startS, endS, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) || include.contains(FacetParams.FacetRangeInclude.ALL), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) || include.contains(FacetParams.FacetRangeInclude.ALL)));
                }
            }
            return ranges;
        }
    }

    static class DistribRangeFacet {
        public SimpleOrderedMap<Object> rangeFacet;

        public DistribRangeFacet(SimpleOrderedMap<Object> rangeFacet) {
            this.rangeFacet = rangeFacet;
        }

        public static void mergeFacetRangesFromShardResponse(LinkedHashMap<String, DistribRangeFacet> rangeCounts, SimpleOrderedMap<SimpleOrderedMap<Object>> shardRanges) {
            assert (shardRanges != null);
            assert (rangeCounts != null);
            for (Map.Entry entry : shardRanges) {
                String rangeKey = (String)entry.getKey();
                DistribRangeFacet existing = rangeCounts.get(rangeKey);
                if (existing == null) {
                    rangeCounts.put(rangeKey, new DistribRangeFacet((SimpleOrderedMap<Object>)((SimpleOrderedMap)entry.getValue())));
                    continue;
                }
                existing.mergeContributionFromShard((SimpleOrderedMap<Object>)((SimpleOrderedMap)entry.getValue()));
            }
        }

        public void mergeContributionFromShard(SimpleOrderedMap<Object> rangeFromShard) {
            if (this.rangeFacet == null) {
                this.rangeFacet = rangeFromShard;
                return;
            }
            NamedList shardFieldValues = (NamedList)rangeFromShard.get("counts");
            NamedList existFieldValues = (NamedList)this.rangeFacet.get("counts");
            for (Map.Entry existPair : existFieldValues) {
                String key = (String)existPair.getKey();
                Integer newValue = (Integer)shardFieldValues.get(key);
                if (null == newValue) continue;
                Integer oldValue = (Integer)existPair.getValue();
                existPair.setValue(oldValue + newValue);
            }
            for (FacetParams.FacetRangeOther otherKey : FacetParams.FacetRangeOther.values()) {
                String name;
                Integer shardValue;
                if (otherKey == FacetParams.FacetRangeOther.NONE || (shardValue = (Integer)rangeFromShard.get(name = otherKey.toString())) == null || shardValue <= 0) continue;
                Integer existingValue = (Integer)this.rangeFacet.get(name);
                int idx = this.rangeFacet.indexOf(name, 0);
                this.rangeFacet.setVal(idx, (Object)(existingValue + shardValue));
            }
        }

        public void removeRangeFacetsUnderLimits(int minCount) {
            boolean replace = false;
            NamedList vals = (NamedList)this.rangeFacet.get("counts");
            NamedList newList = new NamedList();
            for (Map.Entry pair : vals) {
                if (((Number)pair.getValue()).longValue() >= (long)minCount) {
                    newList.add((String)pair.getKey(), pair.getValue());
                    continue;
                }
                replace = true;
            }
            if (replace) {
                vals.clear();
                vals.addAll(newList);
            }
        }
    }
}

