/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardFieldSortedHitQueue;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.CursorMark;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.QueryResult;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SortSpecParsing;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.grouping.CommandHandler;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.distributed.ShardRequestFactory;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.QueryCommand;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.command.TopGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.requestfactory.SearchGroupsRequestFactory;
import org.apache.solr.search.grouping.distributed.requestfactory.StoredFieldsShardRequestFactory;
import org.apache.solr.search.grouping.distributed.requestfactory.TopGroupsShardRequestFactory;
import org.apache.solr.search.grouping.distributed.responseprocessor.SearchGroupShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.responseprocessor.StoredFieldsShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.responseprocessor.TopGroupsShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;
import org.apache.solr.search.grouping.distributed.shardresultserializer.TopGroupsResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.GroupedEndResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.MainEndResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.SimpleEndResultTransformer;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "query";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final EndResultTransformer MAIN_END_RESULT_TRANSFORMER = new MainEndResultTransformer();
    protected static final EndResultTransformer SIMPLE_END_RESULT_TRANSFORMER = new SimpleEndResultTransformer();

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        SolrQueryResponse rsp = rb.rsp;
        SolrReturnFields returnFields = new SolrReturnFields(req);
        rsp.setReturnFields(returnFields);
        int flags = 0;
        if (((ReturnFields)returnFields).wantsScore()) {
            flags |= 1;
        }
        rb.setFieldFlags(flags);
        String defType = params.get("defType", "lucene");
        String queryString = rb.getQueryString();
        if (queryString == null) {
            queryString = params.get("q");
            rb.setQueryString(queryString);
        }
        try {
            String[] fqs;
            QParser parser = QParser.getParser(rb.getQueryString(), defType, req);
            Query q = parser.getQuery();
            if (q == null) {
                q = new MatchNoDocsQuery();
            }
            rb.setQuery(q);
            String rankQueryString = rb.req.getParams().get("rq");
            if (rankQueryString != null) {
                QParser rqparser = QParser.getParser(rankQueryString, defType, req);
                Query rq = rqparser.getQuery();
                if (rq instanceof RankQuery) {
                    RankQuery rankQuery = (RankQuery)rq;
                    rb.setRankQuery(rankQuery);
                    MergeStrategy mergeStrategy = rankQuery.getMergeStrategy();
                    if (mergeStrategy != null) {
                        rb.addMergeStrategy(mergeStrategy);
                        if (mergeStrategy.handlesMergeFields()) {
                            rb.mergeFieldHandler = mergeStrategy;
                        }
                    }
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "rq parameter must be a RankQuery");
                }
            }
            rb.setSortSpec(parser.getSortSpec(true));
            rb.setQparser(parser);
            String cursorStr = rb.req.getParams().get("cursorMark");
            if (null != cursorStr) {
                CursorMark cursorMark = new CursorMark(rb.req.getSchema(), rb.getSortSpec());
                cursorMark.parseSerializedTotem(cursorStr);
                rb.setCursorMark(cursorMark);
            }
            if ((fqs = req.getParams().getParams("fq")) != null && fqs.length != 0) {
                List<Query> filters = rb.getFilters();
                filters = filters == null ? new ArrayList<Query>(fqs.length) : new ArrayList<Query>(filters);
                for (String fq : fqs) {
                    if (fq == null || fq.trim().length() == 0) continue;
                    QParser fqp = QParser.getParser(fq, req);
                    fqp.setIsFilter(true);
                    filters.add(fqp.getQuery());
                }
                if (!filters.isEmpty()) {
                    rb.setFilters(filters);
                }
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        if (params.getBool("group", false)) {
            this.prepareGrouping(rb);
        } else if (rb.getSortSpec().getCount() < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'rows' parameter cannot be negative");
        }
        if (rb.getSortSpec().getOffset() < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'start' parameter cannot be negative");
        }
    }

    protected void prepareGrouping(ResponseBuilder rb) throws IOException {
        Grouping.Format responseFormat;
        SortSpec withinGroupSortSpec;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (null != rb.getCursorMark()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not use Grouping with cursorMark");
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        GroupingSpecification groupingSpec = new GroupingSpecification();
        rb.setGroupingSpec(groupingSpec);
        SortSpec sortSpec = rb.getSortSpec();
        SortSpec groupSortSpec = searcher.weightSortSpec(sortSpec, Sort.RELEVANCE);
        String withinGroupSortStr = params.get("group.sort");
        if (withinGroupSortStr != null) {
            SortSpec parsedWithinGroupSortSpec = SortSpecParsing.parseSortSpec(withinGroupSortStr, req);
            withinGroupSortSpec = searcher.weightSortSpec(parsedWithinGroupSortSpec, Sort.RELEVANCE);
        } else {
            withinGroupSortSpec = new SortSpec(groupSortSpec.getSort(), groupSortSpec.getSchemaFields(), groupSortSpec.getCount(), groupSortSpec.getOffset());
        }
        withinGroupSortSpec.setOffset(params.getInt("group.offset", 0));
        withinGroupSortSpec.setCount(params.getInt("group.limit", 1));
        groupingSpec.setWithinGroupSortSpec(withinGroupSortSpec);
        groupingSpec.setGroupSortSpec(groupSortSpec);
        String formatStr = params.get("group.format", Grouping.Format.grouped.name());
        try {
            responseFormat = Grouping.Format.valueOf(formatStr);
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Illegal %s parameter", "group.format"));
        }
        groupingSpec.setResponseFormat(responseFormat);
        groupingSpec.setFields(params.getParams("group.field"));
        groupingSpec.setQueries(params.getParams("group.query"));
        groupingSpec.setFunctions(params.getParams("group.func"));
        groupingSpec.setIncludeGroupCount(params.getBool("group.ngroups", false));
        groupingSpec.setMain(params.getBool("group.main", false));
        groupingSpec.setNeedScore((rb.getFieldFlags() & 1) != 0);
        groupingSpec.setTruncateGroups(params.getBool("group.truncate", false));
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        GroupingSpecification groupingSpec;
        LOG.debug("process: {}", (Object)rb.req.getParams());
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        StatsCache statsCache = req.getCore().getStatsCache();
        int purpose = params.getInt("shards.purpose", 4);
        if ((purpose & 0x8000) != 0) {
            statsCache.returnLocalStats(rb, searcher);
            return;
        }
        if ((purpose & 0x4000) != 0) {
            statsCache.receiveGlobalStats(req);
        }
        SolrQueryResponse rsp = rb.rsp;
        IndexSchema schema = searcher.getSchema();
        String ids = params.get("ids");
        if (ids != null) {
            SchemaField idField = schema.getUniqueKeyField();
            List idArr = StrUtils.splitSmart((String)ids, (String)",", (boolean)true);
            int[] luceneIds = new int[idArr.size()];
            int docs = 0;
            for (int i = 0; i < idArr.size(); ++i) {
                int id = searcher.getFirstMatch(new Term(idField.getName(), idField.getType().toInternal((String)idArr.get(i))));
                if (id < 0) continue;
                luceneIds[docs++] = id;
            }
            DocListAndSet res = new DocListAndSet();
            res.docList = new DocSlice(0, docs, luceneIds, null, docs, 0.0f);
            if (rb.isNeedDocSet()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(rb.getQuery());
                List<Query> filters = rb.getFilters();
                if (filters != null) {
                    queries.addAll(filters);
                }
                res.docSet = searcher.getDocSet(queries);
            }
            rb.setResults(res);
            BasicResultContext ctx = new BasicResultContext(rb);
            rsp.addResponse(ctx);
            return;
        }
        long timeAllowed = params.getLong("timeAllowed", -1L);
        if (null != rb.getCursorMark() && 0L < timeAllowed) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not search using both cursorMark and timeAllowed");
        }
        QueryCommand cmd = rb.getQueryCommand();
        cmd.setTimeAllowed(timeAllowed);
        req.getContext().put("org.apache.solr.stats_source", statsCache.get(req));
        QueryResult result = new QueryResult();
        cmd.setSegmentTerminateEarly(params.getBool("segmentTerminateEarly", false));
        if (cmd.getSegmentTerminateEarly()) {
            result.setSegmentTerminatedEarly(Boolean.FALSE);
        }
        if ((groupingSpec = rb.getGroupingSpec()) != null) {
            cmd.setSegmentTerminateEarly(false);
            try {
                boolean needScores;
                boolean bl = needScores = (cmd.getFlags() & 1) != 0;
                if (params.getBool("group.distributed.first", false)) {
                    CommandHandler.Builder topsGroupsActionBuilder = new CommandHandler.Builder().setQueryCommand(cmd).setNeedDocSet(false).setIncludeHitCount(true).setSearcher(searcher);
                    for (String field : groupingSpec.getFields()) {
                        topsGroupsActionBuilder.addCommandField(new SearchGroupsFieldCommand.Builder().setField(schema.getField(field)).setGroupSort(groupingSpec.getGroupSort()).setTopNGroups(cmd.getOffset() + cmd.getLen()).setIncludeGroupCount(groupingSpec.isIncludeGroupCount()).build());
                    }
                    CommandHandler commandHandler = topsGroupsActionBuilder.build();
                    commandHandler.execute();
                    SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(searcher);
                    rsp.add("firstPhase", commandHandler.processResult(result, serializer));
                    rsp.add("totalHitCount", commandHandler.getTotalHitCount());
                    rb.setResult(result);
                    return;
                }
                if (params.getBool("group.distributed.second", false)) {
                    CommandHandler.Builder secondPhaseBuilder = new CommandHandler.Builder().setQueryCommand(cmd).setTruncateGroups(groupingSpec.isTruncateGroups() && groupingSpec.getFields().length > 0).setSearcher(searcher);
                    int docsToCollect = Grouping.getMax(groupingSpec.getWithinGroupOffset(), groupingSpec.getWithinGroupLimit(), searcher.maxDoc());
                    docsToCollect = Math.max(docsToCollect, 1);
                    for (String field : groupingSpec.getFields()) {
                        SchemaField schemaField = schema.getField(field);
                        String[] topGroupsParam = params.getParams("group.topgroups." + field);
                        if (topGroupsParam == null) {
                            topGroupsParam = new String[]{};
                        }
                        ArrayList<SearchGroup<BytesRef>> topGroups = new ArrayList<SearchGroup<BytesRef>>(topGroupsParam.length);
                        for (String topGroup : topGroupsParam) {
                            SearchGroup searchGroup = new SearchGroup();
                            if (!topGroup.equals("\u0001")) {
                                searchGroup.groupValue = new BytesRef((CharSequence)schemaField.getType().readableToIndexed(topGroup));
                            }
                            topGroups.add((SearchGroup<BytesRef>)searchGroup);
                        }
                        secondPhaseBuilder.addCommandField(new TopGroupsFieldCommand.Builder().setField(schemaField).setGroupSort(groupingSpec.getGroupSort()).setSortWithinGroup(groupingSpec.getSortWithinGroup()).setFirstPhaseGroups(topGroups).setMaxDocPerGroup(docsToCollect).setNeedScores(needScores).setNeedMaxScore(needScores).build());
                    }
                    for (String query : groupingSpec.getQueries()) {
                        secondPhaseBuilder.addCommandField(new QueryCommand.Builder().setDocsToCollect(docsToCollect).setSort(groupingSpec.getGroupSort()).setQuery(query, rb.req).setDocSet(searcher).build());
                    }
                    CommandHandler commandHandler = secondPhaseBuilder.build();
                    commandHandler.execute();
                    TopGroupsResultTransformer serializer = new TopGroupsResultTransformer(rb);
                    rsp.add("secondPhase", commandHandler.processResult(result, serializer));
                    rb.setResult(result);
                    return;
                }
                int maxDocsPercentageToCache = params.getInt("group.cache.percent", 0);
                boolean cacheSecondPassSearch = maxDocsPercentageToCache >= 1 && maxDocsPercentageToCache <= 100;
                Grouping.TotalCount defaultTotalCount = groupingSpec.isIncludeGroupCount() ? Grouping.TotalCount.grouped : Grouping.TotalCount.ungrouped;
                int limitDefault = cmd.getLen();
                Grouping grouping = new Grouping(searcher, result, cmd, cacheSecondPassSearch, maxDocsPercentageToCache, groupingSpec.isMain());
                grouping.setGroupSort(groupingSpec.getGroupSort()).setWithinGroupSort(groupingSpec.getSortWithinGroup()).setDefaultFormat(groupingSpec.getResponseFormat()).setLimitDefault(limitDefault).setDefaultTotalCount(defaultTotalCount).setDocsPerGroupDefault(groupingSpec.getWithinGroupLimit()).setGroupOffsetDefault(groupingSpec.getWithinGroupOffset()).setGetGroupedDocSet(groupingSpec.isTruncateGroups());
                if (groupingSpec.getFields() != null) {
                    for (String field : groupingSpec.getFields()) {
                        grouping.addFieldCommand(field, rb.req);
                    }
                }
                if (groupingSpec.getFunctions() != null) {
                    for (String groupByStr : groupingSpec.getFunctions()) {
                        grouping.addFunctionCommand(groupByStr, rb.req);
                    }
                }
                if (groupingSpec.getQueries() != null) {
                    for (String groupByStr : groupingSpec.getQueries()) {
                        grouping.addQueryCommand(groupByStr, rb.req);
                    }
                }
                if (rb.isNeedDocList() || rb.isDebug()) {
                    cmd.setFlags(2);
                }
                grouping.execute();
                if (grouping.isSignalCacheWarning()) {
                    rsp.add("cacheWarning", String.format(Locale.ROOT, "Cache limit of %d percent relative to maxdoc has exceeded. Please increase cache size or disable caching.", maxDocsPercentageToCache));
                }
                rb.setResult(result);
                if (grouping.mainResult != null) {
                    BasicResultContext ctx = new BasicResultContext(rb, grouping.mainResult);
                    rsp.addResponse(ctx);
                    rsp.getToLog().add("hits", (Object)grouping.mainResult.matches());
                } else if (!grouping.getCommands().isEmpty()) {
                    rsp.add("grouped", result.groupedResults);
                    rsp.getToLog().add("hits", (Object)grouping.getCommands().get(0).getMatches());
                }
                return;
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
        searcher.search(result, cmd);
        rb.setResult(result);
        BasicResultContext ctx = new BasicResultContext(rb);
        rsp.addResponse(ctx);
        rsp.getToLog().add("hits", (Object)rb.getResults().docList.matches());
        if (!rb.req.getParams().getBool("isShard", false) && null != rb.getNextCursorMark()) {
            rb.rsp.add("nextCursorMark", rb.getNextCursorMark().getSerializedTotem());
        }
        if (rb.mergeFieldHandler != null) {
            rb.mergeFieldHandler.handleMergeFields(rb, searcher);
        } else {
            this.doFieldSortValues(rb, searcher);
        }
        this.doPrefetch(rb);
    }

    protected void doFieldSortValues(ResponseBuilder rb, SolrIndexSearcher searcher) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        boolean fsv = req.getParams().getBool("fsv", false);
        if (fsv) {
            SortField[] sortFieldArray;
            NamedList sortVals = new NamedList();
            IndexReaderContext topReaderContext = searcher.getTopReaderContext();
            List leaves = topReaderContext.leaves();
            LeafReaderContext currentLeaf = null;
            if (leaves.size() == 1) {
                currentLeaf = (LeafReaderContext)leaves.get(0);
                leaves = null;
            }
            DocList docList = rb.getResults().docList;
            int nDocs = docList.size();
            final long[] sortedIds = new long[nDocs];
            final float[] scores = new float[nDocs];
            DocList docs = rb.getResults().docList;
            DocIterator it = docs.iterator();
            for (int i = 0; i < nDocs; ++i) {
                sortedIds[i] = (long)it.nextDoc() << 32 | (long)i;
                scores[i] = docs.hasScores() ? it.score() : Float.NaN;
            }
            new InPlaceMergeSorter(){

                protected void swap(int i, int j) {
                    long tmpId = sortedIds[i];
                    float tmpScore = scores[i];
                    sortedIds[i] = sortedIds[j];
                    scores[i] = scores[j];
                    sortedIds[j] = tmpId;
                    scores[j] = tmpScore;
                }

                protected int compare(int i, int j) {
                    return Long.compare(sortedIds[i], sortedIds[j]);
                }
            }.sort(0, sortedIds.length);
            SortSpec sortSpec = rb.getSortSpec();
            Sort sort = searcher.weightSort(sortSpec.getSort());
            if (sort == null) {
                SortField[] sortFieldArray2 = new SortField[1];
                sortFieldArray = sortFieldArray2;
                sortFieldArray2[0] = SortField.FIELD_SCORE;
            } else {
                sortFieldArray = sort.getSort();
            }
            SortField[] sortFields = sortFieldArray;
            List<SchemaField> schemaFields = sortSpec.getSchemaFields();
            for (int fld = 0; fld < schemaFields.size(); ++fld) {
                SchemaField schemaField = schemaFields.get(fld);
                FieldType ft = null == schemaField ? null : schemaField.getType();
                SortField sortField = sortFields[fld];
                SortField.Type type = sortField.getType();
                if (type == SortField.Type.SCORE || type == SortField.Type.DOC) continue;
                FieldComparator comparator = sortField.getComparator(1, 0);
                LeafFieldComparator leafComparator = null;
                Object[] vals = new Object[nDocs];
                int lastIdx = -1;
                int idx = 0;
                for (int i = 0; i < sortedIds.length; ++i) {
                    long idAndPos = sortedIds[i];
                    float score = scores[i];
                    int doc = (int)(idAndPos >>> 32);
                    int position = (int)idAndPos;
                    if (leaves != null) {
                        idx = ReaderUtil.subIndex((int)doc, (List)leaves);
                        currentLeaf = (LeafReaderContext)leaves.get(idx);
                        if (idx != lastIdx) {
                            lastIdx = idx;
                            leafComparator = null;
                        }
                    }
                    if (leafComparator == null) {
                        leafComparator = comparator.getLeafComparator(currentLeaf);
                    }
                    leafComparator.setScorer((Scorer)new FakeScorer(doc -= currentLeaf.docBase, score));
                    leafComparator.copy(0, doc);
                    Object val = comparator.value(0);
                    if (null != ft) {
                        val = ft.marshalSortValue(val);
                    }
                    vals[position] = val;
                }
                sortVals.add(sortField.getField(), (Object)vals);
            }
            rsp.add("sort_values", sortVals);
        }
    }

    protected void doPrefetch(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        if (!req.getParams().getBool("isShard", false) && rb.getResults().docList != null && rb.getResults().docList.size() <= 50) {
            SolrPluginUtils.optimizePreFetchDocs(rb, rb.getResults().docList, rb.getQuery(), req, rsp);
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.grouping()) {
            return this.groupedDistributedProcess(rb);
        }
        return this.regularDistributedProcess(rb);
    }

    protected int groupedDistributedProcess(ResponseBuilder rb) {
        int nextStage = ResponseBuilder.STAGE_DONE;
        ShardRequestFactory shardRequestFactory = null;
        if (rb.stage < ResponseBuilder.STAGE_PARSE_QUERY) {
            nextStage = ResponseBuilder.STAGE_PARSE_QUERY;
        } else if (rb.stage == ResponseBuilder.STAGE_PARSE_QUERY) {
            this.createDistributedStats(rb);
            nextStage = ResponseBuilder.STAGE_TOP_GROUPS;
        } else if (rb.stage < ResponseBuilder.STAGE_TOP_GROUPS) {
            nextStage = ResponseBuilder.STAGE_TOP_GROUPS;
        } else if (rb.stage == ResponseBuilder.STAGE_TOP_GROUPS) {
            shardRequestFactory = new SearchGroupsRequestFactory();
            nextStage = ResponseBuilder.STAGE_EXECUTE_QUERY;
        } else if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            nextStage = ResponseBuilder.STAGE_EXECUTE_QUERY;
        } else if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            shardRequestFactory = new TopGroupsShardRequestFactory();
            nextStage = ResponseBuilder.STAGE_GET_FIELDS;
        } else if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            nextStage = ResponseBuilder.STAGE_GET_FIELDS;
        } else if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            shardRequestFactory = new StoredFieldsShardRequestFactory();
            nextStage = ResponseBuilder.STAGE_DONE;
        }
        if (shardRequestFactory != null) {
            for (ShardRequest shardRequest : shardRequestFactory.constructRequest(rb)) {
                rb.addRequest(this, shardRequest);
            }
        }
        return nextStage;
    }

    protected int regularDistributedProcess(ResponseBuilder rb) {
        if (rb.stage < ResponseBuilder.STAGE_PARSE_QUERY) {
            return ResponseBuilder.STAGE_PARSE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_PARSE_QUERY) {
            this.createDistributedStats(rb);
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            this.createMainQuery(rb);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS && !rb.onePassDistributedQuery) {
            this.createRetrieveDocs(rb);
            return ResponseBuilder.STAGE_DONE;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (rb.grouping()) {
            this.handleGroupedResponses(rb, sreq);
        } else {
            this.handleRegularResponses(rb, sreq);
        }
    }

    protected void handleGroupedResponses(ResponseBuilder rb, ShardRequest sreq) {
        ShardResponseProcessor responseProcessor = null;
        if ((sreq.purpose & 0x800) != 0) {
            responseProcessor = new SearchGroupShardResponseProcessor();
        } else if ((sreq.purpose & 4) != 0) {
            responseProcessor = new TopGroupsShardResponseProcessor();
        } else if ((sreq.purpose & 0x40) != 0) {
            responseProcessor = new StoredFieldsShardResponseProcessor();
        }
        if (responseProcessor != null) {
            responseProcessor.process(rb, sreq);
        }
    }

    protected void handleRegularResponses(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 4) != 0) {
            this.mergeIds(rb, sreq);
        }
        if ((sreq.purpose & 0x8000) != 0) {
            this.updateStats(rb, sreq);
        }
        if ((sreq.purpose & 0x40) != 0) {
            this.returnFields(rb, sreq);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        if (rb.grouping()) {
            this.groupedFinishStage(rb);
        } else {
            this.regularFinishStage(rb);
        }
    }

    protected void groupedFinishStage(ResponseBuilder rb) {
        EndResultTransformer endResultTransformer;
        GroupingSpecification groupSpec = rb.getGroupingSpec();
        if (rb.mergedTopGroups.isEmpty()) {
            for (String field : groupSpec.getFields()) {
                rb.mergedTopGroups.put(field, (TopGroups<BytesRef>)new TopGroups(null, null, 0, 0, new GroupDocs[0], Float.NaN));
            }
            rb.resultIds = new HashMap<Object, ShardDoc>();
        }
        EndResultTransformer.SolrDocumentSource solrDocumentSource = doc -> {
            ShardDoc solrDoc = (ShardDoc)doc;
            return rb.retrievedDocuments.get(solrDoc.id);
        };
        if (groupSpec.isMain()) {
            endResultTransformer = MAIN_END_RESULT_TRANSFORMER;
        } else if (Grouping.Format.grouped == groupSpec.getResponseFormat()) {
            endResultTransformer = new GroupedEndResultTransformer(rb.req.getSearcher());
        } else if (Grouping.Format.simple == groupSpec.getResponseFormat() && !groupSpec.isMain()) {
            endResultTransformer = SIMPLE_END_RESULT_TRANSFORMER;
        } else {
            return;
        }
        LinkedHashMap<String, Object> combinedMap = new LinkedHashMap<String, Object>();
        combinedMap.putAll(rb.mergedTopGroups);
        combinedMap.putAll(rb.mergedQueryCommandResults);
        endResultTransformer.transform(combinedMap, rb, solrDocumentSource);
    }

    protected void regularFinishStage(ResponseBuilder rb) {
        Iterator iter = rb.getResponseDocs().iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            iter.remove();
            rb.getResponseDocs().setNumFound(rb.getResponseDocs().getNumFound() - 1L);
        }
        rb.rsp.addResponse(rb.getResponseDocs());
        if (null != rb.getNextCursorMark()) {
            rb.rsp.add("nextCursorMark", rb.getNextCursorMark().getSerializedTotem());
        }
    }

    protected void createDistributedStats(ResponseBuilder rb) {
        ShardRequest sreq;
        StatsCache cache = rb.req.getCore().getStatsCache();
        if (((rb.getFieldFlags() & 1) != 0 || rb.getSortSpec().includesScore()) && (sreq = cache.retrieveStatsRequest(rb)) != null) {
            rb.addRequest(this, sreq);
        }
    }

    protected void updateStats(ResponseBuilder rb, ShardRequest sreq) {
        StatsCache cache = rb.req.getCore().getStatsCache();
        cache.mergeToGlobalStats(rb.req, sreq.responses);
    }

    protected void createMainQuery(ResponseBuilder rb) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 4;
        String keyFieldName = rb.req.getSchema().getUniqueKeyField().getName();
        ReturnFields fields = rb.rsp.getReturnFields();
        boolean distribSinglePass = rb.req.getParams().getBool("distrib.singlePass", false);
        if (distribSinglePass || fields != null && fields.wantsField(keyFieldName) && fields.getRequestedFieldNames() != null && !fields.hasPatternMatching() && Arrays.asList(keyFieldName, "score").containsAll(fields.getRequestedFieldNames())) {
            sreq.purpose |= 0x40;
            rb.onePassDistributedQuery = true;
        }
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.remove("shards");
        if (rb.shards_start > -1) {
            sreq.params.set("start", rb.shards_start);
        } else {
            sreq.params.set("start", new String[]{"0"});
        }
        if (rb.shards_rows > -1) {
            sreq.params.set("rows", rb.shards_rows);
        } else {
            sreq.params.set("rows", rb.getSortSpec().getOffset() + rb.getSortSpec().getCount());
        }
        sreq.params.set("fsv", new String[]{"true"});
        boolean shardQueryIncludeScore = (rb.getFieldFlags() & 1) != 0 || rb.getSortSpec().includesScore();
        StringBuilder additionalFL = new StringBuilder();
        boolean additionalAdded = false;
        if (distribSinglePass) {
            String[] fls = rb.req.getParams().getParams("fl");
            if (!(fls == null || fls.length <= 0 || fls.length == 1 && fls[0].isEmpty())) {
                sreq.params.set("fl", fls);
                if (!fields.wantsField(keyFieldName)) {
                    additionalAdded = this.addFL(additionalFL, keyFieldName, additionalAdded);
                }
            } else {
                sreq.params.set("fl", new String[]{"*"});
            }
            if (!fields.wantsScore() && shardQueryIncludeScore) {
                additionalAdded = this.addFL(additionalFL, "score", additionalAdded);
            }
        } else {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName()});
            if (shardQueryIncludeScore) {
                additionalAdded = this.addFL(additionalFL, "score", additionalAdded);
            }
        }
        if (shardQueryIncludeScore) {
            StatsCache statsCache = rb.req.getCore().getStatsCache();
            statsCache.sendGlobalStats(rb, sreq);
        }
        if (additionalAdded) {
            sreq.params.add("fl", new String[]{additionalFL.toString()});
        }
        rb.addRequest(this, sreq);
    }

    protected boolean addFL(StringBuilder fl, String field, boolean additionalAdded) {
        if (additionalAdded) {
            fl.append(",");
        }
        fl.append(field);
        return true;
    }

    protected void mergeIds(ResponseBuilder rb, ShardRequest sreq) {
        List<MergeStrategy> mergeStrategies = rb.getMergeStrategies();
        if (mergeStrategies != null) {
            Collections.sort(mergeStrategies, MergeStrategy.MERGE_COMP);
            boolean idsMerged = false;
            for (MergeStrategy mergeStrategy : mergeStrategies) {
                mergeStrategy.merge(rb, sreq);
                if (!mergeStrategy.mergesIds()) continue;
                idsMerged = true;
            }
            if (idsMerged) {
                return;
            }
        }
        SortSpec ss = rb.getSortSpec();
        Sort sort = ss.getSort();
        SortField[] sortFields = null;
        sortFields = sort != null ? sort.getSort() : new SortField[]{SortField.FIELD_SCORE};
        IndexSchema schema = rb.req.getSchema();
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        HashMap<Object, String> uniqueDoc = new HashMap<Object, String>();
        ShardFieldSortedHitQueue queue = new ShardFieldSortedHitQueue(sortFields, ss.getOffset() + ss.getCount(), rb.req.getSearcher());
        SimpleOrderedMap shardInfo = null;
        if (rb.req.getParams().getBool("shards.info", false)) {
            shardInfo = new SimpleOrderedMap();
            rb.rsp.getValues().add("shards.info", (Object)shardInfo);
        }
        long numFound = 0L;
        Float maxScore = null;
        boolean partialResults = false;
        Boolean segmentTerminatedEarly = null;
        for (ShardResponse srsp : sreq.responses) {
            SolrDocumentList docs = null;
            NamedList responseHeader = null;
            if (shardInfo != null) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                if (srsp.getException() != null) {
                    Throwable t = srsp.getException();
                    if (t instanceof SolrServerException) {
                        t = ((SolrServerException)t).getCause();
                    }
                    nl.add("error", (Object)t.toString());
                    StringWriter trace = new StringWriter();
                    t.printStackTrace(new PrintWriter(trace));
                    nl.add("trace", (Object)trace.toString());
                    if (srsp.getShardAddress() != null) {
                        nl.add("shardAddress", (Object)srsp.getShardAddress());
                    }
                } else {
                    Object rhste;
                    responseHeader = (NamedList)srsp.getSolrResponse().getResponse().get("responseHeader");
                    Object object = rhste = responseHeader == null ? null : responseHeader.get("segmentTerminatedEarly");
                    if (rhste != null) {
                        nl.add("segmentTerminatedEarly", rhste);
                    }
                    docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
                    nl.add("numFound", (Object)docs.getNumFound());
                    nl.add("maxScore", (Object)docs.getMaxScore());
                    nl.add("shardAddress", (Object)srsp.getShardAddress());
                }
                if (srsp.getSolrResponse() != null) {
                    nl.add("time", (Object)srsp.getSolrResponse().getElapsedTime());
                }
                shardInfo.add(srsp.getShard(), (Object)nl);
            }
            if (srsp.getException() != null) {
                partialResults = true;
                continue;
            }
            if (docs == null) {
                docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
            }
            if (responseHeader == null) {
                responseHeader = (NamedList)srsp.getSolrResponse().getResponse().get("responseHeader");
            }
            if (responseHeader != null) {
                if (Boolean.TRUE.equals(responseHeader.get("partialResults"))) {
                    partialResults = true;
                }
                if (!Boolean.TRUE.equals(segmentTerminatedEarly)) {
                    Object ste = responseHeader.get("segmentTerminatedEarly");
                    if (Boolean.TRUE.equals(ste)) {
                        segmentTerminatedEarly = Boolean.TRUE;
                    } else if (Boolean.FALSE.equals(ste)) {
                        segmentTerminatedEarly = Boolean.FALSE;
                    }
                }
            }
            if (docs.getMaxScore() != null) {
                maxScore = Float.valueOf(maxScore == null ? docs.getMaxScore().floatValue() : Math.max(maxScore.floatValue(), docs.getMaxScore().floatValue()));
            }
            numFound += docs.getNumFound();
            NamedList sortFieldValues = (NamedList)srsp.getSolrResponse().getResponse().get("sort_values");
            NamedList unmarshalledSortFieldValues = this.unmarshalSortValues(ss, sortFieldValues, schema);
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = (SolrDocument)docs.get(i);
                Object id = doc.getFieldValue(uniqueKeyField.getName());
                String prevShard = uniqueDoc.put(id, srsp.getShard());
                if (prevShard != null) {
                    --numFound;
                    continue;
                }
                ShardDoc shardDoc = new ShardDoc();
                shardDoc.id = id;
                shardDoc.shard = srsp.getShard();
                shardDoc.orderInShard = i;
                Object scoreObj = doc.getFieldValue("score");
                if (scoreObj != null) {
                    shardDoc.score = scoreObj instanceof String ? Float.parseFloat((String)scoreObj) : ((Float)scoreObj).floatValue();
                }
                shardDoc.sortFieldValues = unmarshalledSortFieldValues;
                queue.insertWithOverflow((Object)shardDoc);
            }
        }
        int resultSize = queue.size() - ss.getOffset();
        resultSize = Math.max(0, resultSize);
        HashMap<Object, ShardDoc> resultIds = new HashMap<Object, ShardDoc>();
        int i = resultSize - 1;
        while (i >= 0) {
            ShardDoc shardDoc = (ShardDoc)((Object)queue.pop());
            shardDoc.positionInResponse = i--;
            resultIds.put(shardDoc.id.toString(), shardDoc);
        }
        rb.rsp.addToLog("hits", numFound);
        SolrDocumentList responseDocs = new SolrDocumentList();
        if (maxScore != null) {
            responseDocs.setMaxScore(maxScore);
        }
        responseDocs.setNumFound(numFound);
        responseDocs.setStart((long)ss.getOffset());
        for (int i2 = 0; i2 < resultSize; ++i2) {
            responseDocs.add(null);
        }
        rb.resultIds = resultIds;
        rb.setResponseDocs(responseDocs);
        this.populateNextCursorMarkFromMergedShards(rb);
        if (partialResults && rb.rsp.getResponseHeader().get("partialResults") == null) {
            rb.rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
        }
        if (segmentTerminatedEarly != null) {
            Object existingSegmentTerminatedEarly = rb.rsp.getResponseHeader().get("segmentTerminatedEarly");
            if (existingSegmentTerminatedEarly == null) {
                rb.rsp.getResponseHeader().add("segmentTerminatedEarly", (Object)segmentTerminatedEarly);
            } else if (!Boolean.TRUE.equals(existingSegmentTerminatedEarly) && Boolean.TRUE.equals(segmentTerminatedEarly)) {
                rb.rsp.getResponseHeader().remove("segmentTerminatedEarly");
                rb.rsp.getResponseHeader().add("segmentTerminatedEarly", (Object)segmentTerminatedEarly);
            }
        }
    }

    protected void populateNextCursorMarkFromMergedShards(ResponseBuilder rb) {
        CursorMark lastCursorMark = rb.getCursorMark();
        if (null == lastCursorMark) {
            return;
        }
        assert (null != rb.resultIds) : "resultIds was not set in ResponseBuilder";
        Collection<ShardDoc> docsOnThisPage = rb.resultIds.values();
        if (0 == docsOnThisPage.size()) {
            rb.setNextCursorMark(lastCursorMark);
            return;
        }
        ShardDoc lastDoc = null;
        for (ShardDoc eachDoc : docsOnThisPage) {
            if (null != lastDoc && lastDoc.positionInResponse >= eachDoc.positionInResponse) continue;
            lastDoc = eachDoc;
        }
        SortField[] sortFields = lastCursorMark.getSortSpec().getSort().getSort();
        ArrayList<Object> nextCursorMarkValues = new ArrayList<Object>(sortFields.length);
        for (SortField sf : sortFields) {
            if (sf.getType().equals((Object)SortField.Type.SCORE)) {
                nextCursorMarkValues.add(Float.valueOf(lastDoc.score));
                continue;
            }
            assert (null != sf.getField()) : "SortField has null field";
            List fieldVals = (List)lastDoc.sortFieldValues.get(sf.getField());
            nextCursorMarkValues.add(fieldVals.get(lastDoc.orderInShard));
        }
        CursorMark nextCursorMark = lastCursorMark.createNext(nextCursorMarkValues);
        assert (null != nextCursorMark) : "null nextCursorMark";
        rb.setNextCursorMark(nextCursorMark);
    }

    protected NamedList unmarshalSortValues(SortSpec sortSpec, NamedList sortFieldValues, IndexSchema schema) {
        NamedList unmarshalledSortValsPerField = new NamedList();
        if (0 == sortFieldValues.size()) {
            return unmarshalledSortValsPerField;
        }
        List<SchemaField> schemaFields = sortSpec.getSchemaFields();
        SortField[] sortFields = sortSpec.getSort().getSort();
        int marshalledFieldNum = 0;
        for (int sortFieldNum = 0; sortFieldNum < sortFields.length; ++sortFieldNum) {
            SortField sortField = sortFields[sortFieldNum];
            SortField.Type type = sortField.getType();
            if (type == SortField.Type.SCORE || type == SortField.Type.DOC) continue;
            String sortFieldName = sortField.getField();
            String valueFieldName = sortFieldValues.getName(marshalledFieldNum);
            assert (sortFieldName.equals(valueFieldName)) : "sortFieldValues name key does not match expected SortField.getField";
            List sortVals = (List)sortFieldValues.getVal(marshalledFieldNum);
            SchemaField schemaField = schemaFields.get(sortFieldNum);
            if (null == schemaField) {
                unmarshalledSortValsPerField.add(sortField.getField(), (Object)sortVals);
            } else {
                FieldType fieldType = schemaField.getType();
                ArrayList<Object> unmarshalledSortVals = new ArrayList<Object>();
                for (Object sortVal : sortVals) {
                    unmarshalledSortVals.add(fieldType.unmarshalSortValue(sortVal));
                }
                unmarshalledSortValsPerField.add(sortField.getField(), unmarshalledSortVals);
            }
            ++marshalledFieldNum;
        }
        return unmarshalledSortValsPerField;
    }

    protected void createRetrieveDocs(ResponseBuilder rb) {
        HashMap shardMap = new HashMap();
        for (ShardDoc sdoc : rb.resultIds.values()) {
            Collection shardDocs = (ArrayList<ShardDoc>)shardMap.get(sdoc.shard);
            if (shardDocs == null) {
                shardDocs = new ArrayList<ShardDoc>();
                shardMap.put(sdoc.shard, shardDocs);
            }
            shardDocs.add(sdoc);
        }
        SchemaField uniqueField = rb.req.getSchema().getUniqueKeyField();
        for (Collection shardDocs : shardMap.values()) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 64;
            sreq.shards = new String[]{((ShardDoc)((Object)shardDocs.iterator().next())).shard};
            sreq.params = new ModifiableSolrParams();
            sreq.params.add(rb.req.getParams());
            sreq.params.remove("sort");
            sreq.params.remove("cursorMark");
            sreq.params.remove("fsv");
            if (!rb.rsp.getReturnFields().wantsField(uniqueField.getName())) {
                sreq.params.add("fl", new String[]{uniqueField.getName()});
            }
            ArrayList<String> ids = new ArrayList<String>(shardDocs.size());
            for (ShardDoc shardDoc : shardDocs) {
                ids.add(shardDoc.id.toString());
            }
            sreq.params.add("ids", new String[]{StrUtils.join(ids, (char)',')});
            rb.addRequest(this, sreq);
        }
    }

    protected void returnFields(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 0x40) != 0) {
            boolean removeKeyField;
            boolean returnScores = (rb.getFieldFlags() & 1) != 0;
            String keyFieldName = rb.req.getSchema().getUniqueKeyField().getName();
            boolean bl = removeKeyField = !rb.rsp.getReturnFields().wantsField(keyFieldName);
            if (rb.rsp.getReturnFields().getFieldRenames().get(keyFieldName) != null) {
                keyFieldName = rb.rsp.getReturnFields().getFieldRenames().get(keyFieldName);
            }
            for (ShardResponse srsp : sreq.responses) {
                if (srsp.getException() != null) {
                    NamedList shardInfo;
                    SimpleOrderedMap nl;
                    if (!rb.req.getParams().getBool("shards.info", false) || (nl = (SimpleOrderedMap)(shardInfo = (NamedList)rb.rsp.getValues().get("shards.info")).get(srsp.getShard())).get("error") != null) continue;
                    Throwable t = srsp.getException();
                    if (t instanceof SolrServerException) {
                        t = ((SolrServerException)t).getCause();
                    }
                    nl.add("error", (Object)t.toString());
                    StringWriter trace = new StringWriter();
                    t.printStackTrace(new PrintWriter(trace));
                    nl.add("trace", (Object)trace.toString());
                    continue;
                }
                SolrDocumentList docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
                for (SolrDocument doc : docs) {
                    Object id = doc.getFieldValue(keyFieldName);
                    ShardDoc sdoc = rb.resultIds.get(id.toString());
                    if (sdoc == null) continue;
                    if (returnScores) {
                        doc.setField("score", (Object)Float.valueOf(sdoc.score));
                    } else {
                        doc.remove((Object)"score");
                    }
                    if (removeKeyField) {
                        doc.removeFields(keyFieldName);
                    }
                    rb.getResponseDocs().set(sdoc.positionInResponse, (Object)doc);
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return COMPONENT_NAME;
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERY;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    protected static class FakeScorer
    extends Scorer {
        final int docid;
        final float score;

        FakeScorer(int docid, float score) {
            super(null);
            this.docid = docid;
            this.score = score;
        }

        public int docID() {
            return this.docid;
        }

        public float score() throws IOException {
            return this.score;
        }

        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        public Weight getWeight() {
            throw new UnsupportedOperationException();
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            throw new UnsupportedOperationException();
        }
    }
}

