/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class SolrInfoMBeanHandler
extends RequestHandlerBase {
    static final Map<String, String> newToOldCategories = new HashMap<String, String>(){
        {
            this.put(SolrInfoMBean.Category.QUERY.toString(), "QUERYHANDLER");
            this.put(SolrInfoMBean.Category.UPDATE.toString(), "UPDATEHANDLER");
            this.put(SolrInfoMBean.Category.HIGHLIGHTER.toString(), "HIGHLIGHTING");
        }
    };
    static final Map<String, String> oldToNewCategories = new HashMap<String, String>(){
        {
            this.put("QUERYHANDLER", SolrInfoMBean.Category.QUERY.toString());
            this.put("UPDATEHANDLER", SolrInfoMBean.Category.UPDATE.toString());
            this.put("HIGHLIGHTING", SolrInfoMBean.Category.HIGHLIGHTER.toString());
        }
    };
    static final boolean useOnlyNewNaming = Boolean.valueOf(System.getProperty("solr.mbeans.useOnlyNewNaming", "false"));

    private Set<String> arrayToSet(Object[] arr) {
        HashSet<String> r = new HashSet<String>();
        if (null == arr) {
            return r;
        }
        for (Object o : arr) {
            if (null == o) continue;
            r.add(o.toString());
        }
        return r;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        NamedList cats = this.getMBeanInfo(req);
        if (req.getParams().getBool("diff", false)) {
            ContentStream body = null;
            try {
                body = req.getContentStreams().iterator().next();
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content-stream for diff");
            }
            String content = IOUtils.toString((Reader)body.getReader());
            NamedList ref = SolrInfoMBeanHandler.fromXML(content);
            SolrQueryResponse wrap = new SolrQueryResponse();
            wrap.add("solr-mbeans", cats);
            cats = (NamedList)BinaryResponseWriter.getParsedResponse(req, wrap).get("solr-mbeans");
            ref = this.normalize(ref);
            cats = this.normalize(cats);
            boolean showAll = req.getParams().getBool("all", false);
            rsp.add("solr-mbeans", this.getDiff((NamedList<NamedList<NamedList<Object>>>)ref, (NamedList<NamedList<NamedList<Object>>>)cats, showAll));
        } else {
            rsp.add("solr-mbeans", cats);
        }
        rsp.setHttpCaching(false);
    }

    static NamedList<NamedList<NamedList<Object>>> fromXML(String content) {
        int idx = content.indexOf("<response>");
        if (idx < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Body does not appear to be an XML response");
        }
        try {
            XMLResponseParser parser = new XMLResponseParser();
            return (NamedList)parser.processResponse((Reader)new StringReader(content)).get("solr-mbeans");
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to read original XML", (Throwable)ex);
        }
    }

    protected NamedList<NamedList<NamedList<Object>>> getMBeanInfo(SolrQueryRequest req) {
        String cat;
        NamedList cats = new NamedList();
        String[] requestedCats = req.getParams().getParams("cat");
        if (null == requestedCats || 0 == requestedCats.length) {
            for (SolrInfoMBean.Category category : SolrInfoMBean.Category.values()) {
                cats.add(category.name(), (Object)new SimpleOrderedMap());
            }
            if (!useOnlyNewNaming) {
                for (String oldName : newToOldCategories.values()) {
                    cats.add(oldName, (Object)new SimpleOrderedMap());
                }
            }
        } else {
            for (SolrInfoMBean.Category category : requestedCats) {
                cats.add((String)((Object)category), (Object)new SimpleOrderedMap());
                if (useOnlyNewNaming) continue;
                if (newToOldCategories.containsKey((Object)category)) {
                    cats.add(newToOldCategories.get((Object)category), (Object)new SimpleOrderedMap());
                }
                if (!oldToNewCategories.containsKey((Object)category)) continue;
                cats.add(oldToNewCategories.get((Object)category), (Object)new SimpleOrderedMap());
            }
        }
        Set<String> requestedKeys = this.arrayToSet(req.getParams().getParams("key"));
        Map<String, SolrInfoMBean> reg = req.getCore().getInfoRegistry();
        for (Map.Entry<String, SolrInfoMBean> entry : reg.entrySet()) {
            cat = entry.getValue().getCategory().name();
            this.addMBean(req, cat, (NamedList<NamedList<NamedList<Object>>>)cats, requestedKeys, entry.getKey(), entry.getValue());
            if (useOnlyNewNaming || !newToOldCategories.containsKey(cat)) continue;
            this.addMBean(req, newToOldCategories.get(cat), (NamedList<NamedList<NamedList<Object>>>)cats, requestedKeys, entry.getKey(), entry.getValue());
        }
        for (SolrInfoMBean solrInfoMBean : req.getCore().getCoreDescriptor().getCoreContainer().getResourceLoader().getInfoMBeans()) {
            cat = solrInfoMBean.getCategory().name();
            this.addMBean(req, cat, (NamedList<NamedList<NamedList<Object>>>)cats, requestedKeys, solrInfoMBean.getName(), solrInfoMBean);
            if (useOnlyNewNaming || !newToOldCategories.containsKey(cat)) continue;
            this.addMBean(req, newToOldCategories.get(cat), (NamedList<NamedList<NamedList<Object>>>)cats, requestedKeys, solrInfoMBean.getName(), solrInfoMBean);
        }
        return cats;
    }

    private void addMBean(SolrQueryRequest req, String categoryName, NamedList<NamedList<NamedList<Object>>> cats, Set<String> requestedKeys, String key, SolrInfoMBean m) {
        if (!requestedKeys.isEmpty() && !requestedKeys.contains(key)) {
            return;
        }
        NamedList catInfo = (NamedList)cats.get(categoryName);
        if (null == catInfo) {
            return;
        }
        SimpleOrderedMap mBeanInfo = new SimpleOrderedMap();
        mBeanInfo.add("class", (Object)m.getName());
        mBeanInfo.add("version", (Object)m.getVersion());
        mBeanInfo.add("description", (Object)m.getDescription());
        mBeanInfo.add("src", (Object)m.getSource());
        URL[] urls = m.getDocs();
        if (urls != null) {
            ArrayList<String> docs = new ArrayList<String>(urls.length);
            for (URL url : urls) {
                docs.add(url.toExternalForm());
            }
            mBeanInfo.add("docs", docs);
        }
        if (req.getParams().getFieldBool(key, "stats", false)) {
            mBeanInfo.add("stats", (Object)m.getStatistics());
        }
        catInfo.add(key, (Object)mBeanInfo);
    }

    protected NamedList<NamedList<NamedList<Object>>> getDiff(NamedList<NamedList<NamedList<Object>>> ref, NamedList<NamedList<NamedList<Object>>> now, boolean includeAll) {
        NamedList changed = new NamedList();
        for (int i = 0; i < ref.size(); ++i) {
            String now_txt;
            String category = ref.getName(i);
            NamedList ref_cat = (NamedList)ref.get(category);
            NamedList now_cat = (NamedList)now.get(category);
            if (now_cat == null) continue;
            String ref_txt = ref_cat + "";
            if (!ref_txt.equals(now_txt = now_cat + "")) {
                SimpleOrderedMap cat = new SimpleOrderedMap();
                for (int j = 0; j < ref_cat.size(); ++j) {
                    String name = ref_cat.getName(j);
                    NamedList ref_bean = (NamedList)ref_cat.get(name);
                    NamedList now_bean = (NamedList)now_cat.get(name);
                    ref_txt = ref_bean + "";
                    if (!ref_txt.equals(now_txt = now_bean + "")) {
                        NamedList diff = this.diffNamedList(ref_bean, now_bean);
                        diff.add("_changed_", (Object)true);
                        cat.add(name, (Object)diff);
                        continue;
                    }
                    if (!includeAll) continue;
                    cat.add(name, (Object)ref_bean);
                }
                if (cat.size() <= 0) continue;
                changed.add(category, (Object)cat);
                continue;
            }
            if (!includeAll) continue;
            changed.add(category, (Object)ref_cat);
        }
        return changed;
    }

    public NamedList diffNamedList(NamedList ref, NamedList now) {
        String name;
        int i;
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (i = 0; i < ref.size(); ++i) {
            name = ref.getName(i);
            Object r = ref.getVal(i);
            Object n = now.remove(name);
            if (n == null) {
                if (r == null) continue;
                out.add("REMOVE " + name, r);
                continue;
            }
            out.add(name, this.diffObject(r, n));
        }
        for (i = 0; i < now.size(); ++i) {
            name = now.getName(i);
            Object v = now.getVal(i);
            if (v == null) continue;
            out.add("ADD " + name, v);
        }
        return out;
    }

    public Object diffObject(Object ref, Object now) {
        if (ref instanceof NamedList) {
            return this.diffNamedList((NamedList)ref, (NamedList)now);
        }
        if (ref.equals(now)) {
            return ref;
        }
        StringBuilder str = new StringBuilder();
        str.append("Was: ").append(ref).append(", Now: ").append(now);
        if (ref instanceof Number) {
            NumberFormat nf = NumberFormat.getIntegerInstance(Locale.ROOT);
            if (ref instanceof Double || ref instanceof Float) {
                nf = NumberFormat.getInstance(Locale.ROOT);
            }
            double dref = ((Number)ref).doubleValue();
            double dnow = ((Number)now).doubleValue();
            double diff = Double.NaN;
            diff = Double.isNaN(dref) ? dnow : (Double.isNaN(dnow) ? dref : dnow - dref);
            str.append(", Delta: ").append(nf.format(diff));
        }
        return str.toString();
    }

    public NamedList normalize(NamedList input) {
        input.remove("avgRequestsPerSecond");
        for (int i = 0; i < input.size(); ++i) {
            Object v = input.getVal(i);
            if (!(v instanceof NamedList)) continue;
            input.setVal(i, (Object)this.normalize((NamedList)v));
        }
        return input;
    }

    @Override
    public String getDescription() {
        return "Get Info (and statistics) for registered SolrInfoMBeans";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.ADMIN;
    }
}

