/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.ModelCache;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.graph.GatherNodesStream;
import org.apache.solr.client.solrj.io.graph.ShortestPathStream;
import org.apache.solr.client.solrj.io.ops.AndOperation;
import org.apache.solr.client.solrj.io.ops.ConcatOperation;
import org.apache.solr.client.solrj.io.ops.DistinctOperation;
import org.apache.solr.client.solrj.io.ops.EqualsOperation;
import org.apache.solr.client.solrj.io.ops.GreaterThanEqualToOperation;
import org.apache.solr.client.solrj.io.ops.GreaterThanOperation;
import org.apache.solr.client.solrj.io.ops.GroupOperation;
import org.apache.solr.client.solrj.io.ops.LessThanEqualToOperation;
import org.apache.solr.client.solrj.io.ops.LessThanOperation;
import org.apache.solr.client.solrj.io.ops.NotOperation;
import org.apache.solr.client.solrj.io.ops.OrOperation;
import org.apache.solr.client.solrj.io.ops.ReplaceOperation;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.CommitStream;
import org.apache.solr.client.solrj.io.stream.ComplementStream;
import org.apache.solr.client.solrj.io.stream.DaemonStream;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.ExecutorStream;
import org.apache.solr.client.solrj.io.stream.FacetStream;
import org.apache.solr.client.solrj.io.stream.FeaturesSelectionStream;
import org.apache.solr.client.solrj.io.stream.FetchStream;
import org.apache.solr.client.solrj.io.stream.HashJoinStream;
import org.apache.solr.client.solrj.io.stream.HavingStream;
import org.apache.solr.client.solrj.io.stream.InnerJoinStream;
import org.apache.solr.client.solrj.io.stream.IntersectStream;
import org.apache.solr.client.solrj.io.stream.JDBCStream;
import org.apache.solr.client.solrj.io.stream.LeftOuterJoinStream;
import org.apache.solr.client.solrj.io.stream.MergeStream;
import org.apache.solr.client.solrj.io.stream.ModelStream;
import org.apache.solr.client.solrj.io.stream.NullStream;
import org.apache.solr.client.solrj.io.stream.OuterHashJoinStream;
import org.apache.solr.client.solrj.io.stream.ParallelStream;
import org.apache.solr.client.solrj.io.stream.PriorityStream;
import org.apache.solr.client.solrj.io.stream.RandomStream;
import org.apache.solr.client.solrj.io.stream.RankStream;
import org.apache.solr.client.solrj.io.stream.ReducerStream;
import org.apache.solr.client.solrj.io.stream.RollupStream;
import org.apache.solr.client.solrj.io.stream.ScoreNodesStream;
import org.apache.solr.client.solrj.io.stream.SelectStream;
import org.apache.solr.client.solrj.io.stream.SortStream;
import org.apache.solr.client.solrj.io.stream.StatsStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TextLogitStream;
import org.apache.solr.client.solrj.io.stream.TopicStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.UpdateStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MaxMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MeanMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MinMetric;
import org.apache.solr.client.solrj.io.stream.metrics.SumMetric;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ClassifyStream;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    static SolrClientCache clientCache = new SolrClientCache();
    static ModelCache modelCache = null;
    private StreamFactory streamFactory = new StreamFactory();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String coreName;
    private Map<String, DaemonStream> daemons = Collections.synchronizedMap(new HashMap());

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreDescriptor().getCoreContainer();
        this.coreName = core.getName();
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreDescriptor().getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
            modelCache = new ModelCache(250, defaultZkhost, clientCache);
        }
        this.streamFactory.withFunctionName("search", CloudSolrStream.class).withFunctionName("facet", FacetStream.class).withFunctionName("update", UpdateStream.class).withFunctionName("jdbc", JDBCStream.class).withFunctionName("topic", TopicStream.class).withFunctionName("commit", CommitStream.class).withFunctionName("random", RandomStream.class).withFunctionName("merge", MergeStream.class).withFunctionName("unique", UniqueStream.class).withFunctionName("top", RankStream.class).withFunctionName("group", GroupOperation.class).withFunctionName("reduce", ReducerStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("rollup", RollupStream.class).withFunctionName("stats", StatsStream.class).withFunctionName("innerJoin", InnerJoinStream.class).withFunctionName("leftOuterJoin", LeftOuterJoinStream.class).withFunctionName("hashJoin", HashJoinStream.class).withFunctionName("outerHashJoin", OuterHashJoinStream.class).withFunctionName("intersect", IntersectStream.class).withFunctionName("complement", ComplementStream.class).withFunctionName("sort", SortStream.class).withFunctionName("train", TextLogitStream.class).withFunctionName("features", FeaturesSelectionStream.class).withFunctionName("daemon", DaemonStream.class).withFunctionName("sort", SortStream.class).withFunctionName("select", SelectStream.class).withFunctionName("shortestPath", ShortestPathStream.class).withFunctionName("gatherNodes", GatherNodesStream.class).withFunctionName("nodes", GatherNodesStream.class).withFunctionName("scoreNodes", ScoreNodesStream.class).withFunctionName("model", ModelStream.class).withFunctionName("classify", ClassifyStream.class).withFunctionName("fetch", FetchStream.class).withFunctionName("executor", ExecutorStream.class).withFunctionName("null", NullStream.class).withFunctionName("priority", PriorityStream.class).withFunctionName("min", MinMetric.class).withFunctionName("max", MaxMetric.class).withFunctionName("avg", MeanMetric.class).withFunctionName("sum", SumMetric.class).withFunctionName("count", CountMetric.class).withFunctionName("replace", ReplaceOperation.class).withFunctionName("concat", ConcatOperation.class).withFunctionName("group", GroupOperation.class).withFunctionName("distinct", DistinctOperation.class).withFunctionName("having", HavingStream.class).withFunctionName("and", AndOperation.class).withFunctionName("or", OrOperation.class).withFunctionName("not", NotOperation.class).withFunctionName("gt", GreaterThanOperation.class).withFunctionName("lt", LessThanOperation.class).withFunctionName("eq", EqualsOperation.class).withFunctionName("lteq", LessThanEqualToOperation.class).withFunctionName("gteq", GreaterThanEqualToOperation.class);
        List<PluginInfo> pluginInfos = core.getSolrConfig().getPluginInfos(Expressible.class.getName());
        for (PluginInfo pluginInfo : pluginInfos) {
            Class<Expressible> clazz = core.getResourceLoader().findClass(pluginInfo.className, Expressible.class);
            this.streamFactory.withFunctionName(pluginInfo.name, clazz);
        }
        core.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
            }

            @Override
            public void postClose(SolrCore core) {
                clientCache.close();
            }
        });
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        TupleStream tupleStream;
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        if (params.get("action") != null) {
            this.handleAdmin(req, rsp, params);
            return;
        }
        try {
            tupleStream = this.streamFactory.constructStream(params.get("expr"));
        }
        catch (Exception e) {
            SolrException.log((Logger)logger, (Throwable)e);
            rsp.add("result-set", (Object)new DummyErrorStream(e));
            return;
        }
        int worker = params.getInt("workerID", 0);
        int numWorkers = params.getInt("numWorkers", 1);
        StreamContext context = new StreamContext();
        context.workerID = worker;
        context.numWorkers = numWorkers;
        context.setSolrClientCache(clientCache);
        context.setModelCache(modelCache);
        context.put((Object)"core", (Object)this.coreName);
        context.put((Object)"solr-core", (Object)req.getCore());
        tupleStream.setStreamContext(context);
        if (params.getBool("explain", false)) {
            rsp.add("explanation", tupleStream.toExplanation(this.streamFactory));
        }
        if (tupleStream instanceof DaemonStream) {
            DaemonStream daemonStream = (DaemonStream)tupleStream;
            if (this.daemons.containsKey(daemonStream.getId())) {
                this.daemons.remove(daemonStream.getId()).close();
            }
            daemonStream.setDaemons(this.daemons);
            daemonStream.open();
            this.daemons.put(daemonStream.getId(), daemonStream);
            rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + daemonStream.getId() + " started on " + this.coreName));
        } else {
            rsp.add("result-set", (Object)new TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        }
    }

    private void handleAdmin(SolrQueryRequest req, SolrQueryResponse rsp, SolrParams params) {
        String action = params.get("action");
        if ("stop".equalsIgnoreCase(action)) {
            String id = params.get("id");
            DaemonStream d = this.daemons.get(id);
            if (d != null) {
                d.close();
                rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " stopped on " + this.coreName));
            } else {
                rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " not found on " + this.coreName));
            }
        } else if ("start".equalsIgnoreCase(action)) {
            String id = params.get("id");
            DaemonStream d = this.daemons.get(id);
            d.open();
            rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " started on " + this.coreName));
        } else if ("list".equalsIgnoreCase(action)) {
            Collection<DaemonStream> vals = this.daemons.values();
            rsp.add("result-set", (Object)new DaemonCollectionStream(vals));
        } else if ("kill".equalsIgnoreCase(action)) {
            String id = params.get("id");
            DaemonStream d = this.daemons.remove(id);
            if (d != null) {
                d.close();
            }
            rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " killed on " + this.coreName));
        }
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    @Override
    public String getDescription() {
        return "StreamHandler";
    }

    @Override
    public String getSource() {
        return null;
    }

    public static class TimerStream
    extends TupleStream {
        private long begin;
        private TupleStream tupleStream;

        public TimerStream(TupleStream tupleStream) {
            this.tupleStream = tupleStream;
        }

        public StreamComparator getStreamSort() {
            return this.tupleStream.getStreamSort();
        }

        public void close() throws IOException {
            this.tupleStream.close();
        }

        public void open() throws IOException {
            this.begin = System.nanoTime();
            this.tupleStream.open();
        }

        public void setStreamContext(StreamContext context) {
            this.tupleStream.setStreamContext(context);
        }

        public List<TupleStream> children() {
            return this.tupleStream.children();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("timer").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() throws IOException {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                long totalTime = (System.nanoTime() - this.begin) / 1000000L;
                tuple.fields.put("RESPONSE_TIME", totalTime);
            }
            return tuple;
        }
    }

    public static class DaemonResponseStream
    extends TupleStream {
        private String message;
        private boolean sendEOF = false;

        public DaemonResponseStream(String message) {
            this.message = message;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("daemon-response").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            if (this.sendEOF) {
                HashMap<String, Boolean> m = new HashMap<String, Boolean>();
                m.put("EOF", true);
                return new Tuple(m);
            }
            this.sendEOF = true;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("DaemonOp", this.message);
            return new Tuple(m);
        }
    }

    public static class DaemonCollectionStream
    extends TupleStream {
        private Iterator<DaemonStream> it;

        public DaemonCollectionStream(Collection<DaemonStream> col) {
            this.it = col.iterator();
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("daemon-collection").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            if (this.it.hasNext()) {
                return this.it.next().getInfo();
            }
            HashMap<String, Boolean> m = new HashMap<String, Boolean>();
            m.put("EOF", true);
            return new Tuple(m);
        }
    }

    public static class DummyErrorStream
    extends TupleStream {
        private Exception e;

        public DummyErrorStream(Exception e) {
            this.e = e;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("error").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            String msg = this.e.getMessage();
            for (Throwable t = this.e.getCause(); t != null; t = t.getCause()) {
                msg = t.getMessage();
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("EOF", true);
            m.put("EXCEPTION", msg);
            return new Tuple(m);
        }
    }
}

