/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.FacetStream;
import org.apache.solr.client.solrj.io.stream.ParallelStream;
import org.apache.solr.client.solrj.io.stream.RankStream;
import org.apache.solr.client.solrj.io.stream.RollupStream;
import org.apache.solr.client.solrj.io.stream.SelectStream;
import org.apache.solr.client.solrj.io.stream.StatsStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MaxMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MeanMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.io.stream.metrics.MinMetric;
import org.apache.solr.client.solrj.io.stream.metrics.SumMetric;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String defaultZkhost = null;
    private static String defaultWorkerCollection = null;
    static final String sqlNonCloudErrorMsg = "/sql handler only works in Solr Cloud mode";
    private boolean isCloud = false;

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreDescriptor().getCoreContainer();
        if (coreContainer.isZooKeeperAware()) {
            defaultZkhost = core.getCoreDescriptor().getCoreContainer().getZkController().getZkServerAddress();
            defaultWorkerCollection = core.getCoreDescriptor().getCollectionName();
            this.isCloud = true;
        }
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        String sql = params.get("stmt");
        int numWorkers = params.getInt("numWorkers", 1);
        String workerCollection = params.get("workerCollection", defaultWorkerCollection);
        String workerZkhost = params.get("workerZkhost", defaultZkhost);
        String mode = params.get("aggregationMode", "map_reduce");
        StreamContext context = new StreamContext();
        boolean includeMetadata = params.getBool("includeMetadata", false);
        try {
            if (!this.isCloud) {
                throw new IllegalStateException(sqlNonCloudErrorMsg);
            }
            if (sql == null) {
                throw new Exception("stmt parameter cannot be null");
            }
            context.setSolrClientCache(StreamHandler.clientCache);
            TupleStream tupleStream = SQLTupleStreamParser.parse(sql, numWorkers, workerCollection, workerZkhost, AggregationMode.getMode(mode), includeMetadata, context);
            rsp.add("result-set", (Object)new StreamHandler.TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        }
        catch (Exception e) {
            SolrException.log((Logger)logger, (Throwable)e);
            rsp.add("result-set", (Object)new StreamHandler.DummyErrorStream(e));
        }
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams(params);
        adjustedParams.set("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    @Override
    public String getDescription() {
        return "SQLHandler";
    }

    @Override
    public String getSource() {
        return null;
    }

    private static TupleStream doGroupByWithAggregates(SQLVisitor sqlVisitor, int numWorkers, String workerCollection, String workerZkHost) throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        Bucket[] buckets = SQLHandler.getBuckets(sqlVisitor.groupBy, fieldSet);
        Metric[] metrics = SQLHandler.getMetrics(sqlVisitor.fields, fieldSet);
        if (metrics.length == 0) {
            throw new IOException("Group by queries must include atleast one aggregate function.");
        }
        String fl = SQLHandler.fields(fieldSet);
        String sortDirection = SQLHandler.getSortDirection(sqlVisitor.sorts);
        String sort = SQLHandler.bucketSort(buckets, sortDirection);
        TableSpec tableSpec = new TableSpec(sqlVisitor.table, defaultZkhost);
        String zkHost = tableSpec.zkHost;
        String collection = tableSpec.collection;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("fl", new String[]{fl});
        params.set("q", new String[]{sqlVisitor.query});
        params.set("qt", new String[]{"/export"});
        if (numWorkers > 1) {
            params.set("partitionKeys", new String[]{SQLHandler.getPartitionKeys(buckets)});
        }
        params.set("sort", new String[]{sort});
        Object tupleStream = null;
        CloudSolrStream cstream = new CloudSolrStream(zkHost, collection, (SolrParams)params);
        tupleStream = new RollupStream((TupleStream)cstream, buckets, metrics);
        if (numWorkers > 1) {
            StreamComparator comp = SQLHandler.bucketSortComp(buckets, sortDirection);
            ParallelStream parallelStream = new ParallelStream(workerZkHost, workerCollection, (TupleStream)tupleStream, numWorkers, comp);
            StreamFactory factory = new StreamFactory().withFunctionName("search", CloudSolrStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("rollup", RollupStream.class).withFunctionName("sum", SumMetric.class).withFunctionName("min", MinMetric.class).withFunctionName("max", MaxMetric.class).withFunctionName("avg", MeanMetric.class).withFunctionName("count", CountMetric.class);
            parallelStream.setStreamFactory(factory);
            tupleStream = parallelStream;
        }
        if (sqlVisitor.havingExpression != null) {
            tupleStream = new HavingStream((TupleStream)tupleStream, sqlVisitor.havingExpression, sqlVisitor.reverseColumnAliases);
        }
        if (sqlVisitor.sorts != null && sqlVisitor.sorts.size() > 0) {
            if (!SQLHandler.sortsEqual(buckets, sortDirection, sqlVisitor.sorts, sqlVisitor.reverseColumnAliases)) {
                int limit = sqlVisitor.limit == -1 ? 100 : sqlVisitor.limit;
                StreamComparator comp = SQLHandler.getComp(sqlVisitor.sorts, sqlVisitor.reverseColumnAliases);
                tupleStream = new RankStream((TupleStream)tupleStream, limit, comp);
            } else if (sqlVisitor.limit > -1) {
                tupleStream = new LimitStream((TupleStream)tupleStream, sqlVisitor.limit);
            }
        }
        if (sqlVisitor.hasColumnAliases) {
            tupleStream = new SelectStream((TupleStream)tupleStream, sqlVisitor.columnAliases);
        }
        return tupleStream;
    }

    private static TupleStream doSelectDistinct(SQLVisitor sqlVisitor, int numWorkers, String workerCollection, String workerZkHost) throws IOException {
        int i;
        HashSet<String> fieldSet = new HashSet<String>();
        Bucket[] buckets = SQLHandler.getBuckets(sqlVisitor.fields, fieldSet);
        Metric[] metrics = SQLHandler.getMetrics(sqlVisitor.fields, fieldSet);
        if (metrics.length > 0) {
            throw new IOException("Select Distinct queries cannot include aggregate functions.");
        }
        String fl = SQLHandler.fields(fieldSet);
        String sort = null;
        FieldEqualitor ecomp = null;
        StreamComparator comp = null;
        if (sqlVisitor.sorts != null && sqlVisitor.sorts.size() > 0) {
            StreamComparator[] adjustedSorts = SQLHandler.adjustSorts(sqlVisitor.sorts, buckets, sqlVisitor.reverseColumnAliases);
            FieldEqualitor[] fieldEqualitors = new FieldEqualitor[adjustedSorts.length];
            StringBuilder buf = new StringBuilder();
            for (i = 0; i < adjustedSorts.length; ++i) {
                FieldComparator fieldComparator = (FieldComparator)adjustedSorts[i];
                fieldEqualitors[i] = new FieldEqualitor(fieldComparator.getLeftFieldName());
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(fieldComparator.getLeftFieldName()).append(" ").append(fieldComparator.getOrder().toString());
            }
            sort = buf.toString();
            if (adjustedSorts.length == 1) {
                ecomp = fieldEqualitors[0];
                comp = adjustedSorts[0];
            } else {
                ecomp = new MultipleFieldEqualitor((StreamEqualitor[])fieldEqualitors);
                comp = new MultipleFieldComparator(adjustedSorts);
            }
        } else {
            StringBuilder sortBuf = new StringBuilder();
            FieldEqualitor[] equalitors = new FieldEqualitor[buckets.length];
            StreamComparator[] streamComparators = new StreamComparator[buckets.length];
            for (i = 0; i < buckets.length; ++i) {
                equalitors[i] = new FieldEqualitor(buckets[i].toString());
                streamComparators[i] = new FieldComparator(buckets[i].toString(), ComparatorOrder.ASCENDING);
                if (i > 0) {
                    sortBuf.append(',');
                }
                sortBuf.append(buckets[i].toString()).append(" asc");
            }
            sort = sortBuf.toString();
            if (equalitors.length == 1) {
                ecomp = equalitors[0];
                comp = streamComparators[0];
            } else {
                ecomp = new MultipleFieldEqualitor((StreamEqualitor[])equalitors);
                comp = new MultipleFieldComparator(streamComparators);
            }
        }
        TableSpec tableSpec = new TableSpec(sqlVisitor.table, defaultZkhost);
        String zkHost = tableSpec.zkHost;
        String collection = tableSpec.collection;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("fl", new String[]{fl});
        params.set("q", new String[]{sqlVisitor.query});
        params.set("qt", new String[]{"/export"});
        if (numWorkers > 1) {
            params.set("partitionKeys", new String[]{SQLHandler.getPartitionKeys(buckets)});
        }
        params.set("sort", new String[]{sort});
        Object tupleStream = null;
        CloudSolrStream cstream = new CloudSolrStream(zkHost, collection, (SolrParams)params);
        tupleStream = new UniqueStream((TupleStream)cstream, (StreamEqualitor)ecomp);
        if (numWorkers > 1) {
            ParallelStream parallelStream = new ParallelStream(workerZkHost, workerCollection, (TupleStream)tupleStream, numWorkers, comp);
            StreamFactory factory = new StreamFactory().withFunctionName("search", CloudSolrStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("unique", UniqueStream.class);
            parallelStream.setStreamFactory(factory);
            tupleStream = parallelStream;
        }
        if (sqlVisitor.limit > 0) {
            tupleStream = new LimitStream((TupleStream)tupleStream, sqlVisitor.limit);
        }
        if (sqlVisitor.hasColumnAliases) {
            tupleStream = new SelectStream((TupleStream)tupleStream, sqlVisitor.columnAliases);
        }
        return tupleStream;
    }

    private static StreamComparator[] adjustSorts(List<SortItem> sorts, Bucket[] buckets, Map<String, String> reverseColumnAliases) throws IOException {
        ArrayList<FieldComparator> adjustedSorts = new ArrayList<FieldComparator>();
        HashSet<String> bucketFields = new HashSet<String>();
        HashSet<String> sortFields = new HashSet<String>();
        for (SortItem sortItem : sorts) {
            sortFields.add(SQLHandler.getSortField(sortItem, reverseColumnAliases));
            adjustedSorts.add(new FieldComparator(SQLHandler.getSortField(sortItem, reverseColumnAliases), SQLHandler.ascDescComp(sortItem.getOrdering().toString())));
        }
        for (Object bucket : buckets) {
            bucketFields.add(bucket.toString());
        }
        for (SortItem sortItem : sorts) {
            String sortField = SQLHandler.getSortField(sortItem, reverseColumnAliases);
            if (bucketFields.contains(sortField)) continue;
            throw new IOException("All sort fields must be in the field list.");
        }
        if (sorts.size() < buckets.length) {
            for (Object bucket : buckets) {
                String b = bucket.toString();
                if (sortFields.contains(b)) continue;
                adjustedSorts.add(new FieldComparator(bucket.toString(), ComparatorOrder.ASCENDING));
            }
        }
        return (StreamComparator[])adjustedSorts.toArray(new FieldComparator[adjustedSorts.size()]);
    }

    private static TupleStream doSelectDistinctFacets(SQLVisitor sqlVisitor) throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        Bucket[] buckets = SQLHandler.getBuckets(sqlVisitor.fields, fieldSet);
        Metric[] metrics = SQLHandler.getMetrics(sqlVisitor.fields, fieldSet);
        if (metrics.length > 0) {
            throw new IOException("Select Distinct queries cannot include aggregate functions.");
        }
        TableSpec tableSpec = new TableSpec(sqlVisitor.table, defaultZkhost);
        String zkHost = tableSpec.zkHost;
        String collection = tableSpec.collection;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{sqlVisitor.query});
        int limit = sqlVisitor.limit > 0 ? sqlVisitor.limit : 100;
        FieldComparator[] sorts = null;
        if (sqlVisitor.sorts == null) {
            sorts = new FieldComparator[buckets.length];
            for (int i = 0; i < sorts.length; ++i) {
                sorts[i] = new FieldComparator("index", ComparatorOrder.ASCENDING);
            }
        } else {
            StreamComparator[] comps = SQLHandler.adjustSorts(sqlVisitor.sorts, buckets, sqlVisitor.reverseColumnAliases);
            sorts = new FieldComparator[comps.length];
            for (int i = 0; i < comps.length; ++i) {
                sorts[i] = (FieldComparator)comps[i];
            }
        }
        Object tupleStream = new FacetStream(zkHost, collection, (SolrParams)params, buckets, metrics, sorts, limit);
        if (sqlVisitor.limit > 0) {
            tupleStream = new LimitStream((TupleStream)tupleStream, sqlVisitor.limit);
        }
        return new SelectStream((TupleStream)tupleStream, sqlVisitor.columnAliases);
    }

    private static TupleStream doGroupByWithAggregatesFacets(SQLVisitor sqlVisitor) throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        Bucket[] buckets = SQLHandler.getBuckets(sqlVisitor.groupBy, fieldSet);
        Metric[] metrics = SQLHandler.getMetrics(sqlVisitor.fields, fieldSet);
        if (metrics.length == 0) {
            throw new IOException("Group by queries must include at least one aggregate function.");
        }
        TableSpec tableSpec = new TableSpec(sqlVisitor.table, defaultZkhost);
        String zkHost = tableSpec.zkHost;
        String collection = tableSpec.collection;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{sqlVisitor.query});
        int limit = sqlVisitor.limit > 0 ? sqlVisitor.limit : 100;
        FieldComparator[] sorts = null;
        if (sqlVisitor.sorts == null) {
            sorts = new FieldComparator[buckets.length];
            for (int i = 0; i < sorts.length; ++i) {
                sorts[i] = new FieldComparator("index", ComparatorOrder.ASCENDING);
            }
        } else {
            sorts = SQLHandler.getComps(sqlVisitor.sorts, sqlVisitor.reverseColumnAliases);
        }
        Object tupleStream = new FacetStream(zkHost, collection, (SolrParams)params, buckets, metrics, sorts, limit);
        if (sqlVisitor.havingExpression != null) {
            tupleStream = new HavingStream((TupleStream)tupleStream, sqlVisitor.havingExpression, sqlVisitor.reverseColumnAliases);
        }
        if (sqlVisitor.limit > 0) {
            tupleStream = new LimitStream((TupleStream)tupleStream, sqlVisitor.limit);
        }
        if (sqlVisitor.hasColumnAliases) {
            tupleStream = new SelectStream((TupleStream)tupleStream, sqlVisitor.columnAliases);
        }
        return tupleStream;
    }

    private static TupleStream doSelect(SQLVisitor sqlVisitor) throws IOException {
        Object tupleStream;
        List<String> fields = sqlVisitor.fields;
        HashSet<String> fieldSet = new HashSet<String>();
        Metric[] metrics = SQLHandler.getMetrics(fields, fieldSet);
        if (metrics.length > 0) {
            return SQLHandler.doAggregates(sqlVisitor, metrics);
        }
        StringBuilder flbuf = new StringBuilder();
        boolean comma = false;
        if (fields.size() == 0) {
            throw new IOException("Select columns must be specified.");
        }
        TableSpec tableSpec = new TableSpec(sqlVisitor.table, defaultZkhost);
        String zkHost = tableSpec.zkHost;
        String collection = tableSpec.collection;
        boolean score = false;
        for (String field : fields) {
            if (field.contains("(")) {
                throw new IOException("Aggregate functions only supported with group by queries.");
            }
            if (field.contains("*")) {
                throw new IOException("* is not supported for column selection.");
            }
            if (field.equals("score")) {
                if (sqlVisitor.limit < 0) {
                    throw new IOException("score is not a valid field for unlimited select queries");
                }
                score = true;
            }
            if (comma) {
                flbuf.append(",");
            }
            comma = true;
            flbuf.append(field);
        }
        String fl = flbuf.toString();
        List<SortItem> sorts = sqlVisitor.sorts;
        StringBuilder siBuf = new StringBuilder();
        comma = false;
        if (sorts != null) {
            for (SortItem sortItem : sorts) {
                if (comma) {
                    siBuf.append(",");
                }
                siBuf.append(SQLHandler.getSortField(sortItem, sqlVisitor.reverseColumnAliases) + " " + SQLHandler.ascDesc(sortItem.getOrdering().toString()));
            }
        } else if (sqlVisitor.limit < 0) {
            siBuf.append("_version_ desc");
            fl = fl + ",_version_";
        } else {
            siBuf.append("score desc");
            if (!score) {
                fl = fl + ",score";
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("fl", new String[]{fl.toString()});
        params.set("q", new String[]{sqlVisitor.query});
        if (siBuf.length() > 0) {
            params.set("sort", new String[]{siBuf.toString()});
        }
        if (sqlVisitor.limit > -1) {
            params.set("rows", new String[]{Integer.toString(sqlVisitor.limit)});
            tupleStream = new LimitStream((TupleStream)new CloudSolrStream(zkHost, collection, (SolrParams)params), sqlVisitor.limit);
        } else {
            params.set("qt", new String[]{"/export"});
            tupleStream = new CloudSolrStream(zkHost, collection, (SolrParams)params);
        }
        return new SelectStream((TupleStream)tupleStream, sqlVisitor.columnAliases);
    }

    private static boolean sortsEqual(Bucket[] buckets, String direction, List<SortItem> sortItems, Map<String, String> reverseColumnAliases) {
        if (buckets.length != sortItems.size()) {
            return false;
        }
        for (int i = 0; i < buckets.length; ++i) {
            Bucket bucket = buckets[i];
            SortItem sortItem = sortItems.get(i);
            if (!bucket.toString().equals(SQLHandler.getSortField(sortItem, reverseColumnAliases))) {
                return false;
            }
            if (sortItem.getOrdering().toString().toLowerCase(Locale.ROOT).contains(direction.toLowerCase(Locale.ROOT))) continue;
            return false;
        }
        return true;
    }

    private static TupleStream doAggregates(SQLVisitor sqlVisitor, Metric[] metrics) throws IOException {
        if (metrics.length != sqlVisitor.fields.size()) {
            throw new IOException("Only aggregate functions are allowed when group by is not specified.");
        }
        TableSpec tableSpec = new TableSpec(sqlVisitor.table, defaultZkhost);
        String zkHost = tableSpec.zkHost;
        String collection = tableSpec.collection;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{sqlVisitor.query});
        StatsStream tupleStream = new StatsStream(zkHost, collection, (SolrParams)params, metrics);
        if (sqlVisitor.hasColumnAliases) {
            tupleStream = new SelectStream((TupleStream)tupleStream, sqlVisitor.columnAliases);
        }
        return tupleStream;
    }

    private static String bucketSort(Bucket[] buckets, String dir) {
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Bucket bucket : buckets) {
            if (comma) {
                buf.append(",");
            }
            buf.append(bucket.toString()).append(" ").append(dir);
            comma = true;
        }
        return buf.toString();
    }

    private static String getPartitionKeys(Bucket[] buckets) {
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Bucket bucket : buckets) {
            if (comma) {
                buf.append(",");
            }
            buf.append(bucket.toString());
            comma = true;
        }
        return buf.toString();
    }

    private static String getSortDirection(List<SortItem> sorts) {
        Iterator<SortItem> iterator;
        if (sorts != null && sorts.size() > 0 && (iterator = sorts.iterator()).hasNext()) {
            SortItem item = iterator.next();
            return SQLHandler.ascDesc(SQLHandler.stripSingleQuotes(SQLHandler.stripQuotes(item.getOrdering().toString())));
        }
        return "asc";
    }

    private static StreamComparator bucketSortComp(Bucket[] buckets, String dir) {
        FieldComparator[] comps = new FieldComparator[buckets.length];
        for (int i = 0; i < buckets.length; ++i) {
            ComparatorOrder comparatorOrder = SQLHandler.ascDescComp(dir);
            String sortKey = buckets[i].toString();
            comps[i] = new FieldComparator(SQLHandler.stripQuotes(sortKey), comparatorOrder);
        }
        if (comps.length == 1) {
            return comps[0];
        }
        return new MultipleFieldComparator((StreamComparator[])comps);
    }

    private static StreamComparator getComp(List<SortItem> sortItems, Map<String, String> reverseColumnAliases) {
        FieldComparator[] comps = new FieldComparator[sortItems.size()];
        for (int i = 0; i < sortItems.size(); ++i) {
            SortItem sortItem = sortItems.get(i);
            String ordering = sortItem.getOrdering().toString();
            ComparatorOrder comparatorOrder = SQLHandler.ascDescComp(ordering);
            String sortKey = SQLHandler.getSortField(sortItem, reverseColumnAliases);
            comps[i] = new FieldComparator(sortKey, comparatorOrder);
        }
        if (comps.length == 1) {
            return comps[0];
        }
        return new MultipleFieldComparator((StreamComparator[])comps);
    }

    private static FieldComparator[] getComps(List<SortItem> sortItems, Map<String, String> reverseColumnAliases) {
        FieldComparator[] comps = new FieldComparator[sortItems.size()];
        for (int i = 0; i < sortItems.size(); ++i) {
            SortItem sortItem = sortItems.get(i);
            String ordering = sortItem.getOrdering().toString();
            ComparatorOrder comparatorOrder = SQLHandler.ascDescComp(ordering);
            String sortKey = SQLHandler.getSortField(sortItem, reverseColumnAliases);
            comps[i] = new FieldComparator(sortKey, comparatorOrder);
        }
        return comps;
    }

    private static String fields(Set<String> fieldSet) {
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (String field : fieldSet) {
            if (comma) {
                buf.append(",");
            }
            buf.append(field);
            comma = true;
        }
        return buf.toString();
    }

    private static Metric[] getMetrics(List<String> fields, Set<String> fieldSet) throws IOException {
        ArrayList<Object> metrics = new ArrayList<Object>();
        for (String field : fields) {
            if (!field.contains("(")) continue;
            field = field.substring(0, field.length() - 1);
            String[] parts = field.split("\\(");
            String function = parts[0];
            SQLHandler.validateFunction(function);
            String column = parts[1];
            if (function.equals("min")) {
                metrics.add(new MinMetric(column));
                fieldSet.add(column);
                continue;
            }
            if (function.equals("max")) {
                metrics.add(new MaxMetric(column));
                fieldSet.add(column);
                continue;
            }
            if (function.equals("sum")) {
                metrics.add(new SumMetric(column));
                fieldSet.add(column);
                continue;
            }
            if (function.equals("avg")) {
                metrics.add(new MeanMetric(column));
                fieldSet.add(column);
                continue;
            }
            if (!function.equals("count")) continue;
            metrics.add(new CountMetric());
        }
        return metrics.toArray(new Metric[metrics.size()]);
    }

    private static void validateFunction(String function) throws IOException {
        if (function.equals("min") || function.equals("max") || function.equals("sum") || function.equals("avg") || function.equals("count")) {
            return;
        }
        throw new IOException("Invalid function: " + function);
    }

    private static Bucket[] getBuckets(List<String> fields, Set<String> fieldSet) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        for (String field : fields) {
            String f = SQLHandler.stripQuotes(field);
            buckets.add(new Bucket(f));
            fieldSet.add(f);
        }
        return buckets.toArray(new Bucket[buckets.size()]);
    }

    private static String ascDesc(String s) {
        if (s.toLowerCase(Locale.ROOT).contains("desc")) {
            return "desc";
        }
        return "asc";
    }

    private static ComparatorOrder ascDescComp(String s) {
        if (s.toLowerCase(Locale.ROOT).contains("desc")) {
            return ComparatorOrder.DESCENDING;
        }
        return ComparatorOrder.ASCENDING;
    }

    private static String stripQuotes(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private static String stripSingleQuotes(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private static String getSortField(SortItem sortItem, Map<String, String> reverseColumnAliases) {
        String field;
        Expression ex = sortItem.getSortKey();
        if (ex instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)ex;
            List parts = ref.getName().getOriginalParts();
            field = (String)parts.get(0);
        } else if (ex instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)ex;
            List parts = functionCall.getName().getOriginalParts();
            List args = functionCall.getArguments();
            String col = null;
            if (args.size() > 0 && args.get(0) instanceof QualifiedNameReference) {
                QualifiedNameReference ref = (QualifiedNameReference)args.get(0);
                col = (String)ref.getName().getOriginalParts().get(0);
                field = (String)parts.get(0) + "(" + SQLHandler.stripSingleQuotes(col) + ")";
            } else {
                field = SQLHandler.stripSingleQuotes(SQLHandler.stripQuotes(functionCall.toString()));
            }
        } else {
            StringLiteral stringLiteral = (StringLiteral)ex;
            field = SQLHandler.stripSingleQuotes(stringLiteral.toString());
        }
        if (reverseColumnAliases.containsKey(field)) {
            field = reverseColumnAliases.get(field);
        }
        return field;
    }

    private static String getHavingField(Expression ex) {
        String field;
        if (ex instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)ex;
            List parts = ref.getName().getOriginalParts();
            field = (String)parts.get(0);
        } else if (ex instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)ex;
            List parts = functionCall.getName().getOriginalParts();
            List args = functionCall.getArguments();
            String col = null;
            if (args.size() > 0 && args.get(0) instanceof QualifiedNameReference) {
                QualifiedNameReference ref = (QualifiedNameReference)args.get(0);
                col = (String)ref.getName().getOriginalParts().get(0);
                field = (String)parts.get(0) + "(" + SQLHandler.stripSingleQuotes(col) + ")";
            } else {
                field = SQLHandler.stripSingleQuotes(SQLHandler.stripQuotes(functionCall.toString()));
            }
        } else {
            StringLiteral stringLiteral = (StringLiteral)ex;
            field = SQLHandler.stripSingleQuotes(stringLiteral.toString());
        }
        return field;
    }

    private static String getPredicateField(Expression ex) {
        String field;
        if (ex instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)ex;
            List parts = ref.getName().getOriginalParts();
            field = (String)parts.get(0);
        } else {
            StringLiteral stringLiteral = (StringLiteral)ex;
            field = SQLHandler.stripSingleQuotes(stringLiteral.toString());
        }
        return field;
    }

    private static String getGroupField(Expression ex) {
        String field;
        if (ex instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)ex;
            List parts = ref.getName().getOriginalParts();
            field = (String)parts.get(0);
        } else {
            StringLiteral stringLiteral = (StringLiteral)ex;
            field = SQLHandler.stripSingleQuotes(stringLiteral.toString());
        }
        return field;
    }

    private static class HavingVisitor
    extends AstVisitor<Boolean, Tuple> {
        private Map<String, String> reverseAliasMap;

        public HavingVisitor(Map<String, String> reverseAliasMap) {
            this.reverseAliasMap = reverseAliasMap;
        }

        protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression node, Tuple tuple) {
            Boolean b = (Boolean)this.process((Node)node.getLeft(), tuple);
            if (node.getType() == LogicalBinaryExpression.Type.AND) {
                if (!b.booleanValue()) {
                    return false;
                }
                return (Boolean)this.process((Node)node.getRight(), tuple);
            }
            if (b.booleanValue()) {
                return true;
            }
            return (Boolean)this.process((Node)node.getRight(), tuple);
        }

        protected Boolean visitComparisonExpression(ComparisonExpression node, Tuple tuple) {
            String field = SQLHandler.getHavingField(node.getLeft());
            if (this.reverseAliasMap.containsKey(field)) {
                field = this.reverseAliasMap.get(field);
            }
            double d = Double.parseDouble(node.getRight().toString());
            double td = tuple.getDouble((Object)field);
            ComparisonExpression.Type t = node.getType();
            switch (t) {
                case LESS_THAN: {
                    return td < d;
                }
                case LESS_THAN_OR_EQUAL: {
                    return td <= d;
                }
                case NOT_EQUAL: {
                    return td != d;
                }
                case EQUAL: {
                    return td == d;
                }
                case GREATER_THAN: {
                    return td > d;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return td >= d;
                }
            }
            return false;
        }
    }

    private static class MetadataStream
    extends TupleStream {
        private final TupleStream stream;
        private final SQLVisitor sqlVisitor;
        private boolean firstTuple = true;

        public MetadataStream(TupleStream stream, SQLVisitor sqlVistor) {
            this.stream = stream;
            this.sqlVisitor = sqlVistor;
        }

        public List<TupleStream> children() {
            return this.stream.children();
        }

        public void open() throws IOException {
            this.stream.open();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName("SQL METADATA").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
        }

        public Tuple read() throws IOException {
            if (this.firstTuple) {
                this.firstTuple = false;
                HashMap<String, Object> fields = new HashMap<String, Object>();
                fields.put("isMetadata", true);
                fields.put("fields", this.sqlVisitor.fields);
                fields.put("aliases", this.sqlVisitor.columnAliases);
                return new Tuple(fields);
            }
            return this.stream.read();
        }

        public StreamComparator getStreamSort() {
            return this.stream.getStreamSort();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void setStreamContext(StreamContext context) {
            this.stream.setStreamContext(context);
        }
    }

    private static class TableStream
    extends TupleStream {
        private final String zkHost;
        private StreamContext context;
        private int currentIndex = 0;
        private List<String> tables;

        TableStream(String zkHost) {
            this.zkHost = zkHost;
        }

        public List<TupleStream> children() {
            return new ArrayList<TupleStream>();
        }

        public void open() throws IOException {
            this.tables = new ArrayList<String>();
            CloudSolrClient cloudSolrClient = this.context.getSolrClientCache().getCloudSolrClient(this.zkHost);
            cloudSolrClient.connect();
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            Set collections = zkStateReader.getClusterState().getCollectionStates().keySet();
            if (collections.size() != 0) {
                this.tables.addAll(collections);
            }
            Collections.sort(this.tables);
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("SQL TABLE").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
        }

        public Tuple read() throws IOException {
            HashMap<String, String> fields = new HashMap<String, String>();
            if (this.currentIndex < this.tables.size()) {
                fields.put("TABLE_CAT", this.zkHost);
                fields.put("TABLE_SCHEM", null);
                fields.put("TABLE_NAME", this.tables.get(this.currentIndex));
                fields.put("TABLE_TYPE", "TABLE");
                fields.put("REMARKS", null);
                ++this.currentIndex;
            } else {
                fields.put("EOF", "true");
            }
            return new Tuple(fields);
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() throws IOException {
        }

        public void setStreamContext(StreamContext context) {
            this.context = context;
        }
    }

    private static class SchemasStream
    extends TupleStream {
        private final String zkHost;
        private StreamContext context;

        SchemasStream(String zkHost) {
            this.zkHost = zkHost;
        }

        public List<TupleStream> children() {
            return new ArrayList<TupleStream>();
        }

        public void open() throws IOException {
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("SQL SCHEMA").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
        }

        public Tuple read() throws IOException {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("EOF", "true");
            return new Tuple(fields);
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() throws IOException {
        }

        public void setStreamContext(StreamContext context) {
            this.context = context;
        }
    }

    private static class CatalogsStream
    extends TupleStream {
        private final String zkHost;
        private StreamContext context;
        private int currentIndex = 0;
        private List<String> catalogs;

        CatalogsStream(String zkHost) {
            this.zkHost = zkHost;
        }

        public List<TupleStream> children() {
            return new ArrayList<TupleStream>();
        }

        public void open() throws IOException {
            this.catalogs = new ArrayList<String>();
            this.catalogs.add(this.zkHost);
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("SQL CATALOG").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
        }

        public Tuple read() throws IOException {
            HashMap<String, String> fields = new HashMap<String, String>();
            if (this.currentIndex < this.catalogs.size()) {
                fields.put("TABLE_CAT", this.catalogs.get(this.currentIndex));
                ++this.currentIndex;
            } else {
                fields.put("EOF", "true");
            }
            return new Tuple(fields);
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() throws IOException {
        }

        public void setStreamContext(StreamContext context) {
            this.context = context;
        }
    }

    private static class HavingStream
    extends TupleStream {
        private TupleStream stream;
        private HavingVisitor havingVisitor;
        private Expression havingExpression;

        public HavingStream(TupleStream stream, Expression havingExpression, Map<String, String> reverseAliasMap) {
            this.stream = stream;
            this.havingVisitor = new HavingVisitor(reverseAliasMap);
            this.havingExpression = havingExpression;
        }

        public void open() throws IOException {
            this.stream.open();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public StreamComparator getStreamSort() {
            return this.stream.getStreamSort();
        }

        public List<TupleStream> children() {
            ArrayList<TupleStream> children = new ArrayList<TupleStream>();
            children.add(this.stream);
            return children;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName("SQL HAVING").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
        }

        public void setStreamContext(StreamContext context) {
            this.stream.setStreamContext(context);
        }

        public Tuple read() throws IOException {
            Tuple tuple;
            do {
                tuple = this.stream.read();
                if (!tuple.EOF) continue;
                return tuple;
            } while (!((Boolean)this.havingVisitor.process((Node)this.havingExpression, tuple)).booleanValue());
            return tuple;
        }
    }

    public static enum AggregationMode {
        MAP_REDUCE,
        FACET;


        public static AggregationMode getMode(String mode) throws IOException {
            if (mode.equalsIgnoreCase("facet")) {
                return FACET;
            }
            if (mode.equalsIgnoreCase("map_reduce")) {
                return MAP_REDUCE;
            }
            throw new IOException("Invalid aggregation mode:" + mode);
        }
    }

    private static class LimitStream
    extends TupleStream {
        private TupleStream stream;
        private int limit;
        private int count;

        public LimitStream(TupleStream stream, int limit) {
            this.stream = stream;
            this.limit = limit;
        }

        public void open() throws IOException {
            this.stream.open();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public List<TupleStream> children() {
            ArrayList<TupleStream> children = new ArrayList<TupleStream>();
            children.add(this.stream);
            return children;
        }

        public StreamComparator getStreamSort() {
            return this.stream.getStreamSort();
        }

        public void setStreamContext(StreamContext context) {
            this.stream.setStreamContext(context);
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName("SQL LIMIT").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
        }

        public Tuple read() throws IOException {
            ++this.count;
            if (this.count > this.limit) {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("EOF", "true");
                return new Tuple(fields);
            }
            Tuple tuple = this.stream.read();
            return tuple;
        }
    }

    static class SQLVisitor
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        public String table;
        public List<String> fields = new ArrayList<String>();
        public List<String> groupBy = new ArrayList<String>();
        public List<SortItem> sorts;
        public String query = "*:*";
        public int limit = -1;
        public boolean groupByQuery;
        public Expression havingExpression;
        public boolean isDistinct;
        public boolean hasColumnAliases;
        public Map<String, String> columnAliases = new HashMap<String, String>();
        public Map<String, String> reverseColumnAliases = new HashMap<String, String>();

        public SQLVisitor(StringBuilder builder) {
            this.builder = builder;
        }

        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        protected void reverseAliases() {
            for (String key : this.columnAliases.keySet()) {
                this.reverseColumnAliases.put(this.columnAliases.get(key), key);
            }
            ArrayList<String> newGroups = new ArrayList<String>();
            for (String g : this.groupBy) {
                if (this.reverseColumnAliases.containsKey(g)) {
                    newGroups.add(this.reverseColumnAliases.get(g));
                    continue;
                }
                newGroups.add(g);
            }
            this.groupBy = newGroups;
        }

        protected Void visitUnnest(Unnest node, Integer indent) {
            return null;
        }

        protected Void visitQuery(Query node, Integer indent) {
            if (node.getWith().isPresent()) {
                With confidence = (With)node.getWith().get();
                this.append(indent, "WITH");
                if (confidence.isRecursive()) {
                    // empty if block
                }
                Iterator queries = confidence.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = (WithQuery)queries.next();
                    this.process((Node)new TableSubquery(query.getQuery()), indent);
                    if (!queries.hasNext()) continue;
                }
            }
            this.processRelation((Relation)node.getQueryBody(), indent);
            if (!node.getOrderBy().isEmpty()) {
                this.sorts = node.getOrderBy();
            }
            if (node.getLimit().isPresent()) {
                // empty if block
            }
            if (node.getApproximate().isPresent()) {
                // empty if block
            }
            return null;
        }

        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process((Node)node.getSelect(), indent);
            if (node.getFrom().isPresent()) {
                this.process((Node)node.getFrom().get(), indent);
            }
            if (node.getWhere().isPresent()) {
                Expression ex = (Expression)node.getWhere().get();
                ExpressionVisitor expressionVisitor = new ExpressionVisitor();
                StringBuilder buf = new StringBuilder();
                expressionVisitor.process((Node)ex, buf);
                this.query = buf.toString();
            }
            if (!node.getGroupBy().isEmpty()) {
                this.groupByQuery = true;
                List groups = node.getGroupBy();
                for (Expression group : groups) {
                    this.groupBy.add(SQLHandler.getGroupField(group));
                }
            }
            if (node.getHaving().isPresent()) {
                this.havingExpression = (Expression)node.getHaving().get();
            }
            if (!node.getOrderBy().isEmpty()) {
                this.sorts = node.getOrderBy();
            }
            if (node.getLimit().isPresent()) {
                this.limit = Integer.parseInt(SQLHandler.stripQuotes((String)node.getLimit().get()));
            }
            return null;
        }

        protected Void visitComparisonExpression(ComparisonExpression node, Integer index) {
            String field = node.getLeft().toString();
            String value = node.getRight().toString();
            this.query = SQLHandler.stripSingleQuotes(SQLHandler.stripQuotes(field)) + ":" + SQLHandler.stripQuotes(value);
            return null;
        }

        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.isDistinct = true;
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.process((Node)item, indent);
                    first = false;
                }
            } else {
                this.process((Node)Iterables.getOnlyElement((Iterable)node.getSelectItems()), indent);
            }
            return null;
        }

        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            Expression ex = node.getExpression();
            String field = null;
            if (ex instanceof QualifiedNameReference) {
                QualifiedNameReference ref = (QualifiedNameReference)ex;
                List parts = ref.getName().getOriginalParts();
                field = (String)parts.get(0);
            } else if (ex instanceof FunctionCall) {
                FunctionCall functionCall = (FunctionCall)ex;
                List parts = functionCall.getName().getOriginalParts();
                List args = functionCall.getArguments();
                String col = null;
                if (args.size() > 0 && args.get(0) instanceof QualifiedNameReference) {
                    QualifiedNameReference ref = (QualifiedNameReference)args.get(0);
                    col = (String)ref.getName().getOriginalParts().get(0);
                    field = (String)parts.get(0) + "(" + SQLHandler.stripSingleQuotes(col) + ")";
                } else {
                    field = SQLHandler.stripSingleQuotes(SQLHandler.stripQuotes(functionCall.toString()));
                }
            } else if (ex instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)ex;
                field = SQLHandler.stripSingleQuotes(stringLiteral.toString());
            }
            this.fields.add(field);
            if (node.getAlias().isPresent()) {
                String alias = (String)node.getAlias().get();
                this.columnAliases.put(field, alias);
                this.hasColumnAliases = true;
            } else {
                this.columnAliases.put(field, field);
            }
            return null;
        }

        protected Void visitAllColumns(AllColumns node, Integer context) {
            return null;
        }

        protected Void visitTable(Table node, Integer indent) {
            this.table = SQLHandler.stripSingleQuotes(node.getName().toString());
            return null;
        }

        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process((Node)node.getRelation(), indent);
            return null;
        }

        protected Void visitValues(Values node, Integer indent) {
            boolean first = true;
            for (Expression expression : node.getRows()) {
                first = false;
            }
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (!(relation instanceof Table)) {
                this.process((Node)relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(SQLVisitor.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)"   ", (int)indent);
        }
    }

    private static class ExpressionVisitor
    extends AstVisitor<Void, StringBuilder> {
        private ExpressionVisitor() {
        }

        protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, StringBuilder buf) {
            buf.append("(");
            this.process((Node)node.getLeft(), buf);
            buf.append(" ").append(node.getType().toString()).append(" ");
            this.process((Node)node.getRight(), buf);
            buf.append(")");
            return null;
        }

        protected Void visitNotExpression(NotExpression node, StringBuilder buf) {
            buf.append("-");
            this.process((Node)node.getValue(), buf);
            return null;
        }

        protected Void visitComparisonExpression(ComparisonExpression node, StringBuilder buf) {
            if (!(node.getLeft() instanceof StringLiteral) && !(node.getLeft() instanceof QualifiedNameReference)) {
                throw new RuntimeException("Left side of comparison must be a literal.");
            }
            String field = SQLHandler.getPredicateField(node.getLeft());
            String value = node.getRight().toString();
            if (!(value = SQLHandler.stripSingleQuotes(value)).startsWith("(") && !value.startsWith("[")) {
                value = '\"' + value + '\"';
            }
            ComparisonExpression.Type t = node.getType();
            switch (t) {
                case NOT_EQUAL: {
                    buf.append('(').append('-').append(field).append(":").append(value).append(')');
                    return null;
                }
                case EQUAL: {
                    buf.append('(').append(field).append(":").append(value).append(')');
                    return null;
                }
                case LESS_THAN: {
                    String lowerBound = "[";
                    String upperBound = "}";
                    String lowerValue = "*";
                    String upperValue = value;
                    buf.append('(').append(field).append(":").append(lowerBound).append(lowerValue).append(" TO ").append(upperValue).append(upperBound).append(')');
                    return null;
                }
                case LESS_THAN_OR_EQUAL: {
                    String lowerBound = "[";
                    String upperBound = "]";
                    String lowerValue = "*";
                    String upperValue = value;
                    buf.append('(').append(field).append(":").append(lowerBound).append(lowerValue).append(" TO ").append(upperValue).append(upperBound).append(')');
                    return null;
                }
                case GREATER_THAN: {
                    String lowerBound = "{";
                    String upperBound = "]";
                    String lowerValue = value;
                    String upperValue = "*";
                    buf.append('(').append(field).append(":").append(lowerBound).append(lowerValue).append(" TO ").append(upperValue).append(upperBound).append(')');
                    return null;
                }
                case GREATER_THAN_OR_EQUAL: {
                    String lowerBound = "[";
                    String upperBound = "]";
                    String lowerValue = value;
                    String upperValue = "*";
                    buf.append('(').append(field).append(":").append(lowerBound).append(lowerValue).append(" TO ").append(upperValue).append(upperBound).append(')');
                    return null;
                }
            }
            return null;
        }
    }

    private static class TableSpec {
        private String collection;
        private String zkHost;

        public TableSpec(String table, String defaultZkHost) {
            if (table.contains("@")) {
                String[] parts = table.split("@");
                this.collection = parts[0];
                this.zkHost = parts[1];
            } else {
                this.collection = table;
                this.zkHost = defaultZkHost;
            }
        }
    }

    public static class SQLTupleStreamParser {
        public static TupleStream parse(String sql, int numWorkers, String workerCollection, String workerZkhost, AggregationMode aggregationMode, boolean includeMetadata, StreamContext context) throws IOException {
            SqlParser parser = new SqlParser();
            Statement statement = parser.createStatement(sql);
            SQLVisitor sqlVistor = new SQLVisitor(new StringBuilder());
            sqlVistor.process((Node)statement, new Integer(0));
            sqlVistor.reverseAliases();
            Object sqlStream = null;
            if (sqlVistor.table.toUpperCase(Locale.ROOT).contains("_CATALOGS_")) {
                sqlStream = new SelectStream((TupleStream)new CatalogsStream(defaultZkhost), sqlVistor.columnAliases);
            } else if (sqlVistor.table.toUpperCase(Locale.ROOT).contains("_SCHEMAS_")) {
                sqlStream = new SelectStream((TupleStream)new SchemasStream(defaultZkhost), sqlVistor.columnAliases);
            } else if (sqlVistor.table.toUpperCase(Locale.ROOT).contains("_TABLES_")) {
                sqlStream = new SelectStream((TupleStream)new TableStream(defaultZkhost), sqlVistor.columnAliases);
            } else if (sqlVistor.groupByQuery) {
                if (aggregationMode == AggregationMode.FACET) {
                    sqlStream = SQLHandler.doGroupByWithAggregatesFacets(sqlVistor);
                } else {
                    context.numWorkers = numWorkers;
                    sqlStream = SQLHandler.doGroupByWithAggregates(sqlVistor, numWorkers, workerCollection, workerZkhost);
                }
            } else if (sqlVistor.isDistinct) {
                if (aggregationMode == AggregationMode.FACET) {
                    sqlStream = SQLHandler.doSelectDistinctFacets(sqlVistor);
                } else {
                    context.numWorkers = numWorkers;
                    sqlStream = SQLHandler.doSelectDistinct(sqlVistor, numWorkers, workerCollection, workerZkhost);
                }
            } else {
                sqlStream = SQLHandler.doSelect(sqlVistor);
            }
            if (includeMetadata) {
                sqlStream = new MetadataStream((TupleStream)sqlStream, sqlVistor);
            }
            sqlStream.setStreamContext(context);
            return sqlStream;
        }
    }
}

