/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.NestedRequestHandler;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerBase
implements SolrRequestHandler,
SolrInfoMBean,
SolrMetricProducer,
NestedRequestHandler {
    protected NamedList initArgs = null;
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    protected boolean httpCaching = true;
    private Meter numErrors = new Meter();
    private Meter numServerErrors = new Meter();
    private Meter numClientErrors = new Meter();
    private Meter numTimeouts = new Meter();
    private Counter requests = new Counter();
    private Timer requestTimes = new Timer();
    private final long handlerStart = System.currentTimeMillis();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PluginInfo pluginInfo;

    @SuppressForbidden(reason="Need currentTimeMillis, used only for stats output")
    public RequestHandlerBase() {
    }

    @Override
    public void init(NamedList args) {
        this.initArgs = args;
        if (args != null) {
            this.defaults = RequestHandlerBase.getSolrParamsFromNamedList(args, "defaults");
            this.appends = RequestHandlerBase.getSolrParamsFromNamedList(args, "appends");
            this.invariants = RequestHandlerBase.getSolrParamsFromNamedList(args, "invariants");
        }
        if (this.initArgs != null) {
            Object caching = this.initArgs.get("httpCaching");
            this.httpCaching = caching != null ? Boolean.parseBoolean(caching.toString()) : true;
        }
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String scope) {
        this.numErrors = manager.meter(registryName, "errors", this.getCategory().toString(), scope);
        this.numServerErrors = manager.meter(registryName, "serverErrors", this.getCategory().toString(), scope);
        this.numClientErrors = manager.meter(registryName, "clientErrors", this.getCategory().toString(), scope);
        this.numTimeouts = manager.meter(registryName, "timeouts", this.getCategory().toString(), scope);
        this.requests = manager.counter(registryName, "requests", this.getCategory().toString(), scope);
        this.requestTimes = manager.timer(registryName, "requestTimes", this.getCategory().toString(), scope);
    }

    public static SolrParams getSolrParamsFromNamedList(NamedList args, String key) {
        Object o = args.get(key);
        if (o != null && o instanceof NamedList) {
            return SolrParams.toSolrParams((NamedList)((NamedList)o));
        }
        return null;
    }

    public NamedList getInitArgs() {
        return this.initArgs;
    }

    public abstract void handleRequestBody(SolrQueryRequest var1, SolrQueryResponse var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.requests.inc();
        Timer.Context timer = this.requestTimes.time();
        try {
            if (this.pluginInfo != null && this.pluginInfo.attributes.containsKey("useParams")) {
                req.getContext().put("useParams", this.pluginInfo.attributes.get("useParams"));
            }
            SolrPluginUtils.setDefaults(this, req, this.defaults, this.appends, this.invariants);
            req.getContext().remove("useParams");
            rsp.setHttpCaching(this.httpCaching);
            this.handleRequestBody(req, rsp);
            NamedList<Object> header = rsp.getResponseHeader();
            if (header != null) {
                boolean timedOut;
                Object partialResults = header.get("partialResults");
                boolean bl = timedOut = partialResults == null ? false : (Boolean)partialResults;
                if (timedOut) {
                    this.numTimeouts.mark();
                    rsp.setHttpCaching(false);
                }
            }
        }
        catch (Exception e2) {
            SolrException e2;
            boolean incrementErrors = true;
            boolean isServerError = true;
            if (e2 instanceof SolrException) {
                SolrException se = (SolrException)((Object)e2);
                if (se.code() == SolrException.ErrorCode.CONFLICT.code) {
                    incrementErrors = false;
                } else if (se.code() >= 400 && se.code() < 500) {
                    isServerError = false;
                }
            } else if (e2 instanceof SyntaxError) {
                isServerError = false;
                e2 = new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e2);
            }
            rsp.setException((Exception)((Object)e2));
            if (incrementErrors) {
                SolrException.log((Logger)log, (Throwable)e2);
                this.numErrors.mark();
                if (isServerError) {
                    this.numServerErrors.mark();
                } else {
                    this.numClientErrors.mark();
                }
            }
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERY;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return null;
    }

    public static SolrRequestHandler getRequestHandler(String handlerName, PluginBag<SolrRequestHandler> reqHandlers) {
        if (handlerName == null) {
            return null;
        }
        SolrRequestHandler handler = reqHandlers.get(handlerName);
        int idx = 0;
        if (handler == null) {
            while ((idx = handlerName.indexOf(47, idx + 1)) > 0) {
                String firstPart = handlerName.substring(0, idx);
                handler = reqHandlers.get(firstPart);
                if (handler == null || !(handler instanceof NestedRequestHandler)) continue;
                return ((NestedRequestHandler)((Object)handler)).getSubHandler(handlerName.substring(idx));
            }
        }
        return handler;
    }

    public void setPluginInfo(PluginInfo pluginInfo) {
        if (this.pluginInfo == null) {
            this.pluginInfo = pluginInfo;
        }
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public NamedList<Object> getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("handlerStart", (Object)this.handlerStart);
        lst.add("requests", (Object)this.requests.getCount());
        lst.add("errors", (Object)this.numErrors.getCount());
        lst.add("serverErrors", (Object)this.numServerErrors.getCount());
        lst.add("clientErrors", (Object)this.numClientErrors.getCount());
        lst.add("timeouts", (Object)this.numTimeouts.getCount());
        MetricUtils.addMetrics((NamedList<Object>)lst, this.requestTimes);
        return lst;
    }
}

