/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrLeaderStateManager;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrStateManager;
import org.apache.solr.update.CdcrUpdateLog;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdcrUpdateLogSynchronizer
implements CdcrStateManager.CdcrStateObserver {
    private CdcrLeaderStateManager leaderStateManager;
    private ScheduledExecutorService scheduler;
    private final SolrCore core;
    private final String collection;
    private final String shardId;
    private final String path;
    private int timeSchedule = 60000;
    private static final int DEFAULT_TIME_SCHEDULE = 60000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    CdcrUpdateLogSynchronizer(SolrCore core, String path, SolrParams updateLogSynchonizerConfiguration) {
        this.core = core;
        this.path = path;
        this.collection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        this.shardId = core.getCoreDescriptor().getCloudDescriptor().getShardId();
        if (updateLogSynchonizerConfiguration != null) {
            this.timeSchedule = updateLogSynchonizerConfiguration.getInt("schedule", 60000);
        }
    }

    void setLeaderStateManager(CdcrLeaderStateManager leaderStateManager) {
        this.leaderStateManager = leaderStateManager;
        this.leaderStateManager.register(this);
    }

    @Override
    public void stateUpdate() {
        if (!this.leaderStateManager.amILeader()) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new DefaultSolrThreadFactory("cdcr-update-log-synchronizer"));
            this.scheduler.scheduleWithFixedDelay(new UpdateLogSynchronisation(), 0L, this.timeSchedule, TimeUnit.MILLISECONDS);
            return;
        }
        this.shutdown();
    }

    boolean isStarted() {
        return this.scheduler != null;
    }

    void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    private class UpdateLogSynchronisation
    implements Runnable {
        private UpdateLogSynchronisation() {
        }

        private String getLeaderUrl() {
            ZkController zkController = CdcrUpdateLogSynchronizer.this.core.getCoreDescriptor().getCoreContainer().getZkController();
            ClusterState cstate = zkController.getClusterState();
            DocCollection docCollection = cstate.getCollection(CdcrUpdateLogSynchronizer.this.collection);
            Replica leaderProps = docCollection.getLeader(CdcrUpdateLogSynchronizer.this.shardId);
            if (leaderProps == null) {
                return null;
            }
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
            return nodeProps.getCoreUrl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long lastVersion;
                String leaderUrl = this.getLeaderUrl();
                if (leaderUrl == null) {
                    return;
                }
                HttpSolrClient server = new HttpSolrClient.Builder(leaderUrl).build();
                server.setConnectionTimeout(15000);
                server.setSoTimeout(60000);
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CdcrParams.CdcrAction.LASTPROCESSEDVERSION.toString()});
                QueryRequest request = new QueryRequest((SolrParams)params);
                request.setPath(CdcrUpdateLogSynchronizer.this.path);
                try {
                    NamedList response = server.request((SolrRequest)request);
                    lastVersion = (Long)response.get("lastProcessedVersion");
                    log.debug("My leader {} says its last processed _version_ number is: {}. I am {}", new Object[]{leaderUrl, lastVersion, CdcrUpdateLogSynchronizer.this.core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName()});
                }
                catch (IOException | SolrServerException e) {
                    log.warn("Couldn't get last processed version from leader {}: {}", (Object)leaderUrl, (Object)e.getMessage());
                    return;
                }
                finally {
                    try {
                        server.close();
                    }
                    catch (IOException ioe) {
                        log.warn("Caught exception trying to close server: ", (Object)leaderUrl, (Object)ioe.getMessage());
                    }
                }
                if (lastVersion == -1L) {
                    return;
                }
                try {
                    CdcrUpdateLog ulog = (CdcrUpdateLog)CdcrUpdateLogSynchronizer.this.core.getUpdateHandler().getUpdateLog();
                    if (ulog.isBuffering()) {
                        log.debug("Advancing replica buffering tlog reader to {} @ {}:{}", new Object[]{lastVersion, CdcrUpdateLogSynchronizer.this.collection, CdcrUpdateLogSynchronizer.this.shardId});
                        ulog.getBufferToggle().seek(lastVersion);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Couldn't advance replica buffering tlog reader to {} (to remove old tlogs): {}", (Object)lastVersion, (Object)e.getMessage());
                }
                catch (IOException e) {
                    log.warn("Couldn't advance replica buffering tlog reader to {} (to remove old tlogs): {}", (Object)lastVersion, (Object)e.getMessage());
                }
            }
            catch (Throwable e) {
                log.warn("Caught unexpected exception", e);
                throw e;
            }
        }
    }
}

